/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.executor;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.core.executor.AbstractExecutor;
import com.xphsc.elasticsearch.core.lambda.LambdaSupplier;
import com.xphsc.elasticsearch.core.query.UpdateQuery;
import com.xphsc.elasticsearch.core.query.UpdateResponseMapper;
import com.xphsc.elasticsearch.core.transform.DynamicEntity;
import com.xphsc.elasticsearch.util.Asserts;
import com.xphsc.elasticsearch.util.Strings;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;

public class UpdateExecutor
extends AbstractExecutor<Object> {
    private UpdateQuery query;
    private List<UpdateQuery> queries;

    public UpdateExecutor(LambdaSupplier<RestHighLevelClientBulider> client, UpdateQuery query) {
        super(client);
        this.query = query;
    }

    public UpdateExecutor(LambdaSupplier<RestHighLevelClientBulider> client, List<UpdateQuery> queries) {
        super(client);
        this.queries = queries;
    }

    @Override
    protected Object doExecute() throws ElasticsearchException {
        UpdateResponse updateResponse = null;
        Object result = null;
        if (this.query != null) {
            UpdateRequest updateRequest = this.getUpdateRequest();
            try {
                updateResponse = this.client.update(updateRequest, RequestOptions.DEFAULT);
                UpdateResponseMapper responseMapper = UpdateResponseMapper.builder().index(updateResponse.getIndex()).id(updateResponse.getId()).version(updateResponse.getVersion()).seqNo(updateResponse.getSeqNo()).type(updateResponse.getType()).primaryTerm(updateResponse.getPrimaryTerm()).status(updateResponse.status().getStatus()).build();
                result = responseMapper;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Iterator<UpdateQuery> iterator = this.queries.iterator();
            while (iterator.hasNext()) {
                UpdateQuery updateQuery;
                this.query = updateQuery = iterator.next();
                UpdateRequest updateRequest = this.getUpdateRequest();
                try {
                    updateResponse = this.client.update(updateRequest, RequestOptions.DEFAULT);
                    LinkedList<Integer> list = new LinkedList<Integer>();
                    list.add(updateResponse.status().getStatus());
                    result = list.size();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private UpdateRequest getUpdateRequest() {
        UpdateRequest updateRequest = new UpdateRequest();
        String indexName = Strings.isNotBlank(this.query.getIndexName()) ? this.query.getIndexName() : DynamicEntity.getPersistentEntityFor(this.query.getClazz()).getIndexName();
        String type = Strings.isNotBlank(this.query.getType()) ? this.query.getType() : DynamicEntity.getPersistentEntityFor(this.query.getClazz()).getIndexType();
        Asserts.notNull((Object)indexName, "No index defined for Query");
        Asserts.notNull((Object)type, "No type define for Query");
        Asserts.notNull((Object)this.query.getId(), "No Id define for Query");
        Asserts.notNull((Object)this.query.getUpdateRequest(), "No IndexRequest define for Query");
        updateRequest.index(indexName);
        updateRequest.type(type);
        updateRequest.id(this.query.getId());
        if (this.query.getUpdateRequest().script() == null) {
            if (this.query.isDoUpsert()) {
                updateRequest.docAsUpsert(true).doc(this.query.getUpdateRequest().doc());
            } else {
                updateRequest.doc(this.query.getUpdateRequest().doc());
            }
        } else {
            updateRequest.script(this.query.getUpdateRequest().script());
        }
        return updateRequest;
    }
}

