/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.query;

import com.xphsc.elasticsearch.core.entity.Sort;
import com.xphsc.elasticsearch.core.query.Criterion;
import com.xphsc.elasticsearch.core.query.QueryProperty;
import com.xphsc.elasticsearch.core.query.SearchIndexRequest;
import com.xphsc.elasticsearch.core.query.aggregations.AggregateBuilder;
import com.xphsc.elasticsearch.page.Page;
import com.xphsc.elasticsearch.util.Asserts;
import com.xphsc.elasticsearch.util.Collects;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;

public abstract class AbstractCriteria<T> {
    public QueryProperty queryProperty;
    private Page page;
    private Map<String, String> mapping;
    protected List<Criterion> mustCriterions = new ArrayList<Criterion>();
    private SearchIndexRequest searchIndexRequest;

    protected AbstractCriteria() {
        this.queryProperty = new QueryProperty();
    }

    protected T page(int pageNum, int pageSize) {
        if (this.page == null) {
            this.page = new Page();
        }
        Asserts.isTrue(pageNum >= 1, "PageNum must be greater than or equal to 1");
        Asserts.isTrue(pageSize > 0, "PageSize must be greater than 0");
        this.page.setPageNum(pageNum);
        this.page.setPageSize(pageSize);
        this.queryProperty.setPage(this.page);
        return (T)this;
    }

    protected T startPage(Integer start, Integer limit) {
        if (this.page == null) {
            this.page = new Page();
        }
        this.page.setOffset(start);
        this.page.setLimit(limit);
        this.queryProperty.setPage(this.page);
        return (T)this;
    }

    protected T scrollPage(long scrollTimeInMillis, int pageSize) {
        if (this.page == null) {
            this.page = new Page();
        }
        this.page.setOffset(0);
        this.page.setPageSize(pageSize);
        this.queryProperty.setTimeValue(TimeValue.timeValueMillis((long)scrollTimeInMillis));
        this.queryProperty.setPage(this.page);
        return (T)this;
    }

    protected T scrollPage(TimeValue timeValue, int pageSize) {
        if (this.page == null) {
            this.page = new Page();
        }
        this.page.setOffset(0);
        this.page.setPageSize(pageSize);
        this.queryProperty.setTimeValue(timeValue);
        this.queryProperty.setPage(this.page);
        return (T)this;
    }

    protected T scroll(TimeValue timeValue, int resultSize) {
        Asserts.isNull((Object)this.page, "The paging object must be empty");
        this.queryProperty.setTimeValue(timeValue);
        this.queryProperty.setQueryMaxSize(resultSize);
        return (T)this;
    }

    protected T orderByAsc(String ... orderByAsc) {
        this.queryProperty.setOrderByAsc(orderByAsc);
        return (T)this;
    }

    protected T orderByDesc(String ... orderByDesc) {
        this.queryProperty.setOrderByDesc(orderByDesc);
        return (T)this;
    }

    protected T isRefresh(boolean isRefresh) {
        this.queryProperty.setRefresh(isRefresh);
        return (T)this;
    }

    protected T highlightBuilder(HighlightBuilder highlightBuilder) {
        this.queryProperty.setHighlightBuilder(highlightBuilder);
        return (T)this;
    }

    protected T aggregationCriteria(AggregateBuilder aggregationCriteria) {
        this.queryProperty.setAggregateBuilder(aggregationCriteria);
        return (T)this;
    }

    protected T statBy(String ... statBy) {
        this.queryProperty.setStatBy(statBy);
        return (T)this;
    }

    protected T query(String includeProperty, String excludeProperty) {
        this.queryProperty.setExclude(excludeProperty);
        this.queryProperty.setInclude(includeProperty);
        return (T)this;
    }

    protected T query(String[] includeProperty, String ... excludeProperty) {
        this.queryProperty.setIncludes(includeProperty);
        this.queryProperty.setExcludes(excludeProperty);
        return (T)this;
    }

    protected T entityClass(Class<?> entityClass) {
        this.queryProperty.setEntityClass(entityClass);
        return (T)this;
    }

    protected T mapping(String property, String field) {
        if (this.mapping == null) {
            this.mapping = new LinkedHashMap<String, String>();
        }
        this.mapping.put(property, field);
        this.queryProperty.setMapping(this.mapping);
        return (T)this;
    }

    protected T sort(Sort sort) {
        this.queryProperty.setSort(sort);
        return (T)this;
    }

    protected T indices(String ... indexNames) {
        if (this.searchIndexRequest == null) {
            this.searchIndexRequest = new SearchIndexRequest();
        }
        this.searchIndexRequest.addIndexNames(indexNames);
        this.queryProperty.setSearchIndexRequest(this.searchIndexRequest);
        return (T)this;
    }

    protected T types(String ... types) {
        if (this.searchIndexRequest == null) {
            this.searchIndexRequest = new SearchIndexRequest();
        }
        this.searchIndexRequest.addTypes(types);
        this.queryProperty.setSearchIndexRequest(this.searchIndexRequest);
        return (T)this;
    }

    protected T trackTotalHits(boolean trackTotalHits) {
        this.queryProperty.setTrackTotalHits(trackTotalHits);
        return (T)this;
    }

    public QueryBuilder listBuilders() {
        int count = this.mustCriterions.size();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        BoolQueryBuilder queryBuilder = null;
        if (count >= 1) {
            if (Collects.isNotEmpty(this.mustCriterions)) {
                for (Criterion criterion : this.mustCriterions) {
                    for (QueryBuilder builder : criterion.listBuilders()) {
                        queryBuilder = boolQueryBuilder.must(builder);
                    }
                }
            }
            return queryBuilder;
        }
        return null;
    }

    protected void clear() {
        this.mustCriterions.clear();
        this.mapping.clear();
    }

    public List<Criterion> getMustCriterions() {
        return this.mustCriterions;
    }

    public void setMustCriterions(List<Criterion> mustCriterions) {
        this.mustCriterions = mustCriterions;
    }
}

