/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.query;

import com.xphsc.elasticsearch.core.entity.Sort;
import com.xphsc.elasticsearch.core.lambda.LambdaFunction;
import com.xphsc.elasticsearch.core.lambda.Reflections;
import com.xphsc.elasticsearch.core.query.AbstractCriteria;
import com.xphsc.elasticsearch.core.query.Criterion;
import com.xphsc.elasticsearch.core.query.LambdaHighlight;
import com.xphsc.elasticsearch.core.query.QueryWhere;
import com.xphsc.elasticsearch.core.query.aggregations.AggregateBuilder;
import com.xphsc.elasticsearch.util.Strings;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;

public class CriteriaWrapper
extends AbstractCriteria<CriteriaWrapper> {
    private CriteriaWrapper(Builder builder) {
        if (builder.pageNum >= 1 && builder.pageSize > 0) {
            super.page(builder.pageNum, builder.pageSize);
        }
        if (builder.start != null && builder.limit != null) {
            super.startPage(builder.start, builder.limit);
        }
        if (builder.entityClass != null) {
            super.entityClass(builder.entityClass);
        }
        if (Strings.isNotBlank(builder.property) && Strings.isNotBlank(builder.field)) {
            super.mapping(builder.property, builder.field);
        }
        if (builder.sort != null) {
            super.sort(builder.sort);
        }
        if (builder.indexNames != null) {
            super.indices(builder.indexNames);
        }
        if (builder.types != null) {
            super.types(builder.types);
        }
        super.trackTotalHits(builder.trackTotalHits);
        if (builder.orderByAsc != null) {
            super.orderByAsc(builder.orderByAsc);
        }
        if (builder.orderByDesc != null) {
            super.orderByDesc(builder.orderByDesc);
        }
        super.isRefresh(builder.isRefresh);
        if (builder.highlightBuilder != null) {
            super.highlightBuilder(builder.highlightBuilder);
        }
        if (builder.lambdaHighlight != null) {
            super.highlightBuilder(builder.lambdaHighlight.getHighlightBuilder());
        }
        if (builder.aggregationCriteria != null) {
            super.aggregationCriteria(builder.aggregationCriteria);
        }
        if (builder.includeProperty != null && builder.excludeProperty != null) {
            super.query(builder.includeProperty, builder.excludeProperty);
        }
        if (builder.scrollTimeValue != null && builder.scrollResultSize != 0) {
            super.scroll(builder.scrollTimeValue, builder.scrollResultSize);
        }
        super.setMustCriterions(builder.mustCriterions);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void clear() {
        super.clear();
    }

    public static class Builder {
        private int pageNum;
        private int pageSize;
        private Class<?> entityClass;
        private Integer start;
        private Integer limit;
        private String property;
        private String field;
        private Sort sort;
        private String[] indexNames;
        private String[] types;
        private boolean trackTotalHits;
        private String[] orderByAsc;
        private String[] orderByDesc;
        private boolean isRefresh;
        private HighlightBuilder highlightBuilder;
        private LambdaHighlight lambdaHighlight;
        private AggregateBuilder aggregationCriteria;
        String[] includeProperty;
        private String[] excludeProperty;
        private TimeValue scrollTimeValue;
        private int scrollResultSize;
        protected List<Criterion> mustCriterions = new ArrayList<Criterion>();

        public Builder page(int pageNum, int pageSize) {
            this.pageNum = pageNum;
            this.pageSize = pageSize;
            return this;
        }

        public Builder startPage(Integer start, Integer limit) {
            this.start = start;
            this.limit = limit;
            return this;
        }

        public Builder entityClass(Class<?> entityClass) {
            this.entityClass = entityClass;
            return this;
        }

        public Builder mapping(String property, String field) {
            this.property = property;
            this.field = field;
            return this;
        }

        public <T, S> Builder mapping(LambdaFunction<T, Object> property, LambdaFunction<S, Object> field) {
            this.property = Reflections.fieldNameForLambdaFunction(property);
            this.field = Reflections.fieldNameForLambdaFunction(field);
            return this;
        }

        public Builder sort(Sort sort) {
            this.sort = sort;
            return this;
        }

        public Builder indices(String ... indexNames) {
            this.indexNames = indexNames;
            return this;
        }

        public Builder types(String ... types) {
            this.types = types;
            return this;
        }

        public Builder trackTotalHits(boolean trackTotalHits) {
            this.trackTotalHits = trackTotalHits;
            return this;
        }

        public Builder orderByAsc(String ... orderByAsc) {
            this.orderByAsc = orderByAsc;
            return this;
        }

        public Builder orderByDesc(String ... orderByDesc) {
            this.orderByDesc = orderByDesc;
            return this;
        }

        public <T> Builder orderByAsc(LambdaFunction<T, Object> ... orderByAsc) {
            this.orderByAsc = Reflections.fieldNameForLambdaFunction(orderByAsc).toArray(new String[orderByAsc.length]);
            return this;
        }

        public <T> Builder orderByDesc(LambdaFunction<T, Object> ... orderBydesc) {
            this.orderByAsc = Reflections.fieldNameForLambdaFunction(orderBydesc).toArray(new String[orderBydesc.length]);
            return this;
        }

        public Builder scroll(TimeValue scrollTimeValue, int scrollResultSize) {
            this.scrollTimeValue = scrollTimeValue;
            this.scrollResultSize = scrollResultSize;
            return this;
        }

        public Builder isRefresh(boolean isRefresh) {
            this.isRefresh = isRefresh;
            return this;
        }

        public Builder highlightBuilder(HighlightBuilder highlightBuilder) {
            this.highlightBuilder = highlightBuilder;
            return this;
        }

        public Builder highlight(LambdaHighlight lambdaHighlight) {
            this.lambdaHighlight = lambdaHighlight;
            return this;
        }

        public Builder aggregationCriteria(AggregateBuilder aggregationCriteria) {
            this.aggregationCriteria = aggregationCriteria;
            return this;
        }

        public Builder query(String[] includeProperty, String ... excludeProperty) {
            this.includeProperty = includeProperty;
            this.excludeProperty = excludeProperty;
            return this;
        }

        public <T> Builder query(LambdaFunction<T, Object>[] includePropertys, LambdaFunction<T, Object> ... excludePropertys) {
            List<String> includes = Reflections.fieldNameForLambdaFunction(includePropertys);
            List<String> excludes = Reflections.fieldNameForLambdaFunction(excludePropertys);
            this.includeProperty = includes.toArray(new String[includes.size()]);
            this.excludeProperty = excludes.toArray(new String[excludes.size()]);
            return this;
        }

        public Builder queryWhere(QueryWhere queryWhere) {
            this.mustCriterions.add(queryWhere);
            return this;
        }

        public CriteriaWrapper build() {
            return new CriteriaWrapper(this);
        }
    }
}

