/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.query;

public class IndexSettings {
    private String indexName;
    private String alias;
    private int shards;
    private int replicas;
    private long maxResult;
    private String refreshInterval;
    private String indexStoreType;

    public IndexSettings() {
    }

    private IndexSettings(Builder builder) {
        this.indexName = builder.indexName;
        this.alias = builder.alias;
        this.shards = builder.shards;
        this.replicas = builder.replicas;
        this.maxResult = builder.maxResult;
        this.refreshInterval = builder.refreshInterval;
        this.indexStoreType = builder.indexStoreType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIndexStoreType() {
        return this.indexStoreType;
    }

    public void setIndexStoreType(String indexStoreType) {
        this.indexStoreType = indexStoreType;
    }

    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    public void setRefreshInterval(String refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public long getMaxResult() {
        return this.maxResult;
    }

    public void setMaxResult(int maxResult) {
        this.maxResult = maxResult;
    }

    public int getShards() {
        return this.shards;
    }

    public void setShards(int shards) {
        this.shards = shards;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public void setReplicas(int replicas) {
        this.replicas = replicas;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String toString() {
        return "IndexSettings{indexName='" + this.indexName + '\'' + ", alias='" + this.alias + '\'' + ", shards=" + this.shards + ", replicas=" + this.replicas + ", maxResult=" + this.maxResult + ", refreshInterval='" + this.refreshInterval + '\'' + ", indexStoreType='" + this.indexStoreType + '\'' + '}';
    }

    public static class Builder {
        private String indexName;
        private String alias;
        private int shards;
        private int replicas;
        private long maxResult;
        private String refreshInterval;
        private String indexStoreType;

        public Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder shards(int shards) {
            this.shards = shards;
            return this;
        }

        public Builder replicas(int replicas) {
            this.replicas = replicas;
            return this;
        }

        public Builder maxResult(long maxResult) {
            this.maxResult = maxResult;
            return this;
        }

        public Builder refreshInterval(String refreshInterval) {
            this.refreshInterval = refreshInterval;
            return this;
        }

        public Builder indexStoreType(String indexStoreType) {
            this.indexStoreType = indexStoreType;
            return this;
        }

        public IndexSettings build() {
            return new IndexSettings(this);
        }
    }
}

