/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.xphsc.elasticsearch.core.entity.aggregate.BucketEntity;
import com.xphsc.elasticsearch.page.Page;
import com.xphsc.elasticsearch.page.PageImpl;
import com.xphsc.elasticsearch.util.Beans;
import com.xphsc.elasticsearch.util.Collects;
import com.xphsc.elasticsearch.util.Elasticsearchs;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;

public class ResultsMapper {
    public static <T> Iterable<T> formatToEntity(SearchHits hits, Class<T> clazz, Class<?> entityClass, Map<String, String> mapping) {
        return ResultsMapper.objectForResult(hits, clazz, entityClass, mapping);
    }

    public static <T> Page<T> formatToPageEntity(SearchHits hits, Class<T> clazz, Class<?> entityClass, Map<String, String> mapping, Page page) {
        Iterable<T> result = ResultsMapper.objectForResult(hits, clazz, entityClass, mapping);
        long total = hits.getTotalHits().value;
        return new PageImpl((List)result, total, page.getPageNum(), page.getPageSize());
    }

    private static <T> Iterable<T> objectForResult(SearchHits hits, Class<T> clazz, Class<?> entityClass, Map<String, String> mapping) {
        SearchHit[] searchHists;
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(Integer.parseInt(hits.getTotalHits().value + ""));
        for (SearchHit sh : searchHists = hits.getHits()) {
            String field;
            Map<String, String> sourceAsMap = sh.getSourceAsMap();
            Map maps = sh.getHighlightFields();
            if (Collects.isNotEmpty(maps)) {
                for (Map.Entry map : maps.entrySet()) {
                    HighlightField highlight;
                    Text[] fragments;
                    if (!sourceAsMap.containsKey(map.getKey()) || (fragments = (highlight = (HighlightField)map.getValue()).fragments()) == null) continue;
                    sourceAsMap.put(highlight.getName(), fragments[0].string());
                }
            }
            Object t = null;
            if (clazz != null) {
                if (Collects.isNotEmpty(mapping)) {
                    for (Map.Entry<String, String> map : mapping.entrySet()) {
                        if (!sourceAsMap.containsKey(map.getKey()) || (field = map.getValue().toString()) == null) continue;
                        sourceAsMap.put(field, (String)sh.getSourceAsMap().get(map.getKey()));
                    }
                }
                t = JSON.parseObject((String)Elasticsearchs.toJsonWithId(JSON.toJSONString(sourceAsMap.toString().contains("_") ? Collects.toCamelCaseMap(sourceAsMap) : sourceAsMap, (boolean)true), Beans.getIdName(clazz), sh.getId()), entityClass == null ? clazz : entityClass, (Feature[])new Feature[0]);
            } else {
                sourceAsMap.put("id", sh.getId());
                if (Collects.isNotEmpty(mapping)) {
                    for (Map.Entry<String, String> resultMapping : mapping.entrySet()) {
                        if (!sourceAsMap.containsKey(resultMapping.getKey()) || (field = resultMapping.getValue().toString()) == null) continue;
                        sourceAsMap.put(field, (String)sourceAsMap.get(resultMapping.getKey()));
                        sourceAsMap.remove(resultMapping.getKey());
                    }
                }
                t = sourceAsMap;
            }
            result.add((Map<String, String>)t);
        }
        return result;
    }

    public static final <T> Page<T> aggregateForPage(SearchHits hits, Aggregations aggregations, Class<T> clazz, Class<?> entityClass, Page page, Map<String, String> mapping, Object[] name) {
        Iterable<T> result = ResultsMapper.formatToObject(aggregations, clazz, entityClass, mapping, name);
        return new PageImpl((List)result, page.getPageNum(), page.getPageSize());
    }

    public static <T> Iterable<T> aggregateForObject(Aggregations aggregations, Class<T> clazz, Class<?> entityClass, Map<String, String> mapping, Object[] name) {
        return ResultsMapper.formatToObject(aggregations, clazz, entityClass, mapping, name);
    }

    private static <T> Iterable<T> formatToObject(Aggregations aggregations, Class<T> clazz, Class<?> entityClass, Map<String, String> mapping, Object[] name) {
        ArrayList<Object> result = new ArrayList<Object>();
        LinkedList<Object> map = new LinkedList<Object>();
        LinkedHashMap<String, Object> sourceAsMap = new LinkedHashMap<String, Object>();
        for (Object object : name) {
            map.add(JSON.parseObject((String)JSON.toJSON(aggregations.getAsMap().get(object)).toString(), Map.class));
        }
        List bucketEntities = null;
        String names = "";
        if (Collects.isNotEmpty(map)) {
            for (Map map2 : map) {
                if (map2.get("buckets") != null) {
                    if (map2.get("name") == null) continue;
                    names = map2.get("name").toString();
                    bucketEntities = JSON.parseArray((String)map2.get("buckets").toString(), BucketEntity.class);
                    continue;
                }
                sourceAsMap.put(map2.get("name").toString(), map2.get("value"));
            }
        }
        if (Collects.isNotEmpty(bucketEntities)) {
            for (BucketEntity bucketEntity : bucketEntities) {
                sourceAsMap.put(names, bucketEntity.getKeyAsString());
                sourceAsMap.put("docCount", bucketEntity.getDocCount());
                sourceAsMap.put("keyAsNumber", bucketEntity.getKeyAsNumber());
                sourceAsMap.put("keyAsString", bucketEntity.getKeyAsString());
                if (Collects.isNotEmpty(mapping)) {
                    for (Map.Entry<String, String> resultMapping : mapping.entrySet()) {
                        String field;
                        if (!sourceAsMap.containsKey(resultMapping.getKey()) || (field = resultMapping.getValue().toString()) == null) continue;
                        sourceAsMap.put(field, sourceAsMap.get(resultMapping.getKey()));
                    }
                }
                if (clazz != null) {
                    Object t = JSON.parseObject((String)JSON.toJSONString(sourceAsMap), entityClass == null ? clazz : entityClass, (Feature[])new Feature[0]);
                    result.add(t);
                    continue;
                }
                result.add(JSON.toJSON(sourceAsMap));
            }
        }
        return result;
    }
}

