/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.query;

import com.xphsc.elasticsearch.core.entity.Sort;
import com.xphsc.elasticsearch.core.query.Criterion;
import com.xphsc.elasticsearch.core.query.QueryCriteria;
import com.xphsc.elasticsearch.core.query.QueryWhere;
import com.xphsc.elasticsearch.page.Page;
import com.xphsc.elasticsearch.util.Asserts;
import com.xphsc.elasticsearch.util.Collects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;

public class SearchQuery {
    private String[] indices;
    private String[] types;
    private String routing;
    private boolean trackTotalHits;
    private SearchType searchType;
    private QueryBuilder queryBuilder;
    private Sort sort;
    private boolean refresh;
    private AggregationBuilder aggregationBuilder;
    private HighlightBuilder highlightBuilder;
    private Page page;
    protected List<Criterion> mustCriterions;

    public SearchQuery() {
        this.mustCriterions = new ArrayList<Criterion>();
    }

    private SearchQuery(Builder builder) {
        this.indices = builder.indices;
        this.trackTotalHits = builder.trackTotalHits;
        this.types = builder.types;
        this.routing = builder.routing;
        this.searchType = builder.searchType;
        this.queryBuilder = builder.queryBuilder;
        this.sort = builder.sort;
        this.refresh = builder.refresh;
        this.aggregationBuilder = builder.aggregationBuilder;
        this.highlightBuilder = builder.highlightBuilder;
        this.page = builder.page;
        this.mustCriterions = builder.mustCriterions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public void setQueryBuilder(QueryBuilder queryBuilder) {
        Asserts.empty(this.mustCriterions, "criteria must be empty");
        this.queryBuilder = queryBuilder;
    }

    public String getRouting() {
        return this.routing;
    }

    public void setRouting(String routing) {
        this.routing = routing;
    }

    public String[] getTypes() {
        return this.types;
    }

    public void setTypes(String ... types) {
        this.types = types;
    }

    public String[] getIndices() {
        return this.indices;
    }

    public void setIndices(String ... indices) {
        this.indices = indices;
    }

    public boolean isTrackTotalHits() {
        return this.trackTotalHits;
    }

    public void setTrackTotalHits(boolean trackTotalHits) {
        this.trackTotalHits = trackTotalHits;
    }

    public SearchType getSearchType() {
        return this.searchType;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public AggregationBuilder getAggregationBuilder() {
        return this.aggregationBuilder;
    }

    public void setAggregationBuilder(AggregationBuilder aggregationBuilder) {
        this.aggregationBuilder = aggregationBuilder;
    }

    public HighlightBuilder getHighlightBuilder() {
        return this.highlightBuilder;
    }

    public void setHighlightBuilder(HighlightBuilder highlightBuilder) {
        this.highlightBuilder = highlightBuilder;
    }

    public Page getPage() {
        return this.page;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    @Deprecated
    public void criteria(QueryCriteria.Criteria criteria) {
        Asserts.isNull((Object)this.queryBuilder, "queryBuilder must be empty");
        this.mustCriterions.add(criteria);
    }

    public QueryBuilder listBuilders() {
        int count = this.mustCriterions.size();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (this.queryBuilder == null) {
            if (count >= 1) {
                if (Collects.isNotEmpty(this.mustCriterions)) {
                    for (Criterion criterion : this.mustCriterions) {
                        for (QueryBuilder builder : criterion.listBuilders()) {
                            this.queryBuilder = boolQueryBuilder.must(builder);
                        }
                    }
                }
                return this.queryBuilder;
            }
            return null;
        }
        return null;
    }

    public String toString() {
        return "SearchQuery{indices=" + Arrays.toString(this.indices) + ", types=" + Arrays.toString(this.types) + ", routing='" + this.routing + '\'' + ", queryBuilder=" + this.queryBuilder + ", sort=" + this.sort + ", refresh=" + this.refresh + ", aggregationBuilder=" + this.aggregationBuilder + ", highlightBuilder=" + this.highlightBuilder + ", page=" + this.page + '}';
    }

    public static class Builder {
        private String[] indices;
        private String[] types;
        private boolean trackTotalHits;
        private String routing;
        private SearchType searchType;
        private QueryBuilder queryBuilder;
        private Sort sort;
        private boolean refresh;
        private AggregationBuilder aggregationBuilder;
        private HighlightBuilder highlightBuilder;
        private Page page;
        protected List<Criterion> mustCriterions = new ArrayList<Criterion>();

        public Builder indices(String ... indices) {
            this.indices = indices;
            return this;
        }

        public Builder types(String ... types) {
            this.types = types;
            return this;
        }

        public Builder trackTotalHits(boolean trackTotalHits) {
            this.trackTotalHits = trackTotalHits;
            return this;
        }

        public Builder routing(String routing) {
            this.routing = routing;
            return this;
        }

        public Builder searchType(SearchType searchType) {
            this.searchType = searchType;
            return this;
        }

        public Builder queryBuilder(QueryBuilder queryBuilder) {
            Asserts.empty(this.mustCriterions, "criteria must be empty");
            this.queryBuilder = queryBuilder;
            return this;
        }

        @Deprecated
        public Builder criteria(QueryCriteria.Criteria criteria) {
            Asserts.isNull((Object)this.queryBuilder, "queryBuilder must be empty");
            this.mustCriterions.add(criteria);
            return this;
        }

        public Builder queryWhere(QueryWhere queryWhere) {
            Asserts.isNull((Object)this.queryBuilder, "queryBuilder must be empty");
            this.mustCriterions.add(queryWhere);
            return this;
        }

        public Builder sort(Sort sort) {
            this.sort = sort;
            return this;
        }

        public Builder refresh(boolean refresh) {
            this.refresh = refresh;
            return this;
        }

        public Builder aggregationBuilder(AggregationBuilder aggregationBuilder) {
            this.aggregationBuilder = aggregationBuilder;
            return this;
        }

        public Builder highlightBuilder(HighlightBuilder highlightBuilder) {
            this.highlightBuilder = highlightBuilder;
            return this;
        }

        public Builder page(Page page) {
            this.page = page;
            return this;
        }

        public SearchQuery build() {
            return new SearchQuery(this);
        }
    }
}

