/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.query;

import com.xphsc.elasticsearch.core.entity.aggregate.DateHistogramEntity;
import com.xphsc.elasticsearch.core.query.Criterion;
import com.xphsc.elasticsearch.util.Strings;
import java.util.Collection;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.FiltersAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.range.DateRangeAggregationBuilder;

public class SimpleExpression {
    private String fieldName;
    private Object value;
    private Collection<Object> values;
    private Criterion.Operator operator;
    private Object from;
    private Object to;
    private String[] fieldNames;
    private Criterion.Projection projection;
    private String asFieldName;
    private Object[] objects;
    private String format;
    private QueryBuilder[] filterQueryBuilders;
    private DateHistogramEntity dateHistogramEntity;

    public SimpleExpression(String fieldName, Object value, Criterion.Operator operator) {
        this.fieldName = fieldName;
        this.value = value;
        this.operator = operator;
    }

    public SimpleExpression(String value, Criterion.Operator operator) {
        this.value = value;
        this.operator = operator;
    }

    public SimpleExpression(String fieldName, Collection<Object> values) {
        this.fieldName = fieldName;
        this.values = values;
        this.operator = Criterion.Operator.TERMS;
    }

    public SimpleExpression(Criterion.Operator operator, Collection<Object> values) {
        this.values = values;
        this.operator = operator;
    }

    public SimpleExpression(Criterion.Operator operator, String fieldName, Collection<Object> values) {
        this.fieldName = fieldName;
        this.values = values;
        this.operator = operator;
    }

    public SimpleExpression(String fieldName, Object from, Object to, Criterion.Operator operator) {
        this.fieldName = fieldName;
        this.from = from;
        this.to = to;
        this.operator = operator;
    }

    public SimpleExpression(String fieldName, Object[] objects, Criterion.Operator operator) {
        this.fieldName = fieldName;
        this.objects = objects;
        this.operator = operator;
    }

    public SimpleExpression(String[] fieldNames, Object[] objects, Criterion.Operator operator) {
        this.fieldNames = fieldNames;
        this.objects = objects;
        this.operator = operator;
    }

    public SimpleExpression(String fieldName, String asFieldName, Criterion.Projection projection) {
        this.fieldName = fieldName;
        this.asFieldName = asFieldName;
        this.projection = projection;
    }

    public SimpleExpression(String fieldName, String asFieldName, String format, Criterion.Projection projection) {
        this.fieldName = fieldName;
        this.asFieldName = asFieldName;
        this.format = format;
        this.projection = projection;
    }

    public SimpleExpression(DateHistogramEntity dateHistogramEntity, Criterion.Projection projection) {
        this.dateHistogramEntity = dateHistogramEntity;
        this.projection = projection;
    }

    public SimpleExpression(String fieldName, String asFieldName, Object to, Object from, String format, Criterion.Projection projection) {
        this.fieldName = fieldName;
        this.asFieldName = asFieldName;
        this.to = to;
        this.from = from;
        this.format = format;
        this.projection = projection;
    }

    public SimpleExpression(String fieldName, String asFieldName, Object to, Object from, Criterion.Projection projection) {
        this.fieldName = fieldName;
        this.asFieldName = asFieldName;
        this.to = to;
        this.from = from;
        this.projection = projection;
    }

    public SimpleExpression(String fieldName, QueryBuilder[] filterQueryBuilders, Criterion.Projection projection) {
        this.fieldName = fieldName;
        this.filterQueryBuilders = filterQueryBuilders;
        this.projection = projection;
    }

    public QueryBuilder toBuilder() {
        TermsQueryBuilder qb = null;
        switch (this.operator) {
            case EQUAL: {
                qb = QueryBuilders.termsQuery((String)this.fieldName, (Object[])new Object[]{this.value});
                break;
            }
            case NOT_EQUAL: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)this.fieldName, (Object)this.value));
                break;
            }
            case OR_EQUAL: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)this.fieldName, (Object)this.value));
                break;
            }
            case OR_NOT_EQUAL: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)this.fieldName, (Object)this.value)));
                break;
            }
            case TERMS: {
                qb = QueryBuilders.termsQuery((String)this.fieldName, this.values);
                break;
            }
            case BETWEEN: {
                qb = QueryBuilders.rangeQuery((String)this.fieldName).from(this.from).to(this.to).includeLower(true);
                break;
            }
            case NOT_BETWEEN: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.rangeQuery((String)this.fieldName).from(this.from).to(this.to).includeLower(true));
                break;
            }
            case OR_BETWEEN: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)this.fieldName).from(this.from).to(this.to).includeLower(true));
                break;
            }
            case OR_NOT_BETWEEN: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.rangeQuery((String)this.fieldName).from(this.from).to(this.to).includeLower(true)));
                break;
            }
            case MATCH: {
                qb = QueryBuilders.matchQuery((String)this.fieldName, (Object)this.value);
                break;
            }
            case OR_MATCH: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)this.fieldName, (Object)this.value));
                break;
            }
            case NOT_MATCH: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchQuery((String)this.fieldName, (Object)this.value));
                break;
            }
            case OR_NOT_MATCH: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchQuery((String)this.fieldName, (Object)this.value)));
                break;
            }
            case MULTI_MATCH: {
                qb = QueryBuilders.multiMatchQuery((Object)this.value, (String[])this.fieldNames);
                break;
            }
            case PREFIX: {
                qb = QueryBuilders.prefixQuery((String)this.fieldName, (String)this.value.toString());
                break;
            }
            case NOT_PREFIX: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.prefixQuery((String)this.fieldName, (String)this.value.toString()));
                break;
            }
            case OR_PREFIX: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.prefixQuery((String)this.fieldName, (String)this.value.toString()));
                break;
            }
            case OR_NOT_PREFIX: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.prefixQuery((String)this.fieldName, (String)this.value.toString())));
                break;
            }
            case REGEXP: {
                qb = QueryBuilders.regexpQuery((String)this.fieldName, (String)this.value.toString());
                break;
            }
            case OR_REGEXP: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.regexpQuery((String)this.fieldName, (String)this.value.toString()));
                break;
            }
            case QUERY_STRING: {
                qb = QueryBuilders.queryStringQuery((String)this.value.toString()).field(this.fieldName);
                break;
            }
            case OR_QUERY_STRING: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.queryStringQuery((String)this.value.toString()).field(this.fieldName));
                break;
            }
            case CONTAINS: {
                qb = QueryBuilders.queryStringQuery((String)("*" + this.value + "*")).field(this.fieldName).analyzeWildcard(Boolean.valueOf(true));
                break;
            }
            case NOT_CONTAINS: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.queryStringQuery((String)("*" + this.value + "*")).field(this.fieldName).analyzeWildcard(Boolean.valueOf(true)));
                break;
            }
            case STARTS_WITH: {
                qb = QueryBuilders.queryStringQuery((String)(this.value.toString() + "*")).field(this.fieldName).defaultField(this.fieldName);
                break;
            }
            case NOT_STARTS_WITH: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.queryStringQuery((String)(this.value + "*")).field(this.fieldName).analyzeWildcard(Boolean.valueOf(true)));
                break;
            }
            case ENDS_WITH: {
                qb = QueryBuilders.queryStringQuery((String)("*" + this.value)).field(this.fieldName).analyzeWildcard(Boolean.valueOf(true));
                break;
            }
            case NOT_ENDS_WITH: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.queryStringQuery((String)("*" + this.value)).field(this.fieldName).analyzeWildcard(Boolean.valueOf(true)));
                break;
            }
            case LIKE: {
                String likeValue = this.value.toString().contains("*") ? this.value.toString() : "*" + this.value.toString() + "*";
                qb = QueryBuilders.wildcardQuery((String)this.fieldName, (String)likeValue);
                break;
            }
            case NOT_LIKE: {
                String likeValue = this.value.toString().contains("*") ? this.value.toString() : "*" + this.value.toString() + "*";
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)this.fieldName, (String)likeValue));
                break;
            }
            case OR_LIKE: {
                String likeValue = this.value.toString().contains("*") ? this.value.toString() : "*" + this.value.toString() + "*";
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.wildcardQuery((String)this.fieldName, (String)likeValue));
                break;
            }
            case OR_NOT_LIKE: {
                String likeValue = this.value.toString().contains("*") ? this.value.toString() : "*" + this.value.toString() + "*";
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)this.fieldName, (String)likeValue)));
                break;
            }
            case LEFT_LIKE: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)this.fieldName, (String)("*" + this.value))));
                break;
            }
            case RIGHT_LIKE: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)this.fieldName, (String)(this.value + "*"))));
                break;
            }
            case GREATER_THAN: {
                qb = QueryBuilders.rangeQuery((String)this.fieldName).gt(this.value);
                break;
            }
            case OR_GREATER_THAN: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)this.fieldName).gt(this.value));
                break;
            }
            case GTE: {
                qb = QueryBuilders.rangeQuery((String)this.fieldName).gte(this.value);
                break;
            }
            case OR_GTE: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)this.fieldName).gte(this.value));
                break;
            }
            case LT: {
                qb = QueryBuilders.rangeQuery((String)this.fieldName).lt(this.value);
                break;
            }
            case OR_LT: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)this.fieldName).lt(this.value));
                break;
            }
            case LTE: {
                qb = QueryBuilders.rangeQuery((String)this.fieldName).lte(this.value);
                break;
            }
            case OR_LTE: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)this.fieldName).lte(this.value));
                break;
            }
            case IN: {
                qb = QueryBuilders.termsQuery((String)this.fieldName, this.values);
                break;
            }
            case NOT_IN: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)this.fieldName, this.values));
                break;
            }
            case OR_IN: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)this.fieldName, this.values));
                break;
            }
            case OR_NOR_IN: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)this.fieldName, this.values)));
                break;
            }
            case IN_IDS: {
                qb = QueryBuilders.termsQuery((String)"_id", this.values);
                break;
            }
            case NOT_IN_IDS: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"_id", this.values));
                break;
            }
            case OR_IN_IDS: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)"_id", this.values));
                break;
            }
            case OR_NOR_IN_IDS: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"_id", this.values)));
                break;
            }
            case MORE_LIKE: {
                qb = QueryBuilders.moreLikeThisQuery((String[])this.fieldNames, (String[])new String[this.objects.length], null);
                break;
            }
            case IS_NULL: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)this.value.toString()));
                break;
            }
            case OR_IS_NULL: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)this.value.toString())));
                break;
            }
            case OR_IS_NOT_NULL: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.existsQuery((String)this.value.toString()));
                break;
            }
            case IS_NOT_NULL: {
                qb = QueryBuilders.existsQuery((String)this.value.toString());
            }
        }
        return qb;
    }

    public AggregationBuilder toAggBuilder() {
        FiltersAggregationBuilder agg = null;
        switch (this.projection) {
            case MAX: {
                agg = AggregationBuilders.max((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case MIN: {
                agg = AggregationBuilders.min((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case AVG: {
                agg = AggregationBuilders.avg((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case SUM: {
                agg = AggregationBuilders.sum((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case COUNT: {
                agg = AggregationBuilders.count((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case MISSING: {
                agg = AggregationBuilders.missing((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case STATS: {
                agg = AggregationBuilders.stats((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case RANGE: {
                agg = AggregationBuilders.range((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case DATERANGE: {
                agg = ((DateRangeAggregationBuilder)((DateRangeAggregationBuilder)AggregationBuilders.dateRange((String)this.asFieldName).field(this.fieldName)).format(this.format != null ? this.format : null)).addUnboundedTo(this.to != null ? this.to.toString() : null).addUnboundedFrom(this.from != null ? this.from.toString() : null);
                break;
            }
            case DATEHISTOGRAM: {
                DateHistogramAggregationBuilder dateHistogramAggregationBuilder = (DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)this.dateHistogramEntity.getName()).field(this.dateHistogramEntity.getField());
                if (this.dateHistogramEntity.getDateHistogramInterval() != null) {
                    dateHistogramAggregationBuilder.dateHistogramInterval(this.dateHistogramEntity.getDateHistogramInterval());
                }
                if (Long.valueOf(this.dateHistogramEntity.getInterval()) != null && this.dateHistogramEntity.getInterval() != 0L) {
                    dateHistogramAggregationBuilder.interval(this.dateHistogramEntity.getInterval());
                }
                if (this.dateHistogramEntity.getFixedInterval() != null) {
                    dateHistogramAggregationBuilder.fixedInterval(this.dateHistogramEntity.getFixedInterval());
                }
                if (this.dateHistogramEntity.getMinDocCount() != 0L) {
                    dateHistogramAggregationBuilder.minDocCount(this.dateHistogramEntity.getMinDocCount());
                }
                if (this.dateHistogramEntity.getOffset() != 0L) {
                    dateHistogramAggregationBuilder.offset(this.dateHistogramEntity.getMinDocCount());
                }
                if (this.dateHistogramEntity.getOrder() != null) {
                    dateHistogramAggregationBuilder.order(this.dateHistogramEntity.getOrder());
                }
                if (Strings.isNotBlank(this.dateHistogramEntity.getFormat())) {
                    dateHistogramAggregationBuilder.format(this.dateHistogramEntity.getFormat());
                }
                agg = dateHistogramAggregationBuilder;
                break;
            }
            case FILTERS: {
                agg = AggregationBuilders.filters((String)this.fieldName, (QueryBuilder[])this.filterQueryBuilders);
                break;
            }
        }
        return agg;
    }
}

