/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.query.aggregations;

import com.xphsc.elasticsearch.core.entity.aggregate.DateHistogramEntity;
import com.xphsc.elasticsearch.core.lambda.LambdaFunction;
import com.xphsc.elasticsearch.core.lambda.Reflections;
import com.xphsc.elasticsearch.core.query.Criterion;
import com.xphsc.elasticsearch.core.query.SimpleExpression;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;

public class AggregateBuilder {
    private List<AggregationBuilder> list = new ArrayList<AggregationBuilder>();
    private AggregationBuilder aggregationBuilder;

    public AggregateBuilder max(String field, String name) {
        this.aggregationBuilder = new SimpleExpression(field, name, Criterion.Projection.MAX).toAggBuilder();
        this.list.add(new SimpleExpression(field, name, Criterion.Projection.MAX).toAggBuilder());
        return this;
    }

    public <T> AggregateBuilder max(LambdaFunction<T, Object> field, String name) {
        this.aggregationBuilder = new SimpleExpression(Reflections.fieldNameForLambdaFunction(field), name, Criterion.Projection.MAX).toAggBuilder();
        this.list.add(new SimpleExpression(Reflections.fieldNameForLambdaFunction(field), name, Criterion.Projection.MAX).toAggBuilder());
        return this;
    }

    public <T> AggregateBuilder min(String field, String name) {
        this.aggregationBuilder = new SimpleExpression(field, name, Criterion.Projection.MIN).toAggBuilder();
        this.list.add(new SimpleExpression(field, name, Criterion.Projection.MIN).toAggBuilder());
        return this;
    }

    public <T> AggregateBuilder min(LambdaFunction<T, Object> field, String name) {
        this.aggregationBuilder = new SimpleExpression(Reflections.fieldNameForLambdaFunction(field), name, Criterion.Projection.MIN).toAggBuilder();
        this.list.add(new SimpleExpression(Reflections.fieldNameForLambdaFunction(field), name, Criterion.Projection.MIN).toAggBuilder());
        return this;
    }

    public AggregateBuilder avg(String field, String name) {
        this.aggregationBuilder = new SimpleExpression(field, name, Criterion.Projection.AVG).toAggBuilder();
        this.list.add(new SimpleExpression(field, name, Criterion.Projection.AVG).toAggBuilder());
        return this;
    }

    public <T> AggregateBuilder avg(LambdaFunction<T, Object> fn, String name) {
        this.aggregationBuilder = new SimpleExpression(Reflections.fieldNameForLambdaFunction(fn), name, Criterion.Projection.AVG).toAggBuilder();
        this.list.add(new SimpleExpression(Reflections.fieldNameForLambdaFunction(fn), name, Criterion.Projection.AVG).toAggBuilder());
        return this;
    }

    public AggregateBuilder count(String field, String name) {
        this.aggregationBuilder = new SimpleExpression(field, name, Criterion.Projection.COUNT).toAggBuilder();
        this.list.add(new SimpleExpression(field, name, Criterion.Projection.COUNT).toAggBuilder());
        return this;
    }

    public <T> AggregateBuilder count(LambdaFunction<T, Object> fn, String name) {
        this.aggregationBuilder = new SimpleExpression(Reflections.fieldNameForLambdaFunction(fn), name, Criterion.Projection.COUNT).toAggBuilder();
        this.list.add(new SimpleExpression(Reflections.fieldNameForLambdaFunction(fn), name, Criterion.Projection.COUNT).toAggBuilder());
        return this;
    }

    public AggregateBuilder sum(String field, String name) {
        this.aggregationBuilder = new SimpleExpression(field, name, Criterion.Projection.SUM).toAggBuilder();
        this.list.add(new SimpleExpression(field, name, Criterion.Projection.SUM).toAggBuilder());
        return this;
    }

    public <T> AggregateBuilder sum(LambdaFunction<T, Object> fn, String name) {
        this.aggregationBuilder = new SimpleExpression(Reflections.fieldNameForLambdaFunction(fn), name, Criterion.Projection.SUM).toAggBuilder();
        this.list.add(new SimpleExpression(Reflections.fieldNameForLambdaFunction(fn), name, Criterion.Projection.SUM).toAggBuilder());
        return this;
    }

    public AggregateBuilder missing(String field, String name) {
        this.aggregationBuilder = new SimpleExpression(field, name, Criterion.Projection.MISSING).toAggBuilder();
        this.list.add(new SimpleExpression(field, name, Criterion.Projection.MISSING).toAggBuilder());
        return this;
    }

    public <T> AggregateBuilder missing(LambdaFunction<T, Object> field, String name) {
        this.aggregationBuilder = new SimpleExpression(Reflections.fieldNameForLambdaFunction(field), name, Criterion.Projection.MISSING).toAggBuilder();
        this.list.add(new SimpleExpression(Reflections.fieldNameForLambdaFunction(field), name, Criterion.Projection.MISSING).toAggBuilder());
        return this;
    }

    public <T> AggregateBuilder range(String field, String name) {
        this.aggregationBuilder = new SimpleExpression(field, name, Criterion.Projection.RANGE).toAggBuilder();
        this.list.add(new SimpleExpression(field, name, Criterion.Projection.RANGE).toAggBuilder());
        return this;
    }

    public <T> AggregateBuilder dateRange(String field, String name, String to, String from, String format) {
        this.aggregationBuilder = new SimpleExpression(field, name, to, from, format, Criterion.Projection.DATERANGE).toAggBuilder();
        this.list.add(new SimpleExpression(field, name, to, from, format, Criterion.Projection.DATERANGE).toAggBuilder());
        return this;
    }

    public <T> AggregateBuilder range(LambdaFunction<T, Object> field, String name) {
        this.aggregationBuilder = new SimpleExpression(Reflections.fieldNameForLambdaFunction(field), name, Criterion.Projection.RANGE).toAggBuilder();
        this.list.add(new SimpleExpression(Reflections.fieldNameForLambdaFunction(field), name, Criterion.Projection.RANGE).toAggBuilder());
        return this;
    }

    public <T> AggregateBuilder dateHistogram(DateHistogramEntity dateHistogramEntity) {
        this.aggregationBuilder = new SimpleExpression(dateHistogramEntity, Criterion.Projection.DATEHISTOGRAM).toAggBuilder();
        this.list.add(new SimpleExpression(dateHistogramEntity, Criterion.Projection.DATEHISTOGRAM).toAggBuilder());
        return this;
    }

    public AggregateBuilder stats(String field, String name) {
        this.aggregationBuilder = new SimpleExpression(field, name, Criterion.Projection.STATS).toAggBuilder();
        this.list.add(new SimpleExpression(field, name, Criterion.Projection.STATS).toAggBuilder());
        return this;
    }

    public <T> AggregateBuilder stats(LambdaFunction<T, Object> field, String name) {
        this.aggregationBuilder = new SimpleExpression(Reflections.fieldNameForLambdaFunction(field), name, Criterion.Projection.STATS).toAggBuilder();
        this.list.add(new SimpleExpression(Reflections.fieldNameForLambdaFunction(field), name, Criterion.Projection.STATS).toAggBuilder());
        return this;
    }

    public AggregateBuilder filters(String field, QueryBuilder ... filterQueryBuilders) {
        this.aggregationBuilder = new SimpleExpression(field, filterQueryBuilders, Criterion.Projection.FILTERS).toAggBuilder();
        this.list.add(new SimpleExpression(field, filterQueryBuilders, Criterion.Projection.FILTERS).toAggBuilder());
        return this;
    }

    public <T> AggregateBuilder filters(LambdaFunction<T, Object> field, QueryBuilder ... filterQueryBuilders) {
        this.aggregationBuilder = new SimpleExpression(Reflections.fieldNameForLambdaFunction(field), filterQueryBuilders, Criterion.Projection.FILTERS).toAggBuilder();
        this.list.add(new SimpleExpression(Reflections.fieldNameForLambdaFunction(field), filterQueryBuilders, Criterion.Projection.FILTERS).toAggBuilder());
        return this;
    }

    public AggregateBuilder subAggregation(AggregateBuilder aggregateBuilder) {
        this.aggregationBuilder = aggregateBuilder.aggregationBuilder();
        this.list.add(this.aggregationBuilder);
        return this;
    }

    public List<AggregationBuilder> listAggBuilders() {
        return this.list;
    }

    public AggregationBuilder aggregationBuilder() {
        return this.aggregationBuilder;
    }
}

