/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.support;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.core.support.SecuredHttpClient;
import com.xphsc.elasticsearch.util.Strings;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.LinkedList;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class ElasticsearchAccessor {
    private RestHighLevelClientBulider client;
    private RestClient restClient = null;
    private String userName;
    private String password;
    private String[] uris = new String[0];
    private String proxyHost;
    private Integer proxyPort;
    private int connectTimeout = 5000;
    private int socketTimeout;
    private int connectionRequestTimeout;
    private int maxRetryTimeoutMillis;
    private boolean sslEnabled;

    public ElasticsearchAccessor() {
    }

    public RestHighLevelClientBulider initClient() {
        if (null == this.client) {
            RestClientBuilder builder = null;
            if (this.uris != null && this.uris.length > 0 && Strings.isBlank(this.proxyHost)) {
                LinkedList<HttpHost> list = new LinkedList<HttpHost>();
                for (String uri : this.uris) {
                    String url = !this.sslEnabled ? Strings.substringAfter(uri, "http://") : Strings.substringAfter(uri, "https://");
                    String[] urls = url.split(":");
                    String host = urls[0];
                    int port = Integer.parseInt(urls[1]);
                    HttpHost httpHost = !this.sslEnabled ? new HttpHost(host, port, "http") : new HttpHost(host, port, "https");
                    list.add(httpHost);
                }
                builder = RestClient.builder((HttpHost[])list.toArray(new HttpHost[list.size()]));
            }
            if (Strings.isNotBlank(this.proxyHost) && this.proxyPort != 0) {
                builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.proxyHost, this.proxyPort.intValue(), "http")});
            }
            if (builder != null) {
                SSLContext sc = null;
                try {
                    sc = SSLContext.getInstance("SSL");
                    sc.init(null, SecuredHttpClient.trustAllCerts, new SecureRandom());
                }
                catch (KeyManagementException e) {
                    e.printStackTrace();
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                SSLIOSessionStrategy sessionStrategy = new SSLIOSessionStrategy(sc, (HostnameVerifier)new SecuredHttpClient.NullHostnameVerifier());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                if (Strings.isNotBlank(this.userName) && Strings.isNotBlank(this.password)) {
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
                }
                SecuredHttpClient.SecuredHttpClientConfigCallback securedHttpClientConfigCallback = new SecuredHttpClient.SecuredHttpClientConfigCallback((CredentialsProvider)credentialsProvider, sessionStrategy);
                builder.setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

                    public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder config) {
                        if (ElasticsearchAccessor.this.connectTimeout != 0) {
                            config.setConnectTimeout(ElasticsearchAccessor.this.connectTimeout);
                        }
                        if (ElasticsearchAccessor.this.socketTimeout != 0) {
                            config.setSocketTimeout(ElasticsearchAccessor.this.socketTimeout);
                        }
                        if (ElasticsearchAccessor.this.connectionRequestTimeout != 0) {
                            config.setConnectionRequestTimeout(ElasticsearchAccessor.this.connectionRequestTimeout);
                        }
                        return config;
                    }
                });
                builder.setHttpClientConfigCallback((RestClientBuilder.HttpClientConfigCallback)securedHttpClientConfigCallback);
                this.restClient = builder.build();
                this.client = new RestHighLevelClientBulider(builder);
            }
        }
        return this.client;
    }

    private ElasticsearchAccessor(Builder builder) {
        this.userName = builder.username;
        this.password = builder.password;
        this.uris = builder.uris;
        this.proxyHost = builder.proxyHost;
        this.proxyPort = builder.proxyPort;
        this.connectTimeout = builder.connectTimeout;
        this.socketTimeout = builder.socketTimeout;
        this.connectionRequestTimeout = builder.connectionRequestTimeout;
        this.maxRetryTimeoutMillis = builder.maxRetryTimeoutMillis;
        this.sslEnabled = builder.sslEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void setClient(RestHighLevelClientBulider client) {
        this.client = client;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName.trim();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password.trim();
    }

    public RestClient getRestClient() {
        return this.initClient().getLowLevelClient();
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public String[] getUris() {
        return this.uris;
    }

    public void setUris(String[] uris) {
        this.uris = uris;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public int getMaxRetryTimeoutMillis() {
        return this.maxRetryTimeoutMillis;
    }

    public void setMaxRetryTimeoutMillis(int maxRetryTimeoutMillis) {
        this.maxRetryTimeoutMillis = maxRetryTimeoutMillis;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public static class Builder {
        private String username;
        private String password;
        private String[] uris = new String[0];
        private String proxyHost;
        private Integer proxyPort;
        private int connectTimeout;
        private int socketTimeout;
        private int connectionRequestTimeout;
        private int maxRetryTimeoutMillis;
        private boolean sslEnabled;

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder uris(String[] uris) {
            this.uris = uris;
            return this;
        }

        public Builder proxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
            return this;
        }

        public Builder proxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder connectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public Builder maxRetryTimeoutMillis(int maxRetryTimeoutMillis) {
            this.maxRetryTimeoutMillis = maxRetryTimeoutMillis;
            return this;
        }

        public Builder sslEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        public ElasticsearchAccessor build() {
            return new ElasticsearchAccessor(this);
        }
    }
}

