/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.transform;

import com.xphsc.elasticsearch.annotations.Document;
import com.xphsc.elasticsearch.annotations.Mapping;
import com.xphsc.elasticsearch.annotations.Setting;
import com.xphsc.elasticsearch.core.entity.PersistentEntity;
import com.xphsc.elasticsearch.util.Strings;
import com.xphsc.elasticsearch.util.io.ClassPathResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;

public class DynamicEntity {
    public static PersistentEntity getPersistentEntityFor(Class clazz) {
        String index = "";
        String type = "";
        String refreshInterval = "";
        short shards = 0;
        short replicas = 0;
        long maxResult = 0L;
        boolean autoCreateIndex = false;
        String storeType = "";
        String alias = "";
        String dynamic = "";
        boolean ignoreTypeName = false;
        try {
            Document document = clazz.getClassLoader().loadClass(clazz.getName()).getAnnotation(Document.class);
            index = document.indexName();
            type = document.type();
            autoCreateIndex = document.createIndex();
            shards = document.shards();
            replicas = document.replicas();
            refreshInterval = document.refreshInterval();
            storeType = document.indexStoreType();
            alias = document.aliasName();
            dynamic = document.dynamic();
            maxResult = document.maxResult();
            ignoreTypeName = document.ignoreTypeName();
            PersistentEntity entity = PersistentEntity.builder().indexName(index).indexType(type).shards(shards).replicas(replicas).autoCreateIndex(autoCreateIndex).indexStoreType(storeType).alias(alias).refreshInterval(refreshInterval).dynamic(dynamic).ignoreTypeName(ignoreTypeName).maxResult(maxResult).build();
            return entity;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String settings(Class<?> clazz) {
        String settingPath;
        String settings = null;
        if (clazz.isAnnotationPresent(Setting.class) && !Strings.isEmpty(settingPath = clazz.getAnnotation(Setting.class).settingPath())) {
            settings = DynamicEntity.readFileFromClasspath(settingPath);
        }
        return settings;
    }

    public static boolean annotatinSettings(Class<?> clazz) {
        boolean settings = false;
        if (clazz.isAnnotationPresent(Setting.class)) {
            settings = true;
        }
        return settings;
    }

    public static String getMappingFor(Class clazz, XContentBuilder mapping) {
        Field[] fields;
        for (Field field : fields = DynamicEntity.retrieveFields(clazz)) {
            ClassPathResource mappings;
            String mappingPath;
            if (!field.isAnnotationPresent(Mapping.class) || Strings.isEmpty(mappingPath = field.getAnnotation(Mapping.class).mappingPath()) || !(mappings = new ClassPathResource(mappingPath)).exists() || mapping == null) continue;
            try {
                mapping.rawField(field.getName(), mappings.getInputStream(), XContentType.JSON);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            mapping.endObject().endObject().endObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            String e = XContentHelper.convertToJson((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (boolean)false, (XContentType)XContentType.JSON);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Field[] retrieveFields(Class<?> clazz) {
        ArrayList<Field> fieldLists = new ArrayList<Field>();
        Class<?> targetClass = clazz;
        do {
            fieldLists.addAll(Arrays.asList(targetClass.getDeclaredFields()));
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        return fieldLists.toArray(new Field[fieldLists.size()]);
    }

    public static String mappings(Class<?> clazz) {
        String mappingPath;
        String mappings = null;
        if (clazz.isAnnotationPresent(Mapping.class) && !Strings.isEmpty(mappingPath = clazz.getAnnotation(Mapping.class).mappingPath())) {
            mappings = DynamicEntity.readFileFromClasspath(mappingPath);
        }
        return mappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileFromClasspath(String url) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            String line;
            ClassPathResource classPathResource = new ClassPathResource(url);
            InputStreamReader inputStreamReader = new InputStreamReader(classPathResource.getInputStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            String lineSeparator = System.getProperty("line.separator");
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line).append(lineSeparator);
            }
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuilder.toString();
    }
}

