/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.page;

import java.util.List;

public class Page<T> {
    private int pageNum;
    private int pageSize;
    private long total = 0L;
    private List<T> list;
    private int totalPages;
    private int offset = -1;
    private int limit;
    private int prePage;
    private int nextPage;
    private boolean hasPrePage;
    private boolean hasNextPage;

    public Page() {
    }

    public Page(int pageNum, int pageSize) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Page(Builder builder) {
        this.pageNum = builder.pageNum;
        this.pageSize = builder.pageSize;
        this.total = builder.total;
        this.list = builder.list;
        this.totalPages = builder.totalPages;
        this.offset = builder.offset;
        this.limit = builder.limit;
        this.prePage = builder.prePage;
        this.nextPage = builder.nextPage;
        this.hasPrePage = builder.hasPrePage;
        this.hasNextPage = builder.hasNextPage;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    public void setHasNextPage(boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    public boolean isHasPrePage() {
        return this.hasPrePage;
    }

    public void setHasPrePage(boolean hasPrePage) {
        this.hasPrePage = hasPrePage;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPrePage() {
        return this.prePage;
    }

    public void setPrePage(int prePage) {
        this.prePage = prePage;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public List<T> getList() {
        return this.list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public static class Builder {
        private int pageNum;
        private int pageSize;
        private long total = 1L;
        private List<Object> list;
        private int totalPages;
        private int offset = -1;
        private int limit;
        private int prePage;
        private int nextPage;
        private boolean hasPrePage;
        private boolean hasNextPage;

        public Builder pageNum(int pageNum) {
            this.pageNum = pageNum;
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder total(long total) {
            this.total = total;
            return this;
        }

        public Builder list(List<Object> list) {
            this.list = list;
            return this;
        }

        public Builder totalPages(int totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        public Builder offset(int offset) {
            this.offset = offset;
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder prePage(int prePage) {
            this.prePage = prePage;
            return this;
        }

        public Builder nextPage(int nextPage) {
            this.nextPage = nextPage;
            return this;
        }

        public Builder hasPrePage(boolean hasPrePage) {
            this.hasPrePage = hasPrePage;
            return this;
        }

        public Builder hasNextPage(boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
            return this;
        }

        public Page build() {
            return new Page(this);
        }
    }
}

