/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.page;

import com.xphsc.elasticsearch.page.Page;
import java.util.Collections;
import java.util.List;

public class PageImpl<T>
extends Page<T> {
    public PageImpl() {
    }

    public PageImpl(List<T> list, long total, int pageNum, int pageSize) {
        this.setPageNum(pageNum);
        if (pageNum < 1) {
            this.setPageNum(1);
        }
        this.setPageSize(pageSize);
        this.setTotal(total);
        this.setList(list);
        this.setPrePage(this.getPageNum() - 1);
        if (this.getPrePage() < 1) {
            this.setHasPrePage(false);
            this.setPrePage(1);
        } else {
            this.setHasPrePage(true);
        }
        this.setTotalPages((int)Math.ceil((double)total / (double)pageSize));
        if (this.getPageNum() > this.getTotalPages()) {
            this.setPageNum(this.getTotalPages());
        }
        this.setNextPage(this.getPageNum() + 1);
        if (this.getNextPage() > this.getTotalPages()) {
            this.setHasNextPage(false);
            this.setNextPage(this.getTotalPages());
        } else {
            this.setHasNextPage(true);
        }
        this.setOffset(this.getPageNum() * pageSize - pageSize);
        this.setLimit(this.getPageSize());
    }

    public PageImpl(List<T> list, int pageNum, int pageSize) {
        this.setPageSize(pageSize);
        this.setPageNum(pageNum);
        this.setTotal(list.size());
        this.setTotalPages((int)Math.ceil((double)this.getTotal() / (double)pageSize));
        if (this.getPageNum() > this.getTotalPages()) {
            this.setPageNum(this.getTotalPages());
        }
        this.setPrePage(pageNum - 1 > 1 ? pageNum - 1 : 1);
        this.setNextPage(pageNum >= this.getTotalPages() ? this.getTotalPages() : pageNum + 1);
        this.setList(this.getPageList(list));
        this.setOffset((this.getPageNum() - 1) * pageSize);
    }

    public List<T> getPageList(List<T> recordList) {
        int fromIndex = (this.getPageNum() - 1) * this.getPageSize();
        if (fromIndex >= recordList.size()) {
            return Collections.emptyList();
        }
        if (fromIndex < 0) {
            return Collections.emptyList();
        }
        int toIndex = this.getPageNum() * this.getPageSize();
        if (toIndex >= recordList.size()) {
            toIndex = recordList.size();
        }
        return recordList.subList(fromIndex, toIndex);
    }
}

