/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.util;

import com.xphsc.elasticsearch.annotations.Id;
import com.xphsc.elasticsearch.util.Strings;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Beans {
    public static Map<String, Object> objectToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Field[] declaredFields = obj.getClass().getDeclaredFields();
        Field[] superDeclaredFields = obj.getClass().getSuperclass().getDeclaredFields();
        for (Field field : declaredFields) {
            if (Beans.getIdName(obj.getClass()).equals(field.getName())) {
                if (null == Beans.getIdValue(obj)) continue;
                field.setAccessible(true);
                try {
                    map.put(field.getName(), field.get(obj));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                continue;
            }
            field.setAccessible(true);
            try {
                map.put(field.getName(), field.get(obj));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (Field field : superDeclaredFields) {
            field.setAccessible(true);
            try {
                map.put(field.getName(), field.get(obj));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public static <T> String getIdValue(T entity) {
        try {
            Field[] declaredFields = null;
            for (Field declaredField : declaredFields = entity.getClass().getClassLoader().loadClass(entity.getClass().getName()).getDeclaredFields()) {
                Id annotation = declaredField.getAnnotation(Id.class);
                if (null == annotation) continue;
                declaredField.setAccessible(true);
                String value = declaredField.get(entity).toString();
                return value;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static <T> String getIdName(Class<T> entity) {
        try {
            Field[] declaredFields = null;
            for (Field declaredField : declaredFields = entity.getClassLoader().loadClass(entity.getName()).getDeclaredFields()) {
                Id annotation = declaredField.getAnnotation(Id.class);
                if (null == annotation) continue;
                String name = declaredField.getName();
                return name;
            }
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return null;
    }

    public static Object mapToObject(Map<String, Object> map, Class<?> beanClass) throws Exception {
        Field[] superFields;
        Field[] fields;
        if (map == null) {
            return null;
        }
        Object obj = beanClass.newInstance();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
            field.setAccessible(true);
            field.set(obj, map.get(field.getName()));
        }
        for (Field field : superFields = obj.getClass().getSuperclass().getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) continue;
            field.setAccessible(true);
            field.set(obj, map.get(field.getName()));
        }
        return obj;
    }

    public static Object combineObject(Object combinedObj, Object obj) throws Exception {
        Map<String, Object> combinedMap = Beans.objectToMap(combinedObj);
        Map<String, Object> objMap = Beans.objectToMap(obj);
        ArrayList list = new ArrayList();
        for (Map.Entry<String, Object> entry : objMap.entrySet()) {
            if (!combinedMap.containsKey(entry.getKey()) || entry.getValue() == null) continue;
            combinedMap.remove(entry.getKey());
            combinedMap.put(entry.getKey(), entry.getValue());
        }
        return Beans.mapToObject(combinedMap, combinedObj.getClass());
    }

    public static Object combineObject(Object combinedObj, Map<String, Object> objMap) throws Exception {
        Map<String, Object> combinedMap = Beans.objectToMap(combinedObj);
        for (Map.Entry<String, Object> entry : objMap.entrySet()) {
            if (!combinedMap.containsKey(entry.getKey()) || !Strings.isNotBlank(entry.getValue().toString())) continue;
            combinedMap.remove(entry.getKey());
            combinedMap.put(entry.getKey(), entry.getValue());
        }
        return Beans.mapToObject(combinedMap, combinedObj.getClass());
    }

    public static Map<String, Object> combineObject(Map<String, Object> combinedMap, Map<String, Object> objMap) throws Exception {
        for (Map.Entry<String, Object> entry : objMap.entrySet()) {
            if (!combinedMap.containsKey(entry.getKey()) || !Strings.isNotBlank(entry.getValue().toString())) continue;
            combinedMap.remove(entry.getKey());
            combinedMap.put(entry.getKey(), entry.getValue());
        }
        return combinedMap;
    }
}

