/*
 * Decompiled with CFR 0.152.
 */
package cn.zvo.fileupload.storage.aliyunOSS;

import cn.zvo.fileupload.StorageInterface;
import cn.zvo.fileupload.bean.SubFileBean;
import cn.zvo.fileupload.storage.aliyunOSS.OSS;
import cn.zvo.fileupload.vo.StorageConfigVO;
import cn.zvo.fileupload.vo.UploadFileVO;
import cn.zvo.fileupload.vo.bean.Param;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.PutObjectResult;
import com.xnx3.BaseVO;
import com.xnx3.Log;
import com.xnx3.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AliyunOSSStorage
implements StorageInterface {
    private OSS oss;

    public AliyunOSSStorage(String accessKeyId, String secretAccessKey, String endpoint, String bucketname) {
        this.init(accessKeyId, secretAccessKey, endpoint, bucketname);
    }

    public AliyunOSSStorage(Map<String, String> map) {
        String secretAccessKey = map.get("secretAccessKey");
        String accessKeyId = map.get("accessKeyId");
        String endpoint = map.get("endpoint");
        String bucketname = map.get("bucketname");
        this.init(accessKeyId, secretAccessKey, endpoint, bucketname);
    }

    private void init(String accessKeyId, String secretAccessKey, String endpoint, String bucketname) {
        this.oss = new OSS(endpoint, accessKeyId, secretAccessKey, bucketname, "");
    }

    public OSS getOss() {
        return this.oss;
    }

    public UploadFileVO upload(String path, InputStream inputStream) {
        PutObjectResult result = this.getOss().getOSSClient().putObject(this.getOss().bucketName, path, inputStream);
        Log.info((String)result.toString());
        String fileName = StringUtil.subString((String)path, (String)"/", null, (int)3);
        UploadFileVO vo = new UploadFileVO();
        vo.setName(fileName);
        vo.setPath(path);
        return vo;
    }

    public BaseVO delete(String path) {
        this.getOss().deleteObject(path);
        return BaseVO.success();
    }

    public void copyFile(String originalFilePath, String newFilePath) {
        String bucketname = this.getOss().bucketName;
        this.getOss().getOSSClient().copyObject(bucketname, originalFilePath, bucketname, newFilePath);
    }

    public List<SubFileBean> getSubFileList(String path) {
        ArrayList<SubFileBean> list = new ArrayList<SubFileBean>();
        if (path == null || path.length() == 0) {
            return list;
        }
        List<OSSObjectSummary> resultList = this.getOss().getFolderObjectList(path);
        for (int i = 0; i < resultList.size(); ++i) {
            OSSObjectSummary item = resultList.get(i);
            SubFileBean bean = new SubFileBean();
            bean.setPath(item.getKey());
            bean.setSize(item.getSize());
            bean.setLastModified(item.getLastModified().getTime());
            bean.setFolder(item.getKey().lastIndexOf("/") + 1 == item.getKey().length());
            list.add(bean);
        }
        return list;
    }

    public long getSize(String path) {
        if (path == null) {
            return -1L;
        }
        if (path.lastIndexOf("/") + 1 == path.length()) {
            return this.getOss().getFolderSize(path);
        }
        OSSObject ossObject = this.getOss().getOSSClient().getObject(this.getOss().bucketName, path);
        if (ossObject == null || ossObject.getObjectContent() == null) {
            return -1L;
        }
        try {
            return ossObject.getObjectContent().available();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public BaseVO createFolder(String path) {
        this.getOss().createFolder(path);
        return BaseVO.success();
    }

    public InputStream get(String path) {
        try {
            OSSObject ossObject = this.getOss().getOSSClient().getObject(this.getOss().bucketName, path);
            return ossObject.getObjectContent();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public StorageConfigVO config() {
        StorageConfigVO vo = new StorageConfigVO();
        vo.setName("\u963f\u91cc\u4e91OSS");
        vo.setDescription("\u963f\u91cc\u4e91\u5bf9\u8c61\u5b58\u50a8OSS");
        vo.getParamList().add(new Param("accessKeyId", "Access Key Id", "\u963f\u91cc\u4e91\u7684 Access Key Id", true, ""));
        vo.getParamList().add(new Param("secretAccessKey", "Secret Access Key", "\u963f\u91cc\u4e91\u7684Secret Access Key", true, ""));
        vo.getParamList().add(new Param("endpoint", "endpoint", "OSS\u670d\u52a1\u7684Endpoint\u3002\u5982\uff1aoss-cn-hongkong.aliyuncs.com", true, ""));
        vo.getParamList().add(new Param("bucketname", "\u6876\u540d\u79f0", "OSS\u670d\u52a1\u7684Bucket\u6876\u540d\u79f0", true, ""));
        return vo;
    }
}

