/*
 * Decompiled with CFR 0.152.
 */
package co.bittub.ares.cache.redis;

import co.bittub.ares.cache.redis.RedisAbstractCacheHandler;
import co.bittub.prime.cache.CacheHandler;
import co.bittub.prime.cache.CacheItem;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedisCacheHandler
extends RedisAbstractCacheHandler
implements CacheHandler {
    private static final Logger logger = LoggerFactory.getLogger(RedisCacheHandler.class);
    private final ObjectMapper om = new ObjectMapper();

    @Autowired
    public RedisCacheHandler(RedisClient client) {
        super(client);
        this.om.findAndRegisterModules();
    }

    public CacheItem get(String key) {
        CacheItem item = CacheItem.newInstance((String)key);
        try {
            StatefulRedisConnection<String, String> connection = this.getConnection();
            RedisCommands commands = connection.sync();
            item.setValue(commands.get((Object)key));
            connection.close();
        }
        catch (Exception e) {
            logger.error("Unable to get cache of key {}. Exception: {}", (Object)key, (Object)e.getMessage());
        }
        return item;
    }

    public int put(CacheItem ... items) {
        int numberOfPutItems = 0;
        for (CacheItem item : items) {
            if (item.getValue() == null || !this.put(item)) continue;
            ++numberOfPutItems;
        }
        return numberOfPutItems;
    }

    public int delete(String ... keys) {
        int numberOfDeletedItems = 0;
        StatefulRedisConnection<String, String> connection = this.getConnection();
        RedisCommands commands = connection.sync();
        for (String key : keys) {
            try {
                commands.del((Object[])new String[]{key});
                ++numberOfDeletedItems;
            }
            catch (Exception e) {
                logger.error("Unable to delete cache of key {}. Exception: {}", (Object)key, (Object)e.getMessage());
            }
        }
        connection.close();
        return numberOfDeletedItems;
    }

    public Boolean has(String key) {
        StatefulRedisConnection<String, String> connection = this.getConnection();
        RedisCommands commands = connection.sync();
        boolean ok = commands.exists((Object[])new String[]{key}) > 0L;
        connection.close();
        return ok;
    }

    private boolean put(CacheItem item) {
        try {
            StatefulRedisConnection<String, String> connection = this.getConnection();
            RedisCommands commands = connection.sync();
            if (item.getValue() instanceof String) {
                commands.set((Object)item.getKey(), (Object)((String)item.getValue()));
            } else {
                commands.set((Object)item.getKey(), (Object)this.om.writeValueAsString(item.getValue()));
            }
            if (item.getExpiration() != null) {
                commands.expire((Object)item.getKey(), item.getExpiration().longValue());
            }
            connection.close();
            return true;
        }
        catch (Exception e) {
            logger.error("Unable to put cache of key {}. Exception: {}", (Object)item.getKey(), (Object)e.getMessage());
            return false;
        }
    }

    public ObjectMapper getOm() {
        return this.om;
    }
}

