/*
 * Decompiled with CFR 0.152.
 */
package co.bittub.ares.cache.redis;

import co.bittub.ares.cache.redis.RedisAbstractCacheHandler;
import co.bittub.prime.cache.CacheItem;
import co.bittub.prime.cache.redis.ListCacheHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RedisListCacheHandler
extends RedisAbstractCacheHandler
implements ListCacheHandler {
    private static final Logger logger = LoggerFactory.getLogger(RedisListCacheHandler.class);
    private final ObjectMapper om = new ObjectMapper();

    @Autowired
    public RedisListCacheHandler(RedisClient client) {
        super(client);
        this.om.findAndRegisterModules();
    }

    public long pushLeft(String key, Object ... values) {
        return this.execute(commands -> commands.lpush((Object)key, (Object[])this.serialize(values)));
    }

    public long pushRight(String key, Object ... values) {
        return this.execute(commands -> commands.rpush((Object)key, (Object[])this.serialize(values)));
    }

    public CacheItem popLeft(String key) {
        return this.execute(commands -> CacheItem.newInstance((String)key, (Object)commands.lpop((Object)key)));
    }

    public CacheItem popRight(String key) {
        return this.execute(commands -> CacheItem.newInstance((String)key, (Object)commands.rpop((Object)key)));
    }

    public List<CacheItem> range(String key, long start, long stop) {
        return this.execute(commands -> {
            List values = commands.lrange((Object)key, start, stop);
            ArrayList<CacheItem> items = new ArrayList<CacheItem>();
            for (String value : values) {
                items.add(CacheItem.newInstance((String)key, (Object)value));
            }
            return items;
        });
    }

    public long size(String key) {
        return this.execute(commands -> commands.llen((Object)key));
    }

    private <R> R execute(Function<RedisCommands<String, String>, R> executor) {
        StatefulRedisConnection connection = this.client.connect();
        RedisCommands commands = connection.sync();
        R result = executor.apply((RedisCommands<String, String>)commands);
        connection.close();
        return result;
    }

    private String serialize(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return this.om.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            logger.error("Unable to serialize object {}. Exception: {}", value, (Object)e.getMessage());
            return null;
        }
    }

    private String[] serialize(Object ... values) {
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.serialize(values[i]);
        }
        return result;
    }
}

