/*
 * Decompiled with CFR 0.152.
 */
package co.bittub.ares.cache.redis.config;

import co.bittub.ares.cache.redis.RedisListCacheHandler;
import co.bittub.prime.cache.redis.ListCacheHandler;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedisBeanConfig {
    @Value(value="${spring.redis.host:localhost}")
    private String redisHost;
    @Value(value="${spring.redis.port:6379}")
    private int redisPort;

    @Bean
    @ConditionalOnMissingBean
    public RedisClient redisClient() {
        RedisClient client = RedisClient.create((RedisURI)RedisURI.create((String)this.redisHost, (int)this.redisPort));
        client.setDefaultTimeout(Duration.ofSeconds(20L));
        return client;
    }

    @Bean
    @ConditionalOnMissingBean
    public ListCacheHandler listCacheHandler() {
        return new RedisListCacheHandler(this.redisClient());
    }
}

