/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.common;

import co.datadome.api.shaded.http.conn.DnsResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class DataDomeResolver
implements DnsResolver {
    private final String host;
    private final String proxyServerName;
    private final int refreshIn;
    private final DnsResolver dnsResolver;
    private Map<String, InetAddress[]> inetAddresses;
    private AtomicLong lastTimeRefreshed = new AtomicLong(Long.MIN_VALUE);

    public DataDomeResolver(String host, int refreshIn, DnsResolver dnsResolver) throws UnknownHostException {
        this(host, null, refreshIn, dnsResolver);
    }

    public DataDomeResolver(String host, String proxyServerName, int refreshIn, DnsResolver dnsResolver) throws UnknownHostException {
        this.host = host;
        this.proxyServerName = proxyServerName;
        this.refreshIn = refreshIn;
        this.dnsResolver = dnsResolver;
        this.inetAddresses = new HashMap<String, InetAddress[]>(2);
        this.refresh();
    }

    public void refresh() throws UnknownHostException {
        for (String h : new String[]{this.host, this.proxyServerName}) {
            if (h == null || h.trim().isEmpty()) continue;
            InetAddress[] resolved = this.dnsResolver.resolve(h);
            this.inetAddresses.put(h, resolved);
        }
    }

    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        InetAddress[] result;
        if (host != null && !host.equals(this.host) && !host.equals(this.proxyServerName)) {
            throw new UnknownHostException("DataDome resolver configured to resolve only " + this.host + "," + this.proxyServerName);
        }
        long lastTime = this.lastTimeRefreshed.get();
        long now = System.currentTimeMillis();
        if (this.refreshIn <= 0 || now - (long)this.refreshIn > lastTime && this.lastTimeRefreshed.compareAndSet(lastTime, now)) {
            this.refresh();
        }
        if ((result = this.inetAddresses.get(host)) == null) {
            throw new UnknownHostException("DataDome resolver failed to resolve this host: " + host);
        }
        return result;
    }
}

