/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.servlet;

import co.datadome.api.common.DataDomeEnvironment;
import co.datadome.api.common.DataDomeRequestConsumer;
import co.datadome.api.common.DataDomeService;
import co.datadome.api.servlet.FilterHttpRequest;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DataDomeFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(DataDomeFilter.class.getCanonicalName());
    private DataDomeRequestConsumer requestConsumer = null;
    private static final Pattern varRegex = Pattern.compile("(\\$\\{(/?[^\\}]+)\\})");

    public void init(FilterConfig filterConfig) throws ServletException {
        String apiKey = this.getStringParam(filterConfig, "datadome.apikey", null);
        String apiHost = this.getStringParam(filterConfig, "datadome.hostname", "api.datadome.co");
        boolean apiSSL = this.getBooleanParam(filterConfig, "datadome.ssl", DataDomeService.DEFAULT_API_SSL);
        String regex = this.getStringParam(filterConfig, "datadome.regex", "");
        String exclusionRegex = this.getStringParam(filterConfig, "datadome.exclusion_regex", "(?i)\\.(avi|flv|mka|mkv|mov|mp4|mpeg|mpg|mp3|flac|ogg|ogm|opus|wav|webm|webp|bmp|gif|ico|jpeg|jpg|png|svg|svgz|swf|eot|otf|ttf|woff|woff2|css|less|js)$");
        int connectTimeout = this.getIntegerParam(filterConfig, "datadome.connection_timeout", 150);
        int readTimeout = this.getIntegerParam(filterConfig, "datadome.read_timeout", 50);
        int maxConnections = this.getIntegerParam(filterConfig, "datadome.max_connections", 100);
        String proxyServer = this.getStringParam(filterConfig, "datadome.proxy_server", "");
        int proxyPort = this.getIntegerParam(filterConfig, "datadome.proxy_port", 0);
        boolean proxySSL = this.getBooleanParam(filterConfig, "datadome.proxy_ssl", false);
        String skipIps = this.getStringParam(filterConfig, "datadome.skip_ips", "");
        boolean useXForwardedHost = this.getBooleanParam(filterConfig, "datadome.use_x_forwarded_host", false);
        List<String> skipIpSet = skipIps.isEmpty() ? Collections.emptyList() : Arrays.asList(skipIps.split(","));
        try {
            this.requestConsumer = new DataDomeRequestConsumer(new DataDomeService(apiKey, apiHost, apiSSL, proxyServer, proxyPort, proxySSL, connectTimeout, readTimeout, maxConnections), regex, exclusionRegex, skipIpSet, useXForwardedHost);
        }
        catch (UnknownHostException e) {
            throw new ServletException("Can not create DataDomeService", (Throwable)e);
        }
        DataDomeEnvironment.setServerInfo(filterConfig.getServletContext().getServerInfo());
    }

    protected void init(DataDomeRequestConsumer dataDomeRequestConsumer, String serverInfo) {
        this.requestConsumer = dataDomeRequestConsumer;
        DataDomeEnvironment.setServerInfo(serverInfo);
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest) || !(resp instanceof HttpServletResponse)) {
            logger.log(Level.WARNING, "DataDome can process only HttpServletRequest");
            chain.doFilter(req, resp);
            return;
        }
        FilterHttpRequest httpRequest = new FilterHttpRequest((HttpServletRequest)req, (HttpServletResponse)resp, chain);
        this.requestConsumer.accept(httpRequest);
    }

    public void destroy() {
        this.requestConsumer = null;
    }

    protected String getStringParam(FilterConfig filterConfig, String name, String defaultValue) throws UnavailableException {
        String rawValue = filterConfig.getInitParameter(name);
        if (rawValue == null) {
            if (defaultValue == null) {
                throw new UnavailableException("Missed DataDome filter init-param: " + name);
            }
            return defaultValue;
        }
        Matcher m = varRegex.matcher(rawValue);
        while (m.find()) {
            String wrappedEnvName = m.group(1);
            String envName = m.group(2);
            String envValue = this.getEnv(envName);
            if (envValue == null) {
                throw new UnavailableException("Undefined variable " + envName);
            }
            rawValue = rawValue.replace(wrappedEnvName, envValue);
        }
        return rawValue;
    }

    protected String getEnv(String envName) {
        return System.getenv(envName);
    }

    protected boolean getBooleanParam(FilterConfig filterConfig, String name, Boolean defaultValue) throws UnavailableException {
        return Boolean.valueOf(this.getStringParam(filterConfig, name, defaultValue.toString()));
    }

    protected int getIntegerParam(FilterConfig filterConfig, String name, Integer defaultValue) throws UnavailableException {
        String param = this.getStringParam(filterConfig, name, defaultValue.toString());
        try {
            return Integer.valueOf(param);
        }
        catch (NumberFormatException e) {
            throw new UnavailableException("DataDome filter init-param: " + name + " should be valid integer but it was: " + param);
        }
    }

    protected DataDomeRequestConsumer getRequestConsumer() {
        return this.requestConsumer;
    }
}

