/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.servlet;

import co.datadome.api.common.DataDomeResponse;
import co.datadome.api.common.HttpRequest;
import co.datadome.api.servlet.EnrichedHttpServletRequest;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FilterHttpRequest
implements HttpRequest {
    private final EnrichedHttpServletRequest httpServletRequest;
    private final HttpServletResponse httpServletResponse;
    private final FilterChain filterChain;

    public FilterHttpRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) {
        this.httpServletRequest = new EnrichedHttpServletRequest(httpServletRequest);
        this.httpServletResponse = httpServletResponse;
        this.filterChain = filterChain;
    }

    @Override
    public String uri() {
        return this.httpServletRequest.getRequestURI();
    }

    @Override
    public String query() {
        return this.httpServletRequest.getQueryString();
    }

    @Override
    public String protocol() {
        return this.httpServletRequest.getScheme();
    }

    @Override
    public String method() {
        return this.httpServletRequest.getMethod();
    }

    @Override
    public void next() throws IOException, ServletException {
        this.filterChain.doFilter((ServletRequest)this.httpServletRequest, (ServletResponse)this.httpServletResponse);
    }

    @Override
    public void timeSpent(long elapsedTime) {
        this.httpServletRequest.setAttribute("datadome.spent_time", elapsedTime);
    }

    @Override
    public void addHeadersInRequest(Set<Map.Entry<String, String>> headers) {
        for (Map.Entry<String, String> header : headers) {
            this.httpServletRequest.addHeader(header.getKey(), header.getValue());
        }
    }

    @Override
    public void addHeadersInResponse(Set<Map.Entry<String, String>> headers) {
        for (Map.Entry<String, String> header : headers) {
            this.httpServletResponse.addHeader(header.getKey(), header.getValue());
        }
    }

    @Override
    public void block(DataDomeResponse dataDomeResponse) throws IOException {
        this.httpServletResponse.setStatus(dataDomeResponse.getStatusCode());
        this.httpServletResponse.getWriter().write(dataDomeResponse.getResponseBody());
    }

    @Override
    public String getHeader(String header) {
        return this.httpServletRequest.getHeader(header);
    }

    @Override
    public Collection<String> headers() {
        return Collections.list(this.httpServletRequest.getHeaderNames());
    }

    @Override
    public String getIp() {
        return this.httpServletRequest.getRemoteAddr();
    }

    @Override
    public String getPort() {
        return Integer.toString(this.httpServletRequest.getRemotePort());
    }

    @Override
    public String getCookie(String cookieName) {
        Cookie[] cookies = this.httpServletRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

