/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.client.protocol;

import co.datadome.api.shaded.http.Header;
import co.datadome.api.shaded.http.HttpException;
import co.datadome.api.shaded.http.HttpRequest;
import co.datadome.api.shaded.http.HttpRequestInterceptor;
import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.protocol.HttpContext;
import co.datadome.api.shaded.http.util.Args;
import java.io.IOException;
import java.util.Collection;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class RequestDefaultHeaders
implements HttpRequestInterceptor {
    private final Collection<? extends Header> defaultHeaders;

    public RequestDefaultHeaders(Collection<? extends Header> defaultHeaders) {
        this.defaultHeaders = defaultHeaders;
    }

    public RequestDefaultHeaders() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        Collection<? extends Header> defHeaders = (Collection<? extends Header>)request.getParams().getParameter("http.default-headers");
        if (defHeaders == null) {
            defHeaders = this.defaultHeaders;
        }
        if (defHeaders != null) {
            for (Header header : defHeaders) {
                request.addHeader(header);
            }
        }
    }
}

