/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.impl;

import co.datadome.api.shaded.http.HttpConnectionMetrics;
import co.datadome.api.shaded.http.HttpEntity;
import co.datadome.api.shaded.http.HttpEntityEnclosingRequest;
import co.datadome.api.shaded.http.HttpException;
import co.datadome.api.shaded.http.HttpRequest;
import co.datadome.api.shaded.http.HttpRequestFactory;
import co.datadome.api.shaded.http.HttpResponse;
import co.datadome.api.shaded.http.HttpServerConnection;
import co.datadome.api.shaded.http.impl.DefaultHttpRequestFactory;
import co.datadome.api.shaded.http.impl.HttpConnectionMetricsImpl;
import co.datadome.api.shaded.http.impl.entity.DisallowIdentityContentLengthStrategy;
import co.datadome.api.shaded.http.impl.entity.EntityDeserializer;
import co.datadome.api.shaded.http.impl.entity.EntitySerializer;
import co.datadome.api.shaded.http.impl.entity.LaxContentLengthStrategy;
import co.datadome.api.shaded.http.impl.entity.StrictContentLengthStrategy;
import co.datadome.api.shaded.http.impl.io.DefaultHttpRequestParser;
import co.datadome.api.shaded.http.impl.io.HttpResponseWriter;
import co.datadome.api.shaded.http.io.EofSensor;
import co.datadome.api.shaded.http.io.HttpMessageParser;
import co.datadome.api.shaded.http.io.HttpMessageWriter;
import co.datadome.api.shaded.http.io.HttpTransportMetrics;
import co.datadome.api.shaded.http.io.SessionInputBuffer;
import co.datadome.api.shaded.http.io.SessionOutputBuffer;
import co.datadome.api.shaded.http.params.HttpParams;
import co.datadome.api.shaded.http.util.Args;
import java.io.IOException;

@Deprecated
public abstract class AbstractHttpServerConnection
implements HttpServerConnection {
    private final EntitySerializer entityserializer = this.createEntitySerializer();
    private final EntityDeserializer entitydeserializer = this.createEntityDeserializer();
    private SessionInputBuffer inBuffer = null;
    private SessionOutputBuffer outbuffer = null;
    private EofSensor eofSensor = null;
    private HttpMessageParser<HttpRequest> requestParser = null;
    private HttpMessageWriter<HttpResponse> responseWriter = null;
    private HttpConnectionMetricsImpl metrics = null;

    protected abstract void assertOpen() throws IllegalStateException;

    protected EntityDeserializer createEntityDeserializer() {
        return new EntityDeserializer(new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0)));
    }

    protected EntitySerializer createEntitySerializer() {
        return new EntitySerializer(new StrictContentLengthStrategy());
    }

    protected HttpRequestFactory createHttpRequestFactory() {
        return DefaultHttpRequestFactory.INSTANCE;
    }

    protected HttpMessageParser<HttpRequest> createRequestParser(SessionInputBuffer buffer, HttpRequestFactory requestFactory, HttpParams params) {
        return new DefaultHttpRequestParser(buffer, null, requestFactory, params);
    }

    protected HttpMessageWriter<HttpResponse> createResponseWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new HttpResponseWriter(buffer, null, params);
    }

    protected HttpConnectionMetricsImpl createConnectionMetrics(HttpTransportMetrics inTransportMetric, HttpTransportMetrics outTransportMetric) {
        return new HttpConnectionMetricsImpl(inTransportMetric, outTransportMetric);
    }

    protected void init(SessionInputBuffer inBuffer, SessionOutputBuffer outbuffer, HttpParams params) {
        this.inBuffer = Args.notNull(inBuffer, "Input session buffer");
        this.outbuffer = Args.notNull(outbuffer, "Output session buffer");
        if (inBuffer instanceof EofSensor) {
            this.eofSensor = (EofSensor)((Object)inBuffer);
        }
        this.requestParser = this.createRequestParser(inBuffer, this.createHttpRequestFactory(), params);
        this.responseWriter = this.createResponseWriter(outbuffer, params);
        this.metrics = this.createConnectionMetrics(inBuffer.getMetrics(), outbuffer.getMetrics());
    }

    @Override
    public HttpRequest receiveRequestHeader() throws HttpException, IOException {
        this.assertOpen();
        HttpRequest request = this.requestParser.parse();
        this.metrics.incrementRequestCount();
        return request;
    }

    @Override
    public void receiveRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        this.assertOpen();
        HttpEntity entity = this.entitydeserializer.deserialize(this.inBuffer, request);
        request.setEntity(entity);
    }

    protected void doFlush() throws IOException {
        this.outbuffer.flush();
    }

    @Override
    public void flush() throws IOException {
        this.assertOpen();
        this.doFlush();
    }

    @Override
    public void sendResponseHeader(HttpResponse response) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        this.assertOpen();
        this.responseWriter.write(response);
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.metrics.incrementResponseCount();
        }
    }

    @Override
    public void sendResponseEntity(HttpResponse response) throws HttpException, IOException {
        if (response.getEntity() == null) {
            return;
        }
        this.entityserializer.serialize(this.outbuffer, response, response.getEntity());
    }

    protected boolean isEof() {
        return this.eofSensor != null && this.eofSensor.isEof();
    }

    @Override
    public boolean isStale() {
        if (!this.isOpen()) {
            return true;
        }
        if (this.isEof()) {
            return true;
        }
        try {
            this.inBuffer.isDataAvailable(1);
            return this.isEof();
        }
        catch (IOException ex) {
            return true;
        }
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return this.metrics;
    }
}

