/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.impl.cookie;

import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.cookie.CommonCookieAttributeHandler;
import co.datadome.api.shaded.http.cookie.Cookie;
import co.datadome.api.shaded.http.cookie.CookieOrigin;
import co.datadome.api.shaded.http.cookie.CookieRestrictionViolationException;
import co.datadome.api.shaded.http.cookie.MalformedCookieException;
import co.datadome.api.shaded.http.cookie.SetCookie;
import co.datadome.api.shaded.http.impl.cookie.AbstractCookieAttributeHandler;
import co.datadome.api.shaded.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

