/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.impl.pool;

import co.datadome.api.shaded.http.HttpClientConnection;
import co.datadome.api.shaded.http.HttpHost;
import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.config.ConnectionConfig;
import co.datadome.api.shaded.http.config.SocketConfig;
import co.datadome.api.shaded.http.impl.pool.BasicConnFactory;
import co.datadome.api.shaded.http.impl.pool.BasicPoolEntry;
import co.datadome.api.shaded.http.params.HttpParams;
import co.datadome.api.shaded.http.pool.AbstractConnPool;
import co.datadome.api.shaded.http.pool.ConnFactory;
import java.util.concurrent.atomic.AtomicLong;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

