/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.protocol;

import co.datadome.api.shaded.http.HttpConnection;
import co.datadome.api.shaded.http.HttpException;
import co.datadome.api.shaded.http.HttpHost;
import co.datadome.api.shaded.http.HttpInetConnection;
import co.datadome.api.shaded.http.HttpRequest;
import co.datadome.api.shaded.http.HttpRequestInterceptor;
import co.datadome.api.shaded.http.HttpVersion;
import co.datadome.api.shaded.http.ProtocolException;
import co.datadome.api.shaded.http.ProtocolVersion;
import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.protocol.HttpContext;
import co.datadome.api.shaded.http.protocol.HttpCoreContext;
import co.datadome.api.shaded.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

