/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.vertx;

import co.datadome.api.common.DataDomeService;
import java.util.Collections;
import java.util.Set;

public class DataDomeRouteHandlerConfig {
    private final String apiKey;
    private final String apiHost;
    private final boolean apiSSL;
    private final String regex;
    private final String exclusionRegex;
    private final int connectTimeout;
    private final int readTimeout;
    private final int maxConnections;
    private final String proxyServer;
    private final int proxyPort;
    private final boolean proxySSL;
    private final boolean useXForwardedHost;
    private final Set<String> skipIps;

    private DataDomeRouteHandlerConfig(String apiKey, String apiHost, boolean apiSSL, String regex, String exclusionRegex, int connectTimeout, int readTimeout, int maxConnections, String proxyServer, int proxyPort, boolean proxySSL, Set<String> skipIps, boolean useXForwardedHost) {
        this.apiKey = apiKey;
        this.apiHost = apiHost;
        this.apiSSL = apiSSL;
        this.regex = regex;
        this.exclusionRegex = exclusionRegex;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.maxConnections = maxConnections;
        this.proxyServer = proxyServer;
        this.proxyPort = proxyPort;
        this.proxySSL = proxySSL;
        this.skipIps = skipIps;
        this.useXForwardedHost = useXForwardedHost;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiHost() {
        return this.apiHost;
    }

    public boolean isApiSSL() {
        return this.apiSSL;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getExclusionRegex() {
        return this.exclusionRegex;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public boolean isProxySSL() {
        return this.proxySSL;
    }

    public boolean isForwardedHost() {
        return this.useXForwardedHost;
    }

    public Set<String> getSkipIps() {
        return this.skipIps;
    }

    public static class DataDomeRouteHandlerConfigBuilder {
        private final String apiKey;
        private String apiHost = "api.datadome.co";
        private boolean apiSSL = DataDomeService.DEFAULT_API_SSL;
        private String regex = "";
        private String exclusionRegex = "(?i)\\.(avi|flv|mka|mkv|mov|mp4|mpeg|mpg|mp3|flac|ogg|ogm|opus|wav|webm|webp|bmp|gif|ico|jpeg|jpg|png|svg|svgz|swf|eot|otf|ttf|woff|woff2|css|less|js)$";
        private int connectTimeout = 150;
        private int readTimeout = 50;
        private int maxConnections = 100;
        private String proxyServer = "";
        private int proxyPort = 0;
        private boolean proxySSL = false;
        private boolean useXForwardedHost = false;
        private Set<String> skipIps = Collections.emptySet();

        public DataDomeRouteHandlerConfigBuilder(String apiKey) {
            this.apiKey = apiKey;
        }

        public DataDomeRouteHandlerConfigBuilder apiHost(String apiHost) {
            this.apiHost = apiHost;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder apiSSL(boolean apiSSL) {
            this.apiSSL = apiSSL;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder exclusionRegex(String exclusionRegex) {
            this.exclusionRegex = exclusionRegex;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder proxyServer(String proxyServer) {
            this.proxyServer = proxyServer;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder proxyPort(int proxyPort) {
            this.proxyPort = proxyPort;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder proxySSL(boolean proxySSL) {
            this.proxySSL = proxySSL;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder useXForwardedHost(boolean useXForwardedHost) {
            this.useXForwardedHost = useXForwardedHost;
            return this;
        }

        public DataDomeRouteHandlerConfigBuilder skipIps(Set<String> skipIps) {
            this.skipIps = skipIps;
            return this;
        }

        public DataDomeRouteHandlerConfig build() {
            return new DataDomeRouteHandlerConfig(this.apiKey, this.apiHost, this.apiSSL, this.regex, this.exclusionRegex, this.connectTimeout, this.readTimeout, this.maxConnections, this.proxyServer, this.proxyPort, this.proxySSL, this.skipIps, this.useXForwardedHost);
        }
    }
}

