package co.faraboom.framework.exception;

public class ServiceException extends Exception {
    private String code;
    private String info;
    private ServiceExceptionType serviceExceptionType;
    private String reference;
    private String value;

    public ServiceException(String yCode, ServiceExceptionType yServiceExceptionType) {
        this.code = yCode;
        serviceExceptionType = yServiceExceptionType;
    }

    public ServiceException(String code, ServiceExceptionType yServiceExceptionType, String message) {
        super(message);
        this.code = code;
        serviceExceptionType = yServiceExceptionType;
    }

    public ServiceException(String yCode, ServiceExceptionType yServiceExceptionType, String message, String info) {
        super(message);
        this.code = yCode;
        this.info = info;
        this.serviceExceptionType = yServiceExceptionType;
    }


    public String getCode() {
        return code;
    }

    public ServiceException setCode(String code) {
        this.code = code;

        return this;
    }

    public String getInfo() {
        return info;
    }

    public ServiceException setInfo(String info) {
        this.info = info;

        return this;
    }

    public ServiceExceptionType getServiceExceptionType() {
        return serviceExceptionType;
    }

    public ServiceException setServiceExceptionType(ServiceExceptionType serviceExceptionType) {
        this.serviceExceptionType = serviceExceptionType;

        return this;
    }

    public String getReference() {
        return reference;
    }

    public ServiceException setReference(String reference) {
        this.reference = reference;

        return this;
    }

    public String getValue() {
        return value;
    }

    public ServiceException setValue(String value) {
        this.value = value;

        return this;
    }
}
