package co.faraboom.framework.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class StringUtil {
    private final static Logger LOGGER = LoggerFactory.getLogger(StringUtil.class);


    public static String toJson(Object o) {

        ObjectMapper jsonMapper = GeneralUtil.createMapper();
        try {
            return jsonMapper.writeValueAsString(o);
        } catch (JsonProcessingException e) {
            LOGGER.error("JsonProcessingException", e);
            return "";
        }
    }

    public static String toSnakeCaseJson(Object o) {
        ObjectMapper jsonMapper = GeneralUtil.createMapper();
        jsonMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        try {
            return jsonMapper.writeValueAsString(o);
        } catch (JsonProcessingException e) {
            LOGGER.error("JsonProcessingException", e);
            return "";
        }
    }

    public static String toSnakeCase(String variableName) {
        if (GeneralUtil.isNullOrEmpty(variableName))
            return variableName;

        int length = variableName.length();
        StringBuilder result = new StringBuilder(length * 2);
        int resultLength = 0;
        boolean wasPrevTranslated = false;
        for (int i = 0; i < length; i++)
        {
            char c = variableName.charAt(i);
            if (i > 0 || c != '_') // skip first starting underscore
            {
                if (Character.isUpperCase(c))
                {
                    if (!wasPrevTranslated && resultLength > 0 && result.charAt(resultLength - 1) != '_')
                    {
                        result.append('_');
                        resultLength++;
                    }
                    c = Character.toLowerCase(c);
                    wasPrevTranslated = true;
                }
                else
                {
                    wasPrevTranslated = false;
                }
                result.append(c);
                resultLength++;
            }
        }
        return resultLength > 0 ? result.toString() : variableName;

        /*StringBuilder builder = new StringBuilder();
        char[] nameChars = variableName.toCharArray();
        for (int i = 0; i < nameChars.length; i++) {
            char ch = nameChars[i];
            if (i > 0 && Character.isUpperCase(ch) && !Character.isUpperCase(nameChars[i-1])) {
                builder.append('_');
            }
            builder.append(Character.toLowerCase(ch));
        }
        return builder.toString();*/
    }
}