package co.faraboom.framework.exception;

public enum ServiceExceptionType {
    Ok(200),                    //200
    Bad_Request(400),            //400
    Unauthorized(401),            //401
    Forbidden(403),                //403
    OiForbidden(403),
    LimitForbidden(403),
    Not_Found(404),                //404
    Not_Acceptable(406),
    Unsupported_Media_Type(415),
    Internal_Server_Error(500),    //500
    NonAuthoritativeInformation(203), //203
    Service_Unavailable(503);  //503;

    private final int statusCode;

    ServiceExceptionType(int statusCode) {
        this.statusCode = statusCode;
    }

    public int statusCode() {
        return statusCode;
    }
}
