/*
 * Decompiled with CFR 0.152.
 */
package co.fingerprintsoft.notification.bulksms;

import co.fingerprintsoft.notification.bulksms.BulkSMSSMSResponse;
import co.fingerprintsoft.notification.bulksms.BulkSMSSettings;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.body.MultipartBody;
import con.fingerprintsoft.notification.sms.SMS;
import con.fingerprintsoft.notification.sms.SMSResponse;
import con.fingerprintsoft.notification.sms.SMSSender;
import con.fingerprintsoft.notification.sms.Status;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkSMSSender
implements SMSSender {
    private static final Logger LOG = LoggerFactory.getLogger(BulkSMSSender.class);
    private BulkSMSSettings settings;

    public BulkSMSSender(BulkSMSSettings settings) {
        this.settings = settings;
    }

    public SMSResponse sendSingleSMS(SMS sms) {
        MultipartBody requestWithBody = Unirest.post((String)this.settings.getEapiUrl()).field("username", (Object)this.settings.getUsername()).field("password", this.settings.getPassword()).field("message", sms.getBody()).field("want_report", "1").field("msisdn", (Collection)sms.getTo()).field("source_id", sms.getId()).field("stop_dup_id", sms.getId()).field("allow_concat_text_sms", "1").field("concat_text_sms_max_parts", "3");
        if (this.settings.getTestAlwaysSucceed() != null) {
            requestWithBody.field("test_always_succeed", (Object)this.settings.getTestAlwaysSucceed());
        }
        if (this.settings.getTestAlwaysFail() != null) {
            requestWithBody.field("test_always_fail", (Object)this.settings.getTestAlwaysFail());
        }
        return this.getSMSResponse(requestWithBody);
    }

    private SMSResponse getSMSResponse(MultipartBody requestWithBody) {
        HttpResponse request = null;
        try {
            request = requestWithBody.asString();
        }
        catch (UnirestException e) {
            throw new RuntimeException(e);
        }
        switch (request.getStatus()) {
            case 200: {
                String responseDetails = (String)request.getBody();
                String[] response = responseDetails.split("\\|");
                int statusCode = Integer.valueOf(response[0]);
                String statusDescription = response[1];
                String batchId = response[2];
                BulkSMSSMSResponse smsResponse = new BulkSMSSMSResponse();
                switch (statusCode) {
                    case 0: 
                    case 1: {
                        smsResponse.setStatus(Status.SUCCESSFULL);
                        break;
                    }
                    default: {
                        smsResponse.setStatus(Status.FAILED);
                        smsResponse.setErrorCode(statusCode);
                    }
                }
                smsResponse.setHttpStatus(request.getStatus());
                smsResponse.setMessage(statusDescription);
                smsResponse.setExternalReference(batchId);
                return smsResponse;
            }
        }
        BulkSMSSMSResponse smsResponse = new BulkSMSSMSResponse();
        smsResponse.setHttpStatus(request.getStatus());
        smsResponse.setStatus(Status.FAILED);
        return smsResponse;
    }
}

