/*
 * Decompiled with CFR 0.152.
 */
package co.fingerprintsoft.notification.bulksms;

import con.fingerprintsoft.notification.sms.SMS;
import lombok.NonNull;

public class BulkSMSSingle {
    @NonNull
    private String to;
    @NonNull
    private String body;
    private String from;
    private String deliveryReports;
    private String userSuppliedId;

    public BulkSMSSingle(String to, String body) {
        this.to = to;
        this.body = body;
    }

    public static BulkSMSSingle create(SMS sms) {
        BulkSMSSingle single = new BulkSMSSingle((String)sms.getTo().get(0), sms.getBody());
        single.setFrom(sms.getFrom());
        single.setUserSuppliedId(sms.getId());
        if (sms.isReports()) {
            single.setDeliveryReports("ALL");
        }
        return single;
    }

    @NonNull
    public String getTo() {
        return this.to;
    }

    @NonNull
    public String getBody() {
        return this.body;
    }

    public String getFrom() {
        return this.from;
    }

    public String getDeliveryReports() {
        return this.deliveryReports;
    }

    public String getUserSuppliedId() {
        return this.userSuppliedId;
    }

    public void setTo(@NonNull String to) {
        if (to == null) {
            throw new NullPointerException("to");
        }
        this.to = to;
    }

    public void setBody(@NonNull String body) {
        if (body == null) {
            throw new NullPointerException("body");
        }
        this.body = body;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setDeliveryReports(String deliveryReports) {
        this.deliveryReports = deliveryReports;
    }

    public void setUserSuppliedId(String userSuppliedId) {
        this.userSuppliedId = userSuppliedId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BulkSMSSingle)) {
            return false;
        }
        BulkSMSSingle other = (BulkSMSSingle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$deliveryReports = this.getDeliveryReports();
        String other$deliveryReports = other.getDeliveryReports();
        if (this$deliveryReports == null ? other$deliveryReports != null : !this$deliveryReports.equals(other$deliveryReports)) {
            return false;
        }
        String this$userSuppliedId = this.getUserSuppliedId();
        String other$userSuppliedId = other.getUserSuppliedId();
        return !(this$userSuppliedId == null ? other$userSuppliedId != null : !this$userSuppliedId.equals(other$userSuppliedId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BulkSMSSingle;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $deliveryReports = this.getDeliveryReports();
        result = result * 59 + ($deliveryReports == null ? 43 : $deliveryReports.hashCode());
        String $userSuppliedId = this.getUserSuppliedId();
        result = result * 59 + ($userSuppliedId == null ? 43 : $userSuppliedId.hashCode());
        return result;
    }

    public BulkSMSSingle() {
    }

    public String toString() {
        return "BulkSMSSingle(to=" + this.getTo() + ", body=" + this.getBody() + ", from=" + this.getFrom() + ", deliveryReports=" + this.getDeliveryReports() + ", userSuppliedId=" + this.getUserSuppliedId() + ")";
    }
}

