/*
 * Decompiled with CFR 0.152.
 */
package co.fingerprintsoft.payment.paygate;

import java.util.HashMap;
import java.util.Map;

public enum CardAuthenticationIndicator {
    NOT_AUTHENTICATED("NX", "Not Authenticated"),
    AUTHENTICATED("AX", "Authenticated", true),
    NOT_APPLICABLE("XX", "Not Applicable");

    private static final Map<String, CardAuthenticationIndicator> CODE_TO_ENUM_MAP;
    private static final Map<String, CardAuthenticationIndicator> DESC_TO_ENUM_MAP;
    private String code;
    private String description;
    private boolean success;

    private CardAuthenticationIndicator(String code, String description) {
        this.code = code;
        this.description = description;
    }

    private CardAuthenticationIndicator(String code, String description, boolean success) {
        this.code = code;
        this.description = description;
        this.success = success;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public static CardAuthenticationIndicator fromDescription(String description) {
        if (description == null) {
            return null;
        }
        CardAuthenticationIndicator type = DESC_TO_ENUM_MAP.get(description);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("No matching type for description " + description);
    }

    public static CardAuthenticationIndicator fromCode(String code) {
        if (code == null) {
            return null;
        }
        CardAuthenticationIndicator type = CODE_TO_ENUM_MAP.get(code);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("No matching type for code " + code);
    }

    static {
        CODE_TO_ENUM_MAP = new HashMap<String, CardAuthenticationIndicator>();
        DESC_TO_ENUM_MAP = new HashMap<String, CardAuthenticationIndicator>();
        for (CardAuthenticationIndicator type : CardAuthenticationIndicator.values()) {
            CODE_TO_ENUM_MAP.put(type.getCode(), type);
            DESC_TO_ENUM_MAP.put(type.getDescription(), type);
        }
    }
}

