/*
 * Decompiled with CFR 0.152.
 */
package co.fingerprintsoft.payment.paygate;

import java.util.HashMap;
import java.util.Map;

public enum TransactionStatus {
    NOT_DONE(0, "Not Done"),
    APPROVED(1, "Approved", true),
    DECLINED(2, "Declined"),
    CANCELLED(3, "Cancelled"),
    USER_CANCELLED(4, "User Cancelled");

    private static final Map<Integer, TransactionStatus> CODE_TO_ENUM_MAP;
    private static final Map<String, TransactionStatus> DESC_TO_ENUM_MAP;
    private int transactionCode;
    private String description;
    private boolean success;

    private TransactionStatus(int transactionCode, String description) {
        this.transactionCode = transactionCode;
        this.description = description;
    }

    private TransactionStatus(int transactionCode, String description, boolean success) {
        this.transactionCode = transactionCode;
        this.description = description;
        this.success = success;
    }

    public int getTransactionCode() {
        return this.transactionCode;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public static TransactionStatus fromDescription(String description) {
        if (description == null) {
            return null;
        }
        TransactionStatus type = DESC_TO_ENUM_MAP.get(description);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("No matching type for description " + description);
    }

    public static TransactionStatus fromTransactionCode(Integer transactionCode) {
        if (transactionCode == null) {
            return null;
        }
        TransactionStatus type = CODE_TO_ENUM_MAP.get(transactionCode);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("No matching type for transactionCode " + transactionCode);
    }

    static {
        CODE_TO_ENUM_MAP = new HashMap<Integer, TransactionStatus>();
        DESC_TO_ENUM_MAP = new HashMap<String, TransactionStatus>();
        for (TransactionStatus type : TransactionStatus.values()) {
            CODE_TO_ENUM_MAP.put(type.getTransactionCode(), type);
            DESC_TO_ENUM_MAP.put(type.getDescription(), type);
        }
    }
}

