/*
 * Decompiled with CFR 0.152.
 */
package co.fingerprintsoft.payment.paygate.api;

import co.fingerprintsoft.payment.paygate.api.PayGateSettings;
import co.fingerprintsoft.payment.paygate.domain.Error;
import co.fingerprintsoft.payment.paygate.domain.NotifyResponse;
import co.fingerprintsoft.payment.paygate.domain.PaymentRequest;
import co.fingerprintsoft.payment.paygate.domain.PaymentResponse;
import co.fingerprintsoft.payment.paygate.domain.Status;
import co.fingerprintsoft.payment.paygate.domain.TransactionStatusRequest;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.body.MultipartBody;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayGatePaymentService {
    private static final Logger log = LoggerFactory.getLogger(PayGatePaymentService.class);
    private PayGateSettings payGateSettings;

    public PayGatePaymentService(PayGateSettings payGateSettings) {
        this.payGateSettings = payGateSettings;
    }

    public PaymentResponse paymentRequest(PaymentRequest request) throws UnirestException, NoSuchAlgorithmException, UnsupportedEncodingException {
        String strLocalDate = request.getFormattedDate();
        MultipartBody post = Unirest.post((String)"https://secure.paygate.co.za/payweb3/initiate.trans").field("PAYGATE_ID", (Object)this.payGateSettings.getPayGateId()).field("REFERENCE", request.getReference()).field("AMOUNT", (Object)request.getAmount()).field("CURRENCY", request.getCurrency().getCurrencyCode()).field("RETURN_URL", this.payGateSettings.getReturnUrl()).field("TRANSACTION_DATE", strLocalDate).field("LOCALE", request.getLocale().getCode()).field("COUNTRY", request.getCountry().getCountryCode()).field("EMAIL", request.getEmail());
        if (this.payGateSettings.getNotifyUrl() != null) {
            post.field("NOTIFY_URL", this.payGateSettings.getNotifyUrl());
        }
        request.getPayMethod().ifPresent(value -> post.field("PAY_METHOD", value));
        request.getPayMethodDetail().ifPresent(value -> post.field("PAY_METHOD_DETAIL", value));
        request.getUser1().ifPresent(value -> post.field("USER1", value));
        request.getUser2().ifPresent(value -> post.field("USER2", value));
        request.getUser3().ifPresent(value -> post.field("USER3", value));
        request.getVault().ifPresent(value -> post.field("VAULT", value));
        request.getVaultId().ifPresent(value -> post.field("VAULT_ID", value));
        post.field("CHECKSUM", request.calculateChecksum(this.payGateSettings));
        HttpResponse response = post.asString();
        String responseDetail = URLDecoder.decode((String)response.getBody(), "UTF-8");
        log.debug("Response Detail : {}", (Object)responseDetail);
        StringTokenizer tokenizer = new StringTokenizer(responseDetail, "&");
        HashMap<String, String> responseMap = new HashMap<String, String>();
        while (tokenizer.hasMoreElements()) {
            String[] split = tokenizer.nextToken().split("=");
            responseMap.put(split[0], split[1]);
        }
        PaymentResponse paymentResponse = PaymentResponse.constructFromMap(responseMap);
        paymentResponse.setHttpStatus(response.getStatus());
        if (Status.SUCCESS.equals((Object)paymentResponse.getStatus()) && !this.payGateSettings.getPayGateId().equals(paymentResponse.getPayGateId())) {
            paymentResponse.setStatus(Status.VERIFICATION_FAILURE);
            paymentResponse.setError(Error.PGID_MOD);
        }
        return paymentResponse;
    }

    public NotifyResponse paymentStatusCheck(TransactionStatusRequest statusCheck) throws UnirestException, NoSuchAlgorithmException, UnsupportedEncodingException {
        MultipartBody post = Unirest.post((String)"https://secure.paygate.co.za/payweb3/query.trans").field("PAYGATE_ID", (Object)this.payGateSettings.getPayGateId()).field("PAY_REQUEST_ID", statusCheck.getPayRequestId()).field("REFERENCE", statusCheck.getReference());
        post.field("CHECKSUM", statusCheck.calculateChecksum(this.payGateSettings.getEncryptionKey(), this.payGateSettings.getPayGateId()));
        HttpResponse response = post.asString();
        String responseDetail = URLDecoder.decode((String)response.getBody(), "UTF-8");
        log.debug("Response Detail : {}", (Object)responseDetail);
        StringTokenizer tokenizer = new StringTokenizer(responseDetail, "&");
        HashMap<String, String> responseMap = new HashMap<String, String>();
        while (tokenizer.hasMoreElements()) {
            String[] split = tokenizer.nextToken().split("=");
            if (split.length != 2) continue;
            responseMap.put(split[0], split[1]);
        }
        NotifyResponse notifyResponse = NotifyResponse.constructFromMap(responseMap);
        notifyResponse.setHttpStatus(response.getStatus());
        if (Status.SUCCESS.equals((Object)notifyResponse.getStatus()) && !this.payGateSettings.getPayGateId().equals(notifyResponse.getPayGateId())) {
            notifyResponse.setStatus(Status.VERIFICATION_FAILURE);
            notifyResponse.setError(Error.ND_INV_PGID);
        }
        return notifyResponse;
    }
}

