/*
 * Decompiled with CFR 0.152.
 */
package co.fingerprintsoft.payment.paygate.domain;

import co.fingerprintsoft.payment.paygate.CardAuthenticationIndicator;
import co.fingerprintsoft.payment.paygate.Currency;
import co.fingerprintsoft.payment.paygate.MD5ToString;
import co.fingerprintsoft.payment.paygate.PaymentMethod;
import co.fingerprintsoft.payment.paygate.PaymentResult;
import co.fingerprintsoft.payment.paygate.TransactionStatus;
import co.fingerprintsoft.payment.paygate.domain.Error;
import co.fingerprintsoft.payment.paygate.domain.Status;
import java.beans.ConstructorProperties;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyResponse {
    private static final Logger log = LoggerFactory.getLogger(NotifyResponse.class);
    @NonNull
    private Long payGateId;
    @NonNull
    private String payRequestId;
    @NonNull
    private String reference;
    @NonNull
    private TransactionStatus transactionStatus;
    @NonNull
    private PaymentResult resultCode;
    @NonNull
    private String authCode;
    @NonNull
    private Currency currency;
    @NonNull
    private Long amount;
    @NonNull
    private String resultDesc;
    @NonNull
    private Long transactionId;
    @NonNull
    private CardAuthenticationIndicator riskIndicator;
    @NonNull
    private PaymentMethod payMethod;
    @NonNull
    private String checksum;
    private String payMethodDetail;
    private String user1;
    private String user2;
    private String user3;
    private String vaultId;
    private String payVaultData1;
    private String payVaultData2;
    private Status status;
    private Integer httpStatus;
    private Error error;

    public String calculateChecksum(String encryptedKey) throws NoSuchAlgorithmException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.payGateId);
        sb.append(this.payRequestId);
        sb.append(this.reference);
        sb.append(this.transactionStatus.getTransactionCode());
        sb.append(this.resultCode.getCode());
        if (this.authCode != null) {
            sb.append(this.authCode);
        }
        sb.append(this.currency.getCurrencyCode());
        sb.append(this.amount);
        sb.append(this.resultDesc);
        sb.append(this.transactionId);
        sb.append(this.riskIndicator.getCode());
        if (this.payMethod != null) {
            sb.append(this.payMethod.getPayMethod());
        }
        if (StringUtils.isNotBlank((CharSequence)this.payMethodDetail)) {
            sb.append(this.payMethodDetail);
        }
        if (StringUtils.isNotBlank((CharSequence)this.user1)) {
            sb.append(this.user1);
        }
        if (StringUtils.isNotBlank((CharSequence)this.user2)) {
            sb.append(this.user2);
        }
        if (StringUtils.isNotBlank((CharSequence)this.user3)) {
            sb.append(this.user3);
        }
        if (StringUtils.isNotBlank((CharSequence)this.vaultId)) {
            sb.append(this.vaultId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.payVaultData1)) {
            sb.append(this.payVaultData1);
        }
        if (StringUtils.isNotBlank((CharSequence)this.payVaultData2)) {
            sb.append(this.payVaultData2);
        }
        sb.append(encryptedKey);
        return MD5ToString.md5String(sb);
    }

    public boolean verifyChecksum(String encryptedKey) throws NoSuchAlgorithmException {
        return this.checksum.equals(this.calculateChecksum(encryptedKey));
    }

    public void updateChecksum(String encryptedKey) throws NoSuchAlgorithmException {
        this.checksum = this.calculateChecksum(encryptedKey);
    }

    public static NotifyResponse constructFromMap(Map<String, String> map) {
        NotifyResponse response = new NotifyResponse();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "PAYGATE_ID": {
                    response.setPayGateId(Long.valueOf(map.get(key)));
                    break;
                }
                case "PAY_REQUEST_ID": {
                    response.setPayRequestId(map.get(key));
                    break;
                }
                case "REFERENCE": {
                    response.setReference(map.get(key));
                    break;
                }
                case "TRANSACTION_STATUS": {
                    response.setTransactionStatus(TransactionStatus.fromTransactionCode(Integer.parseInt(map.get(key))));
                    break;
                }
                case "RESULT_CODE": {
                    response.setResultCode(PaymentResult.fromCode(Integer.parseInt(map.get(key))));
                    break;
                }
                case "AUTH_CODE": {
                    response.setAuthCode(map.get(key));
                    break;
                }
                case "CURRENCY": {
                    response.setCurrency(Currency.fromCurrencyCode(map.get(key)));
                    break;
                }
                case "AMOUNT": {
                    response.setAmount(Long.valueOf(map.get(key)));
                    break;
                }
                case "RESULT_DESC": {
                    response.setResultDesc(map.get(key));
                    break;
                }
                case "TRANSACTION_ID": {
                    response.setTransactionId(Long.valueOf(map.get(key)));
                    break;
                }
                case "RISK_INDICATOR": {
                    response.setRiskIndicator(CardAuthenticationIndicator.fromCode(map.get(key)));
                    break;
                }
                case "PAY_METHOD": {
                    response.setPayMethod(PaymentMethod.fromPayMethod(map.get(key)));
                    break;
                }
                case "PAY_METHOD_DETAIL": {
                    response.setPayMethodDetail(map.get(key));
                    break;
                }
                case "USER1": {
                    response.setUser1(map.get(key));
                    break;
                }
                case "USER2": {
                    response.setUser2(map.get(key));
                    break;
                }
                case "USER3": {
                    response.setUser3(map.get(key));
                    break;
                }
                case "VAULT_ID": {
                    response.setVaultId(map.get(key));
                    break;
                }
                case "PAYVAULT_DATA_1": {
                    response.setPayVaultData1(map.get(key));
                    break;
                }
                case "PAYVAULT_DATA_2": {
                    response.setPayVaultData2(map.get(key));
                    break;
                }
                case "CHECKSUM": {
                    response.setChecksum(map.get(key));
                    break;
                }
                case "ERROR": {
                    String errorCode = map.get(key);
                    Error[] errors = Error.values();
                    response.setStatus(Status.FAILURE);
                    for (Error error : errors) {
                        boolean errorBoolean = error.getCode().equals(errorCode);
                        if (!errorBoolean) continue;
                        response.setError(error);
                    }
                    break;
                }
            }
        }
        if (map.get("ERROR") == null) {
            response.setStatus(Status.SUCCESS);
        }
        return response;
    }

    public String getErrorCode() {
        if (this.error != null) {
            return this.error.getCode();
        }
        return null;
    }

    public String getErrorMessage() {
        if (this.error != null) {
            return this.error.getMessage();
        }
        return null;
    }

    @NonNull
    public Long getPayGateId() {
        return this.payGateId;
    }

    @NonNull
    public String getPayRequestId() {
        return this.payRequestId;
    }

    @NonNull
    public String getReference() {
        return this.reference;
    }

    @NonNull
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    @NonNull
    public PaymentResult getResultCode() {
        return this.resultCode;
    }

    @NonNull
    public String getAuthCode() {
        return this.authCode;
    }

    @NonNull
    public Currency getCurrency() {
        return this.currency;
    }

    @NonNull
    public Long getAmount() {
        return this.amount;
    }

    @NonNull
    public String getResultDesc() {
        return this.resultDesc;
    }

    @NonNull
    public Long getTransactionId() {
        return this.transactionId;
    }

    @NonNull
    public CardAuthenticationIndicator getRiskIndicator() {
        return this.riskIndicator;
    }

    @NonNull
    public PaymentMethod getPayMethod() {
        return this.payMethod;
    }

    @NonNull
    public String getChecksum() {
        return this.checksum;
    }

    public String getPayMethodDetail() {
        return this.payMethodDetail;
    }

    public String getUser1() {
        return this.user1;
    }

    public String getUser2() {
        return this.user2;
    }

    public String getUser3() {
        return this.user3;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public String getPayVaultData1() {
        return this.payVaultData1;
    }

    public String getPayVaultData2() {
        return this.payVaultData2;
    }

    public Status getStatus() {
        return this.status;
    }

    public Integer getHttpStatus() {
        return this.httpStatus;
    }

    public Error getError() {
        return this.error;
    }

    public void setPayGateId(@NonNull Long payGateId) {
        if (payGateId == null) {
            throw new NullPointerException("payGateId");
        }
        this.payGateId = payGateId;
    }

    public void setPayRequestId(@NonNull String payRequestId) {
        if (payRequestId == null) {
            throw new NullPointerException("payRequestId");
        }
        this.payRequestId = payRequestId;
    }

    public void setReference(@NonNull String reference) {
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        this.reference = reference;
    }

    public void setTransactionStatus(@NonNull TransactionStatus transactionStatus) {
        if (transactionStatus == null) {
            throw new NullPointerException("transactionStatus");
        }
        this.transactionStatus = transactionStatus;
    }

    public void setResultCode(@NonNull PaymentResult resultCode) {
        if (resultCode == null) {
            throw new NullPointerException("resultCode");
        }
        this.resultCode = resultCode;
    }

    public void setAuthCode(@NonNull String authCode) {
        if (authCode == null) {
            throw new NullPointerException("authCode");
        }
        this.authCode = authCode;
    }

    public void setCurrency(@NonNull Currency currency) {
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        this.currency = currency;
    }

    public void setAmount(@NonNull Long amount) {
        if (amount == null) {
            throw new NullPointerException("amount");
        }
        this.amount = amount;
    }

    public void setResultDesc(@NonNull String resultDesc) {
        if (resultDesc == null) {
            throw new NullPointerException("resultDesc");
        }
        this.resultDesc = resultDesc;
    }

    public void setTransactionId(@NonNull Long transactionId) {
        if (transactionId == null) {
            throw new NullPointerException("transactionId");
        }
        this.transactionId = transactionId;
    }

    public void setRiskIndicator(@NonNull CardAuthenticationIndicator riskIndicator) {
        if (riskIndicator == null) {
            throw new NullPointerException("riskIndicator");
        }
        this.riskIndicator = riskIndicator;
    }

    public void setPayMethod(@NonNull PaymentMethod payMethod) {
        if (payMethod == null) {
            throw new NullPointerException("payMethod");
        }
        this.payMethod = payMethod;
    }

    public void setChecksum(@NonNull String checksum) {
        if (checksum == null) {
            throw new NullPointerException("checksum");
        }
        this.checksum = checksum;
    }

    public void setPayMethodDetail(String payMethodDetail) {
        this.payMethodDetail = payMethodDetail;
    }

    public void setUser1(String user1) {
        this.user1 = user1;
    }

    public void setUser2(String user2) {
        this.user2 = user2;
    }

    public void setUser3(String user3) {
        this.user3 = user3;
    }

    public void setVaultId(String vaultId) {
        this.vaultId = vaultId;
    }

    public void setPayVaultData1(String payVaultData1) {
        this.payVaultData1 = payVaultData1;
    }

    public void setPayVaultData2(String payVaultData2) {
        this.payVaultData2 = payVaultData2;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setHttpStatus(Integer httpStatus) {
        this.httpStatus = httpStatus;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public String toString() {
        return "NotifyResponse(payGateId=" + this.getPayGateId() + ", payRequestId=" + this.getPayRequestId() + ", reference=" + this.getReference() + ", transactionStatus=" + (Object)((Object)this.getTransactionStatus()) + ", resultCode=" + (Object)((Object)this.getResultCode()) + ", authCode=" + this.getAuthCode() + ", currency=" + (Object)((Object)this.getCurrency()) + ", amount=" + this.getAmount() + ", resultDesc=" + this.getResultDesc() + ", transactionId=" + this.getTransactionId() + ", riskIndicator=" + (Object)((Object)this.getRiskIndicator()) + ", payMethod=" + (Object)((Object)this.getPayMethod()) + ", checksum=" + this.getChecksum() + ", payMethodDetail=" + this.getPayMethodDetail() + ", user1=" + this.getUser1() + ", user2=" + this.getUser2() + ", user3=" + this.getUser3() + ", vaultId=" + this.getVaultId() + ", payVaultData1=" + this.getPayVaultData1() + ", payVaultData2=" + this.getPayVaultData2() + ", status=" + (Object)((Object)this.getStatus()) + ", httpStatus=" + this.getHttpStatus() + ", error=" + (Object)((Object)this.getError()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotifyResponse)) {
            return false;
        }
        NotifyResponse other = (NotifyResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$payGateId = this.getPayGateId();
        Long other$payGateId = other.getPayGateId();
        if (this$payGateId == null ? other$payGateId != null : !((Object)this$payGateId).equals(other$payGateId)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        Long this$transactionId = this.getTransactionId();
        Long other$transactionId = other.getTransactionId();
        return !(this$transactionId == null ? other$transactionId != null : !((Object)this$transactionId).equals(other$transactionId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotifyResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $payGateId = this.getPayGateId();
        result = result * 59 + ($payGateId == null ? 43 : ((Object)$payGateId).hashCode());
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        Long $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : ((Object)$transactionId).hashCode());
        return result;
    }

    @ConstructorProperties(value={"payGateId", "payRequestId", "reference", "transactionStatus", "resultCode", "authCode", "currency", "amount", "resultDesc", "transactionId", "riskIndicator", "payMethod", "checksum"})
    public NotifyResponse(@NonNull Long payGateId, @NonNull String payRequestId, @NonNull String reference, @NonNull TransactionStatus transactionStatus, @NonNull PaymentResult resultCode, @NonNull String authCode, @NonNull Currency currency, @NonNull Long amount, @NonNull String resultDesc, @NonNull Long transactionId, @NonNull CardAuthenticationIndicator riskIndicator, @NonNull PaymentMethod payMethod, @NonNull String checksum) {
        if (payGateId == null) {
            throw new NullPointerException("payGateId");
        }
        if (payRequestId == null) {
            throw new NullPointerException("payRequestId");
        }
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        if (transactionStatus == null) {
            throw new NullPointerException("transactionStatus");
        }
        if (resultCode == null) {
            throw new NullPointerException("resultCode");
        }
        if (authCode == null) {
            throw new NullPointerException("authCode");
        }
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        if (amount == null) {
            throw new NullPointerException("amount");
        }
        if (resultDesc == null) {
            throw new NullPointerException("resultDesc");
        }
        if (transactionId == null) {
            throw new NullPointerException("transactionId");
        }
        if (riskIndicator == null) {
            throw new NullPointerException("riskIndicator");
        }
        if (payMethod == null) {
            throw new NullPointerException("payMethod");
        }
        if (checksum == null) {
            throw new NullPointerException("checksum");
        }
        this.payGateId = payGateId;
        this.payRequestId = payRequestId;
        this.reference = reference;
        this.transactionStatus = transactionStatus;
        this.resultCode = resultCode;
        this.authCode = authCode;
        this.currency = currency;
        this.amount = amount;
        this.resultDesc = resultDesc;
        this.transactionId = transactionId;
        this.riskIndicator = riskIndicator;
        this.payMethod = payMethod;
        this.checksum = checksum;
    }

    private NotifyResponse() {
    }
}

