/*
 * Decompiled with CFR 0.152.
 */
package co.fingerprintsoft.payment.paygate.domain;

import co.fingerprintsoft.payment.paygate.Country;
import co.fingerprintsoft.payment.paygate.Currency;
import co.fingerprintsoft.payment.paygate.Locale;
import co.fingerprintsoft.payment.paygate.MD5ToString;
import co.fingerprintsoft.payment.paygate.api.PayGateSettings;
import java.beans.ConstructorProperties;
import java.security.NoSuchAlgorithmException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import lombok.NonNull;

public class PaymentRequest {
    @NonNull
    private String reference;
    @NonNull
    private Long amount;
    @NonNull
    private Currency currency;
    @NonNull
    private LocalDateTime transactionDate;
    @NonNull
    private Locale locale;
    @NonNull
    private Country country;
    @NonNull
    private String email;
    private Optional<String> payMethod = Optional.empty();
    private Optional<String> payMethodDetail = Optional.empty();
    private Optional<String> user1 = Optional.empty();
    private Optional<String> user2 = Optional.empty();
    private Optional<String> user3 = Optional.empty();
    private Optional<Integer> vault = Optional.empty();
    private Optional<String> vaultId = Optional.empty();

    public void setPayMethod(String payMethod) {
        this.payMethod = Optional.ofNullable(payMethod);
    }

    public void setPayMethodDetail(String payMethodDetail) {
        this.payMethodDetail = Optional.ofNullable(payMethodDetail);
    }

    public void setUser1(String user1) {
        this.user1 = Optional.ofNullable(user1);
    }

    public void setUser2(String user2) {
        this.user2 = Optional.ofNullable(user2);
    }

    public void setUser3(String user3) {
        this.user3 = Optional.ofNullable(user3);
    }

    public void setVault(Integer vault) {
        this.vault = Optional.ofNullable(vault);
    }

    public void setVaultId(String vaultId) {
        this.vaultId = Optional.ofNullable(vaultId);
    }

    public String calculateChecksum(PayGateSettings settings) throws NoSuchAlgorithmException {
        StringBuilder sb = new StringBuilder();
        sb.append(settings.getPayGateId());
        sb.append(this.reference);
        sb.append(this.amount);
        sb.append(this.currency.getCurrencyCode());
        sb.append(settings.getReturnUrl());
        sb.append(this.getFormattedDate());
        sb.append(this.locale.getCode());
        sb.append(this.country.getCountryCode());
        sb.append(this.email);
        this.payMethod.ifPresent(sb::append);
        this.payMethodDetail.ifPresent(sb::append);
        if (settings.getNotifyUrl() != null) {
            sb.append(settings.getNotifyUrl());
        }
        this.user1.ifPresent(sb::append);
        this.user2.ifPresent(sb::append);
        this.user3.ifPresent(sb::append);
        this.vault.ifPresent(sb::append);
        this.vaultId.ifPresent(sb::append);
        sb.append(settings.getEncryptionKey());
        return MD5ToString.md5String(sb);
    }

    public String getFormattedDate() {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(this.getTransactionDate());
    }

    @NonNull
    public String getReference() {
        return this.reference;
    }

    @NonNull
    public Long getAmount() {
        return this.amount;
    }

    @NonNull
    public Currency getCurrency() {
        return this.currency;
    }

    @NonNull
    public LocalDateTime getTransactionDate() {
        return this.transactionDate;
    }

    @NonNull
    public Locale getLocale() {
        return this.locale;
    }

    @NonNull
    public Country getCountry() {
        return this.country;
    }

    @NonNull
    public String getEmail() {
        return this.email;
    }

    public Optional<String> getPayMethod() {
        return this.payMethod;
    }

    public Optional<String> getPayMethodDetail() {
        return this.payMethodDetail;
    }

    public Optional<String> getUser1() {
        return this.user1;
    }

    public Optional<String> getUser2() {
        return this.user2;
    }

    public Optional<String> getUser3() {
        return this.user3;
    }

    public Optional<Integer> getVault() {
        return this.vault;
    }

    public Optional<String> getVaultId() {
        return this.vaultId;
    }

    public void setReference(@NonNull String reference) {
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        this.reference = reference;
    }

    public void setAmount(@NonNull Long amount) {
        if (amount == null) {
            throw new NullPointerException("amount");
        }
        this.amount = amount;
    }

    public void setCurrency(@NonNull Currency currency) {
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        this.currency = currency;
    }

    public void setTransactionDate(@NonNull LocalDateTime transactionDate) {
        if (transactionDate == null) {
            throw new NullPointerException("transactionDate");
        }
        this.transactionDate = transactionDate;
    }

    public void setLocale(@NonNull Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale");
        }
        this.locale = locale;
    }

    public void setCountry(@NonNull Country country) {
        if (country == null) {
            throw new NullPointerException("country");
        }
        this.country = country;
    }

    public void setEmail(@NonNull String email) {
        if (email == null) {
            throw new NullPointerException("email");
        }
        this.email = email;
    }

    public String toString() {
        return "PaymentRequest(reference=" + this.getReference() + ", amount=" + this.getAmount() + ", currency=" + (Object)((Object)this.getCurrency()) + ", transactionDate=" + this.getTransactionDate() + ", locale=" + (Object)((Object)this.getLocale()) + ", country=" + (Object)((Object)this.getCountry()) + ", email=" + this.getEmail() + ", payMethod=" + this.getPayMethod() + ", payMethodDetail=" + this.getPayMethodDetail() + ", user1=" + this.getUser1() + ", user2=" + this.getUser2() + ", user3=" + this.getUser3() + ", vault=" + this.getVault() + ", vaultId=" + this.getVaultId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentRequest)) {
            return false;
        }
        PaymentRequest other = (PaymentRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        return result;
    }

    @ConstructorProperties(value={"reference", "amount", "currency", "transactionDate", "locale", "country", "email"})
    public PaymentRequest(@NonNull String reference, @NonNull Long amount, @NonNull Currency currency, @NonNull LocalDateTime transactionDate, @NonNull Locale locale, @NonNull Country country, @NonNull String email) {
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        if (amount == null) {
            throw new NullPointerException("amount");
        }
        if (currency == null) {
            throw new NullPointerException("currency");
        }
        if (transactionDate == null) {
            throw new NullPointerException("transactionDate");
        }
        if (locale == null) {
            throw new NullPointerException("locale");
        }
        if (country == null) {
            throw new NullPointerException("country");
        }
        if (email == null) {
            throw new NullPointerException("email");
        }
        this.reference = reference;
        this.amount = amount;
        this.currency = currency;
        this.transactionDate = transactionDate;
        this.locale = locale;
        this.country = country;
        this.email = email;
    }

    private PaymentRequest() {
    }
}

