/*
 * Decompiled with CFR 0.152.
 */
package co.fingerprintsoft.payment.paygate.domain;

import co.fingerprintsoft.payment.paygate.MD5ToString;
import co.fingerprintsoft.payment.paygate.domain.Error;
import co.fingerprintsoft.payment.paygate.domain.Status;
import java.beans.ConstructorProperties;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentResponse {
    private static final Logger log = LoggerFactory.getLogger(PaymentResponse.class);
    @NonNull
    private Long payGateId;
    @NonNull
    private String payRequestId;
    @NonNull
    private String reference;
    @NonNull
    private String checksum;
    private Status status;
    private Integer httpStatus;
    private Error error;

    public String calculateChecksum(String encryptedKey) throws NoSuchAlgorithmException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.payGateId);
        sb.append(this.payRequestId);
        sb.append(this.reference);
        sb.append(encryptedKey);
        return MD5ToString.md5String(sb);
    }

    public boolean verifyChecksum(String encryptionKey) throws NoSuchAlgorithmException {
        log.debug("Encryption Key: {}", (Object)encryptionKey);
        log.debug("Checksum: {}", (Object)this.checksum);
        log.debug("Calculated Checksum: {}", (Object)this.calculateChecksum(encryptionKey));
        return this.checksum.equals(this.calculateChecksum(encryptionKey));
    }

    public void updateChecksum(String EncryptionKey) throws NoSuchAlgorithmException {
        this.checksum = this.calculateChecksum(EncryptionKey);
    }

    public static PaymentResponse constructFromMap(Map<String, String> map) {
        PaymentResponse response = new PaymentResponse();
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "PAYGATE_ID": {
                    response.setPayGateId(Long.valueOf(map.get(key)));
                    break;
                }
                case "PAY_REQUEST_ID": {
                    response.setPayRequestId(map.get(key));
                    break;
                }
                case "REFERENCE": {
                    response.setReference(map.get(key));
                    break;
                }
                case "CHECKSUM": {
                    response.setChecksum(map.get(key));
                    break;
                }
                case "ERROR": {
                    String errorCode = map.get(key);
                    Error[] errors = Error.values();
                    response.setStatus(Status.FAILURE);
                    for (Error error : errors) {
                        boolean errorBoolean = error.getCode().equals(errorCode);
                        if (!errorBoolean) continue;
                        response.setError(error);
                    }
                    break;
                }
            }
            if (map.get("ERROR") != null) continue;
            response.setStatus(Status.SUCCESS);
        }
        return response;
    }

    public String getErrorCode() {
        if (this.error != null) {
            return this.error.getCode();
        }
        return null;
    }

    public String getErrorMessage() {
        if (this.error != null) {
            return this.error.getMessage();
        }
        return null;
    }

    @NonNull
    public Long getPayGateId() {
        return this.payGateId;
    }

    @NonNull
    public String getPayRequestId() {
        return this.payRequestId;
    }

    @NonNull
    public String getReference() {
        return this.reference;
    }

    @NonNull
    public String getChecksum() {
        return this.checksum;
    }

    public Status getStatus() {
        return this.status;
    }

    public Integer getHttpStatus() {
        return this.httpStatus;
    }

    public Error getError() {
        return this.error;
    }

    public void setPayGateId(@NonNull Long payGateId) {
        if (payGateId == null) {
            throw new NullPointerException("payGateId");
        }
        this.payGateId = payGateId;
    }

    public void setPayRequestId(@NonNull String payRequestId) {
        if (payRequestId == null) {
            throw new NullPointerException("payRequestId");
        }
        this.payRequestId = payRequestId;
    }

    public void setReference(@NonNull String reference) {
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        this.reference = reference;
    }

    public void setChecksum(@NonNull String checksum) {
        if (checksum == null) {
            throw new NullPointerException("checksum");
        }
        this.checksum = checksum;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setHttpStatus(Integer httpStatus) {
        this.httpStatus = httpStatus;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public String toString() {
        return "PaymentResponse(payGateId=" + this.getPayGateId() + ", payRequestId=" + this.getPayRequestId() + ", reference=" + this.getReference() + ", checksum=" + this.getChecksum() + ", status=" + (Object)((Object)this.getStatus()) + ", httpStatus=" + this.getHttpStatus() + ", error=" + (Object)((Object)this.getError()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentResponse)) {
            return false;
        }
        PaymentResponse other = (PaymentResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$payGateId = this.getPayGateId();
        Long other$payGateId = other.getPayGateId();
        if (this$payGateId == null ? other$payGateId != null : !((Object)this$payGateId).equals(other$payGateId)) {
            return false;
        }
        String this$payRequestId = this.getPayRequestId();
        String other$payRequestId = other.getPayRequestId();
        if (this$payRequestId == null ? other$payRequestId != null : !this$payRequestId.equals(other$payRequestId)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $payGateId = this.getPayGateId();
        result = result * 59 + ($payGateId == null ? 43 : ((Object)$payGateId).hashCode());
        String $payRequestId = this.getPayRequestId();
        result = result * 59 + ($payRequestId == null ? 43 : $payRequestId.hashCode());
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        return result;
    }

    private PaymentResponse() {
    }

    @ConstructorProperties(value={"payGateId", "payRequestId", "reference", "checksum"})
    public PaymentResponse(@NonNull Long payGateId, @NonNull String payRequestId, @NonNull String reference, @NonNull String checksum) {
        if (payGateId == null) {
            throw new NullPointerException("payGateId");
        }
        if (payRequestId == null) {
            throw new NullPointerException("payRequestId");
        }
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        if (checksum == null) {
            throw new NullPointerException("checksum");
        }
        this.payGateId = payGateId;
        this.payRequestId = payRequestId;
        this.reference = reference;
        this.checksum = checksum;
    }
}

