/*
 * Decompiled with CFR 0.152.
 */
package co.fingerprintsoft.payment.paygate.domain;

import co.fingerprintsoft.payment.paygate.MD5ToString;
import co.fingerprintsoft.payment.paygate.TransactionStatus;
import java.beans.ConstructorProperties;
import java.security.NoSuchAlgorithmException;
import lombok.NonNull;

public class PaymentStatus {
    @NonNull
    private String payRequestId;
    @NonNull
    private TransactionStatus transactionStatus;
    @NonNull
    private String reference;
    @NonNull
    private String checksum;

    public String calculateChecksum(String encryptedKey, Long payGateId) throws NoSuchAlgorithmException {
        StringBuilder sb = new StringBuilder();
        sb.append(payGateId);
        sb.append(this.payRequestId);
        sb.append(this.transactionStatus.getTransactionCode());
        sb.append(this.reference);
        sb.append(encryptedKey);
        return MD5ToString.md5String(sb);
    }

    public boolean verifyChecksum(String encryptedKey, Long payGateId) throws NoSuchAlgorithmException {
        return this.checksum.equals(this.calculateChecksum(encryptedKey, payGateId));
    }

    @NonNull
    public String getPayRequestId() {
        return this.payRequestId;
    }

    @NonNull
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    @NonNull
    public String getReference() {
        return this.reference;
    }

    @NonNull
    public String getChecksum() {
        return this.checksum;
    }

    public void setPayRequestId(@NonNull String payRequestId) {
        if (payRequestId == null) {
            throw new NullPointerException("payRequestId");
        }
        this.payRequestId = payRequestId;
    }

    public void setTransactionStatus(@NonNull TransactionStatus transactionStatus) {
        if (transactionStatus == null) {
            throw new NullPointerException("transactionStatus");
        }
        this.transactionStatus = transactionStatus;
    }

    public void setReference(@NonNull String reference) {
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        this.reference = reference;
    }

    public void setChecksum(@NonNull String checksum) {
        if (checksum == null) {
            throw new NullPointerException("checksum");
        }
        this.checksum = checksum;
    }

    public String toString() {
        return "PaymentStatus(payRequestId=" + this.getPayRequestId() + ", transactionStatus=" + (Object)((Object)this.getTransactionStatus()) + ", reference=" + this.getReference() + ", checksum=" + this.getChecksum() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentStatus)) {
            return false;
        }
        PaymentStatus other = (PaymentStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$payRequestId = this.getPayRequestId();
        String other$payRequestId = other.getPayRequestId();
        return !(this$payRequestId == null ? other$payRequestId != null : !this$payRequestId.equals(other$payRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $payRequestId = this.getPayRequestId();
        result = result * 59 + ($payRequestId == null ? 43 : $payRequestId.hashCode());
        return result;
    }

    @ConstructorProperties(value={"payRequestId", "transactionStatus", "reference", "checksum"})
    public PaymentStatus(@NonNull String payRequestId, @NonNull TransactionStatus transactionStatus, @NonNull String reference, @NonNull String checksum) {
        if (payRequestId == null) {
            throw new NullPointerException("payRequestId");
        }
        if (transactionStatus == null) {
            throw new NullPointerException("transactionStatus");
        }
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        if (checksum == null) {
            throw new NullPointerException("checksum");
        }
        this.payRequestId = payRequestId;
        this.transactionStatus = transactionStatus;
        this.reference = reference;
        this.checksum = checksum;
    }

    private PaymentStatus() {
    }
}

