/*
 * Decompiled with CFR 0.152.
 */
package fs2;

import cats.effect.kernel.Sync;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$InvariantOps$;
import fs2.Stream$ToPull$;
import fs2.compat.NotGiven$;
import fs2.compression;
import fs2.compression$DeflateParams$;
import fs2.compression$DeflateParams$FlushMode$DEFAULT$;
import fs2.compression$DeflateParams$Level$;
import fs2.compression$DeflateParams$Level$DEFAULT$;
import fs2.compression$DeflateParams$Strategy$;
import fs2.compression$DeflateParams$Strategy$DEFAULT$;
import fs2.compression$GunzipResult$;
import fs2.compression$InflateParams$;
import fs2.compression$ZLibParams$Header$GZIP$;
import fs2.compression$gzipCompressionMethod$;
import fs2.compression$gzipExtraFlag$;
import fs2.compression$gzipFlag$;
import fs2.compression$gzipOperatingSystem$;
import java.io.EOFException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

public final class compression$ {
    public static compression$ MODULE$;
    private final int gzipHeaderBytes;
    private final byte gzipMagicFirstByte;
    private final byte gzipMagicSecondByte;
    private final int gzipOptionalExtraFieldLengthBytes;
    private final int gzipHeaderCrcBytes;
    private final int gzipInputCrcBytes;
    private final int gzipInputSizeBytes;
    private final int gzipTrailerBytes;
    private final byte zeroByte;
    private final int fileNameBytesSoftLimit;
    private final int fileCommentBytesSoftLimit;

    static {
        new compression$();
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Object>> deflate(compression.DeflateParams deflateParams, Sync<F> SyncF) {
        return (Function1 & Serializable & scala.Serializable)stream -> Stream$.MODULE$.bracket(SyncF.delay((Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            Deflater deflater = new Deflater(deflateParams.level().juzDeflaterLevel(), deflateParams.header().juzDeflaterNoWrap());
            deflater.setStrategy(deflateParams.strategy().juzDeflaterStrategy());
            return var1_1;
        }), (Function1 & Serializable & scala.Serializable)deflater -> SyncF.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> deflater.end())).flatMap((Function1 & Serializable & scala.Serializable)deflater -> (Stream)MODULE$._deflate(deflateParams, (Deflater)deflater, (Option<CRC32>)None$.MODULE$).apply(stream), NotGiven$.MODULE$.default());
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _deflate(compression.DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32) {
        return (Function1 & Serializable & scala.Serializable)in -> Stream$.MODULE$.suspend((Function0 & Serializable & scala.Serializable)() -> {
            byte[] deflatedBuffer = new byte[deflateParams.bufferSizeOrMinimum()];
            return ((Pull)MODULE$._deflate_stream(deflateParams, deflater, crc32, deflatedBuffer).apply(in)).stream(Predef$.MODULE$.$conforms());
        });
    }

    private <F> Pull<F, Object, BoxedUnit> _deflate_chunk(compression.DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32, Chunk<Object> chunk, byte[] deflatedBuffer, boolean isFinalChunk) {
        Chunk.ArraySlice bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.Byte());
        deflater.setInput((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
        if (isFinalChunk) {
            deflater.finish();
        }
        crc32.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.update((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
            return BoxedUnit.UNIT;
        });
        return this.pull$1(deflatedBuffer, deflater, deflateParams, isFinalChunk);
    }

    private <F> Function1<Stream<F, Object>, Pull<F, Object, BoxedUnit>> _deflate_stream(compression.DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32, byte[] deflatedBuffer) {
        return (Function1 & Serializable & scala.Serializable)x$2 -> Stream$ToPull$.MODULE$.unconsNonEmpty$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(x$2))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Pull<Object, Object, Object> pull;
            Some some;
            Tuple2 tuple2;
            Option option = x0$1;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Chunk inflatedChunk = (Chunk)tuple2._1();
                Stream inflatedStream = (Stream)tuple2._2();
                pull = MODULE$._deflate_chunk(deflateParams, deflater, crc32, inflatedChunk, deflatedBuffer, false).$greater$greater((Function0 & Serializable & scala.Serializable)() -> (Pull)MODULE$._deflate_stream(deflateParams, deflater, crc32, deflatedBuffer).apply((Object)inflatedStream));
            } else if (None$.MODULE$.equals(option)) {
                pull = MODULE$._deflate_chunk(deflateParams, deflater, crc32, Chunk$.MODULE$.empty(), deflatedBuffer, true);
            } else {
                throw new MatchError((Object)option);
            }
            return pull;
        });
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Object>> inflate(compression.InflateParams inflateParams, Sync<F> SyncF) {
        return (Function1 & Serializable & scala.Serializable)stream -> Stream$.MODULE$.bracket(SyncF.delay((Function0 & Serializable & scala.Serializable)() -> new Inflater(inflateParams.header().juzDeflaterNoWrap())), (Function1 & Serializable & scala.Serializable)inflater -> SyncF.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> inflater.end())).flatMap((Function1 & Serializable & scala.Serializable)inflater -> (Stream)MODULE$._inflate(inflateParams, (Inflater)inflater, (Option<CRC32>)None$.MODULE$, SyncF).apply(stream), NotGiven$.MODULE$.default());
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _inflate(compression.InflateParams inflateParams, Inflater inflater, Option<CRC32> crc32, Sync<F> SyncF) {
        return (Function1 & Serializable & scala.Serializable)in -> Stream$.MODULE$.suspend((Function0 & Serializable & scala.Serializable)() -> {
            byte[] inflatedBuffer = new byte[inflateParams.bufferSizeOrMinimum()];
            return Stream$ToPull$.MODULE$.unconsNonEmpty$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(in))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Pull<Object, Object, Object> pull;
                Some some;
                Tuple2 tuple2;
                Option option = x0$1;
                if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                    Chunk deflatedChunk = (Chunk)tuple2._1();
                    Stream deflatedStream = (Stream)tuple2._2();
                    pull = MODULE$._inflate_chunk(inflater, crc32, deflatedChunk, inflatedBuffer).$greater$greater((Function0 & Serializable & scala.Serializable)() -> (Pull)MODULE$._inflate_stream(inflateParams, inflater, crc32, inflatedBuffer, SyncF).apply((Object)deflatedStream));
                } else if (None$.MODULE$.equals(option)) {
                    pull = Pull$.MODULE$.done();
                } else {
                    throw new MatchError((Object)option);
                }
                return pull;
            }).stream(Predef$.MODULE$.$conforms());
        });
    }

    private <F> Pull<F, Object, BoxedUnit> _inflate_chunk(Inflater inflater, Option<CRC32> crc32, Chunk<Object> chunk, byte[] inflatedBuffer) {
        Chunk.ArraySlice bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.Byte());
        inflater.setInput((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
        return this.pull$2(inflater, bytesChunk, inflatedBuffer, crc32);
    }

    private <F> Function1<Stream<F, Object>, Pull<F, Object, BoxedUnit>> _inflate_stream(compression.InflateParams inflateParams, Inflater inflater, Option<CRC32> crc32, byte[] inflatedBuffer, Sync<F> SyncF) {
        return (Function1 & Serializable & scala.Serializable)x$4 -> Stream$ToPull$.MODULE$.unconsNonEmpty$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(x$4))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Pull<Object, Object, Object> pull;
            Some some;
            Tuple2 tuple2;
            Option option = x0$1;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Chunk deflatedChunk = (Chunk)tuple2._1();
                Stream deflatedStream = (Stream)tuple2._2();
                pull = MODULE$._inflate_chunk(inflater, crc32, deflatedChunk, inflatedBuffer).$greater$greater((Function0 & Serializable & scala.Serializable)() -> (Pull)MODULE$._inflate_stream(inflateParams, inflater, crc32, inflatedBuffer, SyncF).apply((Object)deflatedStream));
            } else if (None$.MODULE$.equals(option)) {
                pull = !inflater.finished() ? Pull$.MODULE$.raiseError(new DataFormatException("Insufficient data"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)) : Pull$.MODULE$.done();
            } else {
                throw new MatchError((Object)option);
            }
            return pull;
        });
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Object>> gzip(int bufferSize, Option<Object> deflateLevel, Option<Object> deflateStrategy, Option<Instant> modificationTime, Option<String> fileName, Option<String> comment, Sync<F> SyncF) {
        return this.gzip(fileName, modificationTime, comment, compression$DeflateParams$.MODULE$.apply(bufferSize, compression$ZLibParams$Header$GZIP$.MODULE$, (compression.DeflateParams.Level)deflateLevel.map((Function1 & Serializable & scala.Serializable)level -> compression$DeflateParams$Level$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)level))).getOrElse((Function0 & Serializable & scala.Serializable)() -> compression$DeflateParams$Level$DEFAULT$.MODULE$), (compression.DeflateParams.Strategy)deflateStrategy.map((Function1 & Serializable & scala.Serializable)strategy -> compression$DeflateParams$Strategy$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)strategy))).getOrElse((Function0 & Serializable & scala.Serializable)() -> compression$DeflateParams$Strategy$DEFAULT$.MODULE$), compression$DeflateParams$FlushMode$DEFAULT$.MODULE$), SyncF);
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Object>> gzip(Option<String> fileName, Option<Instant> modificationTime, Option<String> comment, compression.DeflateParams deflateParams, Sync<F> SyncF) {
        return (Function1 & Serializable & scala.Serializable)stream -> {
            void var6_11;
            compression.DeflateParams deflateParams = deflateParams;
            if (deflateParams != null) {
                compression.DeflateParams deflateParams2 = deflateParams;
                compression.ZLibParams.Header header = deflateParams2.header();
                compression$ZLibParams$Header$GZIP$ compression$ZLibParams$Header$GZIP$2 = compression$ZLibParams$Header$GZIP$.MODULE$;
                if (!(header != null ? !header.equals(compression$ZLibParams$Header$GZIP$2) : compression$ZLibParams$Header$GZIP$2 != null)) {
                    Stream stream2 = Stream$.MODULE$.bracket(SyncF.delay((Function0 & Serializable & scala.Serializable)() -> {
                        Deflater deflater = new Deflater(deflateParams2.level().juzDeflaterLevel(), true);
                        deflater.setStrategy(deflateParams2.strategy().juzDeflaterStrategy());
                        return new Tuple2((Object)deflater, (Object)new CRC32());
                    }), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Deflater deflater = (Deflater)tuple2._1();
                        Object object = SyncF.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> deflater.end());
                        return object;
                    }).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Deflater deflater = (Deflater)tuple2._1();
                        CRC32 crc32 = (CRC32)tuple2._2();
                        Stream stream = MODULE$._gzip_header(fileName, modificationTime, comment, deflateParams2.level().juzDeflaterLevel()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> (Stream)MODULE$._deflate(deflateParams2, deflater, (Option<CRC32>)new Some((Object)crc32)).apply(stream)).$plus$plus((Function0 & Serializable & scala.Serializable)() -> MODULE$._gzip_trailer(deflater, crc32));
                        return stream;
                    }, NotGiven$.MODULE$.default());
                    return var6_11;
                }
            }
            if (deflateParams == null) throw new MatchError((Object)deflateParams);
            compression.DeflateParams deflateParams3 = deflateParams;
            Stream stream3 = Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(28).append(compression$ZLibParams$Header$GZIP$.MODULE$).append(" header type required, not ").append(deflateParams3.header()).append(".").toString()), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF));
            return var6_11;
        };
    }

    public <F> int gzip$default$1() {
        return 32768;
    }

    public <F> Option<Object> gzip$default$2() {
        return None$.MODULE$;
    }

    public <F> Option<Object> gzip$default$3() {
        return None$.MODULE$;
    }

    public <F> Option<Instant> gzip$default$4() {
        return None$.MODULE$;
    }

    public <F> Option<String> gzip$default$5() {
        return None$.MODULE$;
    }

    public <F> Option<String> gzip$default$6() {
        return None$.MODULE$;
    }

    private <F> Stream<F, Object> _gzip_header(Option<String> fileName, Option<Instant> modificationTime, Option<String> comment, int deflateLevel) {
        byte by;
        long secondsSince197001010000 = BoxesRunTime.unboxToLong((Object)modificationTime.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getEpochSecond())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        byte[] byArray = new byte[10];
        byArray[0] = this.gzipMagicFirstByte();
        byArray[1] = this.gzipMagicSecondByte();
        byArray[2] = compression$gzipCompressionMethod$.MODULE$.DEFLATE();
        byArray[3] = (byte)(compression$gzipFlag$.MODULE$.FHCRC() + BoxesRunTime.unboxToByte((Object)fileName.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToByte((byte)compression$gzipFlag$.MODULE$.FNAME())).getOrElse((Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> MODULE$.zeroByte())) + BoxesRunTime.unboxToByte((Object)comment.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToByte((byte)compression$gzipFlag$.MODULE$.FCOMMENT())).getOrElse((Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> MODULE$.zeroByte())));
        byArray[4] = (byte)(secondsSince197001010000 & 0xFFL);
        byArray[5] = (byte)(secondsSince197001010000 >> 8 & 0xFFL);
        byArray[6] = (byte)(secondsSince197001010000 >> 16 & 0xFFL);
        byArray[7] = (byte)(secondsSince197001010000 >> 24 & 0xFFL);
        int n = deflateLevel;
        switch (n) {
            case 9: {
                by = compression$gzipExtraFlag$.MODULE$.DEFLATE_MAX_COMPRESSION_SLOWEST_ALGO();
                break;
            }
            case 1: {
                by = compression$gzipExtraFlag$.MODULE$.DEFLATE_FASTEST_ALGO();
                break;
            }
            default: {
                by = this.zeroByte();
                break;
            }
        }
        byArray[8] = by;
        byArray[9] = compression$gzipOperatingSystem$.MODULE$.THIS();
        byte[] header = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(byArray), ClassTag$.MODULE$.Byte());
        CRC32 crc32 = new CRC32();
        crc32.update(header);
        Option fileNameEncoded = fileName.map((Function1 & Serializable & scala.Serializable)string -> {
            void var2_2;
            byte[] bytes = string.replaceAll("\u0000", "_").getBytes(StandardCharsets.ISO_8859_1);
            crc32.update(bytes);
            crc32.update(MODULE$.zeroByte());
            return var2_2;
        });
        Option commentEncoded = comment.map((Function1 & Serializable & scala.Serializable)string -> {
            void var2_2;
            byte[] bytes = string.replaceAll("\u0000", " ").getBytes(StandardCharsets.ISO_8859_1);
            crc32.update(bytes);
            crc32.update(MODULE$.zeroByte());
            return var2_2;
        });
        long crc32Value = crc32.getValue();
        byte[] crc16 = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL)}), ClassTag$.MODULE$.Byte());
        return Stream$.MODULE$.chunk(this.moveAsChunkBytes(header)).$plus$plus((Function0 & Serializable & scala.Serializable)() -> (Stream)fileNameEncoded.map((Function1 & Serializable & scala.Serializable)bytes -> Stream$.MODULE$.chunk(MODULE$.moveAsChunkBytes((byte[])bytes)).$plus$plus((Function0 & Serializable & scala.Serializable)() -> Stream$.MODULE$.emit(BoxesRunTime.boxToByte((byte)MODULE$.zeroByte())))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Stream$.MODULE$.empty())).$plus$plus((Function0 & Serializable & scala.Serializable)() -> (Stream)commentEncoded.map((Function1 & Serializable & scala.Serializable)bytes -> Stream$.MODULE$.chunk(MODULE$.moveAsChunkBytes((byte[])bytes)).$plus$plus((Function0 & Serializable & scala.Serializable)() -> Stream$.MODULE$.emit(BoxesRunTime.boxToByte((byte)MODULE$.zeroByte())))).getOrElse((Function0 & Serializable & scala.Serializable)() -> Stream$.MODULE$.empty())).$plus$plus((Function0 & Serializable & scala.Serializable)() -> Stream$.MODULE$.chunk(MODULE$.moveAsChunkBytes(crc16)));
    }

    private <F> Stream<F, Object> _gzip_trailer(Deflater deflater, CRC32 crc32) {
        long crc32Value = crc32.getValue();
        int bytesIn = deflater.getTotalIn();
        byte[] trailer = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL), (byte)(crc32Value >> 16 & 0xFFL), (byte)(crc32Value >> 24 & 0xFFL), (byte)(bytesIn & 0xFF), (byte)(bytesIn >> 8 & 0xFF), (byte)(bytesIn >> 16 & 0xFF), (byte)(bytesIn >> 24 & 0xFF)}), ClassTag$.MODULE$.Byte());
        return Stream$.MODULE$.chunk(this.moveAsChunkBytes(trailer));
    }

    public <F> Function1<Stream<F, Object>, Stream<F, compression.GunzipResult<F>>> gunzip(int bufferSize, Sync<F> SyncF) {
        return this.gunzip(compression$InflateParams$.MODULE$.apply(bufferSize, compression$ZLibParams$Header$GZIP$.MODULE$), SyncF);
    }

    public <F> Function1<Stream<F, Object>, Stream<F, compression.GunzipResult<F>>> gunzip(compression.InflateParams inflateParams, Sync<F> SyncF) {
        return (Function1 & Serializable & scala.Serializable)stream -> {
            void var3_8;
            compression.InflateParams inflateParams = inflateParams;
            if (inflateParams != null) {
                compression.InflateParams inflateParams2 = inflateParams;
                compression.ZLibParams.Header header = inflateParams2.header();
                compression$ZLibParams$Header$GZIP$ compression$ZLibParams$Header$GZIP$2 = compression$ZLibParams$Header$GZIP$.MODULE$;
                if (!(header != null ? !header.equals(compression$ZLibParams$Header$GZIP$2) : compression$ZLibParams$Header$GZIP$2 != null)) {
                    Stream stream2 = Stream$.MODULE$.bracket(SyncF.delay((Function0 & Serializable & scala.Serializable)() -> new Tuple3((Object)new Inflater(true), (Object)new CRC32(), (Object)new CRC32())), (Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple3 tuple3 = x0$1;
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        Inflater inflater = (Inflater)tuple3._1();
                        Object object = SyncF.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> inflater.end());
                        return object;
                    }).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple3 tuple3 = x0$2;
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        Inflater inflater = (Inflater)tuple3._1();
                        CRC32 headerCrc32 = (CRC32)tuple3._2();
                        CRC32 contentCrc32 = (CRC32)tuple3._3();
                        Stream qual$1 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(stream));
                        int x$1 = MODULE$.gzipHeaderBytes();
                        boolean x$2 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$1);
                        Stream stream = Stream$ToPull$.MODULE$.unconsN$extension(qual$1, x$1, x$2).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> {
                            Pull pull;
                            Some some;
                            Tuple2 tuple2;
                            Option option = x0$3;
                            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                                Chunk mandatoryHeaderChunk = (Chunk)tuple2._1();
                                Stream streamAfterMandatoryHeader = (Stream)tuple2._2();
                                pull = MODULE$._gunzip_matchMandatoryHeader(inflateParams2, mandatoryHeaderChunk, streamAfterMandatoryHeader, headerCrc32, contentCrc32, inflater, SyncF);
                            } else if (None$.MODULE$.equals(option)) {
                                pull = Pull$.MODULE$.output1(new compression.GunzipResult(Stream$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), compression$GunzipResult$.MODULE$.apply$default$2(), compression$GunzipResult$.MODULE$.apply$default$3(), compression$GunzipResult$.MODULE$.apply$default$4()));
                            } else {
                                throw new MatchError((Object)option);
                            }
                            return pull;
                        }).stream(Predef$.MODULE$.$conforms());
                        return stream;
                    }, NotGiven$.MODULE$.default());
                    return var3_8;
                }
            }
            if (inflateParams == null) throw new MatchError((Object)inflateParams);
            compression.InflateParams inflateParams3 = inflateParams;
            Stream stream3 = Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(28).append(compression$ZLibParams$Header$GZIP$.MODULE$).append(" header type required, not ").append(inflateParams3.header()).append(".").toString()), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF));
            return var3_8;
        };
    }

    public <F> int gunzip$default$1() {
        return 32768;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private <F> Pull<?, compression.GunzipResult<F>, BoxedUnit> _gunzip_matchMandatoryHeader(compression.InflateParams inflateParams, Chunk<Object> mandatoryHeaderChunk, Stream<F, Object> streamAfterMandatoryHeader, CRC32 headerCrc32, CRC32 contentCrc32, Inflater inflater, Sync<F> SyncF) {
        void var8_22;
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)mandatoryHeaderChunk.size()), mandatoryHeaderChunk.toArraySlice(ClassTag$.MODULE$.Byte()).values());
        if (tuple2 != null) {
            Option option;
            int n = tuple2._1$mcI$sp();
            byte[] byArray = (byte[])tuple2._2();
            if (this.gzipHeaderBytes() == n && !(option = Array$.MODULE$.unapplySeq((Object)byArray)).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(9) == 0) {
                byte by = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(0));
                byte by2 = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(1));
                byte by3 = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(2));
                byte flags = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(3));
                if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by2 && compression$gzipCompressionMethod$.MODULE$.DEFLATE() == by3 && compression$gzipFlag$.MODULE$.reserved5(flags)) {
                    Pull pull = Pull$.MODULE$.output1(new compression.GunzipResult(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 5 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), compression$GunzipResult$.MODULE$.apply$default$2(), compression$GunzipResult$.MODULE$.apply$default$3(), compression$GunzipResult$.MODULE$.apply$default$4()));
                    return var8_22;
                }
            }
        }
        if (tuple2 != null) {
            Option option;
            int n = tuple2._1$mcI$sp();
            byte[] byArray = (byte[])tuple2._2();
            if (this.gzipHeaderBytes() == n && !(option = Array$.MODULE$.unapplySeq((Object)byArray)).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(9) == 0) {
                byte by = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(0));
                byte by4 = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(1));
                byte by5 = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(2));
                byte flags = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(3));
                if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by4 && compression$gzipCompressionMethod$.MODULE$.DEFLATE() == by5 && compression$gzipFlag$.MODULE$.reserved6(flags)) {
                    Pull pull = Pull$.MODULE$.output1(new compression.GunzipResult(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 6 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), compression$GunzipResult$.MODULE$.apply$default$2(), compression$GunzipResult$.MODULE$.apply$default$3(), compression$GunzipResult$.MODULE$.apply$default$4()));
                    return var8_22;
                }
            }
        }
        if (tuple2 != null) {
            Option option;
            int n = tuple2._1$mcI$sp();
            byte[] byArray = (byte[])tuple2._2();
            if (this.gzipHeaderBytes() == n && !(option = Array$.MODULE$.unapplySeq((Object)byArray)).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(9) == 0) {
                byte by = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(0));
                byte by6 = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(1));
                byte by7 = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(2));
                byte flags = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(3));
                if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by6 && compression$gzipCompressionMethod$.MODULE$.DEFLATE() == by7 && compression$gzipFlag$.MODULE$.reserved7(flags)) {
                    Pull pull = Pull$.MODULE$.output1(new compression.GunzipResult(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 7 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), compression$GunzipResult$.MODULE$.apply$default$2(), compression$GunzipResult$.MODULE$.apply$default$3(), compression$GunzipResult$.MODULE$.apply$default$4()));
                    return var8_22;
                }
            }
        }
        if (tuple2 != null) {
            Option option;
            int n = tuple2._1$mcI$sp();
            byte[] header = (byte[])tuple2._2();
            if (this.gzipHeaderBytes() == n && !(option = Array$.MODULE$.unapplySeq((Object)header)).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(10) == 0) {
                byte by = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(0));
                byte by8 = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(1));
                byte by9 = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(2));
                byte flags = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(3));
                if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by8 && compression$gzipCompressionMethod$.MODULE$.DEFLATE() == by9) {
                    headerCrc32.update(header);
                    long secondsSince197001010000 = this.unsignedToLong(header[4], header[5], header[6], header[7]);
                    Pull pull = Stream$ToPull$.MODULE$.uncons1$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(this._gunzip_readOptionalHeader(inflateParams, streamAfterMandatoryHeader, flags, headerCrc32, contentCrc32, secondsSince197001010000, inflater, SyncF)))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Pull pull;
                        Some some;
                        Tuple2 tuple2;
                        Option option = x0$1;
                        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                            compression.GunzipResult gunzipResult = (compression.GunzipResult)tuple2._1();
                            pull = Pull$.MODULE$.output1(gunzipResult);
                        } else if (None$.MODULE$.equals(option)) {
                            pull = Pull$.MODULE$.output1(new compression.GunzipResult(Stream$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), compression$GunzipResult$.MODULE$.apply$default$2(), compression$GunzipResult$.MODULE$.apply$default$3(), compression$GunzipResult$.MODULE$.apply$default$4()));
                        } else {
                            throw new MatchError((Object)option);
                        }
                        return pull;
                    });
                    return var8_22;
                }
            }
        }
        if (tuple2 != null) {
            Option option;
            int n = tuple2._1$mcI$sp();
            byte[] byArray = (byte[])tuple2._2();
            if (this.gzipHeaderBytes() == n && !(option = Array$.MODULE$.unapplySeq((Object)byArray)).isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(10) == 0) {
                byte by = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(0));
                byte by10 = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(1));
                byte compressionMethod = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(2));
                if (this.gzipMagicFirstByte() == by && this.gzipMagicSecondByte() == by10) {
                    Pull pull = Pull$.MODULE$.output1(new compression.GunzipResult(Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(37).append("Unsupported gzip compression method: ").append(compressionMethod).toString()), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), compression$GunzipResult$.MODULE$.apply$default$2(), compression$GunzipResult$.MODULE$.apply$default$3(), compression$GunzipResult$.MODULE$.apply$default$4()));
                    return var8_22;
                }
            }
        }
        Pull pull = Pull$.MODULE$.output1(new compression.GunzipResult(Stream$.MODULE$.raiseError(new ZipException("Not in gzip format"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), compression$GunzipResult$.MODULE$.apply$default$2(), compression$GunzipResult$.MODULE$.apply$default$3(), compression$GunzipResult$.MODULE$.apply$default$4()));
        return var8_22;
    }

    private <F> Stream<F, compression.GunzipResult<F>> _gunzip_readOptionalHeader(compression.InflateParams inflateParams, Stream<F, Object> streamAfterMandatoryHeader, byte flags, CRC32 headerCrc32, CRC32 contentCrc32, long secondsSince197001010000, Inflater inflater, Sync<F> SyncF) {
        return streamAfterMandatoryHeader.through(this._gunzip_skipOptionalExtraField(compression$gzipFlag$.MODULE$.fextra(flags), headerCrc32, SyncF)).through(this._gunzip_readOptionalStringField(compression$gzipFlag$.MODULE$.fname(flags), headerCrc32, "file name", this.fileNameBytesSoftLimit(), SyncF)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option fileName = (Option)tuple2._1();
            Stream streamAfterFileName = (Stream)tuple2._2();
            Stream stream = streamAfterFileName.through(MODULE$._gunzip_readOptionalStringField(compression$gzipFlag$.MODULE$.fcomment(flags), headerCrc32, "file comment", MODULE$.fileCommentBytesSoftLimit(), SyncF)).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Option comment = (Option)tuple2._1();
                Stream streamAfterComment = (Stream)tuple2._2();
                None$ x$1 = secondsSince197001010000 != 0L ? new Some((Object)Instant.ofEpochSecond(secondsSince197001010000)) : None$.MODULE$;
                Option x$2 = fileName;
                Option x$3 = comment;
                Stream x$4 = streamAfterComment.through(MODULE$._gunzip_validateHeader((byte)(flags & compression$gzipFlag$.MODULE$.FHCRC()) == compression$gzipFlag$.MODULE$.FHCRC(), headerCrc32, SyncF)).through(MODULE$._inflate(inflateParams, inflater, (Option<CRC32>)new Some((Object)contentCrc32), SyncF)).through(MODULE$._gunzip_validateTrailer(contentCrc32, inflater, SyncF));
                Stream stream = Stream$.MODULE$.emit(new compression.GunzipResult(x$4, (Option<Instant>)x$1, (Option<String>)x$2, (Option<String>)x$3));
                return stream;
            }, NotGiven$.MODULE$.default());
            return stream;
        }, NotGiven$.MODULE$.default());
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_skipOptionalExtraField(boolean isPresent, CRC32 crc32, Sync<F> Sync2) {
        return (Function1 & Serializable & scala.Serializable)stream -> {
            Stream stream2;
            if (isPresent) {
                Stream qual$1 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(stream));
                int x$1 = MODULE$.gzipOptionalExtraFieldLengthBytes();
                boolean x$2 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$1);
                stream2 = Stream$ToPull$.MODULE$.unconsN$extension(qual$1, x$1, x$2).flatMap(arg_0 -> compression$.$anonfun$_gunzip_skipOptionalExtraField$2(crc32, Sync2, arg_0)).stream(Predef$.MODULE$.$conforms()).flatten(Predef$.MODULE$.$conforms());
            } else {
                stream2 = stream;
            }
            return stream2;
        };
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Tuple2<Option<String>, Stream<F, Object>>>> _gunzip_readOptionalStringField(boolean isPresent, CRC32 crc32, String fieldName, int fieldBytesSoftLimit, Sync<F> SyncF) {
        return (Function1 & Serializable & scala.Serializable)stream -> isPresent ? ((Pull)MODULE$.unconsUntil((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)compression$.$anonfun$_gunzip_readOptionalStringField$2(BoxesRunTime.unboxToByte((Object)x$8))), fieldBytesSoftLimit, ClassTag$.MODULE$.Byte()).apply(stream)).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Pull pull;
            Some some;
            Tuple2 tuple2;
            Option option = x0$1;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Some some2;
                Chunk chunk = (Chunk)tuple2._1();
                Stream rest = (Stream)tuple2._2();
                if (chunk.isEmpty()) {
                    some2 = new Some((Object)"");
                } else {
                    Chunk.ArraySlice bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.Byte());
                    crc32.update((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
                    some2 = new Some((Object)new String((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length(), StandardCharsets.ISO_8859_1));
                }
                pull = Pull$.MODULE$.output1(new Tuple2((Object)some2, rest.dropWhile((Function1 & Serializable & scala.Serializable)object -> BoxesRunTime.boxToBoolean((boolean)compression$.$anonfun$_gunzip_readOptionalStringField$4(crc32, BoxesRunTime.unboxToByte((Object)object)))).drop(1L)));
            } else if (None$.MODULE$.equals(option)) {
                pull = Pull$.MODULE$.output1(new Tuple2((Object)Option$.MODULE$.empty(), Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(21).append("Failed to read ").append(fieldName).append(" field").toString()), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF))));
            } else {
                throw new MatchError((Object)option);
            }
            return pull;
        }).stream(Predef$.MODULE$.$conforms()) : Stream$.MODULE$.emit(new Tuple2((Object)Option$.MODULE$.empty(), stream));
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_validateHeader(boolean isPresent, CRC32 crc32, Sync<F> SyncF) {
        return (Function1 & Serializable & scala.Serializable)stream -> {
            Stream stream2;
            if (isPresent) {
                Stream qual$1 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(stream));
                int x$1 = MODULE$.gzipHeaderCrcBytes();
                boolean x$2 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$1);
                stream2 = Stream$ToPull$.MODULE$.unconsN$extension(qual$1, x$1, x$2).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Pull pull;
                    Some some;
                    Tuple2 tuple2;
                    Option option = x0$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                        long actualHeaderCrc16;
                        Chunk headerCrcChunk = (Chunk)tuple2._1();
                        Stream streamAfterHeaderCrc = (Stream)tuple2._2();
                        int expectedHeaderCrc16 = MODULE$.unsignedToInt(BoxesRunTime.unboxToByte(headerCrcChunk.apply(0)), BoxesRunTime.unboxToByte(headerCrcChunk.apply(1)));
                        pull = (long)expectedHeaderCrc16 != (actualHeaderCrc16 = crc32.getValue() & 0xFFFFL) ? Pull$.MODULE$.raiseError(new ZipException("Header failed CRC validation"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)) : Pull$.MODULE$.output1(streamAfterHeaderCrc);
                    } else if (None$.MODULE$.equals(option)) {
                        pull = Pull$.MODULE$.raiseError(new ZipException("Failed to read header CRC"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return pull;
                }).stream(Predef$.MODULE$.$conforms()).flatten(Predef$.MODULE$.$conforms());
            } else {
                stream2 = stream;
            }
            return stream2;
        };
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_validateTrailer(CRC32 crc32, Inflater inflater, Sync<F> SyncF) {
        return (Function1 & Serializable & scala.Serializable)stream -> ((Pull)compression$.streamUntilTrailer$1(Chunk$.MODULE$.empty(), inflater, crc32, SyncF).apply(stream)).stream(Predef$.MODULE$.$conforms());
    }

    private <F, O> Function1<Stream<F, O>, Pull<F, Nothing$, Option<Tuple2<Chunk<O>, Stream<F, O>>>>> unconsUntil(Function1<O, Object> predicate, int softLimit, ClassTag<O> evidence$1) {
        return (Function1 & Serializable & scala.Serializable)stream -> compression$.go$1((List)Nil$.MODULE$, stream, compression$.go$default$3$1(), predicate, evidence$1, softLimit);
    }

    private int gzipHeaderBytes() {
        return this.gzipHeaderBytes;
    }

    private byte gzipMagicFirstByte() {
        return this.gzipMagicFirstByte;
    }

    private byte gzipMagicSecondByte() {
        return this.gzipMagicSecondByte;
    }

    private int gzipOptionalExtraFieldLengthBytes() {
        return this.gzipOptionalExtraFieldLengthBytes;
    }

    private int gzipHeaderCrcBytes() {
        return this.gzipHeaderCrcBytes;
    }

    private int gzipInputCrcBytes() {
        return this.gzipInputCrcBytes;
    }

    private int gzipInputSizeBytes() {
        return this.gzipInputSizeBytes;
    }

    private int gzipTrailerBytes() {
        return this.gzipTrailerBytes;
    }

    private byte zeroByte() {
        return this.zeroByte;
    }

    private int fileNameBytesSoftLimit() {
        return this.fileNameBytesSoftLimit;
    }

    private int fileCommentBytesSoftLimit() {
        return this.fileCommentBytesSoftLimit;
    }

    private Chunk<Object> moveAsChunkBytes(byte[] values) {
        return this.moveAsChunkBytes(values, values.length);
    }

    private Chunk<Object> moveAsChunkBytes(byte[] values, int length) {
        return length > 0 ? Chunk$.MODULE$.array(values, 0, length, ClassTag$.MODULE$.Byte()) : Chunk$.MODULE$.empty();
    }

    private Chunk<Object> copyAsChunkBytes(byte[] values, int length) {
        Chunk<Object> chunk;
        if (length > 0) {
            byte[] target = new byte[length];
            System.arraycopy(values, 0, target, 0, length);
            chunk = Chunk$.MODULE$.array(target, 0, length, ClassTag$.MODULE$.Byte());
        } else {
            chunk = Chunk$.MODULE$.empty();
        }
        return chunk;
    }

    private int unsignedToInt(byte lsb, byte msb) {
        return (msb & 0xFF) << 8 | lsb & 0xFF;
    }

    private long unsignedToLong(byte lsb, byte byte2, byte byte3, byte msb) {
        return ((long)msb & 0xFFL) << 24 | (long)((byte3 & 0xFF) << 16) | (long)((byte2 & 0xFF) << 8) | (long)(lsb & 0xFF);
    }

    private static final boolean isDone$1(boolean isFinalChunk$1, Deflater deflater$3) {
        return isFinalChunk$1 && deflater$3.finished() || !isFinalChunk$1 && deflater$3.needsInput();
    }

    private static final int runDeflate$1(Deflater deflater$3, byte[] deflatedBuffer$1, compression.DeflateParams deflateParams$3, boolean isFinalChunk$1) {
        return compression$.isDone$1(isFinalChunk$1, deflater$3) ? 0 : deflater$3.deflate(deflatedBuffer$1, 0, deflateParams$3.bufferSizeOrMinimum(), deflateParams$3.flushMode().juzDeflaterFlushMode());
    }

    private final Pull pull$1(byte[] deflatedBuffer$1, Deflater deflater$3, compression.DeflateParams deflateParams$3, boolean isFinalChunk$1) {
        int deflatedBytes = compression$.runDeflate$1(deflater$3, deflatedBuffer$1, deflateParams$3, isFinalChunk$1);
        return compression$.isDone$1(isFinalChunk$1, deflater$3) ? Pull$.MODULE$.output(this.copyAsChunkBytes(deflatedBuffer$1, deflatedBytes)) : Pull$.MODULE$.output(this.copyAsChunkBytes(deflatedBuffer$1, deflatedBytes)).$greater$greater((Function0 & Serializable & scala.Serializable)() -> this.pull$1(deflatedBuffer$1, deflater$3, deflateParams$3, isFinalChunk$1));
    }

    /*
     * WARNING - void declaration
     */
    private static final int runInflate$1(Inflater inflater$3, byte[] inflatedBuffer$2, Option crc32$4) {
        int n;
        if (inflater$3.finished()) {
            n = -2;
        } else if (inflater$3.needsInput()) {
            n = -1;
        } else {
            void var3_3;
            int byteCount = inflater$3.inflate(inflatedBuffer$2);
            crc32$4.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.update(inflatedBuffer$2, 0, byteCount);
                return BoxedUnit.UNIT;
            });
            n = var3_3;
        }
        return n;
    }

    private final Pull pull$2(Inflater inflater$3, Chunk.ArraySlice bytesChunk$2, byte[] inflatedBuffer$2, Option crc32$4) {
        Pull<Object, Object, Object> pull;
        int n = compression$.runInflate$1(inflater$3, inflatedBuffer$2, crc32$4);
        switch (n) {
            default: 
        }
        if (n <= -2) {
            int n2 = inflater$3.getRemaining();
            switch (n2) {
                default: 
            }
            pull = n2 > 0 ? Pull$.MODULE$.output(Chunk$.MODULE$.array(bytesChunk$2.values(), bytesChunk$2.offset() + bytesChunk$2.length() - n2, n2, ClassTag$.MODULE$.Byte())) : Pull$.MODULE$.done();
        } else if (n == -1) {
            pull = Pull$.MODULE$.done();
        } else if (n < inflatedBuffer$2.length) {
            if (inflater$3.finished()) {
                int n3 = inflater$3.getRemaining();
                switch (n3) {
                    default: 
                }
                pull = n3 > 0 ? Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n)).$greater$greater((Function0 & Serializable & scala.Serializable)() -> Pull$.MODULE$.output(Chunk$.MODULE$.array(bytesChunk$2.values(), bytesChunk$2.offset() + bytesChunk$2.length() - n3, n3, ClassTag$.MODULE$.Byte()))) : Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n));
            } else {
                pull = Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n));
            }
        } else {
            pull = Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$2, n)).$greater$greater((Function0 & Serializable & scala.Serializable)() -> this.pull$2(inflater$3, bytesChunk$2, inflatedBuffer$2, crc32$4));
        }
        return pull;
    }

    public static final /* synthetic */ Pull $anonfun$_gunzip_skipOptionalExtraField$3(CRC32 crc32$8, Sync Sync$1, Option x0$2) {
        Pull pull;
        Some some;
        Tuple2 tuple2;
        Option option = x0$2;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            Chunk optionalExtraFieldChunk = (Chunk)tuple2._1();
            Stream streamAfterOptionalExtraField = (Stream)tuple2._2();
            Chunk.ArraySlice fieldBytes = optionalExtraFieldChunk.toArraySlice(ClassTag$.MODULE$.Byte());
            crc32$8.update((byte[])fieldBytes.values(), fieldBytes.offset(), fieldBytes.length());
            pull = Pull$.MODULE$.output1(streamAfterOptionalExtraField);
        } else if (None$.MODULE$.equals(option)) {
            pull = Pull$.MODULE$.raiseError(new ZipException("Failed to read optional extra field header"), RaiseThrowable$.MODULE$.fromApplicativeError(Sync$1));
        } else {
            throw new MatchError((Object)option);
        }
        return pull;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static final /* synthetic */ Pull $anonfun$_gunzip_skipOptionalExtraField$2(CRC32 crc32$8, Sync Sync$1, Option x0$1) {
        block5: {
            block4: {
                var5_3 = x0$1;
                if (!(var5_3 instanceof Some) || (var7_5 = (Tuple2)(var6_4 = (Some)var5_3).value()) == null) break block4;
                optionalExtraFieldLengthChunk = (Chunk)var7_5._1();
                streamAfterOptionalExtraFieldLength = (Stream)var7_5._2();
                var10_8 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)optionalExtraFieldLengthChunk.size()), optionalExtraFieldLengthChunk.toArraySlice(ClassTag$.MODULE$.Byte()).values());
                if (var10_8 == null) ** GOTO lbl-1000
                var11_9 = var10_8._1$mcI$sp();
                lengthBytes = (byte[])var10_8._2();
                if (compression$.MODULE$.gzipOptionalExtraFieldLengthBytes() == var11_9 && !(var13_11 = Array$.MODULE$.unapplySeq((Object)lengthBytes)).isEmpty() && var13_11.get() != null && ((SeqLike)var13_11.get()).lengthCompare(2) == 0) {
                    firstByte = BoxesRunTime.unboxToByte((Object)((SeqLike)var13_11.get()).apply(0));
                    secondByte = BoxesRunTime.unboxToByte((Object)((SeqLike)var13_11.get()).apply(1));
                    crc32$8.update(lengthBytes);
                    optionalExtraFieldLength = compression$.MODULE$.unsignedToInt(firstByte, secondByte);
                    qual$2 = Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(streamAfterOptionalExtraFieldLength));
                    x$3 = optionalExtraFieldLength;
                    x$4 = Stream$ToPull$.MODULE$.unconsN$default$2$extension(qual$2);
                    var4_18 /* !! */  = Stream$ToPull$.MODULE$.unconsN$extension(qual$2, x$3, x$4).flatMap((Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$_gunzip_skipOptionalExtraField$3(java.util.zip.CRC32 cats.effect.kernel.Sync scala.Option ), (Lscala/Option;)Lfs2/Pull;)((CRC32)crc32$8, (Sync)Sync$1));
                } else lbl-1000:
                // 2 sources

                {
                    var4_18 /* !! */  = Pull$.MODULE$.raiseError(new ZipException("Failed to read optional extra field header length"), RaiseThrowable$.MODULE$.fromApplicativeError(Sync$1));
                }
                var3_19 = var4_18 /* !! */ ;
                break block5;
            }
            if (None$.MODULE$.equals(var5_3)) {
                var3_19 = Pull$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(Sync$1));
            } else {
                throw new MatchError((Object)var5_3);
            }
        }
        return var3_19;
    }

    public static final /* synthetic */ boolean $anonfun$_gunzip_readOptionalStringField$2(byte x$8) {
        return x$8 == MODULE$.zeroByte();
    }

    public static final /* synthetic */ boolean $anonfun$_gunzip_readOptionalStringField$4(CRC32 crc32$9, byte by) {
        crc32$9.update(by);
        return by != MODULE$.zeroByte();
    }

    private static final Pull validateTrailer$1(Chunk trailerChunk, CRC32 crc32$11, Inflater inflater$8, Sync SyncF$11) {
        Pull<Object, Nothing$, Object> pull;
        if (trailerChunk.size() == MODULE$.gzipTrailerBytes()) {
            long expectedInputCrc32 = MODULE$.unsignedToLong(BoxesRunTime.unboxToByte(trailerChunk.apply(0)), BoxesRunTime.unboxToByte(trailerChunk.apply(1)), BoxesRunTime.unboxToByte(trailerChunk.apply(2)), BoxesRunTime.unboxToByte(trailerChunk.apply(3)));
            long actualInputCrc32 = crc32$11.getValue();
            long expectedInputSize = MODULE$.unsignedToLong(BoxesRunTime.unboxToByte(trailerChunk.apply(4)), BoxesRunTime.unboxToByte(trailerChunk.apply(5)), BoxesRunTime.unboxToByte(trailerChunk.apply(6)), BoxesRunTime.unboxToByte(trailerChunk.apply(7)));
            long actualInputSize = inflater$8.getBytesWritten() & 0xFFFFFFFFL;
            pull = expectedInputCrc32 != actualInputCrc32 ? Pull$.MODULE$.raiseError(new ZipException("Content failed CRC validation"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$11)) : (expectedInputSize != actualInputSize ? Pull$.MODULE$.raiseError(new ZipException("Content failed size validation"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$11)) : Pull$.MODULE$.done());
        } else {
            pull = Pull$.MODULE$.raiseError(new ZipException("Failed to read trailer (1)"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$11));
        }
        return pull;
    }

    private static final Function1 streamUntilTrailer$1(Chunk last, Inflater inflater$8, CRC32 crc32$11, Sync SyncF$11) {
        return (Function1 & Serializable & scala.Serializable)x$9 -> Stream$ToPull$.MODULE$.unconsNonEmpty$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(x$9))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Pull pull;
            Some some;
            Tuple2 tuple2;
            Option option = x0$1;
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Chunk next = (Chunk)tuple2._1();
                Stream rest = (Stream)tuple2._2();
                pull = inflater$8.finished() ? (next.size() >= MODULE$.gzipTrailerBytes() ? (last.nonEmpty() ? Pull$.MODULE$.output(last).$greater$greater((Function0 & Serializable & scala.Serializable)() -> (Pull)compression$.streamUntilTrailer$1(next, inflater$8, crc32$11, SyncF$11).apply((Object)rest)) : (Pull)compression$.streamUntilTrailer$1(next, inflater$8, crc32$11, SyncF$11).apply((Object)rest)) : (Pull)compression$.streamUntilTrailer$1(last.$plus$plus(next), inflater$8, crc32$11, SyncF$11).apply((Object)rest)) : (last.nonEmpty() ? Pull$.MODULE$.output(last).$greater$greater((Function0 & Serializable & scala.Serializable)() -> Pull$.MODULE$.output(next)).$greater$greater((Function0 & Serializable & scala.Serializable)() -> (Pull)compression$.streamUntilTrailer$1(Chunk$.MODULE$.empty(), inflater$8, crc32$11, SyncF$11).apply((Object)rest)) : Pull$.MODULE$.output(next).$greater$greater((Function0 & Serializable & scala.Serializable)() -> (Pull)compression$.streamUntilTrailer$1(Chunk$.MODULE$.empty(), inflater$8, crc32$11, SyncF$11).apply((Object)rest)));
            } else if (None$.MODULE$.equals(option)) {
                int preTrailerBytes = last.size() - MODULE$.gzipTrailerBytes();
                pull = preTrailerBytes > 0 ? Pull$.MODULE$.output(last.take(preTrailerBytes)).$greater$greater((Function0 & Serializable & scala.Serializable)() -> compression$.validateTrailer$1(last.drop(preTrailerBytes), crc32$11, inflater$8, SyncF$11)) : compression$.validateTrailer$1(last, crc32$11, inflater$8, SyncF$11);
            } else {
                throw new MatchError((Object)option);
            }
            return pull;
        });
    }

    private static final Pull go$1(List acc, Stream rest, int size, Function1 predicate$1, ClassTag evidence$1$1, int softLimit$1) {
        return Stream$ToPull$.MODULE$.uncons$extension(Stream$InvariantOps$.MODULE$.pull$extension(Stream$.MODULE$.InvariantOps(rest))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Some some;
            Tuple2 tuple2;
            Pull pull;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                pull = Pull$.MODULE$.pure(None$.MODULE$);
            } else if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                Pull pull2;
                Chunk hd = (Chunk)tuple2._1();
                Stream tl = (Stream)tuple2._2();
                Option<Object> option2 = hd.indexWhere(predicate$1);
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    int i = BoxesRunTime.unboxToInt((Object)some2.value());
                    Tuple2 tuple22 = hd.splitAt(i);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    Chunk pfx = (Chunk)tuple22._1();
                    Chunk sfx = (Chunk)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)pfx, (Object)sfx);
                    Tuple2 tuple24 = tuple23;
                    Chunk pfx2 = (Chunk)tuple24._1();
                    Chunk sfx2 = (Chunk)tuple24._2();
                    Chunk chunk = pfx2;
                    pull2 = Pull$.MODULE$.pure(new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Chunk$.MODULE$.concat(acc.$colon$colon((Object)chunk).reverse(), evidence$1$1)), tl.cons(sfx2))));
                } else if (None$.MODULE$.equals(option2)) {
                    Pull pull3;
                    int newSize = size + hd.size();
                    if (newSize < softLimit$1) {
                        Chunk chunk = hd;
                        pull3 = compression$.go$1(acc.$colon$colon((Object)chunk), tl, newSize, predicate$1, evidence$1$1, softLimit$1);
                    } else {
                        Chunk chunk = hd;
                        pull3 = Pull$.MODULE$.pure(new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Chunk$.MODULE$.concat(acc.$colon$colon((Object)chunk).reverse(), evidence$1$1)), (Object)tl)));
                    }
                    pull2 = pull3;
                } else {
                    throw new MatchError(option2);
                }
                pull = pull2;
            } else {
                throw new MatchError((Object)option);
            }
            return pull;
        });
    }

    private static final int go$default$3$1() {
        return 0;
    }

    private compression$() {
        MODULE$ = this;
        this.gzipHeaderBytes = 10;
        this.gzipMagicFirstByte = (byte)31;
        this.gzipMagicSecondByte = (byte)139;
        this.gzipOptionalExtraFieldLengthBytes = 2;
        this.gzipHeaderCrcBytes = 2;
        this.gzipInputCrcBytes = 4;
        this.gzipInputSizeBytes = 4;
        this.gzipTrailerBytes = this.gzipInputCrcBytes() + this.gzipInputSizeBytes();
        this.zeroByte = 0;
        this.fileNameBytesSoftLimit = 1024;
        this.fileCommentBytesSoftLimit = 0x100000;
    }
}

