/*
 * Decompiled with CFR 0.152.
 */
package fs2;

import cats.effect.Sync;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Chunk$Bytes$;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$InvariantOps$;
import fs2.Stream$ToPull$;
import fs2.compression;
import fs2.compression$DeflateParams$;
import fs2.compression$DeflateParams$FlushMode$DEFAULT$;
import fs2.compression$DeflateParams$FlushMode$NO_FLUSH$;
import fs2.compression$DeflateParams$Level$;
import fs2.compression$DeflateParams$Level$DEFAULT$;
import fs2.compression$DeflateParams$Strategy$;
import fs2.compression$DeflateParams$Strategy$DEFAULT$;
import fs2.compression$GunzipResult$;
import fs2.compression$InflateParams$;
import fs2.compression$NonProgressiveDecompressionException$;
import fs2.compression$ZLibParams$;
import fs2.compression$ZLibParams$Header$;
import fs2.compression$ZLibParams$Header$GZIP$;
import fs2.compression$gzipCompressionMethod$;
import fs2.compression$gzipExtraFlag$;
import fs2.compression$gzipFlag$;
import fs2.compression$gzipOperatingSystem$;
import fs2.internal.FreeC;
import java.io.EOFException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import scala.$less$colon$less$;
import scala.Any;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class compression$
implements Serializable {
    public static final compression$ZLibParams$ ZLibParams;
    public static final compression$DeflateParams$ DeflateParams;
    public static final compression$InflateParams$ InflateParams;
    public static final compression$GunzipResult$ GunzipResult;
    private static final int gzipHeaderBytes;
    private static final byte gzipMagicFirstByte;
    private static final byte gzipMagicSecondByte;
    private static final compression$gzipCompressionMethod$ gzipCompressionMethod;
    private static final compression$gzipFlag$ gzipFlag;
    private static final compression$gzipExtraFlag$ gzipExtraFlag;
    private static final int gzipOptionalExtraFieldLengthBytes;
    private static final int gzipHeaderCrcBytes;
    private static final compression$gzipOperatingSystem$ gzipOperatingSystem;
    private static final int gzipTrailerBytes;
    private static final byte zeroByte;
    private static final int fileNameBytesSoftLimit;
    private static final int fileCommentBytesSoftLimit;
    public static final compression$NonProgressiveDecompressionException$ NonProgressiveDecompressionException;
    public static final compression$ MODULE$;

    private compression$() {
    }

    static {
        MODULE$ = new compression$();
        gzipHeaderBytes = 10;
        gzipMagicFirstByte = (byte)31;
        gzipMagicSecondByte = (byte)139;
        gzipOptionalExtraFieldLengthBytes = 2;
        gzipHeaderCrcBytes = 2;
        int gzipInputCrcBytes = 4;
        int gzipInputSizeBytes = 4;
        gzipTrailerBytes = gzipInputCrcBytes + gzipInputSizeBytes;
        zeroByte = 0;
        fileNameBytesSoftLimit = 1024;
        fileCommentBytesSoftLimit = 0x100000;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(compression$.class);
    }

    public <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, Object, BoxedUnit>> deflate(int level, boolean nowrap, int bufferSize, int strategy, Sync<F> SyncF) {
        return this.deflate(compression$DeflateParams$.MODULE$.apply(bufferSize, compression$ZLibParams$Header$.MODULE$.apply(nowrap), compression$DeflateParams$Level$.MODULE$.apply(level), compression$DeflateParams$Strategy$.MODULE$.apply(strategy), compression$DeflateParams$FlushMode$NO_FLUSH$.MODULE$), SyncF);
    }

    public int deflate$default$1() {
        return -1;
    }

    public boolean deflate$default$2() {
        return false;
    }

    public int deflate$default$3() {
        return 32768;
    }

    public int deflate$default$4() {
        return 0;
    }

    public <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, Object, BoxedUnit>> deflate(compression.DeflateParams deflateParams, Sync<F> SyncF) {
        return arg_0 -> this.deflate$$anonfun$adapted$1(deflateParams, SyncF, arg_0);
    }

    private <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, Object, BoxedUnit>> _deflate(compression.DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32) {
        return arg_0 -> this._deflate$$anonfun$adapted$1(deflateParams, deflater, crc32, arg_0);
    }

    private <F> FreeC<F, Object, BoxedUnit> _deflate_chunk(compression.DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32, Chunk<Object> chunk, byte[] deflatedBuffer, boolean isFinalChunk) {
        Chunk.Bytes bytesChunk = chunk.toBytes($less$colon$less$.MODULE$.refl());
        deflater.setInput(bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
        if (isFinalChunk) {
            deflater.finish();
        }
        crc32.foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.update(bytesChunk.values(), bytesChunk.offset(), bytesChunk.length()));
        return this.pull$1(deflateParams, deflater, deflatedBuffer, isFinalChunk);
    }

    private <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, Object, BoxedUnit>> _deflate_stream(compression.DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32, byte[] deflatedBuffer) {
        return arg_0 -> this._deflate_stream$$anonfun$adapted$1(deflateParams, deflater, crc32, deflatedBuffer, arg_0);
    }

    public <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, Object, BoxedUnit>> inflate(boolean nowrap, int bufferSize, Sync<F> SyncF) {
        return this.inflate(compression$InflateParams$.MODULE$.apply(bufferSize, compression$ZLibParams$Header$.MODULE$.apply(nowrap)), SyncF);
    }

    public boolean inflate$default$1() {
        return false;
    }

    public int inflate$default$2() {
        return 32768;
    }

    public <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, Object, BoxedUnit>> inflate(compression.InflateParams inflateParams, Sync<F> SyncF) {
        return arg_0 -> this.inflate$$anonfun$adapted$1(inflateParams, SyncF, arg_0);
    }

    private <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, Object, BoxedUnit>> _inflate(compression.InflateParams inflateParams, Inflater inflater, Option<CRC32> crc32, Sync<F> SyncF) {
        return arg_0 -> this._inflate$$anonfun$adapted$1(inflateParams, inflater, crc32, SyncF, arg_0);
    }

    private <F> FreeC<F, Object, BoxedUnit> _inflate_chunk(compression.InflateParams inflaterParams, Inflater inflater, Option<CRC32> crc32, Chunk<Object> chunk, byte[] inflatedBuffer) {
        Chunk.Bytes bytesChunk = chunk.toBytes($less$colon$less$.MODULE$.refl());
        inflater.setInput(bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
        return this.pull$2(inflater, crc32, inflatedBuffer, bytesChunk);
    }

    private <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, Object, BoxedUnit>> _inflate_stream(compression.InflateParams inflateParams, Inflater inflater, Option<CRC32> crc32, byte[] inflatedBuffer, Sync<F> SyncF) {
        return arg_0 -> this._inflate_stream$$anonfun$adapted$1(inflateParams, inflater, crc32, inflatedBuffer, SyncF, arg_0);
    }

    public <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, Object, BoxedUnit>> gzip(int bufferSize, Option<Object> deflateLevel, Option<Object> deflateStrategy, Option<Instant> modificationTime, Option<String> fileName, Option<String> comment, Sync<F> SyncF) {
        return this.gzip(fileName, modificationTime, comment, compression$DeflateParams$.MODULE$.apply(bufferSize, compression$ZLibParams$Header$GZIP$.MODULE$, (compression.DeflateParams.Level)deflateLevel.map((Function1)((JFunction1 & Serializable)this::gzip$$anonfun$adapted$1)).getOrElse(this::gzip$$anonfun$1), (compression.DeflateParams.Strategy)deflateStrategy.map((Function1)((JFunction1 & Serializable)this::gzip$$anonfun$adapted$2)).getOrElse(this::gzip$$anonfun$2), compression$DeflateParams$FlushMode$DEFAULT$.MODULE$), SyncF);
    }

    public int gzip$default$1() {
        return 32768;
    }

    public <F> None$ gzip$default$2() {
        return None$.MODULE$;
    }

    public <F> None$ gzip$default$3() {
        return None$.MODULE$;
    }

    public <F> None$ gzip$default$4() {
        return None$.MODULE$;
    }

    public <F> None$ gzip$default$5() {
        return None$.MODULE$;
    }

    public <F> None$ gzip$default$6() {
        return None$.MODULE$;
    }

    public <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, Object, BoxedUnit>> gzip(Option<String> fileName, Option<Instant> modificationTime, Option<String> comment, compression.DeflateParams deflateParams, Sync<F> SyncF) {
        return arg_0 -> this.gzip$$anonfun$adapted$3(fileName, modificationTime, comment, deflateParams, SyncF, arg_0);
    }

    private <F> FreeC<F, Object, BoxedUnit> _gzip_header(Option<String> fileName, Option<Instant> modificationTime, Option<String> comment, int deflateLevel) {
        int n;
        long secondsSince197001010000 = BoxesRunTime.unboxToLong((Object)modificationTime.map((Function1)(JFunction1 & Serializable)_$18 -> _$18.getEpochSecond()).getOrElse((Function0)((JFunction0.mcJ.sp & Serializable)this::$anonfun$2)));
        byte[] header = new byte[]{gzipMagicFirstByte, gzipMagicSecondByte, compression$gzipCompressionMethod$.MODULE$.DEFLATE(), (byte)(compression$gzipFlag$.MODULE$.FHCRC() + BoxesRunTime.unboxToByte((Object)fileName.map((Function1)(JFunction1 & Serializable)_$19 -> compression$gzipFlag$.MODULE$.FNAME()).getOrElse((Function0)((JFunction0.mcB.sp & Serializable)this::$anonfun$4))) + BoxesRunTime.unboxToByte((Object)comment.map((Function1)(JFunction1 & Serializable)_$20 -> compression$gzipFlag$.MODULE$.FCOMMENT()).getOrElse((Function0)((JFunction0.mcB.sp & Serializable)this::$anonfun$6)))), (byte)(secondsSince197001010000 & 0xFFL), (byte)(secondsSince197001010000 >> 8 & 0xFFL), (byte)(secondsSince197001010000 >> 16 & 0xFFL), (byte)(secondsSince197001010000 >> 24 & 0xFFL), 9 == (n = deflateLevel) ? compression$gzipExtraFlag$.MODULE$.DEFLATE_MAX_COMPRESSION_SLOWEST_ALGO() : (1 == n ? compression$gzipExtraFlag$.MODULE$.DEFLATE_FASTEST_ALGO() : zeroByte), compression$gzipOperatingSystem$.MODULE$.THIS()};
        CRC32 crc32 = new CRC32();
        crc32.update(header);
        Option fileNameEncoded = fileName.map((Function1)(JFunction1 & Serializable)string -> {
            void var3_3;
            byte[] bytes = string.replaceAll("\u0000", "_").getBytes(StandardCharsets.ISO_8859_1);
            crc32.update(bytes);
            crc32.update(zeroByte);
            return var3_3;
        });
        Option commentEncoded = comment.map((Function1)(JFunction1 & Serializable)string -> {
            void var3_3;
            byte[] bytes = string.replaceAll("\u0000", " ").getBytes(StandardCharsets.ISO_8859_1);
            crc32.update(bytes);
            crc32.update(zeroByte);
            return var3_3;
        });
        long crc32Value = crc32.getValue();
        byte[] crc16 = new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL)};
        FreeC freeC = Stream$.MODULE$.chunk(this.moveAsChunkBytes(header));
        FreeC freeC2 = Stream$.MODULE$.$plus$plus$extension(freeC, () -> this.$anonfun$adapted$1(fileNameEncoded));
        FreeC freeC3 = Stream$.MODULE$.$plus$plus$extension(freeC2, () -> this.$anonfun$adapted$2(commentEncoded));
        return Stream$.MODULE$.$plus$plus$extension(freeC3, () -> this._gzip_header$$anonfun$adapted$1(crc16));
    }

    private <F> FreeC<F, Object, BoxedUnit> _gzip_trailer(Deflater deflater, CRC32 crc32) {
        long crc32Value = crc32.getValue();
        int bytesIn = deflater.getTotalIn();
        byte[] trailer = new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL), (byte)(crc32Value >> 16 & 0xFFL), (byte)(crc32Value >> 24 & 0xFFL), (byte)(bytesIn & 0xFF), (byte)(bytesIn >> 8 & 0xFF), (byte)(bytesIn >> 16 & 0xFF), (byte)(bytesIn >> 24 & 0xFF)};
        return Stream$.MODULE$.chunk(this.moveAsChunkBytes(trailer));
    }

    public <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, compression.GunzipResult<F>, BoxedUnit>> gunzip(int bufferSize, Sync<F> SyncF) {
        return this.gunzip(compression$InflateParams$.MODULE$.apply(bufferSize, compression$ZLibParams$Header$GZIP$.MODULE$), SyncF);
    }

    public int gunzip$default$1() {
        return 32768;
    }

    public <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, compression.GunzipResult<F>, BoxedUnit>> gunzip(compression.InflateParams inflateParams, Sync<F> SyncF) {
        return arg_0 -> this.gunzip$$anonfun$adapted$1(inflateParams, SyncF, arg_0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private <F> FreeC<Any, compression.GunzipResult<F>, BoxedUnit> _gunzip_matchMandatoryHeader(compression.InflateParams inflateParams, Chunk<Object> mandatoryHeaderChunk, FreeC<F, Object, BoxedUnit> streamAfterMandatoryHeader, CRC32 headerCrc32, CRC32 contentCrc32, Inflater inflater, Sync<F> SyncF) {
        FreeC<Object, compression.GunzipResult<Object>, Object> freeC;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)mandatoryHeaderChunk.size()), (Object)mandatoryHeaderChunk.toBytes($less$colon$less$.MODULE$.refl()).values());
        if (tuple2 != null) {
            byte[] byArray = (byte[])tuple2._2();
            if (gzipHeaderBytes == BoxesRunTime.unboxToInt((Object)tuple2._1()) && byArray != null) {
                Object object = Array$.MODULE$.unapplySeq((Object)byArray);
                if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 9) == 0) {
                    byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0));
                    byte by2 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1));
                    byte by3 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2));
                    byte by4 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 3));
                    byte by5 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 4));
                    byte by6 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 5));
                    byte by7 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 6));
                    byte by8 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 7));
                    byte by9 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 8));
                    if (gzipMagicFirstByte == by && gzipMagicSecondByte == by2 && compression$gzipCompressionMethod$.MODULE$.DEFLATE() == by3) {
                        byte flags = by4;
                        if (compression$gzipFlag$.MODULE$.reserved5(flags)) {
                            freeC = Pull$.MODULE$.output1(compression$GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 5 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), (Option<Instant>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$2(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$3(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                            return freeC;
                        }
                        byte flags2 = by4;
                        if (compression$gzipFlag$.MODULE$.reserved6(flags2)) {
                            freeC = Pull$.MODULE$.output1(compression$GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 6 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), (Option<Instant>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$2(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$3(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                            return freeC;
                        }
                        byte flags3 = by4;
                        if (compression$gzipFlag$.MODULE$.reserved7(flags3)) {
                            freeC = Pull$.MODULE$.output1(compression$GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 7 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), (Option<Instant>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$2(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$3(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                            return freeC;
                        }
                    }
                }
                if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 10) == 0) {
                    byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0));
                    byte by10 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1));
                    byte by11 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2));
                    byte by12 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 3));
                    byte by13 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 4));
                    byte by14 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 5));
                    byte by15 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 6));
                    byte by16 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 7));
                    byte by17 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 8));
                    byte by18 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 9));
                    if (gzipMagicFirstByte == by && gzipMagicSecondByte == by10) {
                        if (compression$gzipCompressionMethod$.MODULE$.DEFLATE() == by11) {
                            byte flags = by12;
                            byte[] header = byArray;
                            headerCrc32.update(header);
                            long secondsSince197001010000 = this.unsignedToLong(header[4], header[5], header[6], header[7]);
                            FreeC<F, compression.GunzipResult<F>, BoxedUnit> freeC2 = Stream$.MODULE$.InvariantOps(this._gunzip_readOptionalHeader(inflateParams, streamAfterMandatoryHeader, flags, headerCrc32, contentCrc32, secondsSince197001010000, inflater, SyncF));
                            FreeC<F, compression.GunzipResult<F>, BoxedUnit> freeC3 = new Stream.ToPull<F, compression.GunzipResult<F>>(Stream$InvariantOps$.MODULE$.pull$extension(freeC2)).fs2$Stream$ToPull$$free();
                            FreeC<F, Nothing$, Option<Tuple2<compression.GunzipResult<F>, FreeC<F, compression.GunzipResult<F>, BoxedUnit>>>> freeC4 = new Pull<F, Nothing$, Option<Tuple2<compression.GunzipResult<F>, FreeC<F, compression.GunzipResult<F>, BoxedUnit>>>>(Stream$ToPull$.MODULE$.uncons1$extension(freeC3)).fs2$Pull$$free();
                            freeC = Pull$.MODULE$.flatMap$extension(freeC4, arg_0 -> this._gunzip_matchMandatoryHeader$$anonfun$adapted$1(SyncF, arg_0));
                            return freeC;
                        }
                        byte compressionMethod = by11;
                        freeC = Pull$.MODULE$.output1(compression$GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip compression method: " + compressionMethod), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), (Option<Instant>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$2(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$3(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                        return freeC;
                    }
                }
            }
        }
        freeC = Pull$.MODULE$.output1(compression$GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException("Not in gzip format"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), (Option<Instant>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$2(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$3(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$4()));
        return freeC;
    }

    private <F> FreeC<F, compression.GunzipResult<F>, BoxedUnit> _gunzip_readOptionalHeader(compression.InflateParams inflateParams, FreeC<F, Object, BoxedUnit> streamAfterMandatoryHeader, byte flags, CRC32 headerCrc32, CRC32 contentCrc32, long secondsSince197001010000, Inflater inflater, Sync<F> SyncF) {
        FreeC<F, Object, BoxedUnit> freeC = Stream$.MODULE$.through$extension(streamAfterMandatoryHeader, this._gunzip_skipOptionalExtraField(compression$gzipFlag$.MODULE$.fextra(flags), headerCrc32, SyncF));
        FreeC<F, Tuple2<Option<String>, FreeC<F, Object, BoxedUnit>>, BoxedUnit> freeC2 = Stream$.MODULE$.through$extension(freeC, this._gunzip_readOptionalStringField(compression$gzipFlag$.MODULE$.fname(flags), headerCrc32, "file name", fileNameBytesSoftLimit, SyncF));
        return Stream$.MODULE$.flatMap$extension(freeC2, arg_0 -> this._gunzip_readOptionalHeader$$anonfun$adapted$1(inflateParams, flags, headerCrc32, contentCrc32, secondsSince197001010000, inflater, SyncF, arg_0));
    }

    private <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, Object, BoxedUnit>> _gunzip_skipOptionalExtraField(boolean isPresent, CRC32 crc32, Sync<F> Sync2) {
        return arg_0 -> this._gunzip_skipOptionalExtraField$$anonfun$adapted$1(isPresent, crc32, Sync2, arg_0);
    }

    private <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, Tuple2<Option<String>, FreeC<F, Object, BoxedUnit>>, BoxedUnit>> _gunzip_readOptionalStringField(boolean isPresent, CRC32 crc32, String fieldName, int fieldBytesSoftLimit, Sync<F> SyncF) {
        return arg_0 -> this._gunzip_readOptionalStringField$$anonfun$adapted$1(isPresent, crc32, fieldName, fieldBytesSoftLimit, SyncF, arg_0);
    }

    private <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, Object, BoxedUnit>> _gunzip_validateHeader(boolean isPresent, CRC32 crc32, Sync<F> SyncF) {
        return arg_0 -> this._gunzip_validateHeader$$anonfun$adapted$1(isPresent, crc32, SyncF, arg_0);
    }

    private <F> Function1<FreeC<F, Object, BoxedUnit>, FreeC<F, Object, BoxedUnit>> _gunzip_validateTrailer(CRC32 crc32, Inflater inflater, Sync<F> SyncF) {
        return arg_0 -> this._gunzip_validateTrailer$$anonfun$adapted$1(crc32, inflater, SyncF, arg_0);
    }

    private <F, O> Function1<FreeC<F, O, BoxedUnit>, FreeC<F, Nothing$, Option<Tuple2<Chunk<O>, FreeC<F, O, BoxedUnit>>>>> unconsUntil(Function1<O, Object> predicate, int softLimit) {
        return arg_0 -> this.unconsUntil$$anonfun$adapted$1(predicate, softLimit, arg_0);
    }

    private Chunk<Object> moveAsChunkBytes(byte[] values) {
        return this.moveAsChunkBytes(values, values.length);
    }

    private Chunk<Object> moveAsChunkBytes(byte[] values, int length) {
        return length > 0 ? Chunk$Bytes$.MODULE$.apply(values, 0, length) : Chunk$.MODULE$.empty();
    }

    private Chunk<Object> copyAsChunkBytes(byte[] values) {
        return this.copyAsChunkBytes(values, values.length);
    }

    private Chunk<Object> copyAsChunkBytes(byte[] values, int length) {
        Chunk.Bytes bytes;
        if (length > 0) {
            byte[] target = new byte[length];
            System.arraycopy(values, 0, target, 0, length);
            bytes = Chunk$Bytes$.MODULE$.apply(target, 0, length);
        } else {
            bytes = Chunk$.MODULE$.empty();
        }
        return bytes;
    }

    private int unsignedToInt(byte lsb, byte msb) {
        return (msb & 0xFF) << 8 | lsb & 0xFF;
    }

    private long unsignedToLong(byte lsb, byte byte2, byte byte3, byte msb) {
        return ((long)msb & 0xFFL) << 24 | (long)((byte3 & 0xFF) << 16) | (long)((byte2 & 0xFF) << 8) | (long)(lsb & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    private final Deflater deflate$$anonfun$1$$anonfun$1(compression.DeflateParams deflateParams$2) {
        void var2_2;
        Deflater deflater = new Deflater(deflateParams$2.level().juzDeflaterLevel(), deflateParams$2.header().juzDeflaterNoWrap());
        deflater.setStrategy(deflateParams$2.strategy().juzDeflaterStrategy());
        return var2_2;
    }

    private final void deflate$$anonfun$2$$anonfun$2$$anonfun$1(Deflater deflater$1) {
        deflater$1.end();
    }

    private final /* synthetic */ FreeC deflate$$anonfun$4$$anonfun$4(compression.DeflateParams deflateParams$3, FreeC stream$1, Deflater deflater) {
        Object object = this._deflate(deflateParams$3, deflater, (Option<CRC32>)None$.MODULE$).apply(new Stream(stream$1));
        return object == null ? null : ((Stream)object).fs2$Stream$$free();
    }

    private final Object deflate$$anonfun$5$$anonfun$adapted$1(compression.DeflateParams deflateParams$12, FreeC stream$6, Deflater deflater) {
        return new Stream(this.deflate$$anonfun$4$$anonfun$4(deflateParams$12, stream$6, deflater));
    }

    private final /* synthetic */ FreeC deflate$$anonfun$6(compression.DeflateParams deflateParams$1, Sync SyncF$1, FreeC stream) {
        FreeC freeC = Stream$.MODULE$.bracket(SyncF$1.delay(() -> this.deflate$$anonfun$1$$anonfun$1(deflateParams$1)), (JFunction1 & Serializable)deflater -> SyncF$1.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.deflate$$anonfun$2$$anonfun$2$$anonfun$1(deflater))));
        return Stream$.MODULE$.flatMap$extension(freeC, arg_0 -> this.deflate$$anonfun$5$$anonfun$adapted$1(deflateParams$1, stream, arg_0));
    }

    private final Object deflate$$anonfun$adapted$1(compression.DeflateParams deflateParams$13, Sync SyncF$35, Object v1) {
        return new Stream(this.deflate$$anonfun$6(deflateParams$13, SyncF$35, v1 == null ? null : ((Stream)v1).fs2$Stream$$free()));
    }

    private final FreeC _deflate$$anonfun$1$$anonfun$1(compression.DeflateParams deflateParams$5, Deflater deflater$3, Option crc32$2, FreeC in$1) {
        byte[] deflatedBuffer = new byte[deflateParams$5.bufferSizeOrMinimum()];
        Object object = this._deflate_stream(deflateParams$5, deflater$3, (Option<CRC32>)crc32$2, deflatedBuffer).apply(new Stream(in$1));
        FreeC freeC = object == null ? null : ((Pull)object).fs2$Pull$$free();
        return Pull$.MODULE$.stream$extension(freeC, $less$colon$less$.MODULE$.refl());
    }

    private final Object _deflate$$anonfun$2$$anonfun$adapted$1(compression.DeflateParams deflateParams$14, Deflater deflater$13, Option crc32$36, FreeC in$3) {
        return new Stream(this._deflate$$anonfun$1$$anonfun$1(deflateParams$14, deflater$13, crc32$36, in$3));
    }

    private final /* synthetic */ FreeC _deflate$$anonfun$3(compression.DeflateParams deflateParams$4, Deflater deflater$2, Option crc32$1, FreeC in) {
        return Stream$.MODULE$.suspend(() -> this._deflate$$anonfun$2$$anonfun$adapted$1(deflateParams$4, deflater$2, crc32$1, in));
    }

    private final Object _deflate$$anonfun$adapted$1(compression.DeflateParams deflateParams$15, Deflater deflater$14, Option crc32$37, Object v1) {
        return new Stream(this._deflate$$anonfun$3(deflateParams$15, deflater$14, crc32$37, v1 == null ? null : ((Stream)v1).fs2$Stream$$free()));
    }

    private final boolean isDone$1(Deflater deflater$4, boolean isFinalChunk$1) {
        return isFinalChunk$1 && deflater$4.finished() || !isFinalChunk$1 && deflater$4.needsInput();
    }

    private final int runDeflate$1(compression.DeflateParams deflateParams$6, Deflater deflater$5, byte[] deflatedBuffer$1, boolean isFinalChunk$2) {
        return this.isDone$1(deflater$5, isFinalChunk$2) ? 0 : deflater$5.deflate(deflatedBuffer$1, 0, deflateParams$6.bufferSizeOrMinimum(), deflateParams$6.flushMode().juzDeflaterFlushMode());
    }

    private final FreeC pull$3$$anonfun$1(compression.DeflateParams deflateParams$16, Deflater deflater$15, byte[] deflatedBuffer$6, boolean isFinalChunk$4) {
        return this.pull$1(deflateParams$16, deflater$15, deflatedBuffer$6, isFinalChunk$4);
    }

    private final Object pull$4$$anonfun$adapted$1(compression.DeflateParams deflateParams$17, Deflater deflater$16, byte[] deflatedBuffer$7, boolean isFinalChunk$5) {
        return new Pull(this.pull$3$$anonfun$1(deflateParams$17, deflater$16, deflatedBuffer$7, isFinalChunk$5));
    }

    private final FreeC pull$1(compression.DeflateParams deflateParams$7, Deflater deflater$6, byte[] deflatedBuffer$2, boolean isFinalChunk$3) {
        FreeC<Object, Object, Object> freeC;
        int deflatedBytes = this.runDeflate$1(deflateParams$7, deflater$6, deflatedBuffer$2, isFinalChunk$3);
        if (this.isDone$1(deflater$6, isFinalChunk$3)) {
            freeC = Pull$.MODULE$.output(this.copyAsChunkBytes(deflatedBuffer$2, deflatedBytes));
        } else {
            FreeC freeC2 = Pull$.MODULE$.output(this.copyAsChunkBytes(deflatedBuffer$2, deflatedBytes));
            freeC = Pull$.MODULE$.$greater$greater$extension(freeC2, () -> this.pull$4$$anonfun$adapted$1(deflateParams$7, deflater$6, deflatedBuffer$2, isFinalChunk$3));
        }
        return freeC;
    }

    private final FreeC _deflate_stream$$anonfun$1$$anonfun$1$$anonfun$1(compression.DeflateParams deflateParams$10, Deflater deflater$9, Option crc32$5, byte[] deflatedBuffer$5, FreeC inflatedStream$1) {
        Object object = this._deflate_stream(deflateParams$10, deflater$9, (Option<CRC32>)crc32$5, deflatedBuffer$5).apply(new Stream(inflatedStream$1));
        return object == null ? null : ((Pull)object).fs2$Pull$$free();
    }

    private final Object _deflate_stream$$anonfun$2$$anonfun$2$$anonfun$adapted$1(compression.DeflateParams deflateParams$18, Deflater deflater$17, Option crc32$38, byte[] deflatedBuffer$8, FreeC inflatedStream$2) {
        return new Pull(this._deflate_stream$$anonfun$1$$anonfun$1$$anonfun$1(deflateParams$18, deflater$17, crc32$38, deflatedBuffer$8, inflatedStream$2));
    }

    private final /* synthetic */ FreeC _deflate_stream$$anonfun$3$$anonfun$3(compression.DeflateParams deflateParams$9, Deflater deflater$8, Option crc32$4, byte[] deflatedBuffer$4, Option x$1) {
        FreeC<Object, Object, Object> freeC;
        Tuple2 tuple2;
        Option option = x$1;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Chunk inflatedChunk = (Chunk)tuple2._1();
            FreeC inflatedStream = tuple2._2() == null ? null : ((Stream)tuple2._2()).fs2$Stream$$free();
            FreeC freeC2 = this._deflate_chunk(deflateParams$9, deflater$8, (Option<CRC32>)crc32$4, inflatedChunk, deflatedBuffer$4, false);
            freeC = Pull$.MODULE$.$greater$greater$extension(freeC2, () -> this._deflate_stream$$anonfun$2$$anonfun$2$$anonfun$adapted$1(deflateParams$9, deflater$8, crc32$4, deflatedBuffer$4, inflatedStream));
        } else if (None$.MODULE$.equals(option)) {
            freeC = this._deflate_chunk(deflateParams$9, deflater$8, (Option<CRC32>)crc32$4, Chunk$.MODULE$.empty(), deflatedBuffer$4, true);
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    private final Object _deflate_stream$$anonfun$4$$anonfun$adapted$1(compression.DeflateParams deflateParams$19, Deflater deflater$18, Option crc32$39, byte[] deflatedBuffer$9, Option x$1) {
        return new Pull(this._deflate_stream$$anonfun$3$$anonfun$3(deflateParams$19, deflater$18, crc32$39, deflatedBuffer$9, x$1));
    }

    private final /* synthetic */ FreeC _deflate_stream$$anonfun$5(compression.DeflateParams deflateParams$8, Deflater deflater$7, Option crc32$3, byte[] deflatedBuffer$3, FreeC _$7) {
        FreeC freeC = Stream$.MODULE$.InvariantOps(_$7);
        FreeC freeC2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(freeC)).fs2$Stream$ToPull$$free();
        FreeC freeC3 = new Pull(Stream$ToPull$.MODULE$.unconsNonEmpty$extension(freeC2)).fs2$Pull$$free();
        return Pull$.MODULE$.flatMap$extension(freeC3, arg_0 -> this._deflate_stream$$anonfun$4$$anonfun$adapted$1(deflateParams$8, deflater$7, crc32$3, deflatedBuffer$3, arg_0));
    }

    private final Object _deflate_stream$$anonfun$adapted$1(compression.DeflateParams deflateParams$20, Deflater deflater$19, Option crc32$40, byte[] deflatedBuffer$10, Object v1) {
        return new Pull(this._deflate_stream$$anonfun$5(deflateParams$20, deflater$19, crc32$40, deflatedBuffer$10, v1 == null ? null : ((Stream)v1).fs2$Stream$$free()));
    }

    private final Inflater inflate$$anonfun$1$$anonfun$1(compression.InflateParams inflateParams$2) {
        return new Inflater(inflateParams$2.header().juzDeflaterNoWrap());
    }

    private final void inflate$$anonfun$2$$anonfun$2$$anonfun$1(Inflater inflater$1) {
        inflater$1.end();
    }

    private final /* synthetic */ FreeC inflate$$anonfun$4$$anonfun$4(compression.InflateParams inflateParams$3, Sync SyncF$5, FreeC stream$2, Inflater inflater) {
        Object object = this._inflate(inflateParams$3, inflater, (Option<CRC32>)None$.MODULE$, SyncF$5).apply(new Stream(stream$2));
        return object == null ? null : ((Stream)object).fs2$Stream$$free();
    }

    private final Object inflate$$anonfun$5$$anonfun$adapted$1(compression.InflateParams inflateParams$14, Sync SyncF$36, FreeC stream$7, Inflater inflater) {
        return new Stream(this.inflate$$anonfun$4$$anonfun$4(inflateParams$14, SyncF$36, stream$7, inflater));
    }

    private final /* synthetic */ FreeC inflate$$anonfun$6(compression.InflateParams inflateParams$1, Sync SyncF$3, FreeC stream) {
        FreeC freeC = Stream$.MODULE$.bracket(SyncF$3.delay(() -> this.inflate$$anonfun$1$$anonfun$1(inflateParams$1)), (JFunction1 & Serializable)inflater -> SyncF$3.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.inflate$$anonfun$2$$anonfun$2$$anonfun$1(inflater))));
        return Stream$.MODULE$.flatMap$extension(freeC, arg_0 -> this.inflate$$anonfun$5$$anonfun$adapted$1(inflateParams$1, SyncF$3, stream, arg_0));
    }

    private final Object inflate$$anonfun$adapted$1(compression.InflateParams inflateParams$15, Sync SyncF$37, Object v1) {
        return new Stream(this.inflate$$anonfun$6(inflateParams$15, SyncF$37, v1 == null ? null : ((Stream)v1).fs2$Stream$$free()));
    }

    private final FreeC _inflate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(compression.InflateParams inflateParams$7, Inflater inflater$5, Option crc32$9, Sync SyncF$9, byte[] inflatedBuffer$2, FreeC deflatedStream$1) {
        Object object = this._inflate_stream(inflateParams$7, inflater$5, (Option<CRC32>)crc32$9, inflatedBuffer$2, SyncF$9).apply(new Stream(deflatedStream$1));
        return object == null ? null : ((Pull)object).fs2$Pull$$free();
    }

    private final Object _inflate$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$adapted$1(compression.InflateParams inflateParams$16, Inflater inflater$24, Option crc32$41, Sync SyncF$38, byte[] inflatedBuffer$9, FreeC deflatedStream$3) {
        return new Pull(this._inflate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(inflateParams$16, inflater$24, crc32$41, SyncF$38, inflatedBuffer$9, deflatedStream$3));
    }

    private final /* synthetic */ FreeC _inflate$$anonfun$3$$anonfun$3$$anonfun$3(compression.InflateParams inflateParams$6, Inflater inflater$4, Option crc32$8, Sync SyncF$8, byte[] inflatedBuffer$1, Option x$1) {
        FreeC<Object, Object, Object> freeC;
        Tuple2 tuple2;
        Option option = x$1;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Chunk deflatedChunk = (Chunk)tuple2._1();
            FreeC deflatedStream = tuple2._2() == null ? null : ((Stream)tuple2._2()).fs2$Stream$$free();
            FreeC freeC2 = this._inflate_chunk(inflateParams$6, inflater$4, (Option<CRC32>)crc32$8, deflatedChunk, inflatedBuffer$1);
            freeC = Pull$.MODULE$.$greater$greater$extension(freeC2, () -> this._inflate$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$adapted$1(inflateParams$6, inflater$4, crc32$8, SyncF$8, inflatedBuffer$1, deflatedStream));
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.done();
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    private final Object $anonfun$adapted$3(compression.InflateParams inflateParams$17, Inflater inflater$25, Option crc32$42, Sync SyncF$39, byte[] inflatedBuffer$10, Option x$1) {
        return new Pull(this._inflate$$anonfun$3$$anonfun$3$$anonfun$3(inflateParams$17, inflater$25, crc32$42, SyncF$39, inflatedBuffer$10, x$1));
    }

    private final FreeC _inflate$$anonfun$4$$anonfun$4(compression.InflateParams inflateParams$5, Inflater inflater$3, Option crc32$7, Sync SyncF$7, FreeC in$2) {
        byte[] inflatedBuffer = new byte[inflateParams$5.bufferSizeOrMinimum()];
        FreeC freeC = Stream$.MODULE$.InvariantOps(in$2);
        FreeC freeC2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(freeC)).fs2$Stream$ToPull$$free();
        FreeC freeC3 = new Pull(Stream$ToPull$.MODULE$.unconsNonEmpty$extension(freeC2)).fs2$Pull$$free();
        FreeC freeC4 = Pull$.MODULE$.flatMap$extension(freeC3, arg_0 -> this.$anonfun$adapted$3(inflateParams$5, inflater$3, crc32$7, SyncF$7, inflatedBuffer, arg_0));
        return Pull$.MODULE$.stream$extension(freeC4, $less$colon$less$.MODULE$.refl());
    }

    private final Object _inflate$$anonfun$5$$anonfun$adapted$1(compression.InflateParams inflateParams$18, Inflater inflater$26, Option crc32$43, Sync SyncF$40, FreeC in$4) {
        return new Stream(this._inflate$$anonfun$4$$anonfun$4(inflateParams$18, inflater$26, crc32$43, SyncF$40, in$4));
    }

    private final /* synthetic */ FreeC _inflate$$anonfun$6(compression.InflateParams inflateParams$4, Inflater inflater$2, Option crc32$6, Sync SyncF$6, FreeC in) {
        return Stream$.MODULE$.suspend(() -> this._inflate$$anonfun$5$$anonfun$adapted$1(inflateParams$4, inflater$2, crc32$6, SyncF$6, in));
    }

    private final Object _inflate$$anonfun$adapted$1(compression.InflateParams inflateParams$19, Inflater inflater$27, Option crc32$44, Sync SyncF$41, Object v1) {
        return new Stream(this._inflate$$anonfun$6(inflateParams$19, inflater$27, crc32$44, SyncF$41, v1 == null ? null : ((Stream)v1).fs2$Stream$$free()));
    }

    private final int runInflate$2(Inflater inflater$6, Option crc32$10, byte[] inflatedBuffer$3) {
        int n;
        if (inflater$6.finished()) {
            n = -2;
        } else if (inflater$6.needsInput()) {
            n = -1;
        } else {
            int byteCount = inflater$6.inflate(inflatedBuffer$3);
            crc32$10.foreach((Function1)(JProcedure1 & Serializable)_$12 -> _$12.update(inflatedBuffer$3, 0, byteCount));
            n = byteCount;
        }
        return n;
    }

    private final FreeC pull$5$$anonfun$1(Chunk.Bytes bytesChunk$3, int bytesRemaining$1) {
        return Pull$.MODULE$.output(Chunk$Bytes$.MODULE$.apply(bytesChunk$3.values(), bytesChunk$3.offset() + bytesChunk$3.length() - bytesRemaining$1, bytesRemaining$1));
    }

    private final Object pull$6$$anonfun$adapted$1(Chunk.Bytes bytesChunk$4, int bytesRemaining$2) {
        return new Pull(this.pull$5$$anonfun$1(bytesChunk$4, bytesRemaining$2));
    }

    private final FreeC pull$7$$anonfun$2(Inflater inflater$28, Option crc32$45, byte[] inflatedBuffer$11, Chunk.Bytes bytesChunk$5) {
        return this.pull$2(inflater$28, crc32$45, inflatedBuffer$11, bytesChunk$5);
    }

    private final Object pull$8$$anonfun$adapted$2(Inflater inflater$29, Option crc32$46, byte[] inflatedBuffer$12, Chunk.Bytes bytesChunk$6) {
        return new Pull(this.pull$7$$anonfun$2(inflater$29, crc32$46, inflatedBuffer$12, bytesChunk$6));
    }

    private final FreeC pull$2(Inflater inflater$7, Option crc32$11, byte[] inflatedBuffer$5, Chunk.Bytes bytesChunk$2) {
        FreeC<Object, Object, Object> freeC;
        int n = this.runInflate$2(inflater$7, crc32$11, inflatedBuffer$5);
        int inflatedBytes = n;
        if (inflatedBytes <= -2) {
            int n2 = inflater$7.getRemaining();
            int bytesRemaining = n2;
            freeC = bytesRemaining > 0 ? Pull$.MODULE$.output(Chunk$Bytes$.MODULE$.apply(bytesChunk$2.values(), bytesChunk$2.offset() + bytesChunk$2.length() - bytesRemaining, bytesRemaining)) : Pull$.MODULE$.done();
        } else {
            int inflatedBytes2 = n;
            if (inflatedBytes2 == -1) {
                freeC = Pull$.MODULE$.done();
            } else {
                int inflatedBytes3 = n;
                if (inflatedBytes3 < inflatedBuffer$5.length) {
                    if (inflater$7.finished()) {
                        int n3 = inflater$7.getRemaining();
                        int bytesRemaining = n3;
                        if (bytesRemaining > 0) {
                            FreeC freeC2 = Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$5, inflatedBytes3));
                            freeC = Pull$.MODULE$.$greater$greater$extension(freeC2, () -> this.pull$6$$anonfun$adapted$1(bytesChunk$2, bytesRemaining));
                        } else {
                            freeC = Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$5, inflatedBytes3));
                        }
                    } else {
                        freeC = Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$5, inflatedBytes3));
                    }
                } else {
                    int inflatedBytes4 = n;
                    FreeC freeC3 = Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$5, inflatedBytes4));
                    freeC = Pull$.MODULE$.$greater$greater$extension(freeC3, () -> this.pull$8$$anonfun$adapted$2(inflater$7, crc32$11, inflatedBuffer$5, bytesChunk$2));
                }
            }
        }
        return freeC;
    }

    private final FreeC _inflate_stream$$anonfun$1$$anonfun$1$$anonfun$1(compression.InflateParams inflateParams$10, Inflater inflater$10, Option crc32$14, byte[] inflatedBuffer$8, Sync SyncF$12, FreeC deflatedStream$2) {
        Object object = this._inflate_stream(inflateParams$10, inflater$10, (Option<CRC32>)crc32$14, inflatedBuffer$8, SyncF$12).apply(new Stream(deflatedStream$2));
        return object == null ? null : ((Pull)object).fs2$Pull$$free();
    }

    private final Object _inflate_stream$$anonfun$2$$anonfun$2$$anonfun$adapted$1(compression.InflateParams inflateParams$20, Inflater inflater$30, Option crc32$47, byte[] inflatedBuffer$13, Sync SyncF$42, FreeC deflatedStream$4) {
        return new Pull(this._inflate_stream$$anonfun$1$$anonfun$1$$anonfun$1(inflateParams$20, inflater$30, crc32$47, inflatedBuffer$13, SyncF$42, deflatedStream$4));
    }

    private final /* synthetic */ FreeC _inflate_stream$$anonfun$3$$anonfun$3(compression.InflateParams inflateParams$9, Inflater inflater$9, Option crc32$13, byte[] inflatedBuffer$7, Sync SyncF$11, Option x$1) {
        FreeC<Object, Object, Object> freeC;
        Tuple2 tuple2;
        Option option = x$1;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Chunk deflatedChunk = (Chunk)tuple2._1();
            FreeC deflatedStream = tuple2._2() == null ? null : ((Stream)tuple2._2()).fs2$Stream$$free();
            FreeC freeC2 = this._inflate_chunk(inflateParams$9, inflater$9, (Option<CRC32>)crc32$13, deflatedChunk, inflatedBuffer$7);
            freeC = Pull$.MODULE$.$greater$greater$extension(freeC2, () -> this._inflate_stream$$anonfun$2$$anonfun$2$$anonfun$adapted$1(inflateParams$9, inflater$9, crc32$13, inflatedBuffer$7, SyncF$11, deflatedStream));
        } else if (None$.MODULE$.equals(option)) {
            freeC = !inflater$9.finished() ? Pull$.MODULE$.raiseError(new DataFormatException("Insufficient data"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$11)) : Pull$.MODULE$.done();
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    private final Object _inflate_stream$$anonfun$4$$anonfun$adapted$1(compression.InflateParams inflateParams$21, Inflater inflater$31, Option crc32$48, byte[] inflatedBuffer$14, Sync SyncF$43, Option x$1) {
        return new Pull(this._inflate_stream$$anonfun$3$$anonfun$3(inflateParams$21, inflater$31, crc32$48, inflatedBuffer$14, SyncF$43, x$1));
    }

    private final /* synthetic */ FreeC _inflate_stream$$anonfun$5(compression.InflateParams inflateParams$8, Inflater inflater$8, Option crc32$12, byte[] inflatedBuffer$6, Sync SyncF$10, FreeC _$14) {
        FreeC freeC = Stream$.MODULE$.InvariantOps(_$14);
        FreeC freeC2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(freeC)).fs2$Stream$ToPull$$free();
        FreeC freeC3 = new Pull(Stream$ToPull$.MODULE$.unconsNonEmpty$extension(freeC2)).fs2$Pull$$free();
        return Pull$.MODULE$.flatMap$extension(freeC3, arg_0 -> this._inflate_stream$$anonfun$4$$anonfun$adapted$1(inflateParams$8, inflater$8, crc32$12, inflatedBuffer$6, SyncF$10, arg_0));
    }

    private final Object _inflate_stream$$anonfun$adapted$1(compression.InflateParams inflateParams$22, Inflater inflater$32, Option crc32$49, byte[] inflatedBuffer$15, Sync SyncF$44, Object v1) {
        return new Pull(this._inflate_stream$$anonfun$5(inflateParams$22, inflater$32, crc32$49, inflatedBuffer$15, SyncF$44, v1 == null ? null : ((Stream)v1).fs2$Stream$$free()));
    }

    private final /* synthetic */ compression.DeflateParams.Level gzip$$anonfun$3(int level) {
        return compression$DeflateParams$Level$.MODULE$.apply(level);
    }

    private final compression.DeflateParams.Level gzip$$anonfun$adapted$1(Object level) {
        return this.gzip$$anonfun$3(BoxesRunTime.unboxToInt((Object)level));
    }

    private final compression$DeflateParams$Level$DEFAULT$ gzip$$anonfun$1() {
        return compression$DeflateParams$Level$DEFAULT$.MODULE$;
    }

    private final /* synthetic */ compression.DeflateParams.Strategy gzip$$anonfun$4(int strategy) {
        return compression$DeflateParams$Strategy$.MODULE$.apply(strategy);
    }

    private final compression.DeflateParams.Strategy gzip$$anonfun$adapted$2(Object strategy) {
        return this.gzip$$anonfun$4(BoxesRunTime.unboxToInt((Object)strategy));
    }

    private final compression$DeflateParams$Strategy$DEFAULT$ gzip$$anonfun$2() {
        return compression$DeflateParams$Strategy$DEFAULT$.MODULE$;
    }

    private final Tuple2 gzip$$anonfun$5$$anonfun$1(compression.DeflateParams params$1) {
        Deflater deflater = new Deflater(params$1.level().juzDeflaterLevel(), true);
        deflater.setStrategy(params$1.strategy().juzDeflaterStrategy());
        return Tuple2$.MODULE$.apply((Object)deflater, (Object)new CRC32());
    }

    private final void gzip$$anonfun$6$$anonfun$2$$anonfun$1(Deflater deflater$10) {
        deflater$10.end();
    }

    private final FreeC gzip$$anonfun$8$$anonfun$4$$anonfun$1(FreeC stream$4, compression.DeflateParams params$3, Deflater deflater$11, CRC32 crc32$15) {
        Object object = this._deflate(params$3, deflater$11, (Option<CRC32>)Some$.MODULE$.apply((Object)crc32$15)).apply(new Stream(stream$4));
        return object == null ? null : ((Stream)object).fs2$Stream$$free();
    }

    private final Object $anonfun$adapted$4(FreeC stream$8, compression.DeflateParams params$6, Deflater deflater$20, CRC32 crc32$50) {
        return new Stream(this.gzip$$anonfun$8$$anonfun$4$$anonfun$1(stream$8, params$6, deflater$20, crc32$50));
    }

    private final FreeC gzip$$anonfun$9$$anonfun$5$$anonfun$2(Deflater deflater$12, CRC32 crc32$16) {
        return this._gzip_trailer(deflater$12, crc32$16);
    }

    private final Object gzip$$anonfun$10$$anonfun$6$$anonfun$adapted$1(Deflater deflater$21, CRC32 crc32$51) {
        return new Stream(this.gzip$$anonfun$9$$anonfun$5$$anonfun$2(deflater$21, crc32$51));
    }

    private final /* synthetic */ FreeC gzip$$anonfun$11$$anonfun$7(Option fileName$2, Option modificationTime$3, Option comment$2, FreeC stream$3, compression.DeflateParams params$2, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Deflater deflater = (Deflater)tuple2._1();
        CRC32 crc32 = (CRC32)tuple2._2();
        FreeC freeC = this._gzip_header((Option<String>)fileName$2, (Option<Instant>)modificationTime$3, (Option<String>)comment$2, params$2.level().juzDeflaterLevel());
        FreeC freeC2 = Stream$.MODULE$.$plus$plus$extension(freeC, () -> this.$anonfun$adapted$4(stream$3, params$2, deflater, crc32));
        return Stream$.MODULE$.$plus$plus$extension(freeC2, () -> this.gzip$$anonfun$10$$anonfun$6$$anonfun$adapted$1(deflater, crc32));
    }

    private final Object gzip$$anonfun$12$$anonfun$adapted$1(Option fileName$4, Option modificationTime$4, Option comment$3, FreeC stream$9, compression.DeflateParams params$7, Tuple2 x$1) {
        return new Stream(this.gzip$$anonfun$11$$anonfun$7(fileName$4, modificationTime$4, comment$3, stream$9, params$7, x$1));
    }

    private final /* synthetic */ FreeC gzip$$anonfun$13(Option fileName$1, Option modificationTime$2, Option comment$1, compression.DeflateParams deflateParams$11, Sync SyncF$13, FreeC stream) {
        FreeC<Object, Object, BoxedUnit> freeC;
        compression.DeflateParams deflateParams = deflateParams$11;
        if (deflateParams != null) {
            compression.DeflateParams deflateParams2;
            compression.DeflateParams params = deflateParams2 = deflateParams;
            compression.ZLibParams.Header header = params.header();
            compression$ZLibParams$Header$GZIP$ compression$ZLibParams$Header$GZIP$2 = compression$ZLibParams$Header$GZIP$.MODULE$;
            if (!(header != null ? !header.equals(compression$ZLibParams$Header$GZIP$2) : compression$ZLibParams$Header$GZIP$2 != null)) {
                FreeC freeC2 = Stream$.MODULE$.bracket(SyncF$13.delay(() -> this.gzip$$anonfun$5$$anonfun$1(params)), (JFunction1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Deflater deflater = (Deflater)tuple2._1();
                    return SyncF$13.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.gzip$$anonfun$6$$anonfun$2$$anonfun$1(deflater)));
                });
                freeC = Stream$.MODULE$.flatMap$extension(freeC2, arg_0 -> this.gzip$$anonfun$12$$anonfun$adapted$1(fileName$1, modificationTime$2, comment$1, stream, params, arg_0));
            } else {
                compression.DeflateParams params2 = deflateParams2;
                freeC = Stream$.MODULE$.raiseError(new ZipException("" + compression$ZLibParams$Header$GZIP$.MODULE$ + " header type required, not " + params2.header() + "."), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$13));
            }
        } else {
            throw new MatchError((Object)deflateParams);
        }
        return freeC;
    }

    private final Object gzip$$anonfun$adapted$3(Option fileName$5, Option modificationTime$5, Option comment$4, compression.DeflateParams deflateParams$21, Sync SyncF$45, Object v1) {
        return new Stream(this.gzip$$anonfun$13(fileName$5, modificationTime$5, comment$4, deflateParams$21, SyncF$45, v1 == null ? null : ((Stream)v1).fs2$Stream$$free()));
    }

    private final long $anonfun$2() {
        return 0L;
    }

    private final byte $anonfun$4() {
        return zeroByte;
    }

    private final byte $anonfun$6() {
        return zeroByte;
    }

    private final FreeC _gzip_header$$anonfun$1$$anonfun$1$$anonfun$1() {
        return Stream$.MODULE$.emit(BoxesRunTime.boxToByte((byte)zeroByte));
    }

    private final Object _gzip_header$$anonfun$2$$anonfun$2$$anonfun$adapted$1() {
        return new Stream(this._gzip_header$$anonfun$1$$anonfun$1$$anonfun$1());
    }

    private final /* synthetic */ FreeC _gzip_header$$anonfun$3$$anonfun$3(byte[] bytes) {
        FreeC freeC = Stream$.MODULE$.chunk(this.moveAsChunkBytes(bytes));
        return Stream$.MODULE$.$plus$plus$extension(freeC, this::_gzip_header$$anonfun$2$$anonfun$2$$anonfun$adapted$1);
    }

    private final Object _gzip_header$$anonfun$4$$anonfun$adapted$1(byte[] bytes) {
        return new Stream(this._gzip_header$$anonfun$3$$anonfun$3(bytes));
    }

    private final FreeC _gzip_header$$anonfun$5$$anonfun$4() {
        return Stream$.MODULE$.empty();
    }

    private final Object _gzip_header$$anonfun$6$$anonfun$adapted$2() {
        return new Stream(this._gzip_header$$anonfun$5$$anonfun$4());
    }

    private final FreeC _gzip_header$$anonfun$7(Option fileNameEncoded$1) {
        Object object = fileNameEncoded$1.map((Function1)((JFunction1 & Serializable)this::_gzip_header$$anonfun$4$$anonfun$adapted$1)).getOrElse((Function0)((JFunction0 & Serializable)this::_gzip_header$$anonfun$6$$anonfun$adapted$2));
        return object == null ? null : ((Stream)object).fs2$Stream$$free();
    }

    private final Object $anonfun$adapted$1(Option fileNameEncoded$2) {
        return new Stream(this._gzip_header$$anonfun$7(fileNameEncoded$2));
    }

    private final FreeC _gzip_header$$anonfun$8$$anonfun$1$$anonfun$1() {
        return Stream$.MODULE$.emit(BoxesRunTime.boxToByte((byte)zeroByte));
    }

    private final Object _gzip_header$$anonfun$9$$anonfun$2$$anonfun$adapted$1() {
        return new Stream(this._gzip_header$$anonfun$8$$anonfun$1$$anonfun$1());
    }

    private final /* synthetic */ FreeC _gzip_header$$anonfun$10$$anonfun$3(byte[] bytes) {
        FreeC freeC = Stream$.MODULE$.chunk(this.moveAsChunkBytes(bytes));
        return Stream$.MODULE$.$plus$plus$extension(freeC, this::_gzip_header$$anonfun$9$$anonfun$2$$anonfun$adapted$1);
    }

    private final Object _gzip_header$$anonfun$11$$anonfun$adapted$1(byte[] bytes) {
        return new Stream(this._gzip_header$$anonfun$10$$anonfun$3(bytes));
    }

    private final FreeC _gzip_header$$anonfun$12$$anonfun$4() {
        return Stream$.MODULE$.empty();
    }

    private final Object _gzip_header$$anonfun$13$$anonfun$adapted$2() {
        return new Stream(this._gzip_header$$anonfun$12$$anonfun$4());
    }

    private final FreeC _gzip_header$$anonfun$14(Option commentEncoded$1) {
        Object object = commentEncoded$1.map((Function1)((JFunction1 & Serializable)this::_gzip_header$$anonfun$11$$anonfun$adapted$1)).getOrElse((Function0)((JFunction0 & Serializable)this::_gzip_header$$anonfun$13$$anonfun$adapted$2));
        return object == null ? null : ((Stream)object).fs2$Stream$$free();
    }

    private final Object $anonfun$adapted$2(Option commentEncoded$2) {
        return new Stream(this._gzip_header$$anonfun$14(commentEncoded$2));
    }

    private final FreeC _gzip_header$$anonfun$15(byte[] crc16$1) {
        return Stream$.MODULE$.chunk(this.moveAsChunkBytes(crc16$1));
    }

    private final Object _gzip_header$$anonfun$adapted$1(byte[] crc16$2) {
        return new Stream(this._gzip_header$$anonfun$15(crc16$2));
    }

    private final Tuple3 gunzip$$anonfun$1$$anonfun$1() {
        return Tuple3$.MODULE$.apply((Object)new Inflater(true), (Object)new CRC32(), (Object)new CRC32());
    }

    private final void gunzip$$anonfun$2$$anonfun$2$$anonfun$1(Inflater inflater$11) {
        inflater$11.end();
    }

    private final /* synthetic */ FreeC gunzip$$anonfun$4$$anonfun$4$$anonfun$1(Sync SyncF$18, compression.InflateParams params$5, Inflater inflater$12, CRC32 headerCrc32$1, CRC32 contentCrc32$1, Option x$1) {
        FreeC freeC;
        Tuple2 tuple2;
        Option option = x$1;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Chunk mandatoryHeaderChunk = (Chunk)tuple2._1();
            FreeC streamAfterMandatoryHeader = tuple2._2() == null ? null : ((Stream)tuple2._2()).fs2$Stream$$free();
            freeC = this._gunzip_matchMandatoryHeader(params$5, mandatoryHeaderChunk, streamAfterMandatoryHeader, headerCrc32$1, contentCrc32$1, inflater$12, SyncF$18);
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.output1(compression$GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$18)), (Option<Instant>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$2(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$3(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$4()));
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    private final Object $anonfun$adapted$5(Sync SyncF$46, compression.InflateParams params$8, Inflater inflater$33, CRC32 headerCrc32$4, CRC32 contentCrc32$4, Option x$1) {
        return new Pull(this.gunzip$$anonfun$4$$anonfun$4$$anonfun$1(SyncF$46, params$8, inflater$33, headerCrc32$4, contentCrc32$4, x$1));
    }

    private final /* synthetic */ FreeC gunzip$$anonfun$5$$anonfun$5(Sync SyncF$17, FreeC stream$5, compression.InflateParams params$4, Tuple3 x$1) {
        Tuple3 tuple3 = x$1;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Inflater inflater = (Inflater)tuple3._1();
        CRC32 headerCrc32 = (CRC32)tuple3._2();
        CRC32 contentCrc32 = (CRC32)tuple3._3();
        FreeC freeC = Stream$.MODULE$.InvariantOps(stream$5);
        FreeC freeC2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(freeC)).fs2$Stream$ToPull$$free();
        FreeC freeC3 = Stream$ToPull$.MODULE$.unconsN$extension(freeC2, gzipHeaderBytes, Stream$ToPull$.MODULE$.unconsN$default$2$extension(freeC2));
        FreeC freeC4 = Pull$.MODULE$.flatMap$extension(freeC3, arg_0 -> this.$anonfun$adapted$5(SyncF$17, params$4, inflater, headerCrc32, contentCrc32, arg_0));
        return Pull$.MODULE$.stream$extension(freeC4, $less$colon$less$.MODULE$.refl());
    }

    private final Object gunzip$$anonfun$6$$anonfun$adapted$1(Sync SyncF$47, FreeC stream$10, compression.InflateParams params$9, Tuple3 x$1) {
        return new Stream(this.gunzip$$anonfun$5$$anonfun$5(SyncF$47, stream$10, params$9, x$1));
    }

    private final /* synthetic */ FreeC gunzip$$anonfun$7(compression.InflateParams inflateParams$11, Sync SyncF$15, FreeC stream) {
        FreeC<Object, Object, BoxedUnit> freeC;
        compression.InflateParams inflateParams = inflateParams$11;
        if (inflateParams != null) {
            compression.InflateParams inflateParams2;
            compression.InflateParams params = inflateParams2 = inflateParams;
            compression.ZLibParams.Header header = params.header();
            compression$ZLibParams$Header$GZIP$ compression$ZLibParams$Header$GZIP$2 = compression$ZLibParams$Header$GZIP$.MODULE$;
            if (!(header != null ? !header.equals(compression$ZLibParams$Header$GZIP$2) : compression$ZLibParams$Header$GZIP$2 != null)) {
                FreeC freeC2 = Stream$.MODULE$.bracket(SyncF$15.delay(this::gunzip$$anonfun$1$$anonfun$1), (JFunction1 & Serializable)x$1 -> {
                    Tuple3 tuple3 = x$1;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    Inflater inflater = (Inflater)tuple3._1();
                    return SyncF$15.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.gunzip$$anonfun$2$$anonfun$2$$anonfun$1(inflater)));
                });
                freeC = Stream$.MODULE$.flatMap$extension(freeC2, arg_0 -> this.gunzip$$anonfun$6$$anonfun$adapted$1(SyncF$15, stream, params, arg_0));
            } else {
                compression.InflateParams params2 = inflateParams2;
                freeC = Stream$.MODULE$.raiseError(new ZipException("" + compression$ZLibParams$Header$GZIP$.MODULE$ + " header type required, not " + params2.header() + "."), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$15));
            }
        } else {
            throw new MatchError((Object)inflateParams);
        }
        return freeC;
    }

    private final Object gunzip$$anonfun$adapted$1(compression.InflateParams inflateParams$23, Sync SyncF$48, Object v1) {
        return new Stream(this.gunzip$$anonfun$7(inflateParams$23, SyncF$48, v1 == null ? null : ((Stream)v1).fs2$Stream$$free()));
    }

    private final /* synthetic */ FreeC _gunzip_matchMandatoryHeader$$anonfun$1(Sync SyncF$19, Option x$1) {
        FreeC freeC;
        Tuple2 tuple2;
        Option option = x$1;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            compression.GunzipResult gunzipResult = (compression.GunzipResult)tuple2._1();
            freeC = Pull$.MODULE$.output1(gunzipResult);
        } else if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.output1(compression$GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$19)), (Option<Instant>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$2(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$3(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$4()));
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    private final Object _gunzip_matchMandatoryHeader$$anonfun$adapted$1(Sync SyncF$49, Option x$1) {
        return new Pull(this._gunzip_matchMandatoryHeader$$anonfun$1(SyncF$49, x$1));
    }

    private final /* synthetic */ FreeC _gunzip_readOptionalHeader$$anonfun$1$$anonfun$1(compression.InflateParams inflateParams$13, byte flags$2, CRC32 headerCrc32$3, CRC32 contentCrc32$3, long secondsSince197001010000$2, Inflater inflater$14, Sync SyncF$21, Option fileName$3, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option comment = (Option)tuple2._1();
        FreeC streamAfterComment = tuple2._2() == null ? null : ((Stream)tuple2._2()).fs2$Stream$$free();
        None$ none$ = secondsSince197001010000$2 != 0L ? Some$.MODULE$.apply((Object)Instant.ofEpochSecond(secondsSince197001010000$2)) : None$.MODULE$;
        FreeC freeC = Stream$.MODULE$.through$extension(streamAfterComment, this._gunzip_validateHeader((byte)(flags$2 & compression$gzipFlag$.MODULE$.FHCRC()) == compression$gzipFlag$.MODULE$.FHCRC(), headerCrc32$3, SyncF$21));
        FreeC freeC2 = Stream$.MODULE$.through$extension(freeC, this._inflate(inflateParams$13, inflater$14, (Option<CRC32>)Some$.MODULE$.apply((Object)contentCrc32$3), SyncF$21));
        FreeC freeC3 = Stream$.MODULE$.through$extension(freeC2, this._gunzip_validateTrailer(contentCrc32$3, inflater$14, SyncF$21));
        return Stream$.MODULE$.emit(compression$GunzipResult$.MODULE$.apply(freeC3, (Option<Instant>)none$, (Option<String>)fileName$3, (Option<String>)comment));
    }

    private final Object _gunzip_readOptionalHeader$$anonfun$2$$anonfun$adapted$1(compression.InflateParams inflateParams$24, byte flags$3, CRC32 headerCrc32$5, CRC32 contentCrc32$5, long secondsSince197001010000$3, Inflater inflater$34, Sync SyncF$50, Option fileName$6, Tuple2 x$1) {
        return new Stream(this._gunzip_readOptionalHeader$$anonfun$1$$anonfun$1(inflateParams$24, flags$3, headerCrc32$5, contentCrc32$5, secondsSince197001010000$3, inflater$34, SyncF$50, fileName$6, x$1));
    }

    private final /* synthetic */ FreeC _gunzip_readOptionalHeader$$anonfun$3(compression.InflateParams inflateParams$12, byte flags$1, CRC32 headerCrc32$2, CRC32 contentCrc32$2, long secondsSince197001010000$1, Inflater inflater$13, Sync SyncF$20, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option fileName = (Option)tuple2._1();
        FreeC streamAfterFileName = tuple2._2() == null ? null : ((Stream)tuple2._2()).fs2$Stream$$free();
        FreeC freeC = Stream$.MODULE$.through$extension(streamAfterFileName, this._gunzip_readOptionalStringField(compression$gzipFlag$.MODULE$.fcomment(flags$1), headerCrc32$2, "file comment", fileCommentBytesSoftLimit, SyncF$20));
        return Stream$.MODULE$.flatMap$extension(freeC, arg_0 -> this._gunzip_readOptionalHeader$$anonfun$2$$anonfun$adapted$1(inflateParams$12, flags$1, headerCrc32$2, contentCrc32$2, secondsSince197001010000$1, inflater$13, SyncF$20, fileName, arg_0));
    }

    private final Object _gunzip_readOptionalHeader$$anonfun$adapted$1(compression.InflateParams inflateParams$25, byte flags$4, CRC32 headerCrc32$6, CRC32 contentCrc32$6, long secondsSince197001010000$4, Inflater inflater$35, Sync SyncF$51, Tuple2 x$1) {
        return new Stream(this._gunzip_readOptionalHeader$$anonfun$3(inflateParams$25, flags$4, headerCrc32$6, contentCrc32$6, secondsSince197001010000$4, inflater$35, SyncF$51, x$1));
    }

    private final /* synthetic */ FreeC _gunzip_skipOptionalExtraField$$anonfun$1$$anonfun$1$$anonfun$1(CRC32 crc32$21, Sync Sync$3, Option x$1) {
        Pull pull;
        Tuple2 tuple2;
        Option option = x$1;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Chunk optionalExtraFieldChunk = (Chunk)tuple2._1();
            FreeC streamAfterOptionalExtraField = tuple2._2() == null ? null : ((Stream)tuple2._2()).fs2$Stream$$free();
            Chunk.Bytes fieldBytes = optionalExtraFieldChunk.toBytes($less$colon$less$.MODULE$.refl());
            crc32$21.update(fieldBytes.values(), fieldBytes.offset(), fieldBytes.length());
            pull = new Pull(Pull$.MODULE$.output1(new Stream(streamAfterOptionalExtraField)));
        } else if (None$.MODULE$.equals(option)) {
            pull = new Pull(Pull$.MODULE$.raiseError(new ZipException("Failed to read optional extra field header"), RaiseThrowable$.MODULE$.fromApplicativeError(Sync$3)));
        } else {
            throw new MatchError((Object)option);
        }
        Pull pull2 = pull;
        return pull2 == null ? null : pull2.fs2$Pull$$free();
    }

    private final Object _gunzip_skipOptionalExtraField$$anonfun$2$$anonfun$2$$anonfun$adapted$1(CRC32 crc32$52, Sync Sync$4, Option x$1) {
        return new Pull(this._gunzip_skipOptionalExtraField$$anonfun$1$$anonfun$1$$anonfun$1(crc32$52, Sync$4, x$1));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final /* synthetic */ FreeC _gunzip_skipOptionalExtraField$$anonfun$3$$anonfun$3(CRC32 crc32$20, Sync Sync$2, Option x$1) {
        FreeC<Object, Object, Object> freeC;
        Tuple2 tuple2;
        Option option = x$1;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Chunk optionalExtraFieldLengthChunk = (Chunk)tuple2._1();
            FreeC streamAfterOptionalExtraFieldLength = tuple2._2() == null ? null : ((Stream)tuple2._2()).fs2$Stream$$free();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)optionalExtraFieldLengthChunk.size()), (Object)optionalExtraFieldLengthChunk.toBytes($less$colon$less$.MODULE$.refl()).values());
            if (tuple22 != null) {
                Object object;
                byte[] byArray = (byte[])tuple22._2();
                if (gzipOptionalExtraFieldLengthBytes == BoxesRunTime.unboxToInt((Object)tuple22._1()) && byArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)byArray), 2) == 0) {
                    byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0));
                    byte by2 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1));
                    byte firstByte = by;
                    byte secondByte = by2;
                    byte[] lengthBytes = byArray;
                    crc32$20.update(lengthBytes);
                    int optionalExtraFieldLength = this.unsignedToInt(firstByte, secondByte);
                    FreeC freeC2 = Stream$.MODULE$.InvariantOps(streamAfterOptionalExtraFieldLength);
                    FreeC freeC3 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(freeC2)).fs2$Stream$ToPull$$free();
                    FreeC freeC4 = Stream$ToPull$.MODULE$.unconsN$extension(freeC3, optionalExtraFieldLength, Stream$ToPull$.MODULE$.unconsN$default$2$extension(freeC3));
                    freeC = Pull$.MODULE$.flatMap$extension(freeC4, arg_0 -> this._gunzip_skipOptionalExtraField$$anonfun$2$$anonfun$2$$anonfun$adapted$1(crc32$20, Sync$2, arg_0));
                    return freeC;
                }
            }
            freeC = Pull$.MODULE$.raiseError(new ZipException("Failed to read optional extra field header length"), RaiseThrowable$.MODULE$.fromApplicativeError(Sync$2));
            return freeC;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
        freeC = Pull$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(Sync$2));
        return freeC;
    }

    private final Object $anonfun$adapted$6(CRC32 crc32$53, Sync Sync$5, Option x$1) {
        return new Pull(this._gunzip_skipOptionalExtraField$$anonfun$3$$anonfun$3(crc32$53, Sync$5, x$1));
    }

    private final /* synthetic */ FreeC _gunzip_skipOptionalExtraField$$anonfun$4(boolean isPresent$1, CRC32 crc32$19, Sync Sync$1, FreeC stream) {
        FreeC freeC;
        if (isPresent$1) {
            FreeC freeC2 = Stream$.MODULE$.InvariantOps(stream);
            FreeC freeC3 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(freeC2)).fs2$Stream$ToPull$$free();
            FreeC freeC4 = Stream$ToPull$.MODULE$.unconsN$extension(freeC3, gzipOptionalExtraFieldLengthBytes, Stream$ToPull$.MODULE$.unconsN$default$2$extension(freeC3));
            FreeC freeC5 = Pull$.MODULE$.flatMap$extension(freeC4, arg_0 -> this.$anonfun$adapted$6(crc32$19, Sync$1, arg_0));
            FreeC freeC6 = Pull$.MODULE$.stream$extension(freeC5, $less$colon$less$.MODULE$.refl());
            freeC = Stream$.MODULE$.flatten$extension(freeC6, $less$colon$less$.MODULE$.refl());
        } else {
            freeC = stream;
        }
        return freeC;
    }

    private final Object _gunzip_skipOptionalExtraField$$anonfun$adapted$1(boolean isPresent$4, CRC32 crc32$54, Sync Sync$6, Object v1) {
        return new Stream(this._gunzip_skipOptionalExtraField$$anonfun$4(isPresent$4, crc32$54, Sync$6, v1 == null ? null : ((Stream)v1).fs2$Stream$$free()));
    }

    private final /* synthetic */ boolean _gunzip_readOptionalStringField$$anonfun$1$$anonfun$1(byte _$29) {
        return _$29 == zeroByte;
    }

    private final boolean $anonfun$adapted$7(Object _$29) {
        return this._gunzip_readOptionalStringField$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToByte((Object)_$29));
    }

    private final /* synthetic */ boolean _gunzip_readOptionalStringField$$anonfun$2$$anonfun$2$$anonfun$1(CRC32 crc32$24, byte by) {
        crc32$24.update(by);
        return by != zeroByte;
    }

    private final boolean $anonfun$adapted$8(CRC32 crc32$55, Object object) {
        return this._gunzip_readOptionalStringField$$anonfun$2$$anonfun$2$$anonfun$1(crc32$55, BoxesRunTime.unboxToByte((Object)object));
    }

    private final /* synthetic */ FreeC _gunzip_readOptionalStringField$$anonfun$3$$anonfun$3(CRC32 crc32$23, String fieldName$2, Sync SyncF$23, Option x$1) {
        Pull pull;
        Tuple2 tuple2;
        Option option = x$1;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Some some;
            FreeC rest;
            Chunk chunk = (Chunk)tuple2._1();
            FreeC freeC = rest = tuple2._2() == null ? null : ((Stream)tuple2._2()).fs2$Stream$$free();
            if (chunk.isEmpty()) {
                some = Some$.MODULE$.apply((Object)"");
            } else {
                Chunk.Bytes bytesChunk = chunk.toBytes($less$colon$less$.MODULE$.refl());
                crc32$23.update(bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
                some = Some$.MODULE$.apply((Object)new String(bytesChunk.values(), bytesChunk.offset(), bytesChunk.length(), StandardCharsets.ISO_8859_1));
            }
            FreeC freeC2 = Stream$.MODULE$.dropWhile$extension(rest, arg_0 -> this.$anonfun$adapted$8(crc32$23, arg_0));
            Pull pull2 = new Pull(Pull$.MODULE$.output1(Tuple2$.MODULE$.apply((Object)some, new Stream(Stream$.MODULE$.drop$extension(freeC2, 1L)))));
            pull = pull2;
        } else if (None$.MODULE$.equals(option)) {
            pull = new Pull(Pull$.MODULE$.output1(Tuple2$.MODULE$.apply((Object)Option$.MODULE$.empty(), new Stream(Stream$.MODULE$.raiseError(new ZipException("Failed to read " + fieldName$2 + " field"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$23))))));
        } else {
            throw new MatchError((Object)option);
        }
        Pull pull3 = pull;
        return pull3 == null ? null : pull3.fs2$Pull$$free();
    }

    private final Object $anonfun$adapted$9(CRC32 crc32$56, String fieldName$3, Sync SyncF$52, Option x$1) {
        return new Pull(this._gunzip_readOptionalStringField$$anonfun$3$$anonfun$3(crc32$56, fieldName$3, SyncF$52, x$1));
    }

    private final /* synthetic */ FreeC _gunzip_readOptionalStringField$$anonfun$4(boolean isPresent$2, CRC32 crc32$22, String fieldName$1, int fieldBytesSoftLimit$1, Sync SyncF$22, FreeC stream) {
        FreeC<Object, Object, BoxedUnit> freeC;
        if (isPresent$2) {
            Object object = this.unconsUntil((Function1)((JFunction1 & Serializable)this::$anonfun$adapted$7), fieldBytesSoftLimit$1).apply(new Stream(stream));
            FreeC freeC2 = object == null ? null : ((Pull)object).fs2$Pull$$free();
            FreeC freeC3 = Pull$.MODULE$.flatMap$extension(freeC2, arg_0 -> this.$anonfun$adapted$9(crc32$22, fieldName$1, SyncF$22, arg_0));
            freeC = Pull$.MODULE$.stream$extension(freeC3, $less$colon$less$.MODULE$.refl());
        } else {
            freeC = Stream$.MODULE$.emit(Tuple2$.MODULE$.apply((Object)Option$.MODULE$.empty(), new Stream(stream)));
        }
        return freeC;
    }

    private final Object _gunzip_readOptionalStringField$$anonfun$adapted$1(boolean isPresent$5, CRC32 crc32$57, String fieldName$4, int fieldBytesSoftLimit$2, Sync SyncF$53, Object v1) {
        return new Stream(this._gunzip_readOptionalStringField$$anonfun$4(isPresent$5, crc32$57, fieldName$4, fieldBytesSoftLimit$2, SyncF$53, v1 == null ? null : ((Stream)v1).fs2$Stream$$free()));
    }

    private final /* synthetic */ FreeC _gunzip_validateHeader$$anonfun$1$$anonfun$1(CRC32 crc32$26, Sync SyncF$25, Option x$1) {
        Pull pull;
        Tuple2 tuple2;
        Option option = x$1;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            long actualHeaderCrc16;
            Chunk headerCrcChunk = (Chunk)tuple2._1();
            FreeC streamAfterHeaderCrc = tuple2._2() == null ? null : ((Stream)tuple2._2()).fs2$Stream$$free();
            int expectedHeaderCrc16 = this.unsignedToInt(BoxesRunTime.unboxToByte(headerCrcChunk.apply(0)), BoxesRunTime.unboxToByte(headerCrcChunk.apply(1)));
            pull = (long)expectedHeaderCrc16 != (actualHeaderCrc16 = crc32$26.getValue() & 0xFFFFL) ? new Pull(Pull$.MODULE$.raiseError(new ZipException("Header failed CRC validation"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$25))) : new Pull(Pull$.MODULE$.output1(new Stream(streamAfterHeaderCrc)));
        } else if (None$.MODULE$.equals(option)) {
            pull = new Pull(Pull$.MODULE$.raiseError(new ZipException("Failed to read header CRC"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$25)));
        } else {
            throw new MatchError((Object)option);
        }
        Pull pull2 = pull;
        return pull2 == null ? null : pull2.fs2$Pull$$free();
    }

    private final Object $anonfun$adapted$10(CRC32 crc32$58, Sync SyncF$54, Option x$1) {
        return new Pull(this._gunzip_validateHeader$$anonfun$1$$anonfun$1(crc32$58, SyncF$54, x$1));
    }

    private final /* synthetic */ FreeC _gunzip_validateHeader$$anonfun$2(boolean isPresent$3, CRC32 crc32$25, Sync SyncF$24, FreeC stream) {
        FreeC freeC;
        if (isPresent$3) {
            FreeC freeC2 = Stream$.MODULE$.InvariantOps(stream);
            FreeC freeC3 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(freeC2)).fs2$Stream$ToPull$$free();
            FreeC freeC4 = Stream$ToPull$.MODULE$.unconsN$extension(freeC3, gzipHeaderCrcBytes, Stream$ToPull$.MODULE$.unconsN$default$2$extension(freeC3));
            FreeC freeC5 = Pull$.MODULE$.flatMap$extension(freeC4, arg_0 -> this.$anonfun$adapted$10(crc32$25, SyncF$24, arg_0));
            FreeC freeC6 = Pull$.MODULE$.stream$extension(freeC5, $less$colon$less$.MODULE$.refl());
            freeC = Stream$.MODULE$.flatten$extension(freeC6, $less$colon$less$.MODULE$.refl());
        } else {
            freeC = stream;
        }
        return freeC;
    }

    private final Object _gunzip_validateHeader$$anonfun$adapted$1(boolean isPresent$6, CRC32 crc32$59, Sync SyncF$55, Object v1) {
        return new Stream(this._gunzip_validateHeader$$anonfun$2(isPresent$6, crc32$59, SyncF$55, v1 == null ? null : ((Stream)v1).fs2$Stream$$free()));
    }

    private final FreeC validateTrailer$1(CRC32 crc32$28, Inflater inflater$16, Sync SyncF$27, Chunk trailerChunk) {
        FreeC<Object, Nothing$, Object> freeC;
        if (trailerChunk.size() == gzipTrailerBytes) {
            long expectedInputCrc32 = this.unsignedToLong(BoxesRunTime.unboxToByte(trailerChunk.apply(0)), BoxesRunTime.unboxToByte(trailerChunk.apply(1)), BoxesRunTime.unboxToByte(trailerChunk.apply(2)), BoxesRunTime.unboxToByte(trailerChunk.apply(3)));
            long actualInputCrc32 = crc32$28.getValue();
            long expectedInputSize = this.unsignedToLong(BoxesRunTime.unboxToByte(trailerChunk.apply(4)), BoxesRunTime.unboxToByte(trailerChunk.apply(5)), BoxesRunTime.unboxToByte(trailerChunk.apply(6)), BoxesRunTime.unboxToByte(trailerChunk.apply(7)));
            long actualInputSize = inflater$16.getBytesWritten() & 0xFFFFFFFFL;
            freeC = expectedInputCrc32 != actualInputCrc32 ? Pull$.MODULE$.raiseError(new ZipException("Content failed CRC validation"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$27)) : (expectedInputSize != actualInputSize ? Pull$.MODULE$.raiseError(new ZipException("Content failed size validation"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$27)) : Pull$.MODULE$.done());
        } else {
            freeC = Pull$.MODULE$.raiseError(new ZipException("Failed to read trailer (1)"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$27));
        }
        return freeC;
    }

    private final FreeC streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$1(CRC32 crc32$32, Inflater inflater$20, Sync SyncF$31, Chunk next$1, FreeC rest$1) {
        Object object = this.streamUntilTrailer$2(crc32$32, inflater$20, SyncF$31, next$1).apply(new Stream(rest$1));
        return object == null ? null : ((Pull)object).fs2$Pull$$free();
    }

    private final Object streamUntilTrailer$3$$anonfun$2$$anonfun$2$$anonfun$adapted$1(CRC32 crc32$60, Inflater inflater$36, Sync SyncF$56, Chunk next$3, FreeC rest$4) {
        return new Pull(this.streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$1(crc32$60, inflater$36, SyncF$56, next$3, rest$4));
    }

    private final FreeC streamUntilTrailer$4$$anonfun$3$$anonfun$3$$anonfun$2(Chunk next$2) {
        return Pull$.MODULE$.output(next$2);
    }

    private final Object $anonfun$adapted$11(Chunk next$4) {
        return new Pull(this.streamUntilTrailer$4$$anonfun$3$$anonfun$3$$anonfun$2(next$4));
    }

    private final FreeC streamUntilTrailer$5$$anonfun$4$$anonfun$4$$anonfun$3(CRC32 crc32$33, Inflater inflater$21, Sync SyncF$32, FreeC rest$2) {
        Object object = this.streamUntilTrailer$2(crc32$33, inflater$21, SyncF$32, Chunk$.MODULE$.empty()).apply(new Stream(rest$2));
        return object == null ? null : ((Pull)object).fs2$Pull$$free();
    }

    private final Object streamUntilTrailer$6$$anonfun$5$$anonfun$5$$anonfun$adapted$2(CRC32 crc32$61, Inflater inflater$37, Sync SyncF$57, FreeC rest$5) {
        return new Pull(this.streamUntilTrailer$5$$anonfun$4$$anonfun$4$$anonfun$3(crc32$61, inflater$37, SyncF$57, rest$5));
    }

    private final FreeC streamUntilTrailer$7$$anonfun$6$$anonfun$6$$anonfun$4(CRC32 crc32$34, Inflater inflater$22, Sync SyncF$33, FreeC rest$3) {
        Object object = this.streamUntilTrailer$2(crc32$34, inflater$22, SyncF$33, Chunk$.MODULE$.empty()).apply(new Stream(rest$3));
        return object == null ? null : ((Pull)object).fs2$Pull$$free();
    }

    private final Object streamUntilTrailer$8$$anonfun$7$$anonfun$7$$anonfun$adapted$3(CRC32 crc32$62, Inflater inflater$38, Sync SyncF$58, FreeC rest$6) {
        return new Pull(this.streamUntilTrailer$7$$anonfun$6$$anonfun$6$$anonfun$4(crc32$62, inflater$38, SyncF$58, rest$6));
    }

    private final FreeC streamUntilTrailer$9$$anonfun$8$$anonfun$8$$anonfun$5(CRC32 crc32$35, Inflater inflater$23, Sync SyncF$34, Chunk last$3, int preTrailerBytes$1) {
        return this.validateTrailer$1(crc32$35, inflater$23, SyncF$34, last$3.drop(preTrailerBytes$1));
    }

    private final Object streamUntilTrailer$10$$anonfun$9$$anonfun$9$$anonfun$adapted$4(CRC32 crc32$63, Inflater inflater$39, Sync SyncF$59, Chunk last$4, int preTrailerBytes$2) {
        return new Pull(this.streamUntilTrailer$9$$anonfun$8$$anonfun$8$$anonfun$5(crc32$63, inflater$39, SyncF$59, last$4, preTrailerBytes$2));
    }

    private final /* synthetic */ FreeC streamUntilTrailer$11$$anonfun$10$$anonfun$10(CRC32 crc32$31, Inflater inflater$19, Sync SyncF$30, Chunk last$2, Option x$1) {
        FreeC<Object, Object, Object> freeC;
        Tuple2 tuple2;
        Option option = x$1;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            FreeC rest;
            Chunk next = (Chunk)tuple2._1();
            FreeC freeC2 = rest = tuple2._2() == null ? null : ((Stream)tuple2._2()).fs2$Stream$$free();
            if (inflater$19.finished()) {
                if (next.size() >= gzipTrailerBytes) {
                    if (last$2.nonEmpty()) {
                        FreeC freeC3 = Pull$.MODULE$.output(last$2);
                        freeC = Pull$.MODULE$.$greater$greater$extension(freeC3, () -> this.streamUntilTrailer$3$$anonfun$2$$anonfun$2$$anonfun$adapted$1(crc32$31, inflater$19, SyncF$30, next, rest));
                    } else {
                        Object object = this.streamUntilTrailer$2(crc32$31, inflater$19, SyncF$30, next).apply(new Stream(rest));
                        freeC = object == null ? null : ((Pull)object).fs2$Pull$$free();
                    }
                } else {
                    Object object = this.streamUntilTrailer$2(crc32$31, inflater$19, SyncF$30, Chunk$.MODULE$.concatBytes((Seq<Chunk<Object>>)((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Chunk.Bytes[]{last$2.toBytes($less$colon$less$.MODULE$.refl()), next.toBytes($less$colon$less$.MODULE$.refl())}))))).apply(new Stream(rest));
                    freeC = object == null ? null : ((Pull)object).fs2$Pull$$free();
                }
            } else if (last$2.nonEmpty()) {
                FreeC freeC4 = Pull$.MODULE$.output(last$2);
                FreeC freeC5 = Pull$.MODULE$.$greater$greater$extension(freeC4, () -> this.$anonfun$adapted$11(next));
                freeC = Pull$.MODULE$.$greater$greater$extension(freeC5, () -> this.streamUntilTrailer$6$$anonfun$5$$anonfun$5$$anonfun$adapted$2(crc32$31, inflater$19, SyncF$30, rest));
            } else {
                FreeC freeC6 = Pull$.MODULE$.output(next);
                freeC = Pull$.MODULE$.$greater$greater$extension(freeC6, () -> this.streamUntilTrailer$8$$anonfun$7$$anonfun$7$$anonfun$adapted$3(crc32$31, inflater$19, SyncF$30, rest));
            }
        } else if (None$.MODULE$.equals(option)) {
            int preTrailerBytes = last$2.size() - gzipTrailerBytes;
            if (preTrailerBytes > 0) {
                FreeC freeC7 = Pull$.MODULE$.output(last$2.take(preTrailerBytes));
                freeC = Pull$.MODULE$.$greater$greater$extension(freeC7, () -> this.streamUntilTrailer$10$$anonfun$9$$anonfun$9$$anonfun$adapted$4(crc32$31, inflater$19, SyncF$30, last$2, preTrailerBytes));
            } else {
                freeC = this.validateTrailer$1(crc32$31, inflater$19, SyncF$30, last$2);
            }
        } else {
            throw new MatchError((Object)option);
        }
        return freeC;
    }

    private final Object streamUntilTrailer$12$$anonfun$11$$anonfun$adapted$1(CRC32 crc32$64, Inflater inflater$40, Sync SyncF$60, Chunk last$5, Option x$1) {
        return new Pull(this.streamUntilTrailer$11$$anonfun$10$$anonfun$10(crc32$64, inflater$40, SyncF$60, last$5, x$1));
    }

    private final /* synthetic */ FreeC streamUntilTrailer$13$$anonfun$12(CRC32 crc32$30, Inflater inflater$18, Sync SyncF$29, Chunk last$1, FreeC _$32) {
        FreeC freeC = Stream$.MODULE$.InvariantOps(_$32);
        FreeC freeC2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(freeC)).fs2$Stream$ToPull$$free();
        FreeC freeC3 = new Pull(Stream$ToPull$.MODULE$.unconsNonEmpty$extension(freeC2)).fs2$Pull$$free();
        return Pull$.MODULE$.flatMap$extension(freeC3, arg_0 -> this.streamUntilTrailer$12$$anonfun$11$$anonfun$adapted$1(crc32$30, inflater$18, SyncF$29, last$1, arg_0));
    }

    private final Object streamUntilTrailer$14$$anonfun$adapted$1(CRC32 crc32$65, Inflater inflater$41, Sync SyncF$61, Chunk last$6, Object v1) {
        return new Pull(this.streamUntilTrailer$13$$anonfun$12(crc32$65, inflater$41, SyncF$61, last$6, v1 == null ? null : ((Stream)v1).fs2$Stream$$free()));
    }

    private final Function1 streamUntilTrailer$2(CRC32 crc32$29, Inflater inflater$17, Sync SyncF$28, Chunk last) {
        return arg_0 -> this.streamUntilTrailer$14$$anonfun$adapted$1(crc32$29, inflater$17, SyncF$28, last, arg_0);
    }

    private final /* synthetic */ FreeC _gunzip_validateTrailer$$anonfun$1(CRC32 crc32$27, Inflater inflater$15, Sync SyncF$26, FreeC stream) {
        Object object = this.streamUntilTrailer$2(crc32$27, inflater$15, SyncF$26, Chunk$.MODULE$.empty()).apply(new Stream(stream));
        FreeC freeC = object == null ? null : ((Pull)object).fs2$Pull$$free();
        return Pull$.MODULE$.stream$extension(freeC, $less$colon$less$.MODULE$.refl());
    }

    private final Object _gunzip_validateTrailer$$anonfun$adapted$1(CRC32 crc32$66, Inflater inflater$42, Sync SyncF$62, Object v1) {
        return new Stream(this._gunzip_validateTrailer$$anonfun$1(crc32$66, inflater$42, SyncF$62, v1 == null ? null : ((Stream)v1).fs2$Stream$$free()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final /* synthetic */ FreeC go$1$$anonfun$1(Function1 predicate$3, int softLimit$3, List acc$1, int size$1, Option x$1) {
        FreeC freeC;
        Option option = x$1;
        if (None$.MODULE$.equals(option)) {
            freeC = Pull$.MODULE$.pure(None$.MODULE$);
            return freeC;
        } else {
            Tuple2 tuple2;
            if (!(option instanceof Some) || (tuple2 = (Tuple2)((Some)option).value()) == null) throw new MatchError((Object)option);
            Chunk hd = (Chunk)tuple2._1();
            FreeC tl = tuple2._2() == null ? null : ((Stream)tuple2._2()).fs2$Stream$$free();
            Option<Object> option2 = hd.indexWhere(predicate$3);
            if (option2 instanceof Some) {
                int i = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                Tuple2 tuple22 = hd.splitAt(i);
                if (!(tuple22 instanceof Tuple2)) {
                    throw new MatchError(tuple22);
                }
                Tuple2 tuple23 = tuple22;
                Chunk pfx = (Chunk)tuple23._1();
                Chunk sfx = (Chunk)tuple23._2();
                Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)pfx, (Object)sfx);
                Chunk pfx2 = (Chunk)tuple24._1();
                Chunk sfx2 = (Chunk)tuple24._2();
                Object object = Predef$.MODULE$.ArrowAssoc(Chunk$.MODULE$.concat(acc$1.$colon$colon((Object)pfx2).reverse()));
                freeC = Pull$.MODULE$.pure(Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, new Stream(Stream$.MODULE$.cons$extension(tl, sfx2)))));
                return freeC;
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                int newSize = size$1 + hd.size();
                if (newSize < softLimit$3) {
                    freeC = this.go$2(predicate$3, softLimit$3, acc$1.$colon$colon((Object)hd), tl, newSize);
                    return freeC;
                } else {
                    Object object = Predef$.MODULE$.ArrowAssoc(Chunk$.MODULE$.concat(acc$1.$colon$colon((Object)hd).reverse()));
                    freeC = Pull$.MODULE$.pure(Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, new Stream(tl))));
                }
            }
        }
        return freeC;
    }

    private final Object go$3$$anonfun$adapted$1(Function1 predicate$4, int softLimit$4, List acc$2, int size$2, Option x$1) {
        return new Pull(this.go$1$$anonfun$1(predicate$4, softLimit$4, acc$2, size$2, x$1));
    }

    private final FreeC go$2(Function1 predicate$2, int softLimit$2, List acc, FreeC rest, int size) {
        FreeC freeC = Stream$.MODULE$.InvariantOps(rest);
        FreeC freeC2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(freeC)).fs2$Stream$ToPull$$free();
        FreeC freeC3 = new Pull(Stream$ToPull$.MODULE$.uncons$extension(freeC2)).fs2$Pull$$free();
        return Pull$.MODULE$.flatMap$extension(freeC3, arg_0 -> this.go$3$$anonfun$adapted$1(predicate$2, softLimit$2, acc, size, arg_0));
    }

    private final int go$default$3$1() {
        return 0;
    }

    private final /* synthetic */ FreeC unconsUntil$$anonfun$1(Function1 predicate$1, int softLimit$1, FreeC stream) {
        return this.go$2(predicate$1, softLimit$1, (List)package$.MODULE$.Nil(), stream, this.go$default$3$1());
    }

    private final Object unconsUntil$$anonfun$adapted$1(Function1 predicate$5, int softLimit$5, Object v1) {
        return new Pull(this.unconsUntil$$anonfun$1(predicate$5, softLimit$5, v1 == null ? null : ((Stream)v1).fs2$Stream$$free()));
    }
}

