/*
 * Decompiled with CFR 0.152.
 */
package fs2;

import cats.effect.kernel.Sync;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$InvariantOps$;
import fs2.Stream$ToPull$;
import fs2.compression;
import fs2.compression$DeflateParams$;
import fs2.compression$DeflateParams$FlushMode$DEFAULT$;
import fs2.compression$DeflateParams$Level$;
import fs2.compression$DeflateParams$Level$DEFAULT$;
import fs2.compression$DeflateParams$Strategy$;
import fs2.compression$DeflateParams$Strategy$DEFAULT$;
import fs2.compression$GunzipResult$;
import fs2.compression$InflateParams$;
import fs2.compression$ZLibParams$;
import fs2.compression$ZLibParams$Header$GZIP$;
import fs2.compression$gzipCompressionMethod$;
import fs2.compression$gzipExtraFlag$;
import fs2.compression$gzipFlag$;
import fs2.compression$gzipOperatingSystem$;
import java.io.EOFException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import scala.;
import scala.$less$colon$less$;
import scala.Any;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.function.JFunction0;
import scala.runtime.function.JFunction1;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven;
import scala.util.NotGiven$;

public final class compression$
implements Serializable {
    public static final compression$ZLibParams$ ZLibParams;
    public static final compression$DeflateParams$ DeflateParams;
    public static final compression$InflateParams$ InflateParams;
    public static final compression$GunzipResult$ GunzipResult;
    private static final int gzipHeaderBytes;
    private static final byte gzipMagicFirstByte;
    private static final byte gzipMagicSecondByte;
    private static final compression$gzipCompressionMethod$ gzipCompressionMethod;
    private static final compression$gzipFlag$ gzipFlag;
    private static final compression$gzipExtraFlag$ gzipExtraFlag;
    private static final int gzipOptionalExtraFieldLengthBytes;
    private static final int gzipHeaderCrcBytes;
    private static final compression$gzipOperatingSystem$ gzipOperatingSystem;
    private static final int gzipTrailerBytes;
    private static final byte zeroByte;
    private static final int fileNameBytesSoftLimit;
    private static final int fileCommentBytesSoftLimit;
    public static final compression$ MODULE$;

    private compression$() {
    }

    static {
        MODULE$ = new compression$();
        gzipHeaderBytes = 10;
        gzipMagicFirstByte = (byte)31;
        gzipMagicSecondByte = (byte)139;
        gzipOptionalExtraFieldLengthBytes = 2;
        gzipHeaderCrcBytes = 2;
        int gzipInputCrcBytes = 4;
        int gzipInputSizeBytes = 4;
        gzipTrailerBytes = gzipInputCrcBytes + gzipInputSizeBytes;
        zeroByte = 0;
        fileNameBytesSoftLimit = 1024;
        fileCommentBytesSoftLimit = 0x100000;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(compression$.class);
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Object>> deflate(compression.DeflateParams deflateParams, Sync<F> SyncF) {
        return (JFunction1 & Serializable)stream -> Stream$.MODULE$.bracket(SyncF.delay(() -> this.deflate$$anonfun$2$$anonfun$1(deflateParams)), (JFunction1 & Serializable)deflater -> SyncF.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.deflate$$anonfun$3$$anonfun$2$$anonfun$1(deflater)))).flatMap((JFunction1 & Serializable)deflater -> (Stream)this._deflate(deflateParams, (Deflater)deflater, (Option<CRC32>)None$.MODULE$).apply(stream), NotGiven$.MODULE$.value());
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _deflate(compression.DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32) {
        return (JFunction1 & Serializable)in -> Stream$.MODULE$.suspend(() -> this._deflate$$anonfun$2$$anonfun$1(deflateParams, deflater, crc32, in));
    }

    private <F> Pull<F, Object, BoxedUnit> _deflate_chunk(compression.DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32, Chunk<Object> chunk, byte[] deflatedBuffer, boolean isFinalChunk) {
        Chunk.ArraySlice bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE));
        deflater.setInput((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
        if (isFinalChunk) {
            deflater.finish();
        }
        crc32.foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.update((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length()));
        return this.pull$1(deflateParams, deflater, deflatedBuffer, isFinalChunk);
    }

    private <F> Function1<Stream<F, Object>, Pull<F, Object, BoxedUnit>> _deflate_stream(compression.DeflateParams deflateParams, Deflater deflater, Option<CRC32> crc32, byte[] deflatedBuffer) {
        return (JFunction1 & Serializable)_$6 -> {
            Stream stream = Stream$.MODULE$.InvariantOps(_$6);
            Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
            return Stream$ToPull$.MODULE$.uncons$extension(stream2).flatMap((JFunction1 & Serializable)x$1 -> {
                Pull<Object, Object, Object> pull;
                Tuple2 tuple2;
                Option option = x$1;
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    Chunk inflatedChunk = (Chunk)tuple2._1();
                    Stream inflatedStream = (Stream)tuple2._2();
                    pull = this._deflate_chunk(deflateParams, deflater, crc32, inflatedChunk, deflatedBuffer, false).$greater$greater(() -> this._deflate_stream$$anonfun$2$$anonfun$1$$anonfun$1(deflateParams, deflater, crc32, deflatedBuffer, inflatedStream));
                } else if (None$.MODULE$.equals(option)) {
                    pull = this._deflate_chunk(deflateParams, deflater, crc32, Chunk$.MODULE$.empty(), deflatedBuffer, true);
                } else {
                    throw new MatchError((Object)option);
                }
                return pull;
            });
        };
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Object>> inflate(compression.InflateParams inflateParams, Sync<F> SyncF) {
        return (JFunction1 & Serializable)stream -> Stream$.MODULE$.bracket(SyncF.delay(() -> this.inflate$$anonfun$2$$anonfun$1(inflateParams)), (JFunction1 & Serializable)inflater -> SyncF.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.inflate$$anonfun$3$$anonfun$2$$anonfun$1(inflater)))).flatMap((JFunction1 & Serializable)inflater -> (Stream)this._inflate(inflateParams, (Inflater)inflater, (Option<CRC32>)None$.MODULE$, SyncF).apply(stream), NotGiven$.MODULE$.value());
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _inflate(compression.InflateParams inflateParams, Inflater inflater, Option<CRC32> crc32, Sync<F> SyncF) {
        return (JFunction1 & Serializable)in -> Stream$.MODULE$.suspend(() -> this._inflate$$anonfun$4$$anonfun$3(inflateParams, inflater, crc32, SyncF, in));
    }

    private <F> Pull<F, Object, BoxedUnit> _inflate_chunk(Inflater inflater, Option<CRC32> crc32, Chunk<Object> chunk, byte[] inflatedBuffer) {
        Chunk.ArraySlice bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE));
        inflater.setInput((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
        return this.pull$2(inflater, crc32, inflatedBuffer, bytesChunk);
    }

    private <F> Function1<Stream<F, Object>, Pull<F, Object, BoxedUnit>> _inflate_stream(compression.InflateParams inflateParams, Inflater inflater, Option<CRC32> crc32, byte[] inflatedBuffer, Sync<F> SyncF) {
        return (JFunction1 & Serializable)_$12 -> {
            Stream stream = Stream$.MODULE$.InvariantOps(_$12);
            Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
            return Stream$ToPull$.MODULE$.uncons$extension(stream2).flatMap((JFunction1 & Serializable)x$1 -> {
                Pull<Object, Object, Object> pull;
                Tuple2 tuple2;
                Option option = x$1;
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    Chunk deflatedChunk = (Chunk)tuple2._1();
                    Stream deflatedStream = (Stream)tuple2._2();
                    pull = this._inflate_chunk(inflater, crc32, deflatedChunk, inflatedBuffer).$greater$greater(() -> this._inflate_stream$$anonfun$2$$anonfun$1$$anonfun$1(inflateParams, inflater, crc32, inflatedBuffer, SyncF, deflatedStream));
                } else if (None$.MODULE$.equals(option)) {
                    pull = !inflater.finished() ? Pull$.MODULE$.raiseError(new DataFormatException("Insufficient data"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)) : Pull$.MODULE$.done();
                } else {
                    throw new MatchError((Object)option);
                }
                return pull;
            });
        };
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Object>> gzip(int bufferSize, Option<Object> deflateLevel, Option<Object> deflateStrategy, Option<Instant> modificationTime, Option<String> fileName, Option<String> comment, Sync<F> SyncF) {
        return this.gzip(fileName, modificationTime, comment, compression$DeflateParams$.MODULE$.apply(bufferSize, compression$ZLibParams$Header$GZIP$.MODULE$, (compression.DeflateParams.Level)deflateLevel.map((Function1)((JFunction1 & Serializable)this::gzip$$anonfun$adapted$1)).getOrElse(this::gzip$$anonfun$1), (compression.DeflateParams.Strategy)deflateStrategy.map((Function1)((JFunction1 & Serializable)this::gzip$$anonfun$adapted$2)).getOrElse(this::gzip$$anonfun$2), compression$DeflateParams$FlushMode$DEFAULT$.MODULE$), SyncF);
    }

    public int gzip$default$1() {
        return 32768;
    }

    public <F> None$ gzip$default$2() {
        return None$.MODULE$;
    }

    public <F> None$ gzip$default$3() {
        return None$.MODULE$;
    }

    public <F> None$ gzip$default$4() {
        return None$.MODULE$;
    }

    public <F> None$ gzip$default$5() {
        return None$.MODULE$;
    }

    public <F> None$ gzip$default$6() {
        return None$.MODULE$;
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Object>> gzip(Option<String> fileName, Option<Instant> modificationTime, Option<String> comment, compression.DeflateParams deflateParams, Sync<F> SyncF) {
        return (JFunction1 & Serializable)stream -> {
            Stream<Object, Object> stream2;
            compression.DeflateParams deflateParams = deflateParams;
            if (deflateParams != null) {
                compression.DeflateParams deflateParams2;
                compression.DeflateParams params = deflateParams2 = deflateParams;
                compression.ZLibParams.Header header = params.header();
                compression$ZLibParams$Header$GZIP$ compression$ZLibParams$Header$GZIP$2 = compression$ZLibParams$Header$GZIP$.MODULE$;
                if (!(header != null ? !header.equals(compression$ZLibParams$Header$GZIP$2) : compression$ZLibParams$Header$GZIP$2 != null)) {
                    stream2 = Stream$.MODULE$.bracket(SyncF.delay(() -> this.gzip$$anonfun$6$$anonfun$1(params)), (JFunction1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Deflater deflater = (Deflater)tuple2._1();
                        return SyncF.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.gzip$$anonfun$7$$anonfun$2$$anonfun$1(deflater)));
                    }).flatMap((JFunction1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        Deflater deflater = (Deflater)tuple2._1();
                        CRC32 crc32 = (CRC32)tuple2._2();
                        return this._gzip_header(fileName, modificationTime, comment, params.level().juzDeflaterLevel()).$plus$plus(() -> this.gzip$$anonfun$9$$anonfun$4$$anonfun$1(stream, params, deflater, crc32)).$plus$plus(() -> this.gzip$$anonfun$10$$anonfun$5$$anonfun$2(deflater, crc32));
                    }, NotGiven$.MODULE$.value());
                } else {
                    compression.DeflateParams params2 = deflateParams2;
                    stream2 = Stream$.MODULE$.raiseError(new ZipException("" + compression$ZLibParams$Header$GZIP$.MODULE$ + " header type required, not " + params2.header() + "."), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF));
                }
            } else {
                throw new MatchError((Object)deflateParams);
            }
            return stream2;
        };
    }

    private <F> Stream<F, Object> _gzip_header(Option<String> fileName, Option<Instant> modificationTime, Option<String> comment, int deflateLevel) {
        int n;
        long secondsSince197001010000 = BoxesRunTime.unboxToLong((Object)modificationTime.map((Function1)(JFunction1 & Serializable)_$16 -> _$16.getEpochSecond()).getOrElse((Function0)((JFunction0.mcJ.sp & Serializable)this::$anonfun$2)));
        byte[] header = new byte[]{gzipMagicFirstByte, gzipMagicSecondByte, compression$gzipCompressionMethod$.MODULE$.DEFLATE(), (byte)(compression$gzipFlag$.MODULE$.FHCRC() + BoxesRunTime.unboxToByte((Object)fileName.map((Function1)(JFunction1 & Serializable)_$17 -> compression$gzipFlag$.MODULE$.FNAME()).getOrElse((Function0)((JFunction0.mcB.sp & Serializable)this::$anonfun$4))) + BoxesRunTime.unboxToByte((Object)comment.map((Function1)(JFunction1 & Serializable)_$18 -> compression$gzipFlag$.MODULE$.FCOMMENT()).getOrElse((Function0)((JFunction0.mcB.sp & Serializable)this::$anonfun$6)))), (byte)(secondsSince197001010000 & 0xFFL), (byte)(secondsSince197001010000 >> 8 & 0xFFL), (byte)(secondsSince197001010000 >> 16 & 0xFFL), (byte)(secondsSince197001010000 >> 24 & 0xFFL), 9 == (n = deflateLevel) ? compression$gzipExtraFlag$.MODULE$.DEFLATE_MAX_COMPRESSION_SLOWEST_ALGO() : (1 == n ? compression$gzipExtraFlag$.MODULE$.DEFLATE_FASTEST_ALGO() : zeroByte), compression$gzipOperatingSystem$.MODULE$.THIS()};
        CRC32 crc32 = new CRC32();
        crc32.update(header);
        Option fileNameEncoded = fileName.map((Function1)(JFunction1 & Serializable)string -> {
            void var3_3;
            byte[] bytes = string.replaceAll("\u0000", "_").getBytes(StandardCharsets.ISO_8859_1);
            crc32.update(bytes);
            crc32.update(zeroByte);
            return var3_3;
        });
        Option commentEncoded = comment.map((Function1)(JFunction1 & Serializable)string -> {
            void var3_3;
            byte[] bytes = string.replaceAll("\u0000", " ").getBytes(StandardCharsets.ISO_8859_1);
            crc32.update(bytes);
            crc32.update(zeroByte);
            return var3_3;
        });
        long crc32Value = crc32.getValue();
        byte[] crc16 = new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL)};
        return Stream$.MODULE$.chunk(this.moveAsChunkBytes(header)).$plus$plus(() -> this._gzip_header$$anonfun$1(fileNameEncoded)).$plus$plus(() -> this._gzip_header$$anonfun$2(commentEncoded)).$plus$plus(() -> this._gzip_header$$anonfun$3(crc16));
    }

    private <F> Stream<F, Object> _gzip_trailer(Deflater deflater, CRC32 crc32) {
        long crc32Value = crc32.getValue();
        int bytesIn = deflater.getTotalIn();
        byte[] trailer = new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL), (byte)(crc32Value >> 16 & 0xFFL), (byte)(crc32Value >> 24 & 0xFFL), (byte)(bytesIn & 0xFF), (byte)(bytesIn >> 8 & 0xFF), (byte)(bytesIn >> 16 & 0xFF), (byte)(bytesIn >> 24 & 0xFF)};
        return Stream$.MODULE$.chunk(this.moveAsChunkBytes(trailer));
    }

    public <F> Function1<Stream<F, Object>, Stream<F, compression.GunzipResult<F>>> gunzip(int bufferSize, Sync<F> SyncF) {
        return this.gunzip(compression$InflateParams$.MODULE$.apply(bufferSize, compression$ZLibParams$Header$GZIP$.MODULE$), SyncF);
    }

    public int gunzip$default$1() {
        return 32768;
    }

    public <F> Function1<Stream<F, Object>, Stream<F, compression.GunzipResult<F>>> gunzip(compression.InflateParams inflateParams, Sync<F> SyncF) {
        return (JFunction1 & Serializable)stream -> {
            Stream<Object, Object> stream2;
            compression.InflateParams inflateParams = inflateParams;
            if (inflateParams != null) {
                compression.InflateParams inflateParams2;
                compression.InflateParams params = inflateParams2 = inflateParams;
                compression.ZLibParams.Header header = params.header();
                compression$ZLibParams$Header$GZIP$ compression$ZLibParams$Header$GZIP$2 = compression$ZLibParams$Header$GZIP$.MODULE$;
                if (!(header != null ? !header.equals(compression$ZLibParams$Header$GZIP$2) : compression$ZLibParams$Header$GZIP$2 != null)) {
                    stream2 = Stream$.MODULE$.bracket(SyncF.delay(this::gunzip$$anonfun$2$$anonfun$1), (JFunction1 & Serializable)x$1 -> {
                        Tuple3 tuple3 = x$1;
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        Inflater inflater = (Inflater)tuple3._1();
                        return SyncF.delay((Function0)((JFunction0.mcV.sp & Serializable)() -> this.gunzip$$anonfun$3$$anonfun$2$$anonfun$1(inflater)));
                    }).flatMap((JFunction1 & Serializable)x$12 -> {
                        Tuple3 tuple3 = x$12;
                        if (tuple3 == null) {
                            throw new MatchError((Object)tuple3);
                        }
                        Inflater inflater = (Inflater)tuple3._1();
                        CRC32 headerCrc32 = (CRC32)tuple3._2();
                        CRC32 contentCrc32 = (CRC32)tuple3._3();
                        Stream stream = Stream$.MODULE$.InvariantOps(stream);
                        Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                        return Stream$ToPull$.MODULE$.unconsN$extension(stream2, gzipHeaderBytes, Stream$ToPull$.MODULE$.unconsN$default$2$extension(stream2)).flatMap((JFunction1 & Serializable)x$1 -> {
                            Pull pull;
                            Tuple2 tuple2;
                            Option option = x$1;
                            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                                Chunk mandatoryHeaderChunk = (Chunk)tuple2._1();
                                Stream streamAfterMandatoryHeader = (Stream)tuple2._2();
                                pull = this._gunzip_matchMandatoryHeader(params, mandatoryHeaderChunk, streamAfterMandatoryHeader, headerCrc32, contentCrc32, inflater, SyncF);
                            } else if (None$.MODULE$.equals(option)) {
                                pull = Pull$.MODULE$.output1(compression$GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), (Option<Instant>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$2(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$3(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                            } else {
                                throw new MatchError((Object)option);
                            }
                            return pull;
                        }).stream($less$colon$less$.MODULE$.refl());
                    }, NotGiven$.MODULE$.value());
                } else {
                    compression.InflateParams params2 = inflateParams2;
                    stream2 = Stream$.MODULE$.raiseError(new ZipException("" + compression$ZLibParams$Header$GZIP$.MODULE$ + " header type required, not " + params2.header() + "."), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF));
                }
            } else {
                throw new MatchError((Object)inflateParams);
            }
            return stream2;
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private <F> Pull<Any, compression.GunzipResult<F>, BoxedUnit> _gunzip_matchMandatoryHeader(compression.InflateParams inflateParams, Chunk<Object> mandatoryHeaderChunk, Stream<F, Object> streamAfterMandatoryHeader, CRC32 headerCrc32, CRC32 contentCrc32, Inflater inflater, Sync<F> SyncF) {
        Pull<Object, compression.GunzipResult<Object>, Object> pull;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)mandatoryHeaderChunk.size()), mandatoryHeaderChunk.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE)).values());
        if (tuple2 != null) {
            byte[] byArray = (byte[])tuple2._2();
            if (gzipHeaderBytes == BoxesRunTime.unboxToInt((Object)tuple2._1()) && byArray != null) {
                Object object = Array$.MODULE$.unapplySeq((Object)byArray);
                if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 9) == 0) {
                    byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0));
                    byte by2 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1));
                    byte by3 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2));
                    byte by4 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 3));
                    byte by5 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 4));
                    byte by6 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 5));
                    byte by7 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 6));
                    byte by8 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 7));
                    byte by9 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 8));
                    if (gzipMagicFirstByte == by && gzipMagicSecondByte == by2 && compression$gzipCompressionMethod$.MODULE$.DEFLATE() == by3) {
                        byte flags = by4;
                        if (compression$gzipFlag$.MODULE$.reserved5(flags)) {
                            pull = Pull$.MODULE$.output1(compression$GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 5 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), (Option<Instant>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$2(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$3(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                            return pull;
                        }
                        byte flags2 = by4;
                        if (compression$gzipFlag$.MODULE$.reserved6(flags2)) {
                            pull = Pull$.MODULE$.output1(compression$GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 6 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), (Option<Instant>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$2(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$3(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                            return pull;
                        }
                        byte flags3 = by4;
                        if (compression$gzipFlag$.MODULE$.reserved7(flags3)) {
                            pull = Pull$.MODULE$.output1(compression$GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 7 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), (Option<Instant>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$2(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$3(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                            return pull;
                        }
                    }
                }
                if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object, 10) == 0) {
                    byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0));
                    byte by10 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1));
                    byte by11 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2));
                    byte by12 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 3));
                    byte by13 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 4));
                    byte by14 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 5));
                    byte by15 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 6));
                    byte by16 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 7));
                    byte by17 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 8));
                    byte by18 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 9));
                    if (gzipMagicFirstByte == by && gzipMagicSecondByte == by10) {
                        if (compression$gzipCompressionMethod$.MODULE$.DEFLATE() == by11) {
                            byte flags = by12;
                            byte[] header = byArray;
                            headerCrc32.update(header);
                            long secondsSince197001010000 = this.unsignedToLong(header[4], header[5], header[6], header[7]);
                            Stream stream = Stream$.MODULE$.InvariantOps(this._gunzip_readOptionalHeader(inflateParams, streamAfterMandatoryHeader, flags, headerCrc32, contentCrc32, secondsSince197001010000, inflater, SyncF));
                            Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                            pull = Stream$ToPull$.MODULE$.uncons1$extension(stream2).flatMap((JFunction1 & Serializable)x$1 -> {
                                Pull pull;
                                Tuple2 tuple2;
                                Option option = x$1;
                                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                                    compression.GunzipResult gunzipResult = (compression.GunzipResult)tuple2._1();
                                    pull = Pull$.MODULE$.output1(gunzipResult);
                                } else if (None$.MODULE$.equals(option)) {
                                    pull = Pull$.MODULE$.output1(compression$GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), (Option<Instant>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$2(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$3(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                                } else {
                                    throw new MatchError((Object)option);
                                }
                                return pull;
                            });
                            return pull;
                        }
                        byte compressionMethod = by11;
                        pull = Pull$.MODULE$.output1(compression$GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip compression method: " + compressionMethod), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), (Option<Instant>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$2(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$3(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                        return pull;
                    }
                }
            }
        }
        pull = Pull$.MODULE$.output1(compression$GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException("Not in gzip format"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)), (Option<Instant>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$2(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$3(), (Option<String>)compression$GunzipResult$.MODULE$.$lessinit$greater$default$4()));
        return pull;
    }

    private <F> Stream<F, compression.GunzipResult<F>> _gunzip_readOptionalHeader(compression.InflateParams inflateParams, Stream<F, Object> streamAfterMandatoryHeader, byte flags, CRC32 headerCrc32, CRC32 contentCrc32, long secondsSince197001010000, Inflater inflater, Sync<F> SyncF) {
        return streamAfterMandatoryHeader.through(this._gunzip_skipOptionalExtraField(compression$gzipFlag$.MODULE$.fextra(flags), headerCrc32, SyncF)).through(this._gunzip_readOptionalStringField(compression$gzipFlag$.MODULE$.fname(flags), headerCrc32, "file name", fileNameBytesSoftLimit, SyncF)).flatMap((JFunction1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option fileName = (Option)tuple2._1();
            Stream streamAfterFileName = (Stream)tuple2._2();
            return streamAfterFileName.through(this._gunzip_readOptionalStringField(compression$gzipFlag$.MODULE$.fcomment(flags), headerCrc32, "file comment", fileCommentBytesSoftLimit, SyncF)).flatMap((JFunction1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Option comment = (Option)tuple2._1();
                Stream streamAfterComment = (Stream)tuple2._2();
                None$ none$ = secondsSince197001010000 != 0L ? Some$.MODULE$.apply((Object)Instant.ofEpochSecond(secondsSince197001010000)) : None$.MODULE$;
                Stream stream = streamAfterComment.through(this._gunzip_validateHeader((byte)(flags & compression$gzipFlag$.MODULE$.FHCRC()) == compression$gzipFlag$.MODULE$.FHCRC(), headerCrc32, SyncF)).through(this._inflate(inflateParams, inflater, (Option<CRC32>)Some$.MODULE$.apply((Object)contentCrc32), SyncF)).through(this._gunzip_validateTrailer(contentCrc32, inflater, SyncF));
                return Stream$.MODULE$.emit(compression$GunzipResult$.MODULE$.apply(stream, (Option<Instant>)none$, (Option<String>)fileName, (Option<String>)comment));
            }, (NotGiven)NotGiven$.MODULE$.value());
        }, (NotGiven<.less.colon.less<Tuple2<Option<String>, Stream<F, Object>>, Nothing$>>)NotGiven$.MODULE$.value());
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_skipOptionalExtraField(boolean isPresent, CRC32 crc32, Sync<F> Sync2) {
        return (JFunction1 & Serializable)stream -> {
            Stream stream2;
            if (isPresent) {
                Stream stream3 = Stream$.MODULE$.InvariantOps(stream);
                Stream stream4 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream3)).fs2$Stream$ToPull$$self();
                stream2 = Stream$ToPull$.MODULE$.unconsN$extension(stream4, gzipOptionalExtraFieldLengthBytes, Stream$ToPull$.MODULE$.unconsN$default$2$extension(stream4)).flatMap((JFunction1 & Serializable)x$12 -> {
                    Pull<Object, Object, Object> pull;
                    Tuple2 tuple2;
                    Option option = x$12;
                    if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                        Chunk optionalExtraFieldLengthChunk = (Chunk)tuple2._1();
                        Stream streamAfterOptionalExtraFieldLength = (Stream)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)optionalExtraFieldLengthChunk.size()), optionalExtraFieldLengthChunk.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE)).values());
                        if (tuple22 != null) {
                            Object object;
                            byte[] byArray = (byte[])tuple22._2();
                            if (gzipOptionalExtraFieldLengthBytes == BoxesRunTime.unboxToInt((Object)tuple22._1()) && byArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)byArray), 2) == 0) {
                                byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0));
                                byte by2 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1));
                                byte firstByte = by;
                                byte secondByte = by2;
                                byte[] lengthBytes = byArray;
                                crc32.update(lengthBytes);
                                int optionalExtraFieldLength = this.unsignedToInt(firstByte, secondByte);
                                Stream stream = Stream$.MODULE$.InvariantOps(streamAfterOptionalExtraFieldLength);
                                Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                                pull = Stream$ToPull$.MODULE$.unconsN$extension(stream2, optionalExtraFieldLength, Stream$ToPull$.MODULE$.unconsN$default$2$extension(stream2)).flatMap((JFunction1 & Serializable)x$1 -> {
                                    Pull pull;
                                    Tuple2 tuple2;
                                    Option option = x$1;
                                    if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                                        Chunk optionalExtraFieldChunk = (Chunk)tuple2._1();
                                        Stream streamAfterOptionalExtraField = (Stream)tuple2._2();
                                        Chunk.ArraySlice fieldBytes = optionalExtraFieldChunk.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE));
                                        crc32.update((byte[])fieldBytes.values(), fieldBytes.offset(), fieldBytes.length());
                                        pull = Pull$.MODULE$.output1(streamAfterOptionalExtraField);
                                    } else if (None$.MODULE$.equals(option)) {
                                        pull = Pull$.MODULE$.raiseError(new ZipException("Failed to read optional extra field header"), RaiseThrowable$.MODULE$.fromApplicativeError(Sync2));
                                    } else {
                                        throw new MatchError((Object)option);
                                    }
                                    return pull;
                                });
                                return pull;
                            }
                        }
                        pull = Pull$.MODULE$.raiseError(new ZipException("Failed to read optional extra field header length"), RaiseThrowable$.MODULE$.fromApplicativeError(Sync2));
                        return pull;
                    }
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    pull = Pull$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(Sync2));
                    return pull;
                }).stream($less$colon$less$.MODULE$.refl()).flatten($less$colon$less$.MODULE$.refl());
            } else {
                stream2 = stream;
            }
            return stream2;
        };
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Tuple2<Option<String>, Stream<F, Object>>>> _gunzip_readOptionalStringField(boolean isPresent, CRC32 crc32, String fieldName, int fieldBytesSoftLimit, Sync<F> SyncF) {
        return (JFunction1 & Serializable)stream -> isPresent ? ((Pull)this.unconsUntil((Function1)((JFunction1 & Serializable)this::_gunzip_readOptionalStringField$$anonfun$3$$anonfun$adapted$1), fieldBytesSoftLimit, (ClassTag)ClassTag$.MODULE$.apply(Byte.TYPE)).apply(stream)).flatMap((JFunction1 & Serializable)x$1 -> {
            Pull pull;
            Tuple2 tuple2;
            Option option = x$1;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                Some some;
                Chunk chunk = (Chunk)tuple2._1();
                Stream rest = (Stream)tuple2._2();
                if (chunk.isEmpty()) {
                    some = Some$.MODULE$.apply((Object)"");
                } else {
                    Chunk.ArraySlice bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE));
                    crc32.update((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
                    some = Some$.MODULE$.apply((Object)new String((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length(), StandardCharsets.ISO_8859_1));
                }
                pull = Pull$.MODULE$.output1(Tuple2$.MODULE$.apply((Object)some, rest.dropWhile(arg_0 -> this._gunzip_readOptionalStringField$$anonfun$5$$anonfun$3$$anonfun$adapted$1(crc32, arg_0)).drop(1L)));
            } else if (None$.MODULE$.equals(option)) {
                pull = Pull$.MODULE$.output1(Tuple2$.MODULE$.apply((Object)Option$.MODULE$.empty(), Stream$.MODULE$.raiseError(new ZipException("Failed to read " + fieldName + " field"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF))));
            } else {
                throw new MatchError((Object)option);
            }
            return pull;
        }).stream($less$colon$less$.MODULE$.refl()) : Stream$.MODULE$.emit(Tuple2$.MODULE$.apply((Object)Option$.MODULE$.empty(), stream));
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_validateHeader(boolean isPresent, CRC32 crc32, Sync<F> SyncF) {
        return (JFunction1 & Serializable)stream -> {
            Stream stream2;
            if (isPresent) {
                Stream stream3 = Stream$.MODULE$.InvariantOps(stream);
                Stream stream4 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream3)).fs2$Stream$ToPull$$self();
                stream2 = Stream$ToPull$.MODULE$.unconsN$extension(stream4, gzipHeaderCrcBytes, Stream$ToPull$.MODULE$.unconsN$default$2$extension(stream4)).flatMap((JFunction1 & Serializable)x$1 -> {
                    Pull pull;
                    Tuple2 tuple2;
                    Option option = x$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                        long actualHeaderCrc16;
                        Chunk headerCrcChunk = (Chunk)tuple2._1();
                        Stream streamAfterHeaderCrc = (Stream)tuple2._2();
                        int expectedHeaderCrc16 = this.unsignedToInt(BoxesRunTime.unboxToByte(headerCrcChunk.apply(0)), BoxesRunTime.unboxToByte(headerCrcChunk.apply(1)));
                        pull = (long)expectedHeaderCrc16 != (actualHeaderCrc16 = crc32.getValue() & 0xFFFFL) ? Pull$.MODULE$.raiseError(new ZipException("Header failed CRC validation"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF)) : Pull$.MODULE$.output1(streamAfterHeaderCrc);
                    } else if (None$.MODULE$.equals(option)) {
                        pull = Pull$.MODULE$.raiseError(new ZipException("Failed to read header CRC"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return pull;
                }).stream($less$colon$less$.MODULE$.refl()).flatten($less$colon$less$.MODULE$.refl());
            } else {
                stream2 = stream;
            }
            return stream2;
        };
    }

    private <F> Function1<Stream<F, Object>, Stream<F, Object>> _gunzip_validateTrailer(CRC32 crc32, Inflater inflater, Sync<F> SyncF) {
        return (JFunction1 & Serializable)stream -> ((Pull)this.streamUntilTrailer$2(crc32, inflater, SyncF, Chunk$.MODULE$.empty()).apply(stream)).stream($less$colon$less$.MODULE$.refl());
    }

    private <F, O> Function1<Stream<F, O>, Pull<F, Nothing$, Option<Tuple2<Chunk<O>, Stream<F, O>>>>> unconsUntil(Function1<O, Object> predicate, int softLimit, ClassTag<O> evidence$1) {
        return (JFunction1 & Serializable)stream -> this.go$2(predicate, softLimit, evidence$1, (List)package$.MODULE$.Nil(), (Stream)stream, this.go$default$3$1());
    }

    private Chunk<Object> moveAsChunkBytes(byte[] values) {
        return this.moveAsChunkBytes(values, values.length);
    }

    private Chunk<Object> moveAsChunkBytes(byte[] values, int length) {
        return length > 0 ? Chunk$.MODULE$.array(values, 0, length, ClassTag$.MODULE$.apply(Byte.TYPE)) : Chunk$.MODULE$.empty();
    }

    private Chunk<Object> copyAsChunkBytes(byte[] values, int length) {
        Chunk<Object> chunk;
        if (length > 0) {
            byte[] target = new byte[length];
            System.arraycopy(values, 0, target, 0, length);
            chunk = Chunk$.MODULE$.array(target, 0, length, ClassTag$.MODULE$.apply(Byte.TYPE));
        } else {
            chunk = Chunk$.MODULE$.empty();
        }
        return chunk;
    }

    private int unsignedToInt(byte lsb, byte msb) {
        return (msb & 0xFF) << 8 | lsb & 0xFF;
    }

    private long unsignedToLong(byte lsb, byte byte2, byte byte3, byte msb) {
        return ((long)msb & 0xFFL) << 24 | (long)((byte3 & 0xFF) << 16) | (long)((byte2 & 0xFF) << 8) | (long)(lsb & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    private final Deflater deflate$$anonfun$2$$anonfun$1(compression.DeflateParams deflateParams$2) {
        void var2_2;
        Deflater deflater = new Deflater(deflateParams$2.level().juzDeflaterLevel(), deflateParams$2.header().juzDeflaterNoWrap());
        deflater.setStrategy(deflateParams$2.strategy().juzDeflaterStrategy());
        return var2_2;
    }

    private final void deflate$$anonfun$3$$anonfun$2$$anonfun$1(Deflater deflater$1) {
        deflater$1.end();
    }

    private final Stream _deflate$$anonfun$2$$anonfun$1(compression.DeflateParams deflateParams$5, Deflater deflater$3, Option crc32$2, Stream in$1) {
        byte[] deflatedBuffer = new byte[deflateParams$5.bufferSizeOrMinimum()];
        return ((Pull)this._deflate_stream(deflateParams$5, deflater$3, (Option<CRC32>)crc32$2, deflatedBuffer).apply((Object)in$1)).stream($less$colon$less$.MODULE$.refl());
    }

    private final boolean isDone$1(Deflater deflater$4, boolean isFinalChunk$1) {
        return isFinalChunk$1 && deflater$4.finished() || !isFinalChunk$1 && deflater$4.needsInput();
    }

    private final int runDeflate$1(compression.DeflateParams deflateParams$6, Deflater deflater$5, byte[] deflatedBuffer$1, boolean isFinalChunk$2) {
        return this.isDone$1(deflater$5, isFinalChunk$2) ? 0 : deflater$5.deflate(deflatedBuffer$1, 0, deflateParams$6.bufferSizeOrMinimum(), deflateParams$6.flushMode().juzDeflaterFlushMode());
    }

    private final Pull pull$3$$anonfun$1(compression.DeflateParams deflateParams$12, Deflater deflater$13, byte[] deflatedBuffer$6, boolean isFinalChunk$4) {
        return this.pull$1(deflateParams$12, deflater$13, deflatedBuffer$6, isFinalChunk$4);
    }

    private final Pull pull$1(compression.DeflateParams deflateParams$7, Deflater deflater$6, byte[] deflatedBuffer$2, boolean isFinalChunk$3) {
        int deflatedBytes = this.runDeflate$1(deflateParams$7, deflater$6, deflatedBuffer$2, isFinalChunk$3);
        return this.isDone$1(deflater$6, isFinalChunk$3) ? Pull$.MODULE$.output(this.copyAsChunkBytes(deflatedBuffer$2, deflatedBytes)) : Pull$.MODULE$.output(this.copyAsChunkBytes(deflatedBuffer$2, deflatedBytes)).$greater$greater(() -> this.pull$3$$anonfun$1(deflateParams$7, deflater$6, deflatedBuffer$2, isFinalChunk$3));
    }

    private final Pull _deflate_stream$$anonfun$2$$anonfun$1$$anonfun$1(compression.DeflateParams deflateParams$10, Deflater deflater$9, Option crc32$5, byte[] deflatedBuffer$5, Stream inflatedStream$1) {
        return (Pull)this._deflate_stream(deflateParams$10, deflater$9, (Option<CRC32>)crc32$5, deflatedBuffer$5).apply((Object)inflatedStream$1);
    }

    private final Inflater inflate$$anonfun$2$$anonfun$1(compression.InflateParams inflateParams$2) {
        return new Inflater(inflateParams$2.header().juzDeflaterNoWrap());
    }

    private final void inflate$$anonfun$3$$anonfun$2$$anonfun$1(Inflater inflater$1) {
        inflater$1.end();
    }

    private final Pull _inflate$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(compression.InflateParams inflateParams$7, Inflater inflater$5, Option crc32$9, Sync SyncF$9, byte[] inflatedBuffer$2, Stream deflatedStream$1) {
        return (Pull)this._inflate_stream(inflateParams$7, inflater$5, (Option<CRC32>)crc32$9, inflatedBuffer$2, SyncF$9).apply((Object)deflatedStream$1);
    }

    private final Stream _inflate$$anonfun$4$$anonfun$3(compression.InflateParams inflateParams$5, Inflater inflater$3, Option crc32$7, Sync SyncF$7, Stream in$2) {
        byte[] inflatedBuffer = new byte[inflateParams$5.bufferSizeOrMinimum()];
        Stream stream = Stream$.MODULE$.InvariantOps(in$2);
        Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
        return Stream$ToPull$.MODULE$.uncons$extension(stream2).flatMap((JFunction1 & Serializable)x$1 -> {
            Pull<Object, Object, Object> pull;
            Tuple2 tuple2;
            Option option = x$1;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                Chunk deflatedChunk = (Chunk)tuple2._1();
                Stream deflatedStream = (Stream)tuple2._2();
                pull = this._inflate_chunk(inflater$3, (Option<CRC32>)crc32$7, deflatedChunk, inflatedBuffer).$greater$greater(() -> this._inflate$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(inflateParams$5, inflater$3, crc32$7, SyncF$7, inflatedBuffer, deflatedStream));
            } else if (None$.MODULE$.equals(option)) {
                pull = Pull$.MODULE$.done();
            } else {
                throw new MatchError((Object)option);
            }
            return pull;
        }).stream($less$colon$less$.MODULE$.refl());
    }

    private final int runInflate$2(Inflater inflater$6, Option crc32$10, byte[] inflatedBuffer$3) {
        int n;
        if (inflater$6.finished()) {
            n = -2;
        } else if (inflater$6.needsInput()) {
            n = -1;
        } else {
            int byteCount = inflater$6.inflate(inflatedBuffer$3);
            crc32$10.foreach((Function1)(JProcedure1 & Serializable)_$10 -> _$10.update(inflatedBuffer$3, 0, byteCount));
            n = byteCount;
        }
        return n;
    }

    private final Pull pull$4$$anonfun$1(Chunk.ArraySlice bytesChunk$3, int bytesRemaining$1) {
        return Pull$.MODULE$.output(Chunk$.MODULE$.array(bytesChunk$3.values(), bytesChunk$3.offset() + bytesChunk$3.length() - bytesRemaining$1, bytesRemaining$1, ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    private final Pull pull$5$$anonfun$2(Inflater inflater$24, Option crc32$36, byte[] inflatedBuffer$9, Chunk.ArraySlice bytesChunk$4) {
        return this.pull$2(inflater$24, crc32$36, inflatedBuffer$9, bytesChunk$4);
    }

    private final Pull pull$2(Inflater inflater$7, Option crc32$11, byte[] inflatedBuffer$5, Chunk.ArraySlice bytesChunk$2) {
        Pull<Object, Object, Object> pull;
        int n = this.runInflate$2(inflater$7, crc32$11, inflatedBuffer$5);
        int inflatedBytes = n;
        if (inflatedBytes <= -2) {
            int n2 = inflater$7.getRemaining();
            int bytesRemaining = n2;
            pull = bytesRemaining > 0 ? Pull$.MODULE$.output(Chunk$.MODULE$.array(bytesChunk$2.values(), bytesChunk$2.offset() + bytesChunk$2.length() - bytesRemaining, bytesRemaining, ClassTag$.MODULE$.apply(Byte.TYPE))) : Pull$.MODULE$.done();
        } else {
            int inflatedBytes2 = n;
            if (inflatedBytes2 == -1) {
                pull = Pull$.MODULE$.done();
            } else {
                int inflatedBytes3 = n;
                if (inflatedBytes3 < inflatedBuffer$5.length) {
                    int n3;
                    int bytesRemaining;
                    pull = inflater$7.finished() ? ((bytesRemaining = (n3 = inflater$7.getRemaining())) > 0 ? Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$5, inflatedBytes3)).$greater$greater(() -> this.pull$4$$anonfun$1(bytesChunk$2, bytesRemaining)) : Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$5, inflatedBytes3))) : Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$5, inflatedBytes3));
                } else {
                    int inflatedBytes4 = n;
                    pull = Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$5, inflatedBytes4)).$greater$greater(() -> this.pull$5$$anonfun$2(inflater$7, crc32$11, inflatedBuffer$5, bytesChunk$2));
                }
            }
        }
        return pull;
    }

    private final Pull _inflate_stream$$anonfun$2$$anonfun$1$$anonfun$1(compression.InflateParams inflateParams$10, Inflater inflater$10, Option crc32$14, byte[] inflatedBuffer$8, Sync SyncF$12, Stream deflatedStream$2) {
        return (Pull)this._inflate_stream(inflateParams$10, inflater$10, (Option<CRC32>)crc32$14, inflatedBuffer$8, SyncF$12).apply((Object)deflatedStream$2);
    }

    private final /* synthetic */ compression.DeflateParams.Level gzip$$anonfun$4(int level) {
        return compression$DeflateParams$Level$.MODULE$.apply(level);
    }

    private final compression.DeflateParams.Level gzip$$anonfun$adapted$1(Object level) {
        return this.gzip$$anonfun$4(BoxesRunTime.unboxToInt((Object)level));
    }

    private final compression$DeflateParams$Level$DEFAULT$ gzip$$anonfun$1() {
        return compression$DeflateParams$Level$DEFAULT$.MODULE$;
    }

    private final /* synthetic */ compression.DeflateParams.Strategy gzip$$anonfun$5(int strategy) {
        return compression$DeflateParams$Strategy$.MODULE$.apply(strategy);
    }

    private final compression.DeflateParams.Strategy gzip$$anonfun$adapted$2(Object strategy) {
        return this.gzip$$anonfun$5(BoxesRunTime.unboxToInt((Object)strategy));
    }

    private final compression$DeflateParams$Strategy$DEFAULT$ gzip$$anonfun$2() {
        return compression$DeflateParams$Strategy$DEFAULT$.MODULE$;
    }

    private final Tuple2 gzip$$anonfun$6$$anonfun$1(compression.DeflateParams params$1) {
        Deflater deflater = new Deflater(params$1.level().juzDeflaterLevel(), true);
        deflater.setStrategy(params$1.strategy().juzDeflaterStrategy());
        return Tuple2$.MODULE$.apply((Object)deflater, (Object)new CRC32());
    }

    private final void gzip$$anonfun$7$$anonfun$2$$anonfun$1(Deflater deflater$10) {
        deflater$10.end();
    }

    private final Stream gzip$$anonfun$9$$anonfun$4$$anonfun$1(Stream stream$4, compression.DeflateParams params$3, Deflater deflater$11, CRC32 crc32$15) {
        return (Stream)this._deflate(params$3, deflater$11, (Option<CRC32>)Some$.MODULE$.apply((Object)crc32$15)).apply((Object)stream$4);
    }

    private final Stream gzip$$anonfun$10$$anonfun$5$$anonfun$2(Deflater deflater$12, CRC32 crc32$16) {
        return this._gzip_trailer(deflater$12, crc32$16);
    }

    private final long $anonfun$2() {
        return 0L;
    }

    private final byte $anonfun$4() {
        return zeroByte;
    }

    private final byte $anonfun$6() {
        return zeroByte;
    }

    private final Stream _gzip_header$$anonfun$4$$anonfun$1$$anonfun$1() {
        return Stream$.MODULE$.emit(BoxesRunTime.boxToByte((byte)zeroByte));
    }

    private final Stream _gzip_header$$anonfun$6$$anonfun$3() {
        return Stream$.MODULE$.empty();
    }

    private final Stream _gzip_header$$anonfun$1(Option fileNameEncoded$1) {
        return (Stream)fileNameEncoded$1.map((Function1)(JFunction1 & Serializable)bytes -> Stream$.MODULE$.chunk(this.moveAsChunkBytes((byte[])bytes)).$plus$plus(this::_gzip_header$$anonfun$4$$anonfun$1$$anonfun$1)).getOrElse(this::_gzip_header$$anonfun$6$$anonfun$3);
    }

    private final Stream _gzip_header$$anonfun$7$$anonfun$1$$anonfun$1() {
        return Stream$.MODULE$.emit(BoxesRunTime.boxToByte((byte)zeroByte));
    }

    private final Stream _gzip_header$$anonfun$9$$anonfun$3() {
        return Stream$.MODULE$.empty();
    }

    private final Stream _gzip_header$$anonfun$2(Option commentEncoded$1) {
        return (Stream)commentEncoded$1.map((Function1)(JFunction1 & Serializable)bytes -> Stream$.MODULE$.chunk(this.moveAsChunkBytes((byte[])bytes)).$plus$plus(this::_gzip_header$$anonfun$7$$anonfun$1$$anonfun$1)).getOrElse(this::_gzip_header$$anonfun$9$$anonfun$3);
    }

    private final Stream _gzip_header$$anonfun$3(byte[] crc16$1) {
        return Stream$.MODULE$.chunk(this.moveAsChunkBytes(crc16$1));
    }

    private final Tuple3 gunzip$$anonfun$2$$anonfun$1() {
        return Tuple3$.MODULE$.apply((Object)new Inflater(true), (Object)new CRC32(), (Object)new CRC32());
    }

    private final void gunzip$$anonfun$3$$anonfun$2$$anonfun$1(Inflater inflater$11) {
        inflater$11.end();
    }

    private final /* synthetic */ boolean _gunzip_readOptionalStringField$$anonfun$2$$anonfun$1(byte _$27) {
        return _$27 == zeroByte;
    }

    private final boolean _gunzip_readOptionalStringField$$anonfun$3$$anonfun$adapted$1(Object _$27) {
        return this._gunzip_readOptionalStringField$$anonfun$2$$anonfun$1(BoxesRunTime.unboxToByte((Object)_$27));
    }

    private final /* synthetic */ boolean _gunzip_readOptionalStringField$$anonfun$4$$anonfun$2$$anonfun$1(CRC32 crc32$24, byte by) {
        crc32$24.update(by);
        return by != zeroByte;
    }

    private final boolean _gunzip_readOptionalStringField$$anonfun$5$$anonfun$3$$anonfun$adapted$1(CRC32 crc32$37, Object object) {
        return this._gunzip_readOptionalStringField$$anonfun$4$$anonfun$2$$anonfun$1(crc32$37, BoxesRunTime.unboxToByte((Object)object));
    }

    private final Pull validateTrailer$1(CRC32 crc32$28, Inflater inflater$16, Sync SyncF$27, Chunk trailerChunk) {
        Pull<Object, Nothing$, Object> pull;
        if (trailerChunk.size() == gzipTrailerBytes) {
            long expectedInputCrc32 = this.unsignedToLong(BoxesRunTime.unboxToByte(trailerChunk.apply(0)), BoxesRunTime.unboxToByte(trailerChunk.apply(1)), BoxesRunTime.unboxToByte(trailerChunk.apply(2)), BoxesRunTime.unboxToByte(trailerChunk.apply(3)));
            long actualInputCrc32 = crc32$28.getValue();
            long expectedInputSize = this.unsignedToLong(BoxesRunTime.unboxToByte(trailerChunk.apply(4)), BoxesRunTime.unboxToByte(trailerChunk.apply(5)), BoxesRunTime.unboxToByte(trailerChunk.apply(6)), BoxesRunTime.unboxToByte(trailerChunk.apply(7)));
            long actualInputSize = inflater$16.getBytesWritten() & 0xFFFFFFFFL;
            pull = expectedInputCrc32 != actualInputCrc32 ? Pull$.MODULE$.raiseError(new ZipException("Content failed CRC validation"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$27)) : (expectedInputSize != actualInputSize ? Pull$.MODULE$.raiseError(new ZipException("Content failed size validation"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$27)) : Pull$.MODULE$.done());
        } else {
            pull = Pull$.MODULE$.raiseError(new ZipException("Failed to read trailer (1)"), RaiseThrowable$.MODULE$.fromApplicativeError(SyncF$27));
        }
        return pull;
    }

    private final Pull streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$1(CRC32 crc32$32, Inflater inflater$20, Sync SyncF$31, Chunk next$1, Stream rest$1) {
        return (Pull)this.streamUntilTrailer$2(crc32$32, inflater$20, SyncF$31, next$1).apply((Object)rest$1);
    }

    private final Pull streamUntilTrailer$3$$anonfun$2$$anonfun$2$$anonfun$2(Chunk next$2) {
        return Pull$.MODULE$.output(next$2);
    }

    private final Pull streamUntilTrailer$4$$anonfun$3$$anonfun$3$$anonfun$3(CRC32 crc32$33, Inflater inflater$21, Sync SyncF$32, Stream rest$2) {
        return (Pull)this.streamUntilTrailer$2(crc32$33, inflater$21, SyncF$32, Chunk$.MODULE$.empty()).apply((Object)rest$2);
    }

    private final Pull streamUntilTrailer$5$$anonfun$4$$anonfun$4$$anonfun$4(CRC32 crc32$34, Inflater inflater$22, Sync SyncF$33, Stream rest$3) {
        return (Pull)this.streamUntilTrailer$2(crc32$34, inflater$22, SyncF$33, Chunk$.MODULE$.empty()).apply((Object)rest$3);
    }

    private final Pull streamUntilTrailer$6$$anonfun$5$$anonfun$5$$anonfun$5(CRC32 crc32$35, Inflater inflater$23, Sync SyncF$34, Chunk last$3, int preTrailerBytes$1) {
        return this.validateTrailer$1(crc32$35, inflater$23, SyncF$34, last$3.drop(preTrailerBytes$1));
    }

    private final Function1 streamUntilTrailer$2(CRC32 crc32$29, Inflater inflater$17, Sync SyncF$28, Chunk last) {
        return (JFunction1 & Serializable)_$30 -> {
            Stream stream = Stream$.MODULE$.InvariantOps(_$30);
            Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
            return Stream$ToPull$.MODULE$.uncons$extension(stream2).flatMap((JFunction1 & Serializable)x$1 -> {
                Pull<Object, Object, Object> pull;
                Tuple2 tuple2;
                Option option = x$1;
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    Chunk next = (Chunk)tuple2._1();
                    Stream rest = (Stream)tuple2._2();
                    pull = inflater$17.finished() ? (next.size() >= gzipTrailerBytes ? (last.nonEmpty() ? Pull$.MODULE$.output(last).$greater$greater(() -> this.streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$1(crc32$29, inflater$17, SyncF$28, next, rest)) : (Pull)this.streamUntilTrailer$2(crc32$29, inflater$17, SyncF$28, next).apply((Object)rest)) : (Pull)this.streamUntilTrailer$2(crc32$29, inflater$17, SyncF$28, last.$plus$plus(next)).apply((Object)rest)) : (last.nonEmpty() ? Pull$.MODULE$.output(last).$greater$greater(() -> this.streamUntilTrailer$3$$anonfun$2$$anonfun$2$$anonfun$2(next)).$greater$greater(() -> this.streamUntilTrailer$4$$anonfun$3$$anonfun$3$$anonfun$3(crc32$29, inflater$17, SyncF$28, rest)) : Pull$.MODULE$.output(next).$greater$greater(() -> this.streamUntilTrailer$5$$anonfun$4$$anonfun$4$$anonfun$4(crc32$29, inflater$17, SyncF$28, rest)));
                } else if (None$.MODULE$.equals(option)) {
                    int preTrailerBytes = last.size() - gzipTrailerBytes;
                    pull = preTrailerBytes > 0 ? Pull$.MODULE$.output(last.take(preTrailerBytes)).$greater$greater(() -> this.streamUntilTrailer$6$$anonfun$5$$anonfun$5$$anonfun$5(crc32$29, inflater$17, SyncF$28, last, preTrailerBytes)) : this.validateTrailer$1(crc32$29, inflater$17, SyncF$28, last);
                } else {
                    throw new MatchError((Object)option);
                }
                return pull;
            });
        };
    }

    private final Pull go$2(Function1 predicate$2, int softLimit$2, ClassTag evidence$1$2, List acc, Stream rest, int size) {
        Stream stream = Stream$.MODULE$.InvariantOps(rest);
        Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
        return Stream$ToPull$.MODULE$.uncons$extension(stream2).flatMap((JFunction1 & Serializable)x$1 -> {
            Pull pull;
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                pull = Pull$.MODULE$.pure(None$.MODULE$);
                return pull;
            } else {
                Tuple2 tuple2;
                if (!(option instanceof Some) || (tuple2 = (Tuple2)((Some)option).value()) == null) throw new MatchError((Object)option);
                Chunk hd = (Chunk)tuple2._1();
                Stream tl = (Stream)tuple2._2();
                Option<Object> option2 = hd.indexWhere(predicate$2);
                if (option2 instanceof Some) {
                    int i = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    Tuple2 tuple22 = hd.splitAt(i);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    Chunk pfx = (Chunk)tuple22._1();
                    Chunk sfx = (Chunk)tuple22._2();
                    Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)pfx, (Object)sfx);
                    Chunk pfx2 = (Chunk)tuple23._1();
                    Chunk sfx2 = (Chunk)tuple23._2();
                    Chunk chunk = (Chunk)Predef$.MODULE$.ArrowAssoc(Chunk$.MODULE$.concat(acc.$colon$colon((Object)pfx2).reverse(), evidence$1$2));
                    pull = Pull$.MODULE$.pure(Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)chunk, tl.cons(sfx2))));
                    return pull;
                } else {
                    if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                    int newSize = size + hd.size();
                    if (newSize < softLimit$2) {
                        pull = this.go$2(predicate$2, softLimit$2, evidence$1$2, acc.$colon$colon((Object)hd), tl, newSize);
                        return pull;
                    } else {
                        Chunk chunk = (Chunk)Predef$.MODULE$.ArrowAssoc(Chunk$.MODULE$.concat(acc.$colon$colon((Object)hd).reverse(), evidence$1$2));
                        pull = Pull$.MODULE$.pure(Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)chunk, (Object)tl)));
                    }
                }
            }
            return pull;
        });
    }

    private final int go$default$3$1() {
        return 0;
    }
}

