/*
 * Decompiled with CFR 0.152.
 */
package fs2.internal;

import fs2.internal.SizedQueue$;
import scala.Option;
import scala.collection.immutable.Queue;

public final class SizedQueue<A> {
    private final Queue underlying;
    private final int size;

    public static SizedQueue empty() {
        return SizedQueue$.MODULE$.empty();
    }

    public static <A> SizedQueue<A> one(A a) {
        return SizedQueue$.MODULE$.one(a);
    }

    public <A> SizedQueue(Queue<A> underlying, int size) {
        this.underlying = underlying;
        this.size = size;
    }

    private Queue<A> underlying() {
        return this.underlying;
    }

    public int size() {
        return this.size;
    }

    public SizedQueue<A> $plus$colon(A a) {
        return new SizedQueue<A>((Queue)this.underlying().$plus$colon(a), this.size() + 1);
    }

    public SizedQueue<A> $colon$plus(A a) {
        return new SizedQueue<A>((Queue)this.underlying().$colon$plus(a), this.size() + 1);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Option<A> headOption() {
        return this.underlying().headOption();
    }

    public SizedQueue<A> tail() {
        return this.isEmpty() ? this : new SizedQueue<A>(this.underlying().tail(), this.size() - 1);
    }

    public Queue<A> toQueue() {
        return this.underlying();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof SizedQueue)) return false;
        SizedQueue that = (SizedQueue)object;
        if (this.size() != that.size()) return false;
        Queue<A> queue = this.underlying();
        Queue<A> queue2 = that.underlying();
        if (queue != null) {
            if (!queue.equals(queue2)) return false;
            return true;
        }
        if (queue2 == null) return true;
        return false;
    }

    public int hashCode() {
        return this.underlying().hashCode();
    }

    public String toString() {
        return this.underlying().mkString("SizedQueue(", ", ", ")");
    }
}

