/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.tls;

import cats.Applicative;
import cats.Applicative$;
import cats.FlatMap;
import cats.Functor;
import cats.effect.Blocker$;
import cats.effect.Concurrent;
import cats.effect.ContextShift;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.syntax.package;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import fs2.Chunk;
import fs2.io.CollectionCompat$;
import fs2.io.CollectionCompat$JIterableOps$;
import fs2.io.tcp.Socket;
import fs2.io.tls.DTLSSocket$;
import fs2.io.tls.TLSContext;
import fs2.io.tls.TLSEngine;
import fs2.io.tls.TLSEngine$;
import fs2.io.tls.TLSParameters;
import fs2.io.tls.TLSSocket$;
import fs2.io.udp.Packet;
import fs2.io.udp.Packet$;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;

public final class TLSContext$
implements Serializable {
    public static final TLSContext$ MODULE$ = new TLSContext$();

    private TLSContext$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TLSContext$.class);
    }

    public TLSContext fromSSLContext(SSLContext ctx, ExecutionContext blocker) {
        return new TLSContext(ctx, blocker){
            private final SSLContext ctx$1;
            private final ExecutionContext blocker$1;
            {
                this.ctx$1 = ctx$2;
                this.blocker$1 = blocker$10;
            }

            public Resource client(Socket socket, TLSParameters params, Option logger, Concurrent evidence$21, ContextShift evidence$22) {
                return this.mkSocket(socket, true, params, logger, evidence$21, evidence$22);
            }

            public Resource server(Socket socket, TLSParameters params, Option logger, Concurrent evidence$23, ContextShift evidence$24) {
                return this.mkSocket(socket, false, params, logger, evidence$23, evidence$24);
            }

            private Resource mkSocket(Socket socket, boolean clientMode, TLSParameters params, Option logger, Concurrent evidence$25, ContextShift evidence$26) {
                return Resource$.MODULE$.liftF(this.engine(new TLSEngine.Binding(socket){
                    private final Socket socket$1;
                    {
                        this.socket$1 = socket$5;
                    }

                    public Object write(Chunk data, Option timeout) {
                        return this.socket$1.write((Chunk<Object>)data, (Option<FiniteDuration>)timeout);
                    }

                    public Object read(int maxBytes, Option timeout) {
                        return this.socket$1.read(maxBytes, (Option<FiniteDuration>)timeout);
                    }
                }, this.blocker$1, clientMode, params, logger, evidence$25, evidence$26), (Applicative)evidence$25).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> TLSContext$.fs2$io$tls$TLSContext$$anon$1$$_$mkSocket$$anonfun$1(socket, evidence$25, arg_0)));
            }

            public Resource dtlsClient(fs2.io.udp.Socket socket, InetSocketAddress remoteAddress, TLSParameters params, Option logger, Concurrent evidence$27, ContextShift evidence$28) {
                return this.mkDtlsSocket(socket, remoteAddress, true, params, logger, evidence$27, evidence$28);
            }

            public Resource dtlsServer(fs2.io.udp.Socket socket, InetSocketAddress remoteAddress, TLSParameters params, Option logger, Concurrent evidence$29, ContextShift evidence$30) {
                return this.mkDtlsSocket(socket, remoteAddress, false, params, logger, evidence$29, evidence$30);
            }

            private Resource mkDtlsSocket(fs2.io.udp.Socket socket, InetSocketAddress remoteAddress, boolean clientMode, TLSParameters params, Option logger, Concurrent evidence$31, ContextShift evidence$32) {
                return Resource$.MODULE$.liftF(this.engine(new TLSEngine.Binding(socket, remoteAddress, evidence$31){
                    private final fs2.io.udp.Socket socket$1;
                    private final InetSocketAddress remoteAddress$1;
                    private final Concurrent evidence$31$1;
                    {
                        this.socket$1 = socket$6;
                        this.remoteAddress$1 = remoteAddress$3;
                        this.evidence$31$1 = evidence$31$3;
                    }

                    public Object write(Chunk data, Option timeout) {
                        return data.isEmpty() ? Applicative$.MODULE$.apply((Applicative)this.evidence$31$1).unit() : this.socket$1.write(Packet$.MODULE$.apply(this.remoteAddress$1, (Chunk<Object>)data), (Option<FiniteDuration>)timeout);
                    }

                    public Object read(int maxBytes, Option timeout) {
                        return package.all$.MODULE$.toFunctorOps(this.socket$1.read((Option<FiniteDuration>)timeout), (Functor)this.evidence$31$1).map((Function1)((JFunction1 & Serializable)TLSContext$::fs2$io$tls$TLSContext$$anon$3$$_$read$$anonfun$1));
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{fs2$io$tls$TLSContext$$anon$3$$_$read$$anonfun$1(fs2.io.udp.Packet )}, serializedLambda);
                    }
                }, this.blocker$1, clientMode, params, logger, evidence$31, evidence$32), (Applicative)evidence$31).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> TLSContext$.fs2$io$tls$TLSContext$$anon$1$$_$mkDtlsSocket$$anonfun$1(socket, remoteAddress, evidence$31, arg_0)));
            }

            private Object engine(TLSEngine.Binding binding, ExecutionContext blocker, boolean clientMode, TLSParameters params, Option logger, Concurrent evidence$33, ContextShift evidence$34) {
                Object sslEngine = Sync$.MODULE$.apply((Sync)evidence$33).delay(() -> this.$anonfun$1(clientMode, params));
                return package.all$.MODULE$.toFlatMapOps(sslEngine, (FlatMap)evidence$33).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> TLSContext$.fs2$io$tls$TLSContext$$anon$1$$_$engine$$anonfun$1(binding, blocker, logger, evidence$33, evidence$34, arg_0)));
            }

            /*
             * WARNING - void declaration
             */
            private final SSLEngine $anonfun$1(boolean clientMode$1, TLSParameters params$1) {
                void var3_3;
                SSLEngine engine = this.ctx$1.createSSLEngine();
                engine.setUseClientMode(clientMode$1);
                engine.setSSLParameters(params$1.toSSLParameters());
                params$1.handshakeApplicationProtocolSelector().foreach((Function1)((JProcedure1 & Serializable)arg_0 -> TLSContext$.fs2$io$tls$TLSContext$$anon$1$$_$_$$anonfun$5$$anonfun$1(engine, arg_0)));
                return var3_3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{fs2$io$tls$TLSContext$$anon$1$$_$mkSocket$$anonfun$1(fs2.io.tcp.Socket cats.effect.Concurrent fs2.io.tls.TLSEngine ), fs2$io$tls$TLSContext$$anon$1$$_$mkDtlsSocket$$anonfun$1(fs2.io.udp.Socket java.net.InetSocketAddress cats.effect.Concurrent fs2.io.tls.TLSEngine ), $anonfun$1(boolean fs2.io.tls.TLSParameters ), fs2$io$tls$TLSContext$$anon$1$$_$engine$$anonfun$1(fs2.io.tls.TLSEngine$Binding scala.concurrent.ExecutionContext scala.Option cats.effect.Concurrent cats.effect.ContextShift javax.net.ssl.SSLEngine ), fs2$io$tls$TLSContext$$anon$1$$_$_$$anonfun$5$$anonfun$1(javax.net.ssl.SSLEngine scala.Function2 )}, serializedLambda);
            }
        };
    }

    public <F> Object insecure(ExecutionContext blocker, Sync<F> evidence$9, ContextShift<F> evidence$10) {
        return package.all$.MODULE$.toFunctorOps(Blocker$.MODULE$.delay$extension(blocker, this::insecure$$anonfun$1, evidence$9, evidence$10), evidence$9).map((Function1)(JFunction1 & Serializable)_$14 -> this.fromSSLContext((SSLContext)_$14, blocker));
    }

    public <F> Object system(ExecutionContext blocker, Sync<F> evidence$11, ContextShift<F> evidence$12) {
        return package.all$.MODULE$.toFunctorOps(Blocker$.MODULE$.delay$extension(blocker, this::system$$anonfun$1, evidence$11, evidence$12), evidence$11).map((Function1)(JFunction1 & Serializable)_$16 -> this.fromSSLContext((SSLContext)_$16, blocker));
    }

    public <F> Object fromKeyStoreFile(Path file, char[] storePassword, char[] keyPassword, ExecutionContext blocker, Sync<F> evidence$13, ContextShift<F> evidence$14) {
        Object load = Blocker$.MODULE$.delay$extension(blocker, () -> this.$anonfun$1(file), evidence$13, evidence$14);
        Resource stream = Resource$.MODULE$.make(load, (Function1)(JFunction1 & Serializable)s -> Blocker$.MODULE$.delay$extension(blocker, (Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$6$$anonfun$1(s)), evidence$13, evidence$14), evidence$13);
        return this.fromKeyStoreStream(stream, storePassword, keyPassword, blocker, evidence$13, evidence$14);
    }

    public <F> Object fromKeyStoreResource(String resource, char[] storePassword, char[] keyPassword, ExecutionContext blocker, Sync<F> evidence$15, ContextShift<F> evidence$16) {
        Object load = Blocker$.MODULE$.delay$extension(blocker, () -> this.$anonfun$3(resource), evidence$15, evidence$16);
        Resource stream = Resource$.MODULE$.make(load, (Function1)(JFunction1 & Serializable)s -> Blocker$.MODULE$.delay$extension(blocker, (Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$7$$anonfun$1(s)), evidence$15, evidence$16), evidence$15);
        return this.fromKeyStoreStream(stream, storePassword, keyPassword, blocker, evidence$15, evidence$16);
    }

    private <F> Object fromKeyStoreStream(Resource<F, InputStream> stream, char[] storePassword, char[] keyPassword, ExecutionContext blocker, Sync<F> evidence$17, ContextShift<F> evidence$18) {
        return stream.use((Function1)(JFunction1 & Serializable)s -> package.all$.MODULE$.toFlatMapOps(Blocker$.MODULE$.delay$extension(blocker, () -> this.fromKeyStoreStream$$anonfun$2$$anonfun$1(storePassword, s), evidence$17, evidence$18), (FlatMap)evidence$17).flatMap((Function1)(JFunction1 & Serializable)_$20 -> this.fromKeyStore((KeyStore)_$20, keyPassword, blocker, evidence$17, evidence$18)), evidence$17);
    }

    public <F> Object fromKeyStore(KeyStore keyStore, char[] keyPassword, ExecutionContext blocker, Sync<F> evidence$19, ContextShift<F> evidence$20) {
        return package.all$.MODULE$.toFunctorOps(Blocker$.MODULE$.delay$extension(blocker, () -> this.fromKeyStore$$anonfun$1(keyStore, keyPassword), evidence$19, evidence$20), evidence$19).map((Function1)(JFunction1 & Serializable)_$22 -> this.fromSSLContext((SSLContext)_$22, blocker));
    }

    public static final /* synthetic */ Resource fs2$io$tls$TLSContext$$anon$1$$_$mkSocket$$anonfun$1(Socket socket$2, Concurrent evidence$25$1, TLSEngine engine) {
        return TLSSocket$.MODULE$.apply(socket$2, engine, evidence$25$1);
    }

    public static final /* synthetic */ Option fs2$io$tls$TLSContext$$anon$3$$_$read$$anonfun$1(Packet p) {
        return Some$.MODULE$.apply(p.bytes());
    }

    public static final /* synthetic */ Resource fs2$io$tls$TLSContext$$anon$1$$_$mkDtlsSocket$$anonfun$1(fs2.io.udp.Socket socket$4, InetSocketAddress remoteAddress$2, Concurrent evidence$31$2, TLSEngine engine) {
        return DTLSSocket$.MODULE$.apply(socket$4, remoteAddress$2, engine, evidence$31$2);
    }

    public static final /* synthetic */ void fs2$io$tls$TLSContext$$anon$1$$_$_$$anonfun$5$$anonfun$1(SSLEngine engine$1, Function2 f) {
        engine$1.setHandshakeApplicationProtocolSelector(new BiFunction(f){
            private final Function2 f$1;
            {
                this.f$1 = f$2;
            }

            public String apply(SSLEngine engine, List protocols) {
                Iterable<A> iterable = CollectionCompat$.MODULE$.JIterableOps(protocols);
                return (String)this.f$1.apply((Object)engine, (Object)CollectionCompat$JIterableOps$.MODULE$.asScala$extension(iterable).toList());
            }
        });
    }

    public static final /* synthetic */ Object fs2$io$tls$TLSContext$$anon$1$$_$engine$$anonfun$1(TLSEngine.Binding binding$1, ExecutionContext blocker$2, Option logger$1, Concurrent evidence$33$1, ContextShift evidence$34$1, SSLEngine _$12) {
        return TLSEngine$.MODULE$.apply(_$12, binding$1, blocker$2, (Option<Function1<String, Object>>)logger$1, evidence$33$1, evidence$34$1);
    }

    /*
     * WARNING - void declaration
     */
    private final SSLContext insecure$$anonfun$1() {
        void var1_1;
        SSLContext ctx = SSLContext.getInstance("TLS");
        X509TrustManager tm = new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] x, String y) {
            }

            public void checkServerTrusted(X509Certificate[] x, String y) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        ctx.init(null, new TrustManager[]{tm}, null);
        return var1_1;
    }

    private final SSLContext system$$anonfun$1() {
        return SSLContext.getDefault();
    }

    private final InputStream $anonfun$1(Path file$1) {
        return new FileInputStream(file$1.toFile());
    }

    private final void $anonfun$6$$anonfun$1(InputStream s$1) {
        s$1.close();
    }

    private final InputStream $anonfun$3(String resource$1) {
        return this.getClass().getClassLoader().getResourceAsStream(resource$1);
    }

    private final void $anonfun$7$$anonfun$1(InputStream s$2) {
        s$2.close();
    }

    /*
     * WARNING - void declaration
     */
    private final KeyStore fromKeyStoreStream$$anonfun$2$$anonfun$1(char[] storePassword$2, InputStream s$3) {
        void var3_3;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(s$3, storePassword$2);
        return var3_3;
    }

    private final SSLContext fromKeyStore$$anonfun$1(KeyStore keyStore$1, char[] keyPassword$3) {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore$1, keyPassword$3);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore$1);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext;
    }
}

