/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.tls;

import cats.Applicative$;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.syntax.package;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import fs2.Chunk;
import fs2.io.CollectionCompat$;
import fs2.io.CollectionCompat$JIterableOps$;
import fs2.io.Network;
import fs2.io.tcp.Socket;
import fs2.io.tls.DTLSSocket$;
import fs2.io.tls.TLSContext;
import fs2.io.tls.TLSEngine;
import fs2.io.tls.TLSEngine$;
import fs2.io.tls.TLSParameters;
import fs2.io.tls.TLSSocket$;
import fs2.io.udp.Packet;
import fs2.io.udp.Packet$;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Some$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;

public final class TLSContext$
implements Serializable {
    public static final TLSContext$ MODULE$ = new TLSContext$();

    private TLSContext$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TLSContext$.class);
    }

    public TLSContext fromSSLContext(SSLContext ctx) {
        return new TLSContext(ctx){
            private final SSLContext ctx$1;
            {
                this.ctx$1 = ctx$2;
            }

            public Resource client(Socket socket, TLSParameters params, Option logger, Network F) {
                return this.mkSocket(socket, true, params, logger, F);
            }

            public Resource server(Socket socket, TLSParameters params, Option logger, Network F) {
                return this.mkSocket(socket, false, params, logger, F);
            }

            private Resource mkSocket(Socket socket, boolean clientMode, TLSParameters params, Option logger, Network F) {
                return Resource$.MODULE$.liftF(this.engine(new TLSEngine.Binding(socket){
                    private final Socket socket$1;
                    {
                        this.socket$1 = socket$5;
                    }

                    public Object write(Chunk data, Option timeout) {
                        return this.socket$1.write((Chunk<Object>)data, (Option<FiniteDuration>)timeout);
                    }

                    public Object read(int maxBytes, Option timeout) {
                        return this.socket$1.read(maxBytes, (Option<FiniteDuration>)timeout);
                    }
                }, clientMode, params, logger, F)).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> TLSContext$.fs2$io$tls$TLSContext$$anon$1$$_$mkSocket$$anonfun$1(socket, F, arg_0)));
            }

            public Resource dtlsClient(fs2.io.udp.Socket socket, InetSocketAddress remoteAddress, TLSParameters params, Option logger, Network F) {
                return this.mkDtlsSocket(socket, remoteAddress, true, params, logger, F);
            }

            public Resource dtlsServer(fs2.io.udp.Socket socket, InetSocketAddress remoteAddress, TLSParameters params, Option logger, Network F) {
                return this.mkDtlsSocket(socket, remoteAddress, false, params, logger, F);
            }

            private Resource mkDtlsSocket(fs2.io.udp.Socket socket, InetSocketAddress remoteAddress, boolean clientMode, TLSParameters params, Option logger, Network F) {
                return Resource$.MODULE$.liftF(this.engine(new TLSEngine.Binding(socket, remoteAddress, F){
                    private final fs2.io.udp.Socket socket$1;
                    private final InetSocketAddress remoteAddress$1;
                    private final Network F$1;
                    {
                        this.socket$1 = socket$6;
                        this.remoteAddress$1 = remoteAddress$3;
                        this.F$1 = F$9;
                    }

                    public Object write(Chunk data, Option timeout) {
                        return data.isEmpty() ? Applicative$.MODULE$.apply(this.F$1.async()).unit() : this.socket$1.write(Packet$.MODULE$.apply(this.remoteAddress$1, (Chunk<Object>)data), (Option<FiniteDuration>)timeout);
                    }

                    public Object read(int maxBytes, Option timeout) {
                        return package.all$.MODULE$.toFunctorOps(this.socket$1.read((Option<FiniteDuration>)timeout), this.F$1.async()).map((Function1)((JFunction1 & Serializable)TLSContext$::fs2$io$tls$TLSContext$$anon$3$$_$read$$anonfun$1));
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{fs2$io$tls$TLSContext$$anon$3$$_$read$$anonfun$1(fs2.io.udp.Packet )}, serializedLambda);
                    }
                }, clientMode, params, logger, F)).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> TLSContext$.fs2$io$tls$TLSContext$$anon$1$$_$mkDtlsSocket$$anonfun$1(socket, remoteAddress, F, arg_0)));
            }

            private Object engine(TLSEngine.Binding binding, boolean clientMode, TLSParameters params, Option logger, Network F) {
                Object sslEngine = F.async().blocking(() -> this.$anonfun$1(clientMode, params));
                return package.all$.MODULE$.toFlatMapOps(sslEngine, F.async()).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> TLSContext$.fs2$io$tls$TLSContext$$anon$1$$_$engine$$anonfun$1(binding, logger, F, arg_0)));
            }

            /*
             * WARNING - void declaration
             */
            private final SSLEngine $anonfun$1(boolean clientMode$1, TLSParameters params$1) {
                void var3_3;
                SSLEngine engine = this.ctx$1.createSSLEngine();
                engine.setUseClientMode(clientMode$1);
                engine.setSSLParameters(params$1.toSSLParameters());
                params$1.handshakeApplicationProtocolSelector().foreach((Function1)((JProcedure1 & Serializable)arg_0 -> TLSContext$.fs2$io$tls$TLSContext$$anon$1$$_$_$$anonfun$5$$anonfun$1(engine, arg_0)));
                return var3_3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{fs2$io$tls$TLSContext$$anon$1$$_$mkSocket$$anonfun$1(fs2.io.tcp.Socket fs2.io.Network fs2.io.tls.TLSEngine ), fs2$io$tls$TLSContext$$anon$1$$_$mkDtlsSocket$$anonfun$1(fs2.io.udp.Socket java.net.InetSocketAddress fs2.io.Network fs2.io.tls.TLSEngine ), $anonfun$1(boolean fs2.io.tls.TLSParameters ), fs2$io$tls$TLSContext$$anon$1$$_$engine$$anonfun$1(fs2.io.tls.TLSEngine$Binding scala.Option fs2.io.Network javax.net.ssl.SSLEngine ), fs2$io$tls$TLSContext$$anon$1$$_$_$$anonfun$5$$anonfun$1(javax.net.ssl.SSLEngine scala.Function2 )}, serializedLambda);
            }
        };
    }

    public <F> Object insecure(Network<F> F) {
        return package.all$.MODULE$.toFunctorOps(F.async().blocking(this::insecure$$anonfun$1), F.async()).map((Function1)(JFunction1 & Serializable)_$14 -> this.fromSSLContext((SSLContext)_$14));
    }

    public <F> Object system(Network<F> F) {
        return package.all$.MODULE$.toFunctorOps(F.async().blocking(this::system$$anonfun$1), F.async()).map((Function1)(JFunction1 & Serializable)_$16 -> this.fromSSLContext((SSLContext)_$16));
    }

    public <F> Object fromKeyStoreFile(Path file, char[] storePassword, char[] keyPassword, Network<F> F) {
        Object load = F.async().blocking(() -> this.$anonfun$1(file));
        Resource stream = Resource$.MODULE$.make(load, (Function1)(JFunction1 & Serializable)s -> F.async().blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$6$$anonfun$1(s))), F.async());
        return this.fromKeyStoreStream(stream, storePassword, keyPassword, F);
    }

    public <F> Object fromKeyStoreResource(String resource, char[] storePassword, char[] keyPassword, Network<F> F) {
        Object load = F.async().blocking(() -> this.$anonfun$3(resource));
        Resource stream = Resource$.MODULE$.make(load, (Function1)(JFunction1 & Serializable)s -> F.async().blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$7$$anonfun$1(s))), F.async());
        return this.fromKeyStoreStream(stream, storePassword, keyPassword, F);
    }

    private <F> Object fromKeyStoreStream(Resource<F, InputStream> stream, char[] storePassword, char[] keyPassword, Network<F> F) {
        return stream.use((Function1)(JFunction1 & Serializable)s -> package.all$.MODULE$.toFlatMapOps(F.async().blocking(() -> this.fromKeyStoreStream$$anonfun$2$$anonfun$1(storePassword, s)), F.async()).flatMap((Function1)(JFunction1 & Serializable)_$20 -> this.fromKeyStore((KeyStore)_$20, keyPassword, F)), F.async());
    }

    public <F> Object fromKeyStore(KeyStore keyStore, char[] keyPassword, Network<F> F) {
        return package.all$.MODULE$.toFunctorOps(F.async().blocking(() -> this.fromKeyStore$$anonfun$1(keyStore, keyPassword)), F.async()).map((Function1)(JFunction1 & Serializable)_$22 -> this.fromSSLContext((SSLContext)_$22));
    }

    public static final /* synthetic */ Resource fs2$io$tls$TLSContext$$anon$1$$_$mkSocket$$anonfun$1(Socket socket$2, Network F$1, TLSEngine engine) {
        return TLSSocket$.MODULE$.apply(socket$2, engine, F$1.async());
    }

    public static final /* synthetic */ Option fs2$io$tls$TLSContext$$anon$3$$_$read$$anonfun$1(Packet p) {
        return Some$.MODULE$.apply(p.bytes());
    }

    public static final /* synthetic */ Resource fs2$io$tls$TLSContext$$anon$1$$_$mkDtlsSocket$$anonfun$1(fs2.io.udp.Socket socket$4, InetSocketAddress remoteAddress$2, Network F$3, TLSEngine engine) {
        return DTLSSocket$.MODULE$.apply(socket$4, remoteAddress$2, engine, F$3.async());
    }

    public static final /* synthetic */ void fs2$io$tls$TLSContext$$anon$1$$_$_$$anonfun$5$$anonfun$1(SSLEngine engine$1, Function2 f) {
        engine$1.setHandshakeApplicationProtocolSelector(new BiFunction(f){
            private final Function2 f$1;
            {
                this.f$1 = f$2;
            }

            public String apply(SSLEngine engine, List protocols) {
                Iterable<A> iterable = CollectionCompat$.MODULE$.JIterableOps(protocols);
                return (String)this.f$1.apply((Object)engine, (Object)CollectionCompat$JIterableOps$.MODULE$.asScala$extension(iterable).toList());
            }
        });
    }

    public static final /* synthetic */ Object fs2$io$tls$TLSContext$$anon$1$$_$engine$$anonfun$1(TLSEngine.Binding binding$1, Option logger$1, Network F$4, SSLEngine _$12) {
        return TLSEngine$.MODULE$.apply(_$12, binding$1, (Option<Function1<String, Object>>)logger$1, F$4.async());
    }

    /*
     * WARNING - void declaration
     */
    private final SSLContext insecure$$anonfun$1() {
        void var1_1;
        SSLContext ctx = SSLContext.getInstance("TLS");
        X509TrustManager tm = new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] x, String y) {
            }

            public void checkServerTrusted(X509Certificate[] x, String y) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        ctx.init(null, new TrustManager[]{tm}, null);
        return var1_1;
    }

    private final SSLContext system$$anonfun$1() {
        return SSLContext.getDefault();
    }

    private final InputStream $anonfun$1(Path file$1) {
        return new FileInputStream(file$1.toFile());
    }

    private final void $anonfun$6$$anonfun$1(InputStream s$1) {
        s$1.close();
    }

    private final InputStream $anonfun$3(String resource$1) {
        return this.getClass().getClassLoader().getResourceAsStream(resource$1);
    }

    private final void $anonfun$7$$anonfun$1(InputStream s$2) {
        s$2.close();
    }

    /*
     * WARNING - void declaration
     */
    private final KeyStore fromKeyStoreStream$$anonfun$2$$anonfun$1(char[] storePassword$2, InputStream s$3) {
        void var3_3;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(s$3, storePassword$2);
        return var3_3;
    }

    private final SSLContext fromKeyStore$$anonfun$1(KeyStore keyStore$1, char[] keyPassword$3) {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore$1, keyPassword$3);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore$1);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext;
    }
}

