/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.tls;

import cats.Applicative;
import cats.Applicative$;
import cats.FlatMap;
import cats.Functor;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Sync;
import cats.effect.package$;
import cats.syntax.package;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import fs2.Chunk;
import fs2.io.tcp.Socket;
import fs2.io.tls.DTLSSocket$;
import fs2.io.tls.TLSContext;
import fs2.io.tls.TLSEngine;
import fs2.io.tls.TLSEngine$;
import fs2.io.tls.TLSParameters;
import fs2.io.tls.TLSSocket$;
import fs2.io.udp.Packet;
import fs2.io.udp.Packet$;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;

public final class TLSContext$
implements Serializable {
    public static final TLSContext$ MODULE$ = new TLSContext$();

    private TLSContext$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TLSContext$.class);
    }

    public TLSContext fromSSLContext(SSLContext ctx) {
        return new TLSContext(ctx){
            private final SSLContext ctx$1;
            {
                this.ctx$1 = ctx$2;
            }

            public Resource client(Socket socket, TLSParameters params, Option logger, Async F) {
                return this.mkSocket(socket, true, params, logger, F);
            }

            public Resource server(Socket socket, TLSParameters params, Option logger, Async F) {
                return this.mkSocket(socket, false, params, logger, F);
            }

            private Resource mkSocket(Socket socket, boolean clientMode, TLSParameters params, Option logger, Async F) {
                return Resource$.MODULE$.liftF(this.engine(new TLSEngine.Binding(socket){
                    private final Socket socket$1;
                    {
                        this.socket$1 = socket$5;
                    }

                    public Object write(Chunk data, Option timeout) {
                        return this.socket$1.write((Chunk<Object>)data, (Option<FiniteDuration>)timeout);
                    }

                    public Object read(int maxBytes, Option timeout) {
                        return this.socket$1.read(maxBytes, (Option<FiniteDuration>)timeout);
                    }
                }, clientMode, params, logger, F), (Applicative)F).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> TLSContext$.fs2$io$tls$TLSContext$$anon$1$$_$mkSocket$$anonfun$1(socket, F, arg_0)));
            }

            public Resource dtlsClient(fs2.io.udp.Socket socket, InetSocketAddress remoteAddress, TLSParameters params, Option logger, Async F) {
                return this.mkDtlsSocket(socket, remoteAddress, true, params, logger, F);
            }

            public Resource dtlsServer(fs2.io.udp.Socket socket, InetSocketAddress remoteAddress, TLSParameters params, Option logger, Async F) {
                return this.mkDtlsSocket(socket, remoteAddress, false, params, logger, F);
            }

            private Resource mkDtlsSocket(fs2.io.udp.Socket socket, InetSocketAddress remoteAddress, boolean clientMode, TLSParameters params, Option logger, Async F) {
                return Resource$.MODULE$.liftF(this.engine(new TLSEngine.Binding(socket, remoteAddress, F){
                    private final fs2.io.udp.Socket socket$1;
                    private final InetSocketAddress remoteAddress$1;
                    private final Async F$1;
                    {
                        this.socket$1 = socket$6;
                        this.remoteAddress$1 = remoteAddress$3;
                        this.F$1 = F$5;
                    }

                    public Object write(Chunk data, Option timeout) {
                        return data.isEmpty() ? Applicative$.MODULE$.apply((Applicative)this.F$1).unit() : this.socket$1.write(Packet$.MODULE$.apply(this.remoteAddress$1, (Chunk<Object>)data), (Option<FiniteDuration>)timeout);
                    }

                    public Object read(int maxBytes, Option timeout) {
                        return package.all$.MODULE$.toFunctorOps(this.socket$1.read((Option<FiniteDuration>)timeout), (Functor)this.F$1).map((Function1)((JFunction1 & Serializable)TLSContext$::fs2$io$tls$TLSContext$$anon$3$$_$read$$anonfun$1));
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{fs2$io$tls$TLSContext$$anon$3$$_$read$$anonfun$1(fs2.io.udp.Packet )}, serializedLambda);
                    }
                }, clientMode, params, logger, F), (Applicative)F).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> TLSContext$.fs2$io$tls$TLSContext$$anon$1$$_$mkDtlsSocket$$anonfun$1(socket, remoteAddress, F, arg_0)));
            }

            private Object engine(TLSEngine.Binding binding, boolean clientMode, TLSParameters params, Option logger, Async F) {
                Object sslEngine = package$.MODULE$.Sync().apply((Sync)F).blocking(() -> this.$anonfun$1(clientMode, params));
                return package.all$.MODULE$.toFlatMapOps(sslEngine, (FlatMap)F).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> TLSContext$.fs2$io$tls$TLSContext$$anon$1$$_$engine$$anonfun$1(binding, logger, F, arg_0)));
            }

            /*
             * WARNING - void declaration
             */
            private final SSLEngine $anonfun$1(boolean clientMode$1, TLSParameters params$1) {
                void var3_3;
                SSLEngine engine = this.ctx$1.createSSLEngine();
                engine.setUseClientMode(clientMode$1);
                engine.setSSLParameters(params$1.toSSLParameters());
                return var3_3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{fs2$io$tls$TLSContext$$anon$1$$_$mkSocket$$anonfun$1(fs2.io.tcp.Socket cats.effect.kernel.Async fs2.io.tls.TLSEngine ), fs2$io$tls$TLSContext$$anon$1$$_$mkDtlsSocket$$anonfun$1(fs2.io.udp.Socket java.net.InetSocketAddress cats.effect.kernel.Async fs2.io.tls.TLSEngine ), $anonfun$1(boolean fs2.io.tls.TLSParameters ), fs2$io$tls$TLSContext$$anon$1$$_$engine$$anonfun$1(fs2.io.tls.TLSEngine$Binding scala.Option cats.effect.kernel.Async javax.net.ssl.SSLEngine )}, serializedLambda);
            }
        };
    }

    public <F> Object insecure(Sync<F> evidence$1) {
        return package.all$.MODULE$.toFunctorOps(package$.MODULE$.Sync().apply(evidence$1).blocking(this::insecure$$anonfun$1), evidence$1).map((Function1)(JFunction1 & Serializable)_$14 -> this.fromSSLContext((SSLContext)_$14));
    }

    public <F> Object system(Sync<F> evidence$2) {
        return package.all$.MODULE$.toFunctorOps(package$.MODULE$.Sync().apply(evidence$2).blocking(this::system$$anonfun$1), evidence$2).map((Function1)(JFunction1 & Serializable)_$16 -> this.fromSSLContext((SSLContext)_$16));
    }

    public <F> Object fromKeyStoreFile(Path file, char[] storePassword, char[] keyPassword, Async<F> evidence$3) {
        Object load = package$.MODULE$.Sync().apply(evidence$3).blocking(() -> this.$anonfun$1(file));
        Resource stream = Resource$.MODULE$.make(load, (Function1)(JFunction1 & Serializable)s -> package$.MODULE$.Sync().apply((Sync)evidence$3).blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$5$$anonfun$1(s))), evidence$3);
        return this.fromKeyStoreStream(stream, storePassword, keyPassword, evidence$3);
    }

    public <F> Object fromKeyStoreResource(String resource, char[] storePassword, char[] keyPassword, Async<F> evidence$4) {
        Object load = package$.MODULE$.Sync().apply(evidence$4).blocking(() -> this.$anonfun$3(resource));
        Resource stream = Resource$.MODULE$.make(load, (Function1)(JFunction1 & Serializable)s -> package$.MODULE$.Sync().apply((Sync)evidence$4).blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.$anonfun$6$$anonfun$1(s))), evidence$4);
        return this.fromKeyStoreStream(stream, storePassword, keyPassword, evidence$4);
    }

    private <F> Object fromKeyStoreStream(Resource<F, InputStream> stream, char[] storePassword, char[] keyPassword, Async<F> evidence$5) {
        return stream.use((Function1)(JFunction1 & Serializable)s -> package.all$.MODULE$.toFlatMapOps(package$.MODULE$.Sync().apply((Sync)evidence$5).blocking(() -> this.fromKeyStoreStream$$anonfun$2$$anonfun$1(storePassword, s)), (FlatMap)evidence$5).flatMap((Function1)(JFunction1 & Serializable)_$20 -> this.fromKeyStore((KeyStore)_$20, keyPassword, (Sync)evidence$5)), Resource.Bracket$.MODULE$.catsEffectResourceBracketForConcurrent(evidence$5));
    }

    public <F> Object fromKeyStore(KeyStore keyStore, char[] keyPassword, Sync<F> evidence$6) {
        return package.all$.MODULE$.toFunctorOps(package$.MODULE$.Sync().apply(evidence$6).blocking(() -> this.fromKeyStore$$anonfun$1(keyStore, keyPassword)), evidence$6).map((Function1)(JFunction1 & Serializable)_$22 -> this.fromSSLContext((SSLContext)_$22));
    }

    public static final /* synthetic */ Resource fs2$io$tls$TLSContext$$anon$1$$_$mkSocket$$anonfun$1(Socket socket$2, Async F$1, TLSEngine engine) {
        return TLSSocket$.MODULE$.apply(socket$2, engine, F$1);
    }

    public static final /* synthetic */ Option fs2$io$tls$TLSContext$$anon$3$$_$read$$anonfun$1(Packet p) {
        return Some$.MODULE$.apply(p.bytes());
    }

    public static final /* synthetic */ Resource fs2$io$tls$TLSContext$$anon$1$$_$mkDtlsSocket$$anonfun$1(fs2.io.udp.Socket socket$4, InetSocketAddress remoteAddress$2, Async F$3, TLSEngine engine) {
        return DTLSSocket$.MODULE$.apply(socket$4, remoteAddress$2, engine, F$3);
    }

    public static final /* synthetic */ Object fs2$io$tls$TLSContext$$anon$1$$_$engine$$anonfun$1(TLSEngine.Binding binding$1, Option logger$1, Async F$4, SSLEngine _$12) {
        return TLSEngine$.MODULE$.apply(_$12, binding$1, (Option<Function1<String, Object>>)logger$1, F$4);
    }

    /*
     * WARNING - void declaration
     */
    private final SSLContext insecure$$anonfun$1() {
        void var1_1;
        SSLContext ctx = SSLContext.getInstance("TLS");
        X509TrustManager tm = new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] x, String y) {
            }

            public void checkServerTrusted(X509Certificate[] x, String y) {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        ctx.init(null, new TrustManager[]{tm}, null);
        return var1_1;
    }

    private final SSLContext system$$anonfun$1() {
        return SSLContext.getDefault();
    }

    private final InputStream $anonfun$1(Path file$1) {
        return new FileInputStream(file$1.toFile());
    }

    private final void $anonfun$5$$anonfun$1(InputStream s$1) {
        s$1.close();
    }

    private final InputStream $anonfun$3(String resource$1) {
        return this.getClass().getClassLoader().getResourceAsStream(resource$1);
    }

    private final void $anonfun$6$$anonfun$1(InputStream s$2) {
        s$2.close();
    }

    /*
     * WARNING - void declaration
     */
    private final KeyStore fromKeyStoreStream$$anonfun$2$$anonfun$1(char[] storePassword$2, InputStream s$3) {
        void var3_3;
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(s$3, storePassword$2);
        return var3_3;
    }

    private final SSLContext fromKeyStore$$anonfun$1(KeyStore keyStore$1, char[] keyPassword$3) {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore$1, keyPassword$3);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore$1);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        return sslContext;
    }
}

