/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.file;

import cats.Functor;
import cats.arrow.FunctionK;
import cats.arrow.FunctionK$;
import cats.effect.Resource;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Temporal;
import cats.implicits$;
import dotty.runtime.function.JFunction1;
import fs2.Chunk;
import fs2.Pull;
import fs2.Pull$;
import fs2.io.file.FileHandle;
import fs2.io.file.ReadCursor$;
import java.io.Serializable;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ReadCursor<F>
implements Product,
Serializable {
    private final FileHandle file;
    private final long offset;

    public static <F> ReadCursor<F> apply(FileHandle<F> fileHandle, long l) {
        return ReadCursor$.MODULE$.apply(fileHandle, l);
    }

    public static <F> Resource<F, ReadCursor<F>> fromPath(Path path, Seq<OpenOption> seq, Sync<F> sync) {
        return ReadCursor$.MODULE$.fromPath(path, seq, sync);
    }

    public static ReadCursor fromProduct(Product product) {
        return ReadCursor$.MODULE$.fromProduct(product);
    }

    public static <F> ReadCursor<F> unapply(ReadCursor<F> readCursor) {
        return ReadCursor$.MODULE$.unapply(readCursor);
    }

    public static Nil$ fromPath$default$2() {
        return ReadCursor$.MODULE$.fromPath$default$2();
    }

    public <F> ReadCursor(FileHandle<F> file, long offset) {
        this.file = file;
        this.offset = offset;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.file()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.offset()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof ReadCursor)) return false;
        ReadCursor readCursor = (ReadCursor)object;
        if (this.offset() != readCursor.offset()) return false;
        FileHandle<F> fileHandle = this.file();
        FileHandle<F> fileHandle2 = readCursor.file();
        if (fileHandle != null) {
            if (!fileHandle.equals(fileHandle2)) return false;
            return true;
        }
        if (fileHandle2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof ReadCursor;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "ReadCursor";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        if (0 == n2) {
            object = this._1();
        } else if (1 == n2) {
            object = BoxesRunTime.boxToLong((long)this._2());
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "file";
        } else if (1 == n2) {
            string = "offset";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public FileHandle<F> file() {
        return this.file;
    }

    public long offset() {
        return this.offset;
    }

    public F read(int chunkSize, Functor<F> F) {
        return (F)this.read_(chunkSize, FunctionK$.MODULE$.id(), F);
    }

    public Pull<F, Nothing$, Option<Tuple2<ReadCursor<F>, Chunk<Object>>>> readPull(int chunkSize) {
        return (Pull)this.read_(chunkSize, (FunctionK)Pull$.MODULE$.functionKInstance(), (Functor)Pull$.MODULE$.monadErrorInstance());
    }

    private <G> Object read_(int chunkSize, FunctionK<F, G> u, Functor<G> evidence$1) {
        return implicits$.MODULE$.toFunctorOps(u.apply(this.file().read(chunkSize, this.offset())), evidence$1).map((Function1)(JFunction1 & Serializable)_$3 -> _$3.map((Function1)(JFunction1 & Serializable)chunk -> {
            ReadCursor<F> next = ReadCursor$.MODULE$.apply(this.file(), this.offset() + (long)chunk.size());
            return Tuple2$.MODULE$.apply(next, chunk);
        }));
    }

    public Pull<F, Object, ReadCursor<F>> readAll(int chunkSize) {
        return this.readPull(chunkSize).flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            Pull pull;
            Tuple2 tuple2;
            Option option = x$1;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                ReadCursor next = (ReadCursor)tuple2._1();
                Chunk chunk = (Chunk)tuple2._2();
                pull = Pull$.MODULE$.output(chunk).$greater$greater(() -> ReadCursor.readAll$$anonfun$2$$anonfun$1(chunkSize, next));
            } else if (None$.MODULE$.equals(option)) {
                pull = Pull$.MODULE$.pure((Object)this);
            } else {
                throw new MatchError((Object)option);
            }
            return pull;
        });
    }

    public Pull<F, Object, ReadCursor<F>> readUntil(int chunkSize, long end) {
        Pull pull;
        if (this.offset() < end) {
            int toRead = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper((int)RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(end - this.offset()), Integer.MAX_VALUE)), chunkSize);
            pull = this.readPull(toRead).flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
                Pull pull;
                Tuple2 tuple2;
                Option option = x$1;
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    ReadCursor next = (ReadCursor)tuple2._1();
                    Chunk chunk = (Chunk)tuple2._2();
                    pull = Pull$.MODULE$.output(chunk).$greater$greater(() -> ReadCursor.readUntil$$anonfun$2$$anonfun$1(chunkSize, end, next));
                } else if (None$.MODULE$.equals(option)) {
                    pull = Pull$.MODULE$.pure((Object)this);
                } else {
                    throw new MatchError((Object)option);
                }
                return pull;
            });
        } else {
            pull = Pull$.MODULE$.pure((Object)this);
        }
        return pull;
    }

    public ReadCursor<F> seek(long position) {
        return ReadCursor$.MODULE$.apply(this.file(), position);
    }

    public Pull<F, Object, ReadCursor<F>> tail(int chunkSize, FiniteDuration pollDelay, Temporal<F, Throwable> t) {
        return this.readPull(chunkSize).flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            Pull pull;
            Tuple2 tuple2;
            Option option = x$1;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                ReadCursor next = (ReadCursor)tuple2._1();
                Chunk chunk = (Chunk)tuple2._2();
                pull = Pull$.MODULE$.output(chunk).$greater$greater(() -> ReadCursor.tail$$anonfun$2$$anonfun$1(chunkSize, pollDelay, t, next));
            } else if (None$.MODULE$.equals(option)) {
                pull = Pull$.MODULE$.eval(t.sleep(pollDelay)).$greater$greater(() -> this.tail$$anonfun$3$$anonfun$2(chunkSize, pollDelay, t));
            } else {
                throw new MatchError((Object)option);
            }
            return pull;
        });
    }

    public <F> ReadCursor<F> copy(FileHandle<F> file, long offset) {
        return new ReadCursor<F>(file, offset);
    }

    public <F> FileHandle<F> copy$default$1() {
        return this.file();
    }

    public long copy$default$2() {
        return this.offset();
    }

    public FileHandle<F> _1() {
        return this.file();
    }

    public long _2() {
        return this.offset();
    }

    private static final Pull readAll$$anonfun$2$$anonfun$1(int chunkSize$1, ReadCursor next$1) {
        return next$1.readAll(chunkSize$1);
    }

    private static final Pull readUntil$$anonfun$2$$anonfun$1(int chunkSize$3, long end$1, ReadCursor next$2) {
        return next$2.readUntil(chunkSize$3, end$1);
    }

    private static final Pull tail$$anonfun$2$$anonfun$1(int chunkSize$5, FiniteDuration pollDelay$1, Temporal t$1, ReadCursor next$3) {
        return next$3.tail(chunkSize$5, pollDelay$1, t$1);
    }

    private final Pull tail$$anonfun$3$$anonfun$2(int chunkSize$7, FiniteDuration pollDelay$3, Temporal t$3) {
        return this.tail(chunkSize$7, pollDelay$3, t$3);
    }
}

