/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.tcp;

import cats.ApplicativeError;
import cats.FlatMap;
import cats.Functor;
import cats.effect.Resource;
import cats.effect.Resource$;
import cats.effect.concurrent.Deferred;
import cats.effect.concurrent.Ref;
import cats.effect.concurrent.Ref$;
import cats.effect.concurrent.Semaphore;
import cats.effect.concurrent.Semaphore$;
import cats.effect.kernel.Async;
import cats.implicits$;
import cats.syntax.ApplicativeErrorOps$;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.NotNothing$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.tcp.Socket;
import fs2.io.tcp.SocketGroup$;
import fs2.io.tcp.SocketOptionMapping;
import fs2.io.tcp.SocketOptionMapping$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3$;
import scala.collection.immutable.List;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichLong$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class SocketGroup {
    private final AsynchronousChannelGroup channelGroup;

    public static int apply$default$1() {
        return SocketGroup$.MODULE$.apply$default$1();
    }

    public static ThreadFactory apply$default$2() {
        return SocketGroup$.MODULE$.apply$default$2();
    }

    public SocketGroup(AsynchronousChannelGroup channelGroup) {
        this.channelGroup = channelGroup;
    }

    public <F> Resource<F, Socket<F>> client(InetSocketAddress to, boolean reuseAddress, int sendBufferSize, int receiveBufferSize, boolean keepAlive, boolean noDelay, List<SocketOptionMapping<?>> additionalSocketOptions, Async<F> F) {
        return Resource$.MODULE$.liftF(implicits$.MODULE$.toFlatMapOps(this.setup$1(reuseAddress, sendBufferSize, receiveBufferSize, keepAlive, noDelay, additionalSocketOptions, F), F).flatMap((Function1)(JFunction1 & Serializable)ch -> SocketGroup.connect$2(to, F, ch)), F).flatMap((Function1)(JFunction1 & Serializable)_$2 -> this.apply((AsynchronousSocketChannel)_$2, F));
    }

    public boolean client$default$2() {
        return true;
    }

    public int client$default$3() {
        return 262144;
    }

    public int client$default$4() {
        return 262144;
    }

    public boolean client$default$5() {
        return false;
    }

    public boolean client$default$6() {
        return false;
    }

    public <F> List<SocketOptionMapping<?>> client$default$7() {
        return package$.MODULE$.List().empty();
    }

    public <F> Stream<F, Resource<F, Socket<F>>> server(InetSocketAddress address, boolean reuseAddress, int receiveBufferSize, List<SocketOptionMapping<?>> additionalSocketOptions, Async<F> F) {
        return Stream$.MODULE$.resource(this.serverResource(address, reuseAddress, receiveBufferSize, additionalSocketOptions, F)).flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Stream clients = (Stream)tuple2._2();
            return clients;
        }, NotNothing$.MODULE$.instance());
    }

    public boolean server$default$2() {
        return true;
    }

    public int server$default$3() {
        return 262144;
    }

    public <F> List<SocketOptionMapping<?>> server$default$4() {
        return package$.MODULE$.List().empty();
    }

    public <F> Resource<F, Tuple2<InetSocketAddress, Stream<F, Resource<F, Socket<F>>>>> serverResource(InetSocketAddress address, boolean reuseAddress, int receiveBufferSize, List<SocketOptionMapping<?>> additionalSocketOptions, Async<F> F) {
        Object setup = F.blocking(() -> this.$anonfun$1(address, reuseAddress, receiveBufferSize, additionalSocketOptions));
        return Resource$.MODULE$.make(setup, (Function1)(JFunction1 & Serializable)sch -> SocketGroup.cleanup$2(F, sch), F).map((Function1)(JFunction1 & Serializable)sch -> {
            InetSocketAddress localAddress = (InetSocketAddress)sch.getLocalAddress();
            return Tuple2$.MODULE$.apply((Object)localAddress, (Object)this.acceptIncoming$5(F, (AsynchronousServerSocketChannel)sch));
        }, F);
    }

    public boolean serverResource$default$2() {
        return true;
    }

    public int serverResource$default$3() {
        return 262144;
    }

    public <F> List<SocketOptionMapping<?>> serverResource$default$4() {
        return package$.MODULE$.List().empty();
    }

    private <F> Resource<F, Socket<F>> apply(AsynchronousSocketChannel ch, Async<F> F) {
        Ref.MkIn mkIn = Ref$.MODULE$.apply(Ref.MkIn$.MODULE$.instance(F, F));
        Object socket = implicits$.MODULE$.catsSyntaxTuple3Semigroupal(Tuple3$.MODULE$.apply(Semaphore$.MODULE$.apply(1L, Semaphore.MkIn$.MODULE$.instance(Ref.MkIn$.MODULE$.instance(F, F), Deferred.MkIn$.MODULE$.instance(F, F), F, F)), Semaphore$.MODULE$.apply(1L, Semaphore.MkIn$.MODULE$.instance(Ref.MkIn$.MODULE$.instance(F, F), Deferred.MkIn$.MODULE$.instance(F, F), F, F)), Ref.ApplyBuilders$.MODULE$.of$extension(mkIn, (Object)ByteBuffer.allocate(0)))).mapN((Function3 & Serializable)(readSemaphore, writeSemaphore, bufferRef) -> new Socket(ch, F, (Semaphore)readSemaphore, (Semaphore)writeSemaphore, (Ref)bufferRef, this){
            private final AsynchronousSocketChannel ch$1;
            private final Async F$1;
            private final Semaphore readSemaphore$1;
            private final Semaphore writeSemaphore$1;
            private final Ref bufferRef$1;
            {
                this.ch$1 = ch$22;
                this.F$1 = F$33;
                this.readSemaphore$1 = readSemaphore$4;
                this.writeSemaphore$1 = writeSemaphore$3;
                this.bufferRef$1 = bufferRef$7;
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Object readN(int numBytes, Option timeout) {
                return SocketGroup.fs2$io$tcp$SocketGroup$$_$readN0$4(this.ch$1, this.F$1, this.readSemaphore$1, this.bufferRef$1, numBytes, timeout);
            }

            public Object read(int maxBytes, Option timeout) {
                return SocketGroup.fs2$io$tcp$SocketGroup$$_$read0$6(this.ch$1, this.F$1, this.readSemaphore$1, this.bufferRef$1, maxBytes, timeout);
            }

            public Stream reads(int maxBytes, Option timeout) {
                return Stream$.MODULE$.eval(this.read(maxBytes, timeout)).flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
                    Stream stream;
                    Option option = x$1;
                    if (option instanceof Some) {
                        Chunk bytes = (Chunk)((Some)option).value();
                        stream = Stream$.MODULE$.chunk(bytes).$plus$plus(() -> this.reads$$anonfun$2$$anonfun$1(maxBytes, timeout));
                    } else if (None$.MODULE$.equals(option)) {
                        stream = Stream$.MODULE$.empty();
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return stream;
                }, NotNothing$.MODULE$.instance());
            }

            public Object write(Chunk bytes, Option timeout) {
                return SocketGroup.fs2$io$tcp$SocketGroup$$_$write0$3(this.ch$1, this.F$1, this.writeSemaphore$1, bytes, timeout);
            }

            public Function1 writes(Option timeout) {
                return (JFunction1 & Serializable)_$11 -> _$11.chunks().foreach((Function1)(JFunction1 & Serializable)_$12 -> this.write((Chunk)_$12, timeout));
            }

            public Object localAddress() {
                return this.F$1.blocking(this::localAddress$$anonfun$1);
            }

            public Object remoteAddress() {
                return this.F$1.blocking(this::remoteAddress$$anonfun$1);
            }

            public Object isOpen() {
                return this.F$1.blocking((Function0)((JFunction0.mcZ.sp & Serializable)this::isOpen$$anonfun$1));
            }

            public Object close() {
                return this.F$1.blocking((Function0)((JFunction0.mcV.sp & Serializable)this::close$$anonfun$1));
            }

            public Object endOfOutput() {
                return this.F$1.blocking((Function0)((JFunction0.mcV.sp & Serializable)this::endOfOutput$$anonfun$1));
            }

            public Object endOfInput() {
                return this.F$1.blocking((Function0)((JFunction0.mcV.sp & Serializable)this::endOfInput$$anonfun$1));
            }

            private final Stream reads$$anonfun$2$$anonfun$1(int maxBytes$2, Option timeout$4) {
                return this.reads(maxBytes$2, timeout$4);
            }

            private final SocketAddress localAddress$$anonfun$1() {
                return this.ch$1.getLocalAddress();
            }

            private final SocketAddress remoteAddress$$anonfun$1() {
                return this.ch$1.getRemoteAddress();
            }

            private final boolean isOpen$$anonfun$1() {
                return this.ch$1.isOpen();
            }

            private final void close$$anonfun$1() {
                this.ch$1.close();
            }

            private final void endOfOutput$$anonfun$1() {
                this.ch$1.shutdownOutput();
            }

            private final void endOfInput$$anonfun$1() {
                this.ch$1.shutdownInput();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{reads$$anonfun$1(int scala.Option scala.Option ), writes$$anonfun$1(scala.Option fs2.Stream ), localAddress$$anonfun$1(), remoteAddress$$anonfun$1(), isOpen$$anonfun$1(), close$$anonfun$1(), endOfOutput$$anonfun$1(), endOfInput$$anonfun$1(), reads$$anonfun$2$$anonfun$1(int scala.Option ), writes$$anonfun$2$$anonfun$1(scala.Option fs2.Chunk )}, serializedLambda);
            }
        }, F, F);
        return Resource$.MODULE$.make(socket, (Function1)(JFunction1 & Serializable)_$13 -> {
            Object object = implicits$.MODULE$.catsSyntaxApplicativeError(F.blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> SocketGroup.apply$$anonfun$2$$anonfun$1(ch))), (ApplicativeError)F);
            return implicits$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, (ApplicativeError)F), (Functor)F).void();
        }, F);
    }

    private final AsynchronousSocketChannel setup$3$$anonfun$2(boolean reuseAddress$2, int sendBufferSize$2, int receiveBufferSize$2, boolean keepAlive$2, boolean noDelay$2, List additionalSocketOptions$2) {
        AsynchronousSocketChannel ch = AsynchronousChannelProvider.provider().openAsynchronousSocketChannel(this.channelGroup);
        ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Predef$.MODULE$.boolean2Boolean(reuseAddress$2));
        ch.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, Predef$.MODULE$.int2Integer(sendBufferSize$2));
        ch.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, Predef$.MODULE$.int2Integer(receiveBufferSize$2));
        ch.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, Predef$.MODULE$.boolean2Boolean(keepAlive$2));
        ch.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, Predef$.MODULE$.boolean2Boolean(noDelay$2));
        additionalSocketOptions$2.foreach((Function1)(JFunction1 & Serializable)x$1 -> {
            SocketOptionMapping socketOptionMapping = x$1;
            if (!(socketOptionMapping instanceof SocketOptionMapping)) {
                throw new MatchError((Object)socketOptionMapping);
            }
            SocketOptionMapping socketOptionMapping2 = SocketOptionMapping$.MODULE$.unapply(socketOptionMapping);
            SocketOption socketOption = socketOptionMapping2._1();
            Object a = socketOptionMapping2._2();
            SocketOption option = socketOption;
            Object value = a;
            return ch.setOption(option, value);
        });
        return ch;
    }

    private final Object setup$1(boolean reuseAddress$1, int sendBufferSize$1, int receiveBufferSize$1, boolean keepAlive$1, boolean noDelay$1, List additionalSocketOptions$1, Async F$1) {
        return F$1.blocking(() -> this.setup$3$$anonfun$2(reuseAddress$1, sendBufferSize$1, receiveBufferSize$1, keepAlive$1, noDelay$1, additionalSocketOptions$1));
    }

    private static final Object connect$2(InetSocketAddress to$1, Async F$2, AsynchronousSocketChannel ch) {
        return F$2.async_((Function1)(JProcedure1 & Serializable)cb -> ch.connect(to$1, null, new CompletionHandler(ch, (Function1)cb){
            private final AsynchronousSocketChannel ch$1;
            private final Function1 cb$1;
            {
                this.ch$1 = ch$21;
                this.cb$1 = cb$5;
            }

            public void completed(Void result, Void attachment) {
                this.cb$1.apply((Object)package$.MODULE$.Right().apply((Object)this.ch$1));
            }

            public void failed(Throwable rsn, Void attachment) {
                this.cb$1.apply((Object)package$.MODULE$.Left().apply((Object)rsn));
            }
        }));
    }

    private final AsynchronousServerSocketChannel $anonfun$1(InetSocketAddress address$1, boolean reuseAddress$3, int receiveBufferSize$3, List additionalSocketOptions$3) {
        AsynchronousServerSocketChannel ch = AsynchronousChannelProvider.provider().openAsynchronousServerSocketChannel(this.channelGroup);
        ch.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Predef$.MODULE$.boolean2Boolean(reuseAddress$3));
        ch.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, Predef$.MODULE$.int2Integer(receiveBufferSize$3));
        additionalSocketOptions$3.foreach((Function1)(JFunction1 & Serializable)x$1 -> {
            SocketOptionMapping socketOptionMapping = x$1;
            if (!(socketOptionMapping instanceof SocketOptionMapping)) {
                throw new MatchError((Object)socketOptionMapping);
            }
            SocketOptionMapping socketOptionMapping2 = SocketOptionMapping$.MODULE$.unapply(socketOptionMapping);
            SocketOption socketOption = socketOptionMapping2._1();
            Object a = socketOptionMapping2._2();
            SocketOption option = socketOption;
            Object value = a;
            return ch.setOption(option, value);
        });
        ch.bind(address$1);
        return ch;
    }

    private static final void cleanup$1$$anonfun$1(AsynchronousServerSocketChannel sch$1) {
        if (sch$1.isOpen()) {
            sch$1.close();
        }
    }

    private static final Object cleanup$2(Async F$4, AsynchronousServerSocketChannel sch) {
        return F$4.blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> SocketGroup.cleanup$1$$anonfun$1(sch)));
    }

    private static final Object acceptChannel$2(Async F$7, AsynchronousServerSocketChannel sch$3) {
        return F$7.async_((Function1)(JProcedure1 & Serializable)cb -> sch$3.accept(null, new CompletionHandler((Function1)cb){
            private final Function1 cb$1;
            {
                this.cb$1 = cb$6;
            }

            public void completed(AsynchronousSocketChannel ch, Void attachment) {
                this.cb$1.apply((Object)package$.MODULE$.Right().apply((Object)ch));
            }

            public void failed(Throwable rsn, Void attachment) {
                this.cb$1.apply((Object)package$.MODULE$.Left().apply((Object)rsn));
            }
        }));
    }

    private final Stream go$2$$anonfun$2(Async F$29, AsynchronousServerSocketChannel sch$7) {
        return this.go$3(F$29, sch$7);
    }

    private final Stream go$3(Async F$6, AsynchronousServerSocketChannel sch$2) {
        Object object = implicits$.MODULE$.catsSyntaxApplicativeError(SocketGroup.acceptChannel$2(F$6, sch$2), (ApplicativeError)F$6);
        return Stream$.MODULE$.eval(ApplicativeErrorOps$.MODULE$.attempt$extension(object, (ApplicativeError)F$6)).flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            Stream stream;
            Either either = x$1;
            if (either instanceof Left) {
                Stream stream2 = Stream$.MODULE$.PureOps(Stream$.MODULE$.empty());
                stream = Stream.PureOps$.MODULE$.apply$extension(stream2);
            } else if (either instanceof Right) {
                AsynchronousSocketChannel accepted = (AsynchronousSocketChannel)((Right)either).value();
                stream = Stream$.MODULE$.emit(this.apply(accepted, F$6));
            } else {
                throw new MatchError((Object)either);
            }
            return stream;
        }, NotNothing$.MODULE$.instance()).$plus$plus(() -> this.go$2$$anonfun$2(F$6, sch$2));
    }

    private static final boolean acceptIncoming$1$$anonfun$1$$anonfun$1(AsynchronousServerSocketChannel sch$6) {
        return sch$6.isOpen();
    }

    private static final /* synthetic */ Stream acceptIncoming$2$$anonfun$2$$anonfun$2(Async F$10, AsynchronousCloseException err$1, boolean isOpen) {
        return isOpen ? Stream$.MODULE$.raiseError((Throwable)err$1, RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)F$10)) : Stream$.MODULE$.empty();
    }

    private static final Stream acceptIncoming$3$$anonfun$3$$anonfun$adapted$1(Async F$30, AsynchronousCloseException err$2, Object isOpen) {
        return SocketGroup.acceptIncoming$2$$anonfun$2$$anonfun$2(F$30, err$2, BoxesRunTime.unboxToBoolean((Object)isOpen));
    }

    private final Stream acceptIncoming$5(Async F$5, AsynchronousServerSocketChannel sch) {
        return this.go$3(F$5, sch).handleErrorWith((Function1)(JFunction1 & Serializable)x$1 -> {
            Stream stream;
            Throwable throwable = x$1;
            if (throwable instanceof AsynchronousCloseException) {
                AsynchronousCloseException err = (AsynchronousCloseException)throwable;
                stream = Stream$.MODULE$.eval(F$5.blocking((Function0)((JFunction0.mcZ.sp & Serializable)() -> SocketGroup.acceptIncoming$1$$anonfun$1$$anonfun$1(sch)))).flatMap((Function1)((JFunction1 & Serializable)arg_0 -> SocketGroup.acceptIncoming$3$$anonfun$3$$anonfun$adapted$1(F$5, err, arg_0)), NotNothing$.MODULE$.instance());
            } else {
                Throwable err = throwable;
                stream = Stream$.MODULE$.raiseError(err, RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)F$5));
            }
            return stream;
        });
    }

    private static final Object readChunk$2(AsynchronousSocketChannel ch$6, Async F$12, ByteBuffer buff, long timeoutMs) {
        return F$12.async_((Function1)(JProcedure1 & Serializable)cb -> {
            long started = System.currentTimeMillis();
            ch$6.read(buff, timeoutMs, TimeUnit.MILLISECONDS, BoxedUnit.UNIT, new CompletionHandler((Function1)cb, started){
                private final Function1 cb$1;
                private final long started$1;
                {
                    this.cb$1 = cb$7;
                    this.started$1 = started$2;
                }

                public void completed(Integer result, BoxedUnit attachment) {
                    long took = System.currentTimeMillis() - this.started$1;
                    this.cb$1.apply((Object)package$.MODULE$.Right().apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(result)), (Object)BoxesRunTime.boxToLong((long)took))));
                }

                public void failed(Throwable err, BoxedUnit attachment) {
                    this.cb$1.apply((Object)package$.MODULE$.Left().apply((Object)err));
                }
            });
        });
    }

    private static final ByteBuffer getBufferOf$1$$anonfun$1$$anonfun$1(int sz$2) {
        return ByteBuffer.allocate(sz$2);
    }

    private static final ByteBuffer getBufferOf$3$$anonfun$3$$anonfun$3(int sz$3, ByteBuffer buff$2) {
        ((Buffer)buff$2).clear();
        ((Buffer)buff$2).limit(sz$3);
        return buff$2;
    }

    private static final Object getBufferOf$5(Async F$13, Ref bufferRef$1, int sz) {
        return implicits$.MODULE$.toFlatMapOps(bufferRef$1.get(), (FlatMap)F$13).flatMap((Function1)(JFunction1 & Serializable)buff -> buff.capacity() < sz ? implicits$.MODULE$.toFlatMapOps(F$13.delay(() -> SocketGroup.getBufferOf$1$$anonfun$1$$anonfun$1(sz)), (FlatMap)F$13).flatTap((Function1)(JFunction1 & Serializable)a -> bufferRef$1.set(a)) : F$13.delay(() -> SocketGroup.getBufferOf$3$$anonfun$3$$anonfun$3(sz, buff)));
    }

    /*
     * WARNING - void declaration
     */
    private static final Chunk releaseBuffer$1$$anonfun$1(ByteBuffer buff$3) {
        void var2_3;
        Chunk chunk;
        int read = buff$3.position();
        if (read == 0) {
            chunk = Chunk$.MODULE$.bytes((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Byte.TYPE)));
        } else {
            byte[] dest = new byte[read];
            ((Buffer)buff$3).flip();
            buff$3.get(dest);
            chunk = Chunk$.MODULE$.bytes(dest);
        }
        Chunk result = chunk;
        ((Buffer)buff$3).clear();
        return var2_3;
    }

    private static final Object releaseBuffer$2(Async F$15, ByteBuffer buff) {
        return F$15.delay(() -> SocketGroup.releaseBuffer$1$$anonfun$1(buff));
    }

    private static final long read0$2$$anonfun$2$$anonfun$2() {
        return 0L;
    }

    public static final Object fs2$io$tcp$SocketGroup$$_$read0$6(AsynchronousSocketChannel ch$8, Async F$16, Semaphore readSemaphore$1, Ref bufferRef$4, int max, Option timeout) {
        return readSemaphore$1.withPermit(implicits$.MODULE$.toFlatMapOps(SocketGroup.getBufferOf$5(F$16, bufferRef$4, max), (FlatMap)F$16).flatMap((Function1)(JFunction1 & Serializable)buff -> implicits$.MODULE$.toFlatMapOps(SocketGroup.readChunk$2(ch$8, F$16, buff, BoxesRunTime.unboxToLong((Object)timeout.map((Function1)(JFunction1 & Serializable)_$6 -> _$6.toMillis()).getOrElse((Function0)((JFunction0.mcJ.sp & Serializable)SocketGroup::read0$2$$anonfun$2$$anonfun$2)))), (FlatMap)F$16).flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
            } else {
                throw new MatchError((Object)tuple2);
            }
            int read = BoxesRunTime.unboxToInt((Object)tuple2._1());
            return read < 0 ? F$16.pure((Object)None$.MODULE$) : implicits$.MODULE$.toFunctorOps(SocketGroup.releaseBuffer$2(F$16, buff), (Functor)F$16).map((Function1)(JFunction1 & Serializable)_$7 -> Some$.MODULE$.apply(_$7));
        })));
    }

    private static final Object go$6(AsynchronousSocketChannel ch$11, Async F$20, int max$1, ByteBuffer buff$5, long timeoutMs) {
        return implicits$.MODULE$.toFlatMapOps(SocketGroup.readChunk$2(ch$11, F$20, buff$5, timeoutMs), (FlatMap)F$20).flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            long took;
            int readBytes;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                readBytes = BoxesRunTime.unboxToInt((Object)tuple2._1());
                took = BoxesRunTime.unboxToLong((Object)tuple2._2());
            } else {
                throw new MatchError((Object)tuple2);
            }
            return readBytes < 0 || buff$5.position() >= max$1 ? implicits$.MODULE$.toFunctorOps(SocketGroup.releaseBuffer$2(F$20, buff$5), (Functor)F$20).map((Function1)(JFunction1 & Serializable)_$8 -> Some$.MODULE$.apply(_$8)) : SocketGroup.go$6(ch$11, F$20, max$1, buff$5, RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(timeoutMs - took), 0L));
        });
    }

    private static final long readN0$2$$anonfun$2$$anonfun$2() {
        return 0L;
    }

    public static final Object fs2$io$tcp$SocketGroup$$_$readN0$4(AsynchronousSocketChannel ch$10, Async F$19, Semaphore readSemaphore$2, Ref bufferRef$5, int max, Option timeout) {
        return readSemaphore$2.withPermit(implicits$.MODULE$.toFlatMapOps(SocketGroup.getBufferOf$5(F$19, bufferRef$5, max), (FlatMap)F$19).flatMap((Function1)(JFunction1 & Serializable)buff -> SocketGroup.go$6(ch$10, F$19, max, buff, BoxesRunTime.unboxToLong((Object)timeout.map((Function1)(JFunction1 & Serializable)_$9 -> _$9.toMillis()).getOrElse((Function0)((JFunction0.mcJ.sp & Serializable)SocketGroup::readN0$2$$anonfun$2$$anonfun$2))))));
    }

    private static final Object go$9(AsynchronousSocketChannel ch$15, Async F$24, ByteBuffer buff, long remains) {
        return implicits$.MODULE$.toFlatMapOps(F$24.async_((Function1)(JProcedure1 & Serializable)cb -> {
            long start = System.currentTimeMillis();
            ch$15.write(buff, remains, TimeUnit.MILLISECONDS, BoxedUnit.UNIT, new CompletionHandler(buff, (Function1)cb, start){
                private final ByteBuffer buff$1;
                private final Function1 cb$1;
                private final long start$1;
                {
                    this.buff$1 = buff$10;
                    this.cb$1 = cb$8;
                    this.start$1 = start$2;
                }

                public void completed(Integer result, BoxedUnit attachment) {
                    this.cb$1.apply((Object)package$.MODULE$.Right().apply(this.buff$1.remaining() <= 0 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - this.start$1)))));
                }

                public void failed(Throwable err, BoxedUnit attachment) {
                    this.cb$1.apply((Object)package$.MODULE$.Left().apply((Object)err));
                }
            });
        }), (FlatMap)F$24).flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            Object object;
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                object = F$24.unit();
            } else if (option instanceof Some) {
                long took = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                object = SocketGroup.go$9(ch$15, F$24, buff, RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(remains - took), 0L));
            } else {
                throw new MatchError((Object)option);
            }
            return object;
        });
    }

    private static final long write0$2$$anonfun$2() {
        return 0L;
    }

    public static final Object fs2$io$tcp$SocketGroup$$_$write0$3(AsynchronousSocketChannel ch$14, Async F$23, Semaphore writeSemaphore$1, Chunk bytes, Option timeout) {
        return writeSemaphore$1.withPermit(SocketGroup.go$9(ch$14, F$23, bytes.toByteBuffer($less$colon$less$.MODULE$.refl()), BoxesRunTime.unboxToLong((Object)timeout.map((Function1)(JFunction1 & Serializable)_$10 -> _$10.toMillis()).getOrElse((Function0)((JFunction0.mcJ.sp & Serializable)SocketGroup::write0$2$$anonfun$2)))));
    }

    private static final void apply$$anonfun$2$$anonfun$1(AsynchronousSocketChannel ch$20) {
        if (ch$20.isOpen()) {
            ch$20.close();
        }
    }
}

