/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.file;

import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import dotty.runtime.Arrays$;
import dotty.runtime.function.JFunction0;
import dotty.runtime.function.JFunction1;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.CollectionCompat$;
import fs2.io.CollectionCompat$JIterableOps$;
import fs2.io.CollectionCompat$JIteratorOps$;
import fs2.io.CollectionCompat$JSetOps$;
import fs2.io.CollectionCompat$SetOps$;
import fs2.io.file.FileHandle;
import fs2.io.file.FileHandle$;
import fs2.io.file.ReadCursor;
import fs2.io.file.ReadCursor$;
import fs2.io.file.WriteCursor;
import fs2.io.file.WriteCursor$;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Not$;

public interface SyncFiles<F> {
    public F copy(Path var1, Path var2, Seq<CopyOption> var3);

    public static Seq copy$default$3$(SyncFiles $this) {
        return $this.copy$default$3();
    }

    default public Seq<CopyOption> copy$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public F createDirectory(Path var1, Seq<FileAttribute<?>> var2);

    public static Seq createDirectory$default$2$(SyncFiles $this) {
        return $this.createDirectory$default$2();
    }

    default public Seq<FileAttribute<?>> createDirectory$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public F createDirectories(Path var1, Seq<FileAttribute<?>> var2);

    public static Seq createDirectories$default$2$(SyncFiles $this) {
        return $this.createDirectories$default$2();
    }

    default public Seq<FileAttribute<?>> createDirectories$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public F delete(Path var1);

    public F deleteIfExists(Path var1);

    public F deleteDirectoryRecursively(Path var1, scala.collection.immutable.Set<FileVisitOption> var2);

    public static scala.collection.immutable.Set deleteDirectoryRecursively$default$2$(SyncFiles $this) {
        return $this.deleteDirectoryRecursively$default$2();
    }

    default public scala.collection.immutable.Set<FileVisitOption> deleteDirectoryRecursively$default$2() {
        return Predef$.MODULE$.Set().empty();
    }

    public Stream<F, Path> directoryStream(Path var1);

    public Stream<F, Path> directoryStream(Path var1, Function1<Path, Object> var2);

    public Stream<F, Path> directoryStream(Path var1, String var2);

    public F exists(Path var1, Seq<LinkOption> var2);

    public static Seq exists$default$2$(SyncFiles $this) {
        return $this.exists$default$2();
    }

    default public Seq<LinkOption> exists$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public F move(Path var1, Path var2, Seq<CopyOption> var3);

    public static Seq move$default$3$(SyncFiles $this) {
        return $this.move$default$3();
    }

    default public Seq<CopyOption> move$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Resource<F, FileHandle<F>> open(Path var1, Seq<OpenOption> var2);

    public Resource<F, FileHandle<F>> openFileChannel(F var1);

    public F permissions(Path var1, Seq<LinkOption> var2);

    public static Seq permissions$default$2$(SyncFiles $this) {
        return $this.permissions$default$2();
    }

    default public Seq<LinkOption> permissions$default$2() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Stream<F, Object> readAll(Path var1, int var2);

    public Resource<F, ReadCursor<F>> readCursor(Path var1, Seq<OpenOption> var2);

    public static Nil$ readCursor$default$2$(SyncFiles $this) {
        return $this.readCursor$default$2();
    }

    default public Nil$ readCursor$default$2() {
        return package$.MODULE$.Nil();
    }

    public Stream<F, Object> readRange(Path var1, int var2, long var3, long var5);

    public F setPermissions(Path var1, scala.collection.immutable.Set<PosixFilePermission> var2);

    public F size(Path var1);

    public Resource<F, Path> tempFile(Path var1, String var2, String var3, Seq<FileAttribute<?>> var4);

    public static String tempFile$default$2$(SyncFiles $this) {
        return $this.tempFile$default$2();
    }

    default public String tempFile$default$2() {
        return "";
    }

    public static String tempFile$default$3$(SyncFiles $this) {
        return $this.tempFile$default$3();
    }

    default public String tempFile$default$3() {
        return ".tmp";
    }

    public static Seq tempFile$default$4$(SyncFiles $this) {
        return $this.tempFile$default$4();
    }

    default public Seq<FileAttribute<?>> tempFile$default$4() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Resource<F, Path> tempDirectory(Path var1, String var2, Seq<FileAttribute<?>> var3);

    public static String tempDirectory$default$2$(SyncFiles $this) {
        return $this.tempDirectory$default$2();
    }

    default public String tempDirectory$default$2() {
        return "";
    }

    public static Seq tempDirectory$default$3$(SyncFiles $this) {
        return $this.tempDirectory$default$3();
    }

    default public Seq<FileAttribute<?>> tempDirectory$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Stream<F, Path> walk(Path var1);

    public Stream<F, Path> walk(Path var1, Seq<FileVisitOption> var2);

    public Stream<F, Path> walk(Path var1, int var2, Seq<FileVisitOption> var3);

    public static Seq walk$default$3$(SyncFiles $this) {
        return $this.walk$default$3();
    }

    default public Seq<FileVisitOption> walk$default$3() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Function1<Stream<F, Object>, Stream<F, Nothing$>> writeAll(Path var1, Seq<StandardOpenOption> var2);

    public static List writeAll$default$2$(SyncFiles $this) {
        return $this.writeAll$default$2();
    }

    default public List<StandardOpenOption> writeAll$default$2() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE}));
    }

    public Resource<F, WriteCursor<F>> writeCursor(Path var1, Seq<OpenOption> var2);

    public static List writeCursor$default$2$(SyncFiles $this) {
        return $this.writeCursor$default$2();
    }

    default public List<StandardOpenOption> writeCursor$default$2() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE}));
    }

    public F writeCursorFromFileHandle(FileHandle<F> var1, boolean var2);

    public F isDirectory(Path var1, Seq<LinkOption> var2);

    public static Nil$ isDirectory$default$2$(SyncFiles $this) {
        return $this.isDirectory$default$2();
    }

    default public Nil$ isDirectory$default$2() {
        return package$.MODULE$.Nil();
    }

    public F isFile(Path var1, Seq<LinkOption> var2);

    public static Nil$ isFile$default$2$(SyncFiles $this) {
        return $this.isFile$default$2();
    }

    default public Nil$ isFile$default$2() {
        return package$.MODULE$.Nil();
    }

    public static class Impl<F>
    implements SyncFiles<F> {
        private final Sync<F> evidence$2;

        public <F> Impl(Sync<F> evidence$2) {
            this.evidence$2 = evidence$2;
            int n = 16;
        }

        @Override
        public F copy(Path source, Path target, Seq<CopyOption> flags) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.copy$$anonfun$1(source, target, flags));
        }

        @Override
        public F createDirectory(Path path, Seq<FileAttribute<?>> flags) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.createDirectory$$anonfun$1(path, flags));
        }

        @Override
        public F createDirectories(Path path, Seq<FileAttribute<?>> flags) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.createDirectories$$anonfun$1(path, flags));
        }

        @Override
        public F delete(Path path) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.delete$$anonfun$1(path)));
        }

        @Override
        public F deleteIfExists(Path path) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking((Function0)((JFunction0.mcZ.sp & Serializable)() -> this.deleteIfExists$$anonfun$1(path)));
        }

        @Override
        public F deleteDirectoryRecursively(Path path, scala.collection.immutable.Set<FileVisitOption> options) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.deleteDirectoryRecursively$$anonfun$1(path, options)));
        }

        @Override
        public Stream<F, Path> directoryStream(Path path) {
            return this._runJavaCollectionResource((F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.directoryStream$$anonfun$1(path)), (Function1)(JFunction1 & Serializable)_$5 -> {
                Iterable iterable = CollectionCompat$.MODULE$.JIterableOps(_$5);
                return CollectionCompat$JIterableOps$.MODULE$.asScala$extension(iterable).iterator();
            });
        }

        @Override
        public Stream<F, Path> directoryStream(Path path, Function1<Path, Object> filter) {
            return this._runJavaCollectionResource((F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.directoryStream$$anonfun$3(path, filter)), (Function1)(JFunction1 & Serializable)_$6 -> {
                Iterable iterable = CollectionCompat$.MODULE$.JIterableOps(_$6);
                return CollectionCompat$JIterableOps$.MODULE$.asScala$extension(iterable).iterator();
            });
        }

        @Override
        public Stream<F, Path> directoryStream(Path path, String glob) {
            return this._runJavaCollectionResource((F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.directoryStream$$anonfun$5(path, glob)), (Function1)(JFunction1 & Serializable)_$7 -> {
                Iterable iterable = CollectionCompat$.MODULE$.JIterableOps(_$7);
                return CollectionCompat$JIterableOps$.MODULE$.asScala$extension(iterable).iterator();
            });
        }

        private <C extends AutoCloseable> Stream<F, Path> _runJavaCollectionResource(F javaCollection, Function1<C, Iterator<Path>> collectionIterator) {
            return Stream$.MODULE$.resource(Resource$.MODULE$.fromAutoCloseable(javaCollection, this.evidence$2), this.evidence$2).flatMap((Function1)(JFunction1 & Serializable)ds -> {
                boolean bl = Stream$.MODULE$.fromBlockingIterator();
                return Stream.PartiallyAppliedFromIterator$.MODULE$.apply$extension(bl, (Iterator)collectionIterator.apply(ds), 16, this.evidence$2);
            }, Not$.MODULE$.value());
        }

        @Override
        public F exists(Path path, Seq<LinkOption> flags) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking((Function0)((JFunction0.mcZ.sp & Serializable)() -> this.exists$$anonfun$1(path, flags)));
        }

        @Override
        public F move(Path source, Path target, Seq<CopyOption> flags) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.move$$anonfun$1(source, target, flags));
        }

        @Override
        public Resource<F, FileHandle<F>> open(Path path, Seq<OpenOption> flags) {
            return this.openFileChannel(Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.open$$anonfun$1(path, flags)));
        }

        @Override
        public Resource<F, FileHandle<F>> openFileChannel(F channel) {
            return Resource$.MODULE$.make(channel, (Function1)(JFunction1 & Serializable)ch -> Sync$.MODULE$.apply(this.evidence$2).blocking((Function0)((JFunction0.mcV.sp & Serializable)() -> this.openFileChannel$$anonfun$3$$anonfun$1(ch))), this.evidence$2).map((Function1)(JFunction1 & Serializable)ch -> FileHandle$.MODULE$.make((FileChannel)ch, this.evidence$2));
        }

        @Override
        public F permissions(Path path, Seq<LinkOption> flags) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.permissions$$anonfun$1(path, flags));
        }

        @Override
        public Stream<F, Object> readAll(Path path, int chunkSize) {
            return Stream$.MODULE$.resource(this.readCursor(path, (Seq<OpenOption>)this.readCursor$default$2()), this.evidence$2).flatMap((Function1)(JFunction1 & Serializable)cursor -> cursor.readAll(chunkSize).void().stream((.less.colon.less)$less$colon$less$.MODULE$.refl()), Not$.MODULE$.value());
        }

        @Override
        public Resource<F, ReadCursor<F>> readCursor(Path path, Seq<OpenOption> flags) {
            StandardOpenOption standardOpenOption = StandardOpenOption.READ;
            return this.open(path, (Seq<OpenOption>)flags.toList().$colon$colon((Object)standardOpenOption)).map((Function1)(JFunction1 & Serializable)fileHandle -> ReadCursor$.MODULE$.apply(fileHandle, 0L));
        }

        @Override
        public Nil$ readCursor$default$2() {
            return package$.MODULE$.Nil();
        }

        @Override
        public Stream<F, Object> readRange(Path path, int chunkSize, long start, long end) {
            return Stream$.MODULE$.resource(this.readCursor(path, (Seq<OpenOption>)this.readCursor$default$2()), this.evidence$2).flatMap((Function1)(JFunction1 & Serializable)cursor -> cursor.seek(start).readUntil(chunkSize, end).void().stream((.less.colon.less)$less$colon$less$.MODULE$.refl()), Not$.MODULE$.value());
        }

        @Override
        public F setPermissions(Path path, scala.collection.immutable.Set<PosixFilePermission> permissions) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.setPermissions$$anonfun$1(path, permissions));
        }

        @Override
        public F size(Path path) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).blocking((Function0)((JFunction0.mcJ.sp & Serializable)() -> this.size$$anonfun$1(path)));
        }

        @Override
        public Resource<F, Path> tempFile(Path dir, String prefix, String suffix, Seq<FileAttribute<?>> attributes) {
            return Resource$.MODULE$.make(Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.tempFile$$anonfun$1(dir, prefix, suffix, attributes)), (Function1)(JFunction1 & Serializable)_$8 -> package.all$.MODULE$.toFunctorOps(this.deleteIfExists((Path)_$8), this.evidence$2).void(), this.evidence$2);
        }

        @Override
        public Resource<F, Path> tempDirectory(Path dir, String prefix, Seq<FileAttribute<?>> attributes) {
            return Resource$.MODULE$.make(Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.tempDirectory$$anonfun$1(dir, prefix, attributes)), (Function1)(JFunction1 & Serializable)p -> {
                Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.deleteDirectoryRecursively((Path)p, (scala.collection.immutable.Set<FileVisitOption>)this.deleteDirectoryRecursively$default$2()), this.evidence$2);
                return ApplicativeErrorOps$.MODULE$.recover$extension(object, (PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        return throwable instanceof NoSuchFileException;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        return throwable instanceof NoSuchFileException ? BoxedUnit.UNIT : function1.apply((Object)x);
                    }
                }, this.evidence$2);
            }, this.evidence$2);
        }

        @Override
        public Stream<F, Path> walk(Path start) {
            return this.walk(start, (Seq<FileVisitOption>)((Seq)package$.MODULE$.Seq().empty()));
        }

        @Override
        public Stream<F, Path> walk(Path start, Seq<FileVisitOption> options) {
            return this.walk(start, Integer.MAX_VALUE, options);
        }

        @Override
        public Stream<F, Path> walk(Path start, int maxDepth, Seq<FileVisitOption> options) {
            return this._runJavaCollectionResource((F)Sync$.MODULE$.apply(this.evidence$2).blocking(() -> this.walk$$anonfun$1(start, maxDepth, options)), (Function1)(JFunction1 & Serializable)_$9 -> {
                java.util.Iterator iterator = CollectionCompat$.MODULE$.JIteratorOps(_$9.iterator());
                return CollectionCompat$JIteratorOps$.MODULE$.asScala$extension(iterator);
            });
        }

        @Override
        public Function1<Stream<F, Object>, Stream<F, Nothing$>> writeAll(Path path, Seq<StandardOpenOption> flags) {
            return (JFunction1 & Serializable)in -> Stream$.MODULE$.resource(this.writeCursor(path, (Seq<OpenOption>)flags), this.evidence$2).flatMap((Function1)(JFunction1 & Serializable)_$10 -> _$10.writeAll(in).void().stream((.less.colon.less)$less$colon$less$.MODULE$.refl()), Not$.MODULE$.value());
        }

        @Override
        public List<StandardOpenOption> writeAll$default$2() {
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE}));
        }

        @Override
        public Resource<F, WriteCursor<F>> writeCursor(Path path, Seq<OpenOption> flags) {
            StandardOpenOption standardOpenOption = StandardOpenOption.WRITE;
            return this.open(path, (Seq<OpenOption>)flags.toList().$colon$colon((Object)standardOpenOption)).flatMap((Function1)(JFunction1 & Serializable)fileHandle -> {
                Object object;
                if (flags.contains((Object)StandardOpenOption.APPEND)) {
                    object = fileHandle.size();
                } else {
                    Object object2 = package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToLong((long)0L));
                    object = ApplicativeIdOps$.MODULE$.pure$extension(object2, this.evidence$2);
                }
                Object size = object;
                Object cursor = package.all$.MODULE$.toFunctorOps(size, this.evidence$2).map((Function1)((JFunction1 & Serializable)arg_0 -> this.$anonfun$adapted$1(fileHandle, arg_0)));
                return Resource$.MODULE$.liftF(cursor);
            });
        }

        @Override
        public List<StandardOpenOption> writeCursor$default$2() {
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StandardOpenOption[]{StandardOpenOption.CREATE}));
        }

        @Override
        public F writeCursorFromFileHandle(FileHandle<F> file, boolean append) {
            Object object;
            if (append) {
                object = package.all$.MODULE$.toFunctorOps(file.size(), this.evidence$2).map((Function1)((JFunction1 & Serializable)arg_0 -> this.writeCursorFromFileHandle$$anonfun$adapted$1(file, arg_0)));
            } else {
                Object object2 = package.all$.MODULE$.catsSyntaxApplicativeId(WriteCursor$.MODULE$.apply(file, 0L));
                object = ApplicativeIdOps$.MODULE$.pure$extension(object2, this.evidence$2);
            }
            return (F)object;
        }

        @Override
        public F isDirectory(Path path, Seq<LinkOption> linkOption) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).delay((Function0)((JFunction0.mcZ.sp & Serializable)() -> this.isDirectory$$anonfun$1(path, linkOption)));
        }

        @Override
        public F isFile(Path path, Seq<LinkOption> linkOption) {
            return (F)Sync$.MODULE$.apply(this.evidence$2).delay((Function0)((JFunction0.mcZ.sp & Serializable)() -> this.isFile$$anonfun$1(path, linkOption)));
        }

        private final Path copy$$anonfun$1(Path source$1, Path target$1, Seq flags$1) {
            return Files.copy(source$1, target$1, (CopyOption[])Arrays$.MODULE$.seqToArray(flags$1, CopyOption.class));
        }

        private final Path createDirectory$$anonfun$1(Path path$1, Seq flags$2) {
            return Files.createDirectory(path$1, (FileAttribute[])Arrays$.MODULE$.seqToArray(flags$2, FileAttribute.class));
        }

        private final Path createDirectories$$anonfun$1(Path path$2, Seq flags$3) {
            return Files.createDirectories(path$2, (FileAttribute[])Arrays$.MODULE$.seqToArray(flags$3, FileAttribute.class));
        }

        private final void delete$$anonfun$1(Path path$3) {
            Files.delete(path$3);
        }

        private final boolean deleteIfExists$$anonfun$1(Path path$4) {
            return Files.deleteIfExists(path$4);
        }

        private final void deleteDirectoryRecursively$$anonfun$1(Path path$5, scala.collection.immutable.Set options$1) {
            scala.collection.immutable.Set set = CollectionCompat$.MODULE$.SetOps(options$1);
            Files.walkFileTree(path$5, CollectionCompat$SetOps$.MODULE$.asJava$extension(set), Integer.MAX_VALUE, new SimpleFileVisitor(){

                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                    Files.deleteIfExists(path);
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult postVisitDirectory(Path path, IOException e) {
                    Files.deleteIfExists(path);
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        private final DirectoryStream directoryStream$$anonfun$1(Path path$6) {
            return Files.newDirectoryStream(path$6);
        }

        private final DirectoryStream directoryStream$$anonfun$3(Path path$7, Function1 filter$1) {
            return Files.newDirectoryStream(path$7, entry -> BoxesRunTime.unboxToBoolean((Object)filter$1.apply(entry)));
        }

        private final DirectoryStream directoryStream$$anonfun$5(Path path$8, String glob$1) {
            return Files.newDirectoryStream(path$8, glob$1);
        }

        private final boolean exists$$anonfun$1(Path path$9, Seq flags$4) {
            return Files.exists(path$9, (LinkOption[])Arrays$.MODULE$.seqToArray(flags$4, LinkOption.class));
        }

        private final Path move$$anonfun$1(Path source$2, Path target$2, Seq flags$5) {
            return Files.move(source$2, target$2, (CopyOption[])Arrays$.MODULE$.seqToArray(flags$5, CopyOption.class));
        }

        private final FileChannel open$$anonfun$1(Path path$10, Seq flags$6) {
            return FileChannel.open(path$10, (OpenOption[])Arrays$.MODULE$.seqToArray(flags$6, OpenOption.class));
        }

        private final void openFileChannel$$anonfun$3$$anonfun$1(FileChannel ch$1) {
            ch$1.close();
        }

        private final scala.collection.immutable.Set permissions$$anonfun$1(Path path$11, Seq flags$7) {
            Set<PosixFilePermission> set = CollectionCompat$.MODULE$.JSetOps(Files.getPosixFilePermissions(path$11, (LinkOption[])Arrays$.MODULE$.seqToArray(flags$7, LinkOption.class)));
            return CollectionCompat$JSetOps$.MODULE$.asScala$extension(set);
        }

        private final Path setPermissions$$anonfun$1(Path path$12, scala.collection.immutable.Set permissions$1) {
            scala.collection.immutable.Set set = CollectionCompat$.MODULE$.SetOps(permissions$1);
            return Files.setPosixFilePermissions(path$12, CollectionCompat$SetOps$.MODULE$.asJava$extension(set));
        }

        private final long size$$anonfun$1(Path path$13) {
            return Files.size(path$13);
        }

        private final Path tempFile$$anonfun$1(Path dir$1, String prefix$1, String suffix$1, Seq attributes$1) {
            return Files.createTempFile(dir$1, prefix$1, suffix$1, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes$1, FileAttribute.class));
        }

        private final Path tempDirectory$$anonfun$1(Path dir$2, String prefix$2, Seq attributes$2) {
            return Files.createTempDirectory(dir$2, prefix$2, (FileAttribute[])Arrays$.MODULE$.seqToArray(attributes$2, FileAttribute.class));
        }

        private final java.util.stream.Stream walk$$anonfun$1(Path start$2, int maxDepth$1, Seq options$2) {
            return Files.walk(start$2, maxDepth$1, (FileVisitOption[])Arrays$.MODULE$.seqToArray(options$2, FileVisitOption.class));
        }

        private final /* synthetic */ WriteCursor $anonfun$1(FileHandle fileHandle$1, long s) {
            return WriteCursor$.MODULE$.apply(fileHandle$1, s);
        }

        private final WriteCursor $anonfun$adapted$1(FileHandle fileHandle$2, Object s) {
            return this.$anonfun$1(fileHandle$2, BoxesRunTime.unboxToLong((Object)s));
        }

        private final /* synthetic */ WriteCursor writeCursorFromFileHandle$$anonfun$1(FileHandle file$1, long s) {
            return WriteCursor$.MODULE$.apply(file$1, s);
        }

        private final WriteCursor writeCursorFromFileHandle$$anonfun$adapted$1(FileHandle file$2, Object s) {
            return this.writeCursorFromFileHandle$$anonfun$1(file$2, BoxesRunTime.unboxToLong((Object)s));
        }

        private final boolean isDirectory$$anonfun$1(Path path$15, Seq linkOption$1) {
            return Files.isDirectory(path$15, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOption$1, LinkOption.class));
        }

        private final boolean isFile$$anonfun$1(Path path$16, Seq linkOption$2) {
            return Files.isRegularFile(path$16, (LinkOption[])Arrays$.MODULE$.seqToArray(linkOption$2, LinkOption.class));
        }
    }
}

