/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.udp;

import fs2.Chunk;
import fs2.Chunk$;
import fs2.internal.ThreadFactories$;
import fs2.io.udp.AsynchronousSocketGroup;
import fs2.io.udp.AsynchronousSocketGroup$;
import fs2.io.udp.AsynchronousSocketGroup$$anon$1$;
import fs2.io.udp.AsynchronousSocketGroup$$anon$1$Attachment$;
import fs2.io.udp.AsynchronousSocketGroup$$anon$1$Timeout$;
import fs2.io.udp.Packet;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.InterruptedByTimeoutException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.PriorityQueue;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

public final class AsynchronousSocketGroup$ {
    public static AsynchronousSocketGroup$ MODULE$;

    static {
        new AsynchronousSocketGroup$();
    }

    public AsynchronousSocketGroup apply() {
        return new AsynchronousSocketGroup(){
            private volatile AsynchronousSocketGroup$$anon$1$Timeout$ Timeout$module;
            private volatile AsynchronousSocketGroup$$anon$1$Attachment$ Attachment$module;
            private final Selector fs2$io$udp$AsynchronousSocketGroup$$anon$$selector;
            private final Object closeLock;
            private volatile boolean fs2$io$udp$AsynchronousSocketGroup$$anon$$closed;
            private final ConcurrentLinkedQueue<Function0<BoxedUnit>> pendingThunks;
            private final PriorityQueue<anon.Timeout> fs2$io$udp$AsynchronousSocketGroup$$anon$$pendingTimeouts;
            private final ByteBuffer readBuffer;
            private final Thread selectorThread;

            private AsynchronousSocketGroup$$anon$1$Timeout$ Timeout() {
                if (this.Timeout$module == null) {
                    this.Timeout$lzycompute$1();
                }
                return this.Timeout$module;
            }

            private AsynchronousSocketGroup$$anon$1$Attachment$ Attachment() {
                if (this.Attachment$module == null) {
                    this.Attachment$lzycompute$1();
                }
                return this.Attachment$module;
            }

            public Selector fs2$io$udp$AsynchronousSocketGroup$$anon$$selector() {
                return this.fs2$io$udp$AsynchronousSocketGroup$$anon$$selector;
            }

            private Object closeLock() {
                return this.closeLock;
            }

            public boolean fs2$io$udp$AsynchronousSocketGroup$$anon$$closed() {
                return this.fs2$io$udp$AsynchronousSocketGroup$$anon$$closed;
            }

            private void fs2$io$udp$AsynchronousSocketGroup$$anon$$closed_$eq(boolean x$1) {
                this.fs2$io$udp$AsynchronousSocketGroup$$anon$$closed = x$1;
            }

            private ConcurrentLinkedQueue<Function0<BoxedUnit>> pendingThunks() {
                return this.pendingThunks;
            }

            public PriorityQueue<anon.Timeout> fs2$io$udp$AsynchronousSocketGroup$$anon$$pendingTimeouts() {
                return this.fs2$io$udp$AsynchronousSocketGroup$$anon$$pendingTimeouts;
            }

            private ByteBuffer readBuffer() {
                return this.readBuffer;
            }

            public SelectionKey register(DatagramChannel channel) {
                ObjectRef key = ObjectRef.create(null);
                CountDownLatch latch = new CountDownLatch(1);
                this.onSelectorThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    channel.configureBlocking(false);
                    anon.Attachment attachment = new anon.Attachment(this, this.Attachment().$lessinit$greater$default$1(), this.Attachment().$lessinit$greater$default$2());
                    key$4.elem = channel.register(this.fs2$io$udp$AsynchronousSocketGroup$$anon$$selector(), 0, attachment);
                    latch.countDown();
                }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> latch.countDown());
                latch.await();
                if ((SelectionKey)key.elem == null) {
                    throw new ClosedChannelException();
                }
                return (SelectionKey)key.elem;
            }

            public void read(SelectionKey key, Option<FiniteDuration> timeout, Function1<Either<Throwable, Packet>, BoxedUnit> cb) {
                this.onSelectorThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    block3: {
                        Option t2;
                        anon.Attachment attachment;
                        DatagramChannel channel;
                        block2: {
                            channel = (DatagramChannel)key.channel();
                            attachment = (anon.Attachment)key.attachment();
                            ObjectRef cancelReader = ObjectRef.create(null);
                            t2 = timeout.map((Function1 & Serializable & scala.Serializable)t0 -> this.Timeout().apply((FiniteDuration)t0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                block0: {
                                    cb.apply((Object)package$.MODULE$.Left().apply((Object)new InterruptedByTimeoutException()));
                                    if ((Function0)cancelReader$1.elem == null) break block0;
                                    ((Function0)cancelReader$1.elem).apply$mcV$sp();
                                }
                            }));
                            if (!attachment.hasReaders()) break block2;
                            cancelReader.elem = attachment.queueReader(cb, (Option<anon.Timeout>)t2);
                            t2.foreach((Function1 & Serializable & scala.Serializable)t -> this.fs2$io$udp$AsynchronousSocketGroup$$anon$$pendingTimeouts().$plus$eq(t));
                            break block3;
                        }
                        if (this.fs2$io$udp$AsynchronousSocketGroup$$anon$$read1(key, channel, attachment, cb)) break block3;
                        cancelReader.elem = attachment.queueReader(cb, (Option<anon.Timeout>)t2);
                        t2.foreach((Function1 & Serializable & scala.Serializable)t -> this.fs2$io$udp$AsynchronousSocketGroup$$anon$$pendingTimeouts().$plus$eq(t));
                        try {
                            key.interestOps(key.interestOps() | 1);
                        }
                        catch (CancelledKeyException t3) {}
                    }
                }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cb.apply((Object)package$.MODULE$.Left().apply((Object)new ClosedChannelException())));
            }

            public boolean fs2$io$udp$AsynchronousSocketGroup$$anon$$read1(SelectionKey key, DatagramChannel channel, anon.Attachment attachment, Function1<Either<Throwable, Packet>, BoxedUnit> reader) {
                boolean bl;
                block3: {
                    try {
                        InetSocketAddress src = (InetSocketAddress)channel.receive(this.readBuffer());
                        if (src == null) {
                            bl = false;
                            break block3;
                        }
                        this.readBuffer().flip();
                        byte[] bytes = new byte[this.readBuffer().remaining()];
                        this.readBuffer().get(bytes);
                        this.readBuffer().clear();
                        reader.apply((Object)package$.MODULE$.Right().apply((Object)new Packet(src, (Chunk<Object>)Chunk$.MODULE$.bytes(bytes))));
                        bl = true;
                    }
                    catch (IOException t) {
                        reader.apply((Object)package$.MODULE$.Left().apply((Object)t));
                        bl = true;
                    }
                }
                return bl;
            }

            public void write(SelectionKey key, Packet packet, Option<FiniteDuration> timeout, Function1<Option<Throwable>, BoxedUnit> cb) {
                byte[] byArray;
                Chunk.Bytes srcBytes = packet.bytes().toBytes(Predef.$eq$colon$eq$.MODULE$.tpEquals());
                if (srcBytes.size() == new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(srcBytes.values())).size()) {
                    byArray = srcBytes.values();
                } else {
                    byte[] destBytes = new byte[srcBytes.size()];
                    Array$.MODULE$.copy((Object)srcBytes.values(), 0, (Object)destBytes, srcBytes.offset(), srcBytes.size());
                    byArray = destBytes;
                }
                byte[] bytes = byArray;
                AsynchronousSocketGroup.WriterPacket writerPacket = new AsynchronousSocketGroup.WriterPacket(packet.remote(), ByteBuffer.wrap(bytes));
                this.onSelectorThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    block3: {
                        Option t2;
                        anon.Attachment attachment;
                        DatagramChannel channel;
                        block2: {
                            channel = (DatagramChannel)key.channel();
                            attachment = (anon.Attachment)key.attachment();
                            ObjectRef cancelWriter = ObjectRef.create(null);
                            t2 = timeout.map((Function1 & Serializable & scala.Serializable)t0 -> this.Timeout().apply((FiniteDuration)t0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                block0: {
                                    cb.apply((Object)new Some((Object)new InterruptedByTimeoutException()));
                                    if ((Function0)cancelWriter$1.elem == null) break block0;
                                    ((Function0)cancelWriter$1.elem).apply$mcV$sp();
                                }
                            }));
                            if (!attachment.hasWriters()) break block2;
                            cancelWriter.elem = attachment.queueWriter((Tuple2<AsynchronousSocketGroup.WriterPacket, Function1<Option<Throwable>, BoxedUnit>>)new Tuple2((Object)writerPacket, (Object)cb), (Option<anon.Timeout>)t2);
                            t2.foreach((Function1 & Serializable & scala.Serializable)t -> this.fs2$io$udp$AsynchronousSocketGroup$$anon$$pendingTimeouts().$plus$eq(t));
                            break block3;
                        }
                        if (this.fs2$io$udp$AsynchronousSocketGroup$$anon$$write1(key, channel, attachment, writerPacket, cb)) break block3;
                        cancelWriter.elem = attachment.queueWriter((Tuple2<AsynchronousSocketGroup.WriterPacket, Function1<Option<Throwable>, BoxedUnit>>)new Tuple2((Object)writerPacket, (Object)cb), (Option<anon.Timeout>)t2);
                        t2.foreach((Function1 & Serializable & scala.Serializable)t -> this.fs2$io$udp$AsynchronousSocketGroup$$anon$$pendingTimeouts().$plus$eq(t));
                        try {
                            key.interestOps(key.interestOps() | 4);
                        }
                        catch (CancelledKeyException t3) {}
                    }
                }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cb.apply((Object)new Some((Object)new ClosedChannelException())));
            }

            public boolean fs2$io$udp$AsynchronousSocketGroup$$anon$$write1(SelectionKey key, DatagramChannel channel, anon.Attachment attachment, AsynchronousSocketGroup.WriterPacket packet, Function1<Option<Throwable>, BoxedUnit> cb) {
                boolean bl;
                block3: {
                    try {
                        int sent = channel.send(packet.bytes(), packet.remote());
                        if (sent > 0) {
                            cb.apply((Object)None$.MODULE$);
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                    catch (IOException e) {
                        cb.apply((Object)new Some((Object)e));
                        bl = true;
                    }
                }
                return bl;
            }

            public void close(SelectionKey key) {
                this.onSelectorThread((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    DatagramChannel channel = (DatagramChannel)key.channel();
                    anon.Attachment attachment = (anon.Attachment)key.attachment();
                    key.cancel();
                    channel.close();
                    attachment.close();
                }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
            }

            public void close() {
                Object object = this.closeLock();
                synchronized (object) {
                    this.fs2$io$udp$AsynchronousSocketGroup$$anon$$closed_$eq(true);
                }
            }

            private void onSelectorThread(Function0<BoxedUnit> f, Function0<BoxedUnit> ifClosed) {
                Object object = this.closeLock();
                synchronized (object) {
                    if (this.fs2$io$udp$AsynchronousSocketGroup$$anon$$closed()) {
                        ifClosed.apply$mcV$sp();
                    } else {
                        this.pendingThunks().add(f);
                        this.fs2$io$udp$AsynchronousSocketGroup$$anon$$selector().wakeup();
                    }
                }
            }

            public void fs2$io$udp$AsynchronousSocketGroup$$anon$$runPendingThunks() {
                Function0<BoxedUnit> next = this.pendingThunks().poll();
                while (next != null) {
                    next.apply$mcV$sp();
                    next = this.pendingThunks().poll();
                }
            }

            private Thread selectorThread() {
                return this.selectorThread;
            }

            public String toString() {
                return "AsynchronousSocketGroup";
            }

            private final void Timeout$lzycompute$1() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.Timeout$module == null) {
                        this.Timeout$module = new AsynchronousSocketGroup$$anon$1$Timeout$(this);
                    }
                }
            }

            private final void Attachment$lzycompute$1() {
                anon.1 var1_1 = this;
                synchronized (var1_1) {
                    if (this.Attachment$module == null) {
                        this.Attachment$module = new AsynchronousSocketGroup$$anon$1$Attachment$(this);
                    }
                }
            }
            {
                this.fs2$io$udp$AsynchronousSocketGroup$$anon$$selector = Selector.open();
                this.closeLock = new Object();
                this.fs2$io$udp$AsynchronousSocketGroup$$anon$$closed = false;
                this.pendingThunks = new ConcurrentLinkedQueue<E>();
                this.fs2$io$udp$AsynchronousSocketGroup$$anon$$pendingTimeouts = new PriorityQueue(this.Timeout().ordTimeout());
                this.readBuffer = ByteBuffer.allocate(65536);
                this.selectorThread = ThreadFactories$.MODULE$.named("fs2-udp-selector", true, ThreadFactories$.MODULE$.named$default$3()).newThread(new Runnable(this){
                    private final /* synthetic */ anon.1 $outer;

                    public void run() {
                        while (!this.$outer.fs2$io$udp$AsynchronousSocketGroup$$anon$$closed() && !Thread.currentThread().isInterrupted()) {
                            this.$outer.fs2$io$udp$AsynchronousSocketGroup$$anon$$runPendingThunks();
                            Option timeout = this.$outer.fs2$io$udp$AsynchronousSocketGroup$$anon$$pendingTimeouts().headOption().map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)anon$1$$anon$2.$anonfun$run$1(t)));
                            this.$outer.fs2$io$udp$AsynchronousSocketGroup$$anon$$selector().select(BoxesRunTime.unboxToLong((Object)timeout.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
                            Iterator<SelectionKey> selectedKeys = this.$outer.fs2$io$udp$AsynchronousSocketGroup$$anon$$selector().selectedKeys().iterator();
                            while (selectedKeys.hasNext()) {
                                Object object;
                                SelectionKey key = selectedKeys.next();
                                selectedKeys.remove();
                                DatagramChannel channel = (DatagramChannel)key.channel();
                                anon.Attachment attachment = (anon.Attachment)key.attachment();
                                try {
                                    if (key.isValid()) {
                                        if (key.isReadable()) {
                                            boolean success = true;
                                            while (success && attachment.hasReaders()) {
                                                Function1 reader = (Function1)attachment.peekReader().get();
                                                success = this.$outer.fs2$io$udp$AsynchronousSocketGroup$$anon$$read1(key, channel, attachment, (Function1<Either<Throwable, Packet>, BoxedUnit>)reader);
                                                Option<Function1<Either<Throwable, Packet>, BoxedUnit>> option = success ? attachment.dequeueReader() : BoxedUnit.UNIT;
                                            }
                                        }
                                        if (key.isWritable()) {
                                            boolean success = true;
                                            while (success && attachment.hasWriters()) {
                                                Tuple2 tuple2 = (Tuple2)attachment.peekWriter().get();
                                                if (tuple2 == null) {
                                                    throw new MatchError((Object)tuple2);
                                                }
                                                AsynchronousSocketGroup.WriterPacket p = (AsynchronousSocketGroup.WriterPacket)tuple2._1();
                                                Function1 writer = (Function1)tuple2._2();
                                                Tuple2 tuple22 = new Tuple2((Object)p, (Object)writer);
                                                Tuple2 tuple23 = tuple22;
                                                AsynchronousSocketGroup.WriterPacket p2 = (AsynchronousSocketGroup.WriterPacket)tuple23._1();
                                                Function1 writer2 = (Function1)tuple23._2();
                                                success = this.$outer.fs2$io$udp$AsynchronousSocketGroup$$anon$$write1(key, channel, attachment, p2, (Function1<Option<Throwable>, BoxedUnit>)writer2);
                                                Option<Tuple2<AsynchronousSocketGroup.WriterPacket, Function1<Option<Throwable>, BoxedUnit>>> option = success ? attachment.dequeueWriter() : BoxedUnit.UNIT;
                                            }
                                        }
                                        object = key.interestOps((attachment.hasReaders() ? 1 : 0) | (attachment.hasWriters() ? 4 : 0));
                                        continue;
                                    }
                                    object = BoxedUnit.UNIT;
                                }
                                catch (CancelledKeyException t2) {
                                    object = BoxedUnit.UNIT;
                                }
                            }
                            long now = System.currentTimeMillis();
                            Option nextTimeout = this.$outer.fs2$io$udp$AsynchronousSocketGroup$$anon$$pendingTimeouts().headOption();
                            while (nextTimeout.isDefined() && ((anon.Timeout)nextTimeout.get()).expiry() <= now) {
                                ((anon.Timeout)nextTimeout.get()).timedOut();
                                this.$outer.fs2$io$udp$AsynchronousSocketGroup$$anon$$pendingTimeouts().dequeue();
                                nextTimeout = this.$outer.fs2$io$udp$AsynchronousSocketGroup$$anon$$pendingTimeouts().headOption();
                            }
                        }
                        this.$outer.close();
                        this.$outer.fs2$io$udp$AsynchronousSocketGroup$$anon$$runPendingThunks();
                    }

                    public static final /* synthetic */ long $anonfun$run$1(anon.Timeout t) {
                        return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(t.expiry() - System.currentTimeMillis()), 0L);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1$adapted(fs2.io.udp.AsynchronousSocketGroup$$anon$1$Timeout ), $anonfun$run$2()}, serializedLambda);
                    }
                });
                this.selectorThread().start();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$register$1(fs2.io.udp.AsynchronousSocketGroup$$anon$1 java.nio.channels.DatagramChannel scala.runtime.ObjectRef java.util.concurrent.CountDownLatch ), $anonfun$register$2(java.util.concurrent.CountDownLatch ), $anonfun$read$1(fs2.io.udp.AsynchronousSocketGroup$$anon$1 java.nio.channels.SelectionKey scala.Option scala.Function1 ), $anonfun$read$6(scala.Function1 ), $anonfun$write$1(fs2.io.udp.AsynchronousSocketGroup$$anon$1 java.nio.channels.SelectionKey scala.Option scala.Function1 fs2.io.udp.AsynchronousSocketGroup$WriterPacket ), $anonfun$write$6(scala.Function1 ), $anonfun$close$5(java.nio.channels.SelectionKey ), $anonfun$close$6(), $anonfun$read$3(scala.Function1 scala.runtime.ObjectRef ), $anonfun$read$2(fs2.io.udp.AsynchronousSocketGroup$$anon$1 scala.Function1 scala.runtime.ObjectRef scala.concurrent.duration.FiniteDuration ), $anonfun$read$4(fs2.io.udp.AsynchronousSocketGroup$$anon$1 fs2.io.udp.AsynchronousSocketGroup$$anon$1$Timeout ), $anonfun$read$5(fs2.io.udp.AsynchronousSocketGroup$$anon$1 fs2.io.udp.AsynchronousSocketGroup$$anon$1$Timeout ), $anonfun$write$3(scala.Function1 scala.runtime.ObjectRef ), $anonfun$write$2(fs2.io.udp.AsynchronousSocketGroup$$anon$1 scala.Function1 scala.runtime.ObjectRef scala.concurrent.duration.FiniteDuration ), $anonfun$write$4(fs2.io.udp.AsynchronousSocketGroup$$anon$1 fs2.io.udp.AsynchronousSocketGroup$$anon$1$Timeout ), $anonfun$write$5(fs2.io.udp.AsynchronousSocketGroup$$anon$1 fs2.io.udp.AsynchronousSocketGroup$$anon$1$Timeout )}, serializedLambda);
            }
        };
    }

    private AsynchronousSocketGroup$() {
        MODULE$ = this;
    }
}

