/*
 * Decompiled with CFR 0.152.
 */
package fs2.io;

import cats.Applicative;
import cats.ApplicativeError;
import cats.Apply;
import cats.FlatMap;
import cats.Functor;
import cats.Show;
import cats.effect.kernel.Async;
import cats.effect.kernel.Deferred$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.Sync;
import cats.effect.kernel.Sync$;
import cats.effect.kernel.implicits$;
import cats.effect.kernel.syntax.MonadCancelOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import fs2.Chunk$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.compat.NotGiven$;
import fs2.io.JavaInputOutputStream$;
import fs2.text$;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

public final class package$ {
    public static package$ MODULE$;
    private final Charset utf8Charset;

    static {
        new package$();
    }

    private Charset utf8Charset() {
        return this.utf8Charset;
    }

    public <F> Stream<F, Object> readInputStream(F fis, int chunkSize, boolean closeAfterUse, Sync<F> F) {
        return this.readInputStreamGeneric(fis, F.delay((Function0 & Serializable & scala.Serializable)() -> new byte[chunkSize]), closeAfterUse, F);
    }

    public <F> boolean readInputStream$default$3() {
        return true;
    }

    public <F> Stream<F, Object> unsafeReadInputStream(F fis, int chunkSize, boolean closeAfterUse, Sync<F> F) {
        return this.readInputStreamGeneric(fis, F.pure((Object)new byte[chunkSize]), closeAfterUse, F);
    }

    public <F> boolean unsafeReadInputStream$default$3() {
        return true;
    }

    private <F> F readBytesFromInputStream(InputStream is, byte[] buf, Sync<F> F) {
        return (F)package.all$.MODULE$.toFunctorOps(F.blocking((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> is.read(buf)), F).map((Function1 & Serializable & scala.Serializable)numBytes -> package$.$anonfun$readBytesFromInputStream$2(buf, BoxesRunTime.unboxToInt((Object)numBytes)));
    }

    private <F> Stream<F, Object> readInputStreamGeneric(F fis, F buf, boolean closeAfterUse, Sync<F> F) {
        return closeAfterUse ? Stream$.MODULE$.bracket(fis, (Function1 & Serializable & scala.Serializable)is -> Sync$.MODULE$.apply(F).blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> is.close())).flatMap((Function1 & Serializable & scala.Serializable)is -> package$.useIs$1(is, buf, F), NotGiven$.MODULE$.default()) : Stream$.MODULE$.eval(fis).flatMap((Function1 & Serializable & scala.Serializable)is -> package$.useIs$1(is, buf, F), NotGiven$.MODULE$.default());
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Nothing$>> writeOutputStream(F fos, boolean closeAfterUse, Sync<F> F) {
        return (Function1 & Serializable & scala.Serializable)s -> {
            Stream os2 = closeAfterUse ? Stream$.MODULE$.bracket(fos, (Function1 & Serializable & scala.Serializable)os -> F.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> os.close())) : Stream$.MODULE$.eval(fos);
            return os2.flatMap((Function1 & Serializable & scala.Serializable)os -> package$.useOs$1(os, s, F).$plus$plus((Function0 & Serializable & scala.Serializable)() -> Stream$.MODULE$.exec(F.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> os.flush()))), NotGiven$.MODULE$.default());
        };
    }

    public <F> boolean writeOutputStream$default$2() {
        return true;
    }

    public <F> Stream<F, Object> readOutputStream(int chunkSize, Function1<OutputStream, F> f, Async<F> evidence$1) {
        Resource mkOutput = Resource$.MODULE$.make(Sync$.MODULE$.apply(evidence$1).delay((Function0 & Serializable & scala.Serializable)() -> {
            PipedOutputStream os = new PipedOutputStream();
            PipedInputStream is = new PipedInputStream(os, chunkSize);
            return new Tuple2((Object)os, (Object)is);
        }), (Function1 & Serializable & scala.Serializable)ois -> Sync$.MODULE$.apply((Sync)evidence$1).blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ((InputStream)ois._2()).close();
            ((OutputStream)ois._1()).close();
        }), evidence$1);
        return Stream$.MODULE$.resource(mkOutput, evidence$1).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            OutputStream os = (OutputStream)tuple2._1();
            InputStream is = (InputStream)tuple2._2();
            Stream stream = Stream$.MODULE$.eval(Deferred$.MODULE$.apply((GenConcurrent)evidence$1)).flatMap((Function1 & Serializable & scala.Serializable)err -> {
                Object write = MonadCancelOps$.MODULE$.guaranteeCase$extension(implicits$.MODULE$.monadCancelOps(f.apply((Object)os), (MonadCancel)evidence$1), (Function1 & Serializable & scala.Serializable)outcome -> {
                    None$ none$;
                    Apply.Ops ops = package.all$.MODULE$.catsSyntaxApply(Sync$.MODULE$.apply((Sync)evidence$1).blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> os.close()), (Apply)evidence$1);
                    Outcome outcome2 = outcome;
                    if (outcome2 instanceof Outcome.Errored) {
                        Outcome.Errored errored = (Outcome.Errored)outcome2;
                        Throwable t = (Throwable)errored.e();
                        none$ = new Some((Object)t);
                    } else {
                        none$ = None$.MODULE$;
                    }
                    return ops.$times$greater(package.all$.MODULE$.toFunctorOps(err.complete((Object)none$), (Functor)evidence$1).void());
                }, (MonadCancel)evidence$1);
                Stream<Object, Object> read = MODULE$.readInputStream((Object)ApplicativeIdOps$.MODULE$.pure$extension(package.all$.MODULE$.catsSyntaxApplicativeId((Object)is), (Applicative)evidence$1), chunkSize, false, (Sync)evidence$1);
                return read.concurrently(Stream$.MODULE$.eval(write), (GenConcurrent)evidence$1).$plus$plus((Function0 & Serializable & scala.Serializable)() -> Stream$.MODULE$.eval(err.get()).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Stream stream;
                    Option option = x0$2;
                    if (None$.MODULE$.equals(option)) {
                        stream = Stream$.MODULE$.empty();
                    } else if (option instanceof Some) {
                        Some some = (Some)option;
                        Throwable t = (Throwable)some.value();
                        stream = Stream$.MODULE$.raiseError(t, RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)evidence$1));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return stream;
                }, NotGiven$.MODULE$.default()));
            }, NotGiven$.MODULE$.default());
            return stream;
        }, NotGiven$.MODULE$.default());
    }

    public <F> Stream<F, Object> stdin(int bufSize, Sync<F> evidence$2) {
        return this.readInputStream(Sync$.MODULE$.apply(evidence$2).blocking((Function0 & Serializable & scala.Serializable)() -> System.in), bufSize, false, evidence$2);
    }

    public <F> Function1<Stream<F, Object>, Stream<F, Nothing$>> stdout(Sync<F> evidence$3) {
        return this.writeOutputStream(Sync$.MODULE$.apply(evidence$3).blocking((Function0 & Serializable & scala.Serializable)() -> System.out), false, evidence$3);
    }

    public <F, O> Function1<Stream<F, O>, Stream<F, Nothing$>> stdoutLines(Charset charset, Sync<F> evidence$4, Show<O> evidence$5) {
        return (Function1 & Serializable & scala.Serializable)x$1 -> x$1.map((Function1 & Serializable & scala.Serializable)x$2 -> package.all$.MODULE$.toShow(x$2, evidence$5).show()).through(text$.MODULE$.encode(charset)).through(MODULE$.stdout(evidence$4));
    }

    public <F, O> Charset stdoutLines$default$1() {
        return this.utf8Charset();
    }

    public <F> Stream<F, String> stdinUtf8(int bufSize, Sync<F> evidence$6) {
        return this.stdin(bufSize, evidence$6).through(text$.MODULE$.utf8Decode());
    }

    public <F> Function1<Stream<F, Object>, Stream<F, InputStream>> toInputStream(Async<F> evidence$7) {
        return (Function1 & Serializable & scala.Serializable)source -> Stream$.MODULE$.resource(MODULE$.toInputStreamResource((Stream)source, evidence$7), (MonadCancel)evidence$7);
    }

    public <F> Resource<F, InputStream> toInputStreamResource(Stream<F, Object> source, Async<F> evidence$8) {
        return JavaInputOutputStream$.MODULE$.toInputStream(source, evidence$8);
    }

    public static final /* synthetic */ Option $anonfun$readBytesFromInputStream$2(byte[] buf$1, int numBytes) {
        return numBytes < 0 ? None$.MODULE$ : (numBytes == 0 ? new Some((Object)Chunk$.MODULE$.empty()) : (numBytes < new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(buf$1)).size() ? new Some((Object)Chunk$.MODULE$.array(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(buf$1)).slice(0, numBytes), ClassTag$.MODULE$.Byte())) : new Some((Object)Chunk$.MODULE$.array((Object)buf$1, ClassTag$.MODULE$.Byte()))));
    }

    private static final Stream useIs$1(InputStream is, Object buf$2, Sync F$1) {
        return Stream.OptionStreamOps$.MODULE$.unNoneTerminate$extension(Stream$.MODULE$.OptionStreamOps(Stream$.MODULE$.eval(package.all$.MODULE$.toFlatMapOps(buf$2, (FlatMap)F$1).flatMap((Function1 & Serializable & scala.Serializable)b -> MODULE$.readBytesFromInputStream(is, (byte[])b, (Sync)F$1))).repeat())).flatMap((Function1 & Serializable & scala.Serializable)c -> Stream$.MODULE$.chunk(c), NotGiven$.MODULE$.default());
    }

    private static final Stream useOs$1(OutputStream os, Stream s$1, Sync F$2) {
        return s$1.chunks().foreach((Function1 & Serializable & scala.Serializable)c -> F$2.blocking((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> os.write((byte[])c.toArray(ClassTag$.MODULE$.Byte()))));
    }

    private package$() {
        MODULE$ = this;
        this.utf8Charset = Charset.forName("UTF-8");
    }
}

